/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.modules.mprop.VolumetricData;
import java.text.NumberFormat;

public class Grid {
    private static final String NL = System.getProperty("line.separator");
    protected float startX = 0.0f;
    protected float startY = 0.0f;
    protected float startZ = 0.0f;
    protected float stepX = 1.0f;
    protected float stepY = 1.0f;
    protected float stepZ = 1.0f;
    protected int sizeX = 0;
    protected int sizeY = 0;
    protected int sizeZ = 0;
    float[][][] grid;

    public Grid() {
    }

    public Grid(int sx, int sy, int sz) {
        this.grid = new float[sz][sy][sx];
        this.sizeX = sx;
        this.sizeY = sy;
        this.sizeZ = sz;
    }

    public Grid(Grid g) {
        this.stepX = g.stepX;
        this.stepY = g.stepY;
        this.stepZ = g.stepZ;
        this.startX = g.startX;
        this.startY = g.startY;
        this.startZ = g.startZ;
        this.sizeX = g.sizeX;
        this.sizeY = g.sizeY;
        this.sizeZ = g.sizeZ;
        this.grid = new float[this.sizeZ][this.sizeY][this.sizeX];
    }

    public Grid(VolumetricData vd) {
        this.grid = vd.grid;
        this.startX = vd.origo[0];
        this.startY = vd.origo[1];
        this.startZ = vd.origo[2];
        this.stepX = vd.step[0];
        this.stepY = vd.step[1];
        this.stepZ = vd.step[2];
        this.sizeX = vd.size[2];
        this.sizeY = vd.size[1];
        this.sizeZ = vd.size[0];
    }

    protected void finalize() throws Throwable {
        this.grid = null;
    }

    public int getCellX(double x) {
        return (int)Math.round((x - (double)this.startX) / (double)this.stepX);
    }

    public int getCellY(double y) {
        return (int)Math.round((y - (double)this.startY) / (double)this.stepY);
    }

    public int getCellZ(double z) {
        return (int)Math.round((z - (double)this.startZ) / (double)this.stepZ);
    }

    public int getLesserX(double x) {
        return (int)Math.floor((x - (double)this.startX) / (double)this.stepX);
    }

    public int getLesserY(double y) {
        return (int)Math.floor((y - (double)this.startY) / (double)this.stepY);
    }

    public int getLesserZ(double z) {
        return (int)Math.floor((z - (double)this.startZ) / (double)this.stepZ);
    }

    public float getWorldX(int x) {
        return this.startX + (float)x * this.stepX;
    }

    public float getWorldY(int y) {
        return this.startY + (float)y * this.stepY;
    }

    public float getWorldZ(int z) {
        return this.startZ + (float)z * this.stepZ;
    }

    public float get(int x, int y, int z) {
        return this.grid[z][y][x];
    }

    public float get(double x, double y, double z) {
        return this.grid[this.getCellZ(z)][this.getCellY(y)][this.getCellX(x)];
    }

    public float getAverage6(double x, double y, double z) {
        int zz = this.getCellZ(z);
        int yy = this.getCellY(y);
        int xx = this.getCellX(x);
        int s = 0;
        float v = 0.0f;
        if (this.grid[zz][yy][xx] > 0.0f) {
            v += this.grid[zz][yy][xx];
            ++s;
        }
        if (this.grid[zz][yy][xx + 1] > 0.0f) {
            v += this.grid[zz][yy][xx + 1];
            ++s;
        }
        if (this.grid[zz][yy][xx - 1] > 0.0f) {
            v += this.grid[zz][yy][xx - 1];
            ++s;
        }
        if (this.grid[zz][yy + 1][xx] > 0.0f) {
            v += this.grid[zz][yy + 1][xx];
            ++s;
        }
        if (this.grid[zz][yy - 1][xx] > 0.0f) {
            v += this.grid[zz][yy - 1][xx];
            ++s;
        }
        if (this.grid[zz + 1][yy][xx] > 0.0f) {
            v += this.grid[zz + 1][yy][xx];
            ++s;
        }
        if (this.grid[zz - 1][yy][xx] > 0.0f) {
            v += this.grid[zz - 1][yy][xx];
            ++s;
        }
        if (s == 0) {
            return 0.0f;
        }
        return v / (float)s;
    }

    public float getLinearWeighted(float x, float y, float z) {
        int zz = this.getLesserZ(z);
        int yy = this.getLesserY(y);
        int xx = this.getLesserX(x);
        float dz = (z - this.getWorldZ(zz)) / this.stepZ;
        float dy = (y - this.getWorldY(yy)) / this.stepY;
        float dx = (x - this.getWorldX(xx)) / this.stepX;
        float x1 = (1.0f - dx) * this.grid[zz][yy][xx] + dx * this.grid[zz][yy][xx + 1];
        float x2 = (1.0f - dx) * this.grid[zz][yy + 1][xx] + dx * this.grid[zz][yy + 1][xx + 1];
        float x3 = (1.0f - dx) * this.grid[zz + 1][yy][xx] + dx * this.grid[zz + 1][yy][xx + 1];
        float x4 = (1.0f - dx) * this.grid[zz + 1][yy + 1][xx] + dx * this.grid[zz + 1][yy + 1][xx + 1];
        float y1 = (1.0f - dy) * x1 + dy * x2;
        float y2 = (1.0f - dy) * x3 + dy * x4;
        return (1.0f - dz) * y1 + dz * y2;
    }

    public void set(int x, int y, int z, float v) {
        this.grid[z][y][x] = v;
    }

    public float[] getCoordinates(int x, int y, int z) {
        float[] ret = new float[]{this.startX + (float)x * this.stepX, this.startY + (float)y * this.stepY, this.startZ + (float)z * this.stepZ};
        return ret;
    }

    public int[] getCellCoordinates(double x, double y, double z) {
        int[] ret = new int[]{this.getCellX(x), this.getCellY(y), this.getCellZ(z)};
        return ret;
    }

    public void getCellCoordinates(double x, double y, double z, int[] grid) {
        grid[0] = this.getCellX(x);
        grid[1] = this.getCellY(y);
        grid[2] = this.getCellZ(z);
    }

    public void getCellCoordinates(float[] xyz, int[] grid) {
        grid[0] = this.getCellX(xyz[0]);
        grid[1] = this.getCellY(xyz[1]);
        grid[2] = this.getCellZ(xyz[2]);
    }

    public boolean isInside(double x, double y, double z) {
        int xi = this.getCellX(x);
        if (xi < 0 || xi > this.sizeX) {
            return false;
        }
        int yi = this.getCellY(y);
        if (yi < 0 || yi > this.sizeY) {
            return false;
        }
        int zi = this.getCellZ(z);
        return zi >= 0 && zi <= this.sizeZ;
    }

    public boolean isInside(int c) {
        int xi = this.getCellX(GeomCalc.getX(c));
        if (xi < 0 || xi > this.sizeX) {
            return false;
        }
        int yi = this.getCellY(GeomCalc.getY(c));
        if (yi < 0 || yi > this.sizeY) {
            return false;
        }
        int zi = this.getCellZ(GeomCalc.getZ(c));
        return zi >= 0 && zi <= this.sizeZ;
    }

    public float getStartX() {
        return this.startX;
    }

    public float getStartY() {
        return this.startY;
    }

    public float getStartZ() {
        return this.startZ;
    }

    public void setStart(float x, float y, float z) {
        this.startX = x;
        this.startY = y;
        this.startZ = z;
    }

    public float getStepX() {
        return this.stepX;
    }

    public float getStepY() {
        return this.stepY;
    }

    public float getStepZ() {
        return this.stepZ;
    }

    public void setStep(float sx, float sy, float sz) {
        this.stepX = sx;
        this.stepY = sy;
        this.stepZ = sz;
    }

    public void setStepX(float step) {
        this.stepX = step;
    }

    public void setStepY(float step) {
        this.stepY = step;
    }

    public void setStepZ(float step) {
        this.stepZ = step;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    public void setSize(int sx, int sy, int sz) {
        this.grid = new float[sz][sy][sx];
        this.sizeX = sx;
        this.sizeY = sy;
        this.sizeZ = sz;
    }

    public String toString() {
        String ret = "";
        ret = ret + "Size: " + this.sizeX + ", " + this.sizeY + ", " + this.sizeZ + NL;
        ret = ret + "Step: " + this.stepX + ", " + this.stepY + ", " + this.stepZ + NL;
        ret = ret + "Start: " + this.startX + ", " + this.startY + ", " + this.startZ + NL;
        return ret;
    }

    public void printGridValues() {
        for (int k = 0; k < this.sizeZ; ++k) {
            for (int j = this.sizeY - 1; j >= 0; --j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    System.out.print(this.grid[k][j][i] + " ");
                }
                System.out.println("");
            }
            System.out.println("");
        }
    }

    public String gridValuesToFormattedString() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        String ret = "";
        for (int k = 0; k < this.sizeZ; ++k) {
            for (int j = this.sizeY - 1; j >= 0; --j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    ret = ret + nf.format(this.grid[k][j][i]) + " ";
                }
                ret = ret + NL;
            }
            ret = ret + NL;
        }
        return ret;
    }

    public void emptyGrid() {
        for (int i = 0; i <= this.sizeZ; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                for (int k = 0; k <= this.sizeX; ++k) {
                    this.grid[k][j][i] = 0.0f;
                }
            }
        }
    }

    protected double distance2(int x1, int y1, int z1, int v2) {
        int v1 = GeomCalc.newVector((float)x1 * this.stepX + this.startX, (float)y1 * this.stepY + this.startY, (float)z1 * this.stepZ + this.startZ);
        double ret = GeomCalc.distance2(v1, v2);
        GeomCalc.deleteVector(v1);
        return ret;
    }

    protected double distance2(int i, int j, int k) {
        int v = GeomCalc.newVector((float)i * this.stepX, (float)j * this.stepY, (float)k * this.stepZ);
        double ret = GeomCalc.length2(v);
        GeomCalc.deleteVector(v);
        return ret;
    }
}

