/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.marvin.space.ProgressBarInterface;
import chemaxon.marvin.space.SurfaceComponent;
import chemaxon.marvin.space.grid.WeightedValues;
import chemaxon.marvin.space.util.Palette;
import chemaxon.marvin.util.ColorPaletteUtil;
import java.lang.reflect.Method;

public class PropertyMapper {
    Method colorMapperMethod = null;
    Object colorObject = null;
    Palette palette = null;
    private boolean builtInPaletteInUse = false;
    private boolean rangeIsSetManually = false;
    private ProgressBarInterface progressBar;
    private int startProgress;
    private int progressLength;

    protected void finalize() throws Throwable {
        this.colorMapperMethod = null;
        this.colorObject = null;
        this.palette = null;
    }

    public void setProgressBar(ProgressBarInterface progressBar, int start, int end) {
        this.progressBar = progressBar;
        this.startProgress = start;
        this.progressLength = end - this.startProgress;
    }

    public void reset() {
        this.colorMapperMethod = null;
        this.colorObject = null;
        this.palette = null;
        this.builtInPaletteInUse = false;
        this.rangeIsSetManually = false;
    }

    public void setPropertyColorMapperMethod(Method colorMapperMethod) throws Exception {
        this.colorMapperMethod = colorMapperMethod;
    }

    public void setPropertyColorObject(Object o) {
        this.colorObject = o;
    }

    public void setPropertyColorMapperRange(double min, double max) {
        this.palette.setMin(min);
        this.palette.setMax(max);
        this.rangeIsSetManually = true;
    }

    public void setMinimumValue(double min) {
        this.palette.setMin(min);
        this.rangeIsSetManually = true;
    }

    public void setMaximumValue(double max) {
        this.palette.setMax(max);
        this.rangeIsSetManually = true;
    }

    public void setHomogeneousPaletteColors(byte[][] colorArray) {
        this.builtInPaletteInUse = true;
        this.palette = new Palette(0.0, 1.0);
        this.palette.clear();
        for (int i = 0; i < colorArray.length; ++i) {
            this.palette.putColor(colorArray[i]);
        }
        try {
            this.setPropertyColorMapperMethod(Palette.class.getMethod("getByteColor", Double.TYPE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void changePaletteColors(int paletteId) {
        if (this.palette == null) {
            return;
        }
        this.palette.clear();
        this.palette.putColors(ColorPaletteUtil.getBuiltInPalette(paletteId));
    }

    public void setBuiltInPropertyColorMapperMethod(int mode, boolean twoPolePalette) {
        this.builtInPaletteInUse = true;
        this.palette = twoPolePalette ? new Palette(-0.5, 0.5, 0.0) : new Palette(0.0, 1.0);
        this.changePaletteColors(mode);
        try {
            this.setPropertyColorMapperMethod(Palette.class.getMethod("getByteColor", Double.TYPE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doMapping(SurfaceComponent surface, WeightedValues values) throws Exception {
        this.setProgress(this.startProgress);
        int pl = surface.getVertexCount() / this.progressLength;
        surface.coloring(true);
        if (this.builtInPaletteInUse && !this.rangeIsSetManually) {
            this.palette.setMin(values.getMinimumValue());
            this.palette.setMax(values.getMaximumValue());
        }
        for (int i = 0; i < surface.getVertexCount(); ++i) {
            byte[] color = new byte[3];
            if (values.singleAtomEntries()) {
                Object o = values.sValues[i];
                if (o == null) {
                    surface.putColor(surface.getColor3());
                    continue;
                }
                color = this.invoke(o);
            } else {
                Object[] wValues = values.mValues[i];
                if (wValues == null) {
                    surface.putColor(surface.getColor3());
                    continue;
                }
                for (int j = 0; j < wValues.length / 2; ++j) {
                    byte[] c = this.invoke(wValues[j * 2]);
                    float weight = ((Float)wValues[j * 2 + 1]).floatValue();
                    color[0] = (byte)((float)color[0] + (float)c[0] * weight);
                    color[1] = (byte)((float)color[1] + (float)c[1] * weight);
                    color[2] = (byte)((float)color[2] + (float)c[2] * weight);
                }
            }
            surface.putColor(color);
            if (i % pl != 0) continue;
            this.setProgress(this.startProgress + i / pl);
        }
    }

    private void setProgress(int i) {
        if (this.progressBar != null) {
            this.progressBar.setProgress(i);
        }
    }

    public Palette getBuiltInPalette() {
        return this.palette;
    }

    private byte[] invoke(Object value) throws Exception {
        if (this.colorObject != null) {
            return (byte[])this.colorMapperMethod.invoke(this.colorObject, value);
        }
        return (byte[])this.colorMapperMethod.invoke((Object)this.palette, value);
    }
}

