/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.grid.AtomGrid;
import chemaxon.marvin.space.grid.AtomTypeColorGrid;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MoleculeIterators;
import java.util.ArrayList;

public class ResidueTypeColorGrid
extends AtomTypeColorGrid {
    private float[][][] residueSpheres = null;

    public ResidueTypeColorGrid(ArrayList ms, AtomGrid ag, String surfaceType) {
        this.atomGrid = ag;
        this.step = this.atomGrid.getStepX();
        this.start = GeomCalc.newVector(this.atomGrid.getStartX(), this.atomGrid.getStartY(), this.atomGrid.getStartZ());
        this.setSize(this.atomGrid.getSizeX(), this.atomGrid.getSizeY(), this.atomGrid.getSizeZ());
        if (surfaceType.equals("Solvent-accessible") || surfaceType.equals("Gaussian Cube")) {
            this.sas = this.atomGrid.getProbeRadius();
        }
        this.residueSpheres = new float[29][][];
        for (int i = 0; i < 29; ++i) {
            this.residueSpheres[i] = this.createSphere(2.0 + this.sas, Colors.getResidueColor(i));
        }
        for (MoleculeIterators.MoleculeInterface this.mc : ms) {
            this.placeSpheres();
        }
    }

    @Override
    public void finalize() {
    }

    private void placeSpheres() {
        MoleculeIterators.AtomIteratorInterface ai = this.mc.getAtomIterator(true);
        if (!(ai instanceof MacroMolecule.Polymer.AtomIterator)) {
            return;
        }
        MacroMolecule.Polymer.AtomIterator atomIterator = (MacroMolecule.Polymer.AtomIterator)ai;
        atomIterator.reset();
        while (atomIterator.hasNext()) {
            int index = atomIterator.getResidueType();
            this.placeSphere(atomIterator.getX(), atomIterator.getY(), atomIterator.getZ(), this.residueSpheres[index], 2.0 + this.sas);
            atomIterator.next();
        }
    }
}

