/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.gui.AlignmentForMSpace;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class AlignmentDialog
extends JDialog {
    private final GraphicScene graphicScene;
    private AlignmentForMSpace align;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;

    public AlignmentDialog(GraphicScene graphicScene) {
        super((Frame)SwingUtilities.getAncestorOfClass(Frame.class, graphicScene), "Detailed alignment settings", false);
        this.graphicScene = graphicScene;
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel0 = new JPanel();
        BoxLayout bl = new BoxLayout(jPanel0, 1);
        jPanel0.setLayout(bl);
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel1.setAlignmentX(0.0f);
        this.jPanel2.setAlignmentX(0.0f);
        this.jPanel3.setAlignmentX(0.0f);
        this.buttonGroup1 = new ButtonGroup();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Alignment options"));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jPanel1.add(new JLabel("Aligment by:"));
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Extended atom types");
        this.jRadioButton1.setToolTipText("Align only the same atomtypes onto each other.");
        this.jPanel1.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("2D Maximum Common Substructure ");
        this.jRadioButton2.setToolTipText("Assign atompairs by MCS. Non-MCS atoms are aligned with Extended atomtypes.");
        this.jPanel1.add(this.jRadioButton2);
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.setText("Pharmacophore types");
        this.jRadioButton3.setToolTipText("H-bond donor, acceptor, aromatic, hydrophobic features are aligned ");
        this.jPanel1.add(this.jRadioButton3);
        this.buttonGroup1.add(this.jRadioButton4);
        this.jRadioButton4.setText("Shape only");
        this.jRadioButton4.setToolTipText("Shape only. ");
        this.jPanel1.add(this.jRadioButton4);
        jPanel0.add(this.jPanel1);
        this.getContentPane().add(jPanel0);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Rigid/Flexible alignment hint"));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jLabel1.setText("Selected molecules are kept conformationally flexible.");
        this.jPanel2.add(this.jLabel1);
        this.jLabel2.setText("Input conformation is preserved for unselected molecules.");
        this.jPanel2.add(this.jLabel2);
        this.jLabel3.setText("Use tree view to select molecules.");
        this.jPanel2.add(this.jLabel3);
        jPanel0.add(this.jPanel2);
        this.jPanel3.setLayout(new FlowLayout(1, 20, 5));
        this.jButton1.setText("Align");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton1);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton2);
        jPanel0.add(this.jPanel3);
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        AlignmentProperties at = null;
        if (this.jRadioButton1.isSelected()) {
            at = AlignmentProperties.GAUSS_FAST_EXTENDED_ATOMTYPE;
        }
        if (this.jRadioButton2.isSelected()) {
            at = AlignmentProperties.GAUSS_FAST_EXTENDED_ATOMTYPE_MCS;
        }
        if (this.jRadioButton3.isSelected()) {
            at = AlignmentProperties.GAUSS_FAST_PHARMACOPHORE;
        }
        if (this.jRadioButton4.isSelected()) {
            at = AlignmentProperties.GAUSS_FAST_SHAPE_ONLY;
        }
        this.align = new AlignmentForMSpace(this.graphicScene);
        this.align.setAlignmentProperties(at, AlignmentForMSpace.AlignmentFlexMode.SELECTED_FLEX);
        this.align.align();
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

