/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentMoleculeFactory;
import chemaxon.marvin.alignment.PairwiseComparison;
import chemaxon.marvin.alignment.PairwiseSimilarity3D;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.marvin.space.GraphicCell;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.gui.JMSpaceProgressBar;
import chemaxon.struc.Molecule;

class DockingForMSpace {
    private GraphicScene graphicScene;
    private PairwiseComparison dock;
    private Molecule ligandToDock = null;
    private Molecule ligandOrig = null;
    private MoleculeComponent ligandToDockComp = null;
    private MoleculeComponent ligandOrigComp = null;

    DockingForMSpace(GraphicScene graphicScene, PairwiseComparison p) {
        this.graphicScene = graphicScene;
        this.dock = p;
        this.dock.setQueryRigidForced(true);
        this.dock.setTargetRigidForced(false);
    }

    private MoleculeComponent getDefaultLigand() {
        GraphicCell cell = this.graphicScene.getCell(0);
        for (int i = 0; i < cell.getComponentCount(); ++i) {
            if (!(cell.getComponent(i) instanceof MacroMoleculeComponent)) continue;
            MacroMoleculeComponent mc = (MacroMoleculeComponent)cell.getComponent(i);
            for (MacroMoleculeComponent.MoleculeVisualizer mcc : mc.getComponents()) {
                MoleculeComponent mcMacro;
                if (!(mcc instanceof MoleculeComponent) || !(mcMacro = (MoleculeComponent)mcc).isLigand()) continue;
                return mcMacro;
            }
        }
        return null;
    }

    private MoleculeComponent getDefaultToDock() {
        GraphicCell cell = this.graphicScene.getCell(0);
        for (int i = 0; i < cell.getComponentCount(); ++i) {
            if (!(cell.getComponent(i) instanceof MoleculeComponent)) continue;
            MoleculeComponent mc = (MoleculeComponent)cell.getComponent(i);
            return mc;
        }
        return null;
    }

    public void dock() {
        try {
            this.dock.removeAllMolecules();
            GraphicCell cell = this.graphicScene.getCell(0);
            this.ligandToDock = null;
            this.ligandOrig = null;
            this.ligandToDockComp = null;
            this.ligandOrigComp = null;
            for (int i = 0; i < cell.getComponentCount(); ++i) {
                GraphicComponent mc;
                if (cell.getComponent(i) instanceof MoleculeComponent) {
                    mc = (MoleculeComponent)cell.getComponent(i);
                    if (((MoleculeComponent)mc).isSelected()) {
                        this.ligandOrigComp = mc;
                        this.ligandOrig = ((MoleculeComponent)mc).getMolecule().cloneMolecule();
                        continue;
                    }
                    if (!((MoleculeComponent)mc).isHighlighted()) continue;
                    this.ligandToDockComp = mc;
                    this.ligandToDock = this.ligandToDockComp.getMolecule().cloneMolecule();
                    continue;
                }
                if (!(cell.getComponent(i) instanceof MacroMoleculeComponent) || this.ligandOrig == null) continue;
                mc = (MacroMoleculeComponent)cell.getComponent(i);
                for (MacroMoleculeComponent.MoleculeVisualizer mcc : ((MacroMoleculeComponent)mc).getComponents()) {
                    if (!mcc.isSelected() || !(mcc instanceof MoleculeComponent)) continue;
                    MoleculeComponent mcMacro = (MoleculeComponent)mcc;
                    this.ligandOrig = mcMacro.getMolecule().cloneMolecule();
                    this.ligandOrigComp = mcMacro;
                }
            }
            if (this.ligandOrig == null) {
                this.ligandOrigComp = this.getDefaultLigand();
                this.ligandOrig = this.ligandOrigComp.getMolecule().cloneMolecule();
            }
            if (this.ligandOrig == null) {
                this.graphicScene.getEventHandler().handleMyErrors("Select natural docked ligand.", "Alignment error", 0);
                return;
            }
            if (this.ligandToDock == null) {
                this.ligandToDockComp = this.getDefaultToDock();
                if (this.ligandToDockComp == null) {
                    this.graphicScene.getEventHandler().handleMyErrors("Highlight new ligand to dock.", "Alignment error", 0);
                    return;
                }
                this.ligandToDock = this.ligandToDockComp.getMolecule().cloneMolecule();
            }
            if (this.ligandToDock == null) {
                this.graphicScene.getEventHandler().handleMyErrors("Highlight new ligand to dock.", "Alignment error", 0);
                return;
            }
            this.ligandToDock.setDim(3);
            this.ligandOrig.setDim(3);
            MolGeom.removeAlias(this.ligandOrig);
            MolGeom.removeAlias(this.ligandToDock);
            JMSpaceProgressBar bar = this.graphicScene.getEventHandler().getProgressBar();
            bar.setMessage("Calculate min/max distance ranges");
            MyProgressBar mp = new MyProgressBar(bar);
            this.dock.setProgressBar(mp);
            AlignmentMoleculeFactory amf = new AlignmentMoleculeFactory();
            amf.setGenerateDistanceRanges(this.dock instanceof PairwiseSimilarity3D);
            amf.setProgressBar(mp);
            AlignmentMolecule q = amf.generate(0, this.ligandOrig, false, false);
            AlignmentMolecule t = amf.generate(1, this.ligandToDock, true, true);
            this.dock.setQuery(q);
            this.dock.similarity(t);
            this.ligandOrigComp.setMolecule(q.getMoleculeOrig());
            this.graphicScene.removeComponent(this.ligandToDockComp);
            this.graphicScene.getEventHandler().updateSelectionBar(this.ligandToDockComp);
            Molecule result = this.dock.getAlignedTarget();
            result.setName("docked ligand");
            this.ligandToDockComp = this.graphicScene.getEventHandler().setMoleculeWithoutChange(result, false);
            this.graphicScene.refresh();
        }
        catch (Exception ex) {
            this.graphicScene.getEventHandler().handleMyErrors(ex.getMessage(), "Alignment error", 0);
            ex.printStackTrace();
        }
    }

    private static class MyProgressBar
    implements AlignmentMoleculeFactory.ProgressBarInterface {
        private JMSpaceProgressBar bar;

        MyProgressBar(JMSpaceProgressBar bar) {
            this.bar = bar;
        }

        @Override
        public void start() {
            this.bar.start();
        }

        @Override
        public void stop() {
            this.bar.stop();
        }

        @Override
        public void setProgress(int progress) {
            this.bar.setProgress(progress);
        }

        @Override
        public void setMessage(String text) {
            this.bar.setMessage(text);
        }

        @Override
        public void setMinimum(int min) {
            this.bar.setMinimum(min);
        }

        @Override
        public void setMaximum(int max) {
            this.bar.setMaximum(max);
        }
    }
}

