/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.edu.stanford.ejalbert.BrowserLauncher;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.gui.MSpace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URLEncoder;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ErrorDialog
extends JDialog {
    String jvendor = System.getProperty("java.vendor");
    String jver = System.getProperty("java.version");
    String osarch = System.getProperty("os.arch");
    String osname = System.getProperty("os.name");
    String osver = System.getProperty("os.version");
    JScrollPane scrollPane = new JScrollPane();
    JPanel detailsPanel = new JPanel();
    JTextArea textArea = new JTextArea();
    JOptionPane optionPane = null;
    String title;
    String errorMessage;
    String detailedErrorMessage;
    boolean detailsAvailable = false;
    boolean detailsShown = false;
    Object[] options;
    JButton closeButton = new JButton("Ok");
    JButton detailsButton = new JButton("Details");
    JButton sendReportButton = new JButton("Send Report...");
    boolean exitonhide = false;
    Dimension normalSize;
    int heightExtension = 200;
    int widthExtension = 600;

    public ErrorDialog(Component parentComponent, String atitle, String errorMessage, String detailedErrorMessage, boolean closeApplication) {
        super(ErrorDialog.getFrame(parentComponent), atitle);
        this.detailedErrorMessage = detailedErrorMessage;
        this.exitonhide = closeApplication;
        this.title = atitle;
        this.errorMessage = errorMessage;
        if (this.detailedErrorMessage != null) {
            this.detailsAvailable = true;
        } else {
            this.heightExtension = 0;
        }
        this.initGUI();
        this.pack();
        this.normalSize = this.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = new Dimension(this.getSize().width, this.getSize().height + this.heightExtension);
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setLocationRelativeTo(parentComponent);
        this.setVisible(true);
        this.toFront();
    }

    public static Frame getFrame(Component parentComponent) {
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parentComponent);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.optionPane.setMessage(this.errorMessage);
    }

    public void setDetailedErrorMessage(String detailedErrorMessage) {
        this.detailedErrorMessage = detailedErrorMessage;
        this.textArea.setText(detailedErrorMessage);
    }

    private void initGUI() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ErrorDialog.this.exitDialog();
            }
        });
        this.detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.detailsButtonActionPerformed(e);
            }
        });
        this.sendReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ErrorDialog.this.sendReportAction();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Error sending report");
                    ex.printStackTrace();
                }
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.exitDialog();
            }
        });
        this.options = this.detailsAvailable ? new Object[]{this.closeButton, this.detailsButton, this.sendReportButton} : new Object[]{this.closeButton, this.sendReportButton};
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(false);
        this.textArea.setText(this.detailedErrorMessage);
        this.textArea.setSize(this.widthExtension, this.heightExtension);
        this.scrollPane = new JScrollPane(this.textArea);
        this.detailsPanel.setLayout(new BorderLayout());
        this.detailsPanel.add((Component)this.scrollPane, "Center");
        int messagetype = this.exitonhide ? 0 : 2;
        this.optionPane = new JOptionPane(this.errorMessage, messagetype, 0, null, this.options);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.optionPane, "North");
    }

    private void exitDialog() {
        this.setVisible(false);
        this.dispose();
        if (this.exitonhide) {
            System.exit(0);
        }
    }

    public void setShowDetails(boolean b) {
        if (b) {
            this.getContentPane().add((Component)this.detailsPanel, "Center");
            this.detailsShown = true;
        } else {
            this.getContentPane().remove(this.detailsPanel);
            this.detailsShown = false;
        }
        this.pack();
    }

    void detailsButtonActionPerformed(ActionEvent e) {
        this.setShowDetails(!this.detailsShown);
    }

    private void sendReportAction() throws IOException {
        BrowserLauncher.openURL("mailto:mspacebugs@chemaxon.com?Subject=MarvinSpace%20Error%20Report&Body=" + this.getBodyString());
    }

    private String getBodyString() {
        String body = "";
        body = body + "MarvinSpace " + MSpace.version;
        body = body + "\nJVM: " + this.jvendor + " Java " + this.jver;
        body = body + "\nBrowser: " + this.getBrowserInfo();
        body = body + "\nOS: " + this.osarch + " " + this.osname + " " + this.osver + "\n";
        String dbody = (body = body + "\n" + GraphicScene.GLInfo + "\n") + this.detailedErrorMessage;
        if (dbody.length() > 1024) {
            dbody = dbody.substring(0, 1024);
        }
        try {
            dbody = URLEncoder.encode(dbody, System.getProperty("file.encoding"));
            return dbody;
        }
        catch (Exception e) {
            body = this.formatURL(body);
            return body;
        }
    }

    private String getBrowserInfo() {
        String browser = "";
        try {
            browser = System.getProperty("browser");
            browser = browser + " " + System.getProperty("browser.version");
        }
        catch (SecurityException e) {
            return "n/a";
        }
        return browser;
    }

    private String formatURL(String s) {
        String ss = s;
        ss = ss.replaceAll(" ", "%20");
        ss = ss.replaceAll(",", "%2C");
        ss = ss.replaceAll(";", "%3B");
        ss = ss.replaceAll("%", "%25");
        ss = ss.replaceAll("<", "%3C");
        ss = ss.replaceAll(">", "%3E");
        ss = ss.replaceAll("\n", "%0D%0A");
        return ss;
    }
}

