/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolInputStream;
import chemaxon.license.LicenseManagerGUI;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.beans.MSketchPane;
import chemaxon.marvin.common.swing.modules.AboutDialogImpl;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MonitorableInputStream;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.GraphicCell;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.MSpaceEasy;
import chemaxon.marvin.space.MSpaceEventHandler;
import chemaxon.marvin.space.MSpaceInstaller;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.gui.AlignmentDialog;
import chemaxon.marvin.space.gui.AlignmentForMSpace;
import chemaxon.marvin.space.gui.DockDialog;
import chemaxon.marvin.space.gui.GuiFactory;
import chemaxon.marvin.space.gui.JMSpaceOptionsDialog;
import chemaxon.marvin.space.gui.MSpaceDialog;
import chemaxon.marvin.space.gui.MarvinSpaceHelp;
import chemaxon.marvin.util.ParentPanelIface;
import chemaxon.struc.Molecule;
import chemaxon.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class JMSpaceMenuBar
extends JMenuBar
implements ActionListener {
    JFileChooser openMoleculesFC;
    JFileChooser openPropertiesFC;
    JFileChooser saveImegeFC;
    JFileChooser savePDBFC;
    JFileChooser save;
    MSpaceDialog pdbDialog;
    private AlignmentForMSpace align;
    private final GraphicScene graphicScene;
    private final MSpaceEventHandler eventHandler;
    private JMSpaceOptionsDialog optionsDialog;
    private JMenuItem newMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem openPDBMenuItem;
    private JMenuItem openPropertyMenuItem;
    private JMenuItem exportImageMenuItem;
    private JMenuItem saveImageMenuItem;
    private JMenuItem loadSMenuItem;
    private JMenuItem contents;
    private JMenuItem licenses;
    private JMenuItem aboutjvm;
    private JMenuItem closeMenuItem;
    private JMenuItem exitMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem sketchMenuItem;
    private JMenuItem rigidAlignment;
    private JMenuItem flexibleAlignment;
    private JMenuItem detailedAlignment;
    private JMenuItem saveMenuItem;
    private JMenuItem detailedDock;
    private JMenuItem logCreate;
    private JMenuItem logClose;
    private JMenuItem logOpen;
    private JMenuItem logSaveView;
    ActionListener drawTypeActionListener;
    ActionListener colorTypeActionListener;
    private ArrayList ligandDrawTypes;
    private ArrayList proteinDrawTypes;
    private ArrayList waterDrawTypes;
    private ArrayList ionDrawTypes;
    private ArrayList secondaryDrawTypes;
    private ArrayList phpDrawTypes;
    private ArrayList phaDrawTypes;
    private ArrayList surfaceDrawTypes;
    private ArrayList ligandColorTypes;
    private ArrayList proteinColorTypes;
    private ArrayList waterColorTypes;
    private ArrayList ionColorTypes;
    private ArrayList secondaryColorTypes;
    private ArrayList surfaceColorTypes;
    private JCheckBoxMenuItem addHys;
    private JCheckBoxMenuItem addLps;
    private JCheckBoxMenuItem praddHys;
    private JCheckBoxMenuItem praddLps;
    private JCheckBoxMenuItem waddHys;
    private JCheckBoxMenuItem waddLps;
    private JCheckBoxMenuItem labelsOnSelection;
    private JCheckBoxMenuItem coordinateSystem;
    private JCheckBoxMenuItem l2dMenuItem;
    private JCheckBoxMenuItem labelBackground;
    private JCheckBoxMenuItem labelBorder;
    private JCheckBoxMenuItem labelOnlyOnHeavyAtoms;
    private JCheckBoxMenuItem depthcue;
    private JCheckBoxMenuItem antialias;
    private JCheckBoxMenuItem idleRotation;
    private JRadioButtonMenuItem highMenuItem;
    private JRadioButtonMenuItem mediumMenuItem;
    private JRadioButtonMenuItem lowMenuItem;
    private JMenuItem optionsMenuItem;
    private JMenuItem labelBackgroundColor;
    private JMenuItem labelForegroundColor;
    private JMenuItem labelBorderColor;
    static final Object[] closeOptions = new Object[]{"Cancel", "Close Components"};
    static final String closeText = "All components are about to be closed.\nClick \"Cancel\" to prevent it.";
    static final String exitText = "Do you really want to exit MarvinSpace?";
    static final Object[] exitOptions = new Object[]{"No", "Yes"};
    static final Object[] confirmOptions = new Object[]{"No", "Close components"};
    static final String confirmText = "Do you really want to close all components before opening the new one?";
    static final String toEmptyCell = "Do you want to add the selected molecule to an empty cell?";
    static final Object[] toEmptyCellOptions = new Object[]{"No", "Yes"};
    static final String toEmptyCellTitle = "Add to empty cell";
    static final String closeTitle = "Close all components";
    static final String exitTitle = "Exit MarvinSpace";

    public JMSpaceMenuBar(final GraphicScene graphicScene, MSpaceEventHandler eventHandler, JMSpaceOptionsDialog optionsDialog) {
        this.graphicScene = graphicScene;
        this.eventHandler = eventHandler;
        this.optionsDialog = optionsDialog;
        GuiFactory guiFactory = new GuiFactory();
        this.createActionListeners();
        this.createPDBDialog();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.newMenuItem = new JMenuItem("Open...", 79);
        this.newMenuItem.setActionCommand("New");
        this.newMenuItem.setMnemonic(79);
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem = new JMenuItem("Add...", 65);
        this.openMenuItem.setActionCommand("Open");
        this.openMenuItem.setMnemonic(65);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.openPDBMenuItem = new JMenuItem("Open from RCSB PDB...", 65);
        this.openPDBMenuItem.setActionCommand("OpenPDB");
        this.openPDBMenuItem.setMnemonic(80);
        this.openPDBMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.openPropertyMenuItem = new JMenuItem("Open property file...", 80);
        this.openPropertyMenuItem.setActionCommand("MapProperty");
        this.openPropertyMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.saveMenuItem = new JMenuItem("Save as...", 83);
        this.saveMenuItem.setActionCommand("Save");
        this.saveMenuItem.setMnemonic(83);
        this.saveImageMenuItem = new JMenuItem("Save screen as...", 73);
        this.saveImageMenuItem.setActionCommand("SaveScreen");
        this.saveImageMenuItem.setMnemonic(73);
        this.exportImageMenuItem = new JMenuItem("Export image...");
        this.logCreate = new JMenuItem("Create Log File...");
        this.logCreate.setActionCommand("LogCreate");
        this.logSaveView = new JMenuItem("Log current view");
        this.logSaveView.setToolTipText("Save current view in current log file");
        this.logSaveView.setActionCommand("LogSaveView");
        this.logClose = new JMenuItem("Close Log File");
        this.logClose.setActionCommand("LogClose");
        this.logOpen = new JMenuItem("Process Existing Log File...");
        this.logOpen.setActionCommand("LogOpen");
        this.closeMenuItem = new JMenuItem("Close");
        this.closeMenuItem.setActionCommand("Close");
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.setMnemonic(88);
        this.exitMenuItem.setActionCommand("Exit");
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.loadSMenuItem = new JMenuItem("Load surface...");
        this.loadSMenuItem.setActionCommand("Load Surface");
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic(69);
        editMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.copyMenuItem = new JMenuItem("Copy");
        this.copyMenuItem.setActionCommand("Copy");
        this.copyMenuItem.setMnemonic(67);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.cutMenuItem = new JMenuItem("Cut");
        this.cutMenuItem.setActionCommand("Cut");
        this.pasteMenuItem = new JMenuItem("Paste");
        this.pasteMenuItem.setActionCommand("Paste");
        this.pasteMenuItem.setMnemonic(80);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.sketchMenuItem = new JMenuItem("Open MarvinSketch");
        this.sketchMenuItem.setActionCommand("MSketch");
        try {
            Class.forName("chemaxon.marvin.beans.MSketchPane");
        }
        catch (Exception e) {
            this.sketchMenuItem.setEnabled(false);
        }
        JMenu showMenu = new JMenu("Show");
        showMenu.setMnemonic(83);
        showMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenu labelsMenu = new JMenu("Labels");
        labelsMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenuItem atomsMI = new JMenuItem("Atoms");
        atomsMI.setActionCommand("Atom");
        JMenuItem bondsMI = new JMenuItem("Bonds");
        bondsMI.setActionCommand("Bond");
        JMenuItem residuesMI = new JMenuItem("Residues");
        residuesMI.setActionCommand("Residue");
        JMenuItem moleculesMI = new JMenuItem("Molecules");
        moleculesMI.setActionCommand("Molecule");
        JMenuItem secondaryMI = new JMenuItem("Secondary structures");
        secondaryMI.setActionCommand("SecondaryStructure");
        JMenu surfaceMenu = new JMenu("Surface");
        surfaceMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenuItem showVDW = new JMenuItem("van der Waals");
        showVDW.setActionCommand("van der Waals");
        JMenuItem showSAS = new JMenuItem("Solvent accessible");
        showSAS.setActionCommand("Solvent-accessible");
        JMenuItem showGauss = new JMenuItem("Blobby");
        showGauss.setActionCommand("Blobby");
        JMenuItem showConnolly = new JMenuItem("Connolly");
        showConnolly.setActionCommand("Connolly");
        JMenuItem ssMenuItem = new JMenuItem("Secondary Structure");
        this.coordinateSystem = new JCheckBoxMenuItem("Coordinate System", false);
        JMenu displayMenu = new JMenu("Display");
        displayMenu.setMnemonic(68);
        displayMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenu modeMenu = new JMenu("Draw Type");
        modeMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.ligandDrawTypes = new ArrayList();
        JMenu ligandMenu = guiFactory.getRadioButtonMenu("Ligand", GuiFactory.ligandDrawTypes, this.ligandDrawTypes, this.drawTypeActionListener);
        this.proteinDrawTypes = new ArrayList();
        JMenu proteinMenu = guiFactory.getRadioButtonMenu("MacroMolecule", GuiFactory.proteinDrawTypes, this.proteinDrawTypes, this.drawTypeActionListener);
        this.waterDrawTypes = new ArrayList();
        JMenu waterMenu = guiFactory.getRadioButtonMenu("Water", GuiFactory.waterDrawTypes, this.waterDrawTypes, this.drawTypeActionListener);
        this.ionDrawTypes = new ArrayList();
        JMenu ionMenu = guiFactory.getRadioButtonMenu("Ion", GuiFactory.ionDrawTypes, this.ionDrawTypes, this.drawTypeActionListener);
        this.secondaryDrawTypes = new ArrayList();
        JMenu secondaryMenu = guiFactory.getRadioButtonMenu("Secondary Structure", GuiFactory.secondaryDrawTypes, this.secondaryDrawTypes, this.drawTypeActionListener);
        String[] phpdt = new String[]{"Dotted", "Mesh", "Solid", "Transparent"};
        this.phpDrawTypes = new ArrayList();
        JMenu phpMenu = guiFactory.getRadioButtonMenu("Pharmacophore Point", phpdt, this.phpDrawTypes, this.drawTypeActionListener);
        String[] phadt = new String[]{"Mesh", "Solid", "Transparent"};
        this.phaDrawTypes = new ArrayList();
        JMenu phaMenu = guiFactory.getRadioButtonMenu("Pharmacophore Arrow", phadt, this.phaDrawTypes, this.drawTypeActionListener);
        String[] surfdt = new String[]{"Dot", "Mesh", "Solid", "Transparent"};
        this.surfaceDrawTypes = new ArrayList();
        JMenu sdtMenu = guiFactory.getRadioButtonMenu("Surface", surfdt, this.surfaceDrawTypes, this.drawTypeActionListener);
        this.addHys = new JCheckBoxMenuItem("Hydrogens", false);
        this.addLps = new JCheckBoxMenuItem("Lone Pairs", false);
        this.praddHys = new JCheckBoxMenuItem("Hydrogens", false);
        this.praddLps = new JCheckBoxMenuItem("Lone Pairs", false);
        this.waddHys = new JCheckBoxMenuItem("Hydrogens", true);
        this.waddLps = new JCheckBoxMenuItem("Lone Pairs", false);
        JMenu colorMenu = new JMenu("Color Type");
        colorMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        String[] lct = new String[]{"Constant", "CPK"};
        this.ligandColorTypes = new ArrayList();
        JMenu cligandMenu = guiFactory.getRadioButtonMenu("Ligand", lct, this.ligandColorTypes, this.colorTypeActionListener);
        String[] pct = new String[]{"Constant", "CPK", "Residue", "Chain", "Secondary Structure", "Rainbow", "B-factor"};
        this.proteinColorTypes = new ArrayList();
        JMenu cproteinMenu = guiFactory.getRadioButtonMenu("MacroMolecule", pct, this.proteinColorTypes, this.colorTypeActionListener);
        String[] wct = new String[]{"Constant", "CPK"};
        this.waterColorTypes = new ArrayList();
        JMenu cwaterMenu = guiFactory.getRadioButtonMenu("Water", wct, this.waterColorTypes, this.colorTypeActionListener);
        String[] ict = new String[]{"Constant", "CPK"};
        this.ionColorTypes = new ArrayList();
        JMenu cionMenu = guiFactory.getRadioButtonMenu("Ion", ict, this.ionColorTypes, this.colorTypeActionListener);
        String[] surfct = new String[]{"Constant", "Atom Type", "Residue Type", "Chain Type", "Electrostatic Potential", "Secondary Structure Type", "Rainbow", "B-factor"};
        this.surfaceColorTypes = new ArrayList();
        JMenu csurfaceMenu = guiFactory.getRadioButtonMenu("Surface", surfct, this.surfaceColorTypes, this.colorTypeActionListener);
        String[] secct = new String[]{"Constant", "Residue", "Chain", "Secondary Structure", "Rainbow", "B-factor"};
        this.secondaryColorTypes = new ArrayList();
        JMenu csecondaryMenu = guiFactory.getRadioButtonMenu("Secondary Structure", secct, this.secondaryColorTypes, this.colorTypeActionListener);
        JMenu clabelMenu = new JMenu("Labels");
        clabelMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenu labelMenu = new JMenu("Labels");
        labelMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.l2dMenuItem = new JCheckBoxMenuItem("Draw in plane");
        this.l2dMenuItem.setActionCommand("Label.Draw2D");
        this.l2dMenuItem.setState(true);
        JRadioButtonMenuItem smallMenuItem = new JRadioButtonMenuItem("Small");
        smallMenuItem.setActionCommand("Small");
        JRadioButtonMenuItem medMenuItem = new JRadioButtonMenuItem("Medium");
        medMenuItem.setActionCommand("Medium");
        medMenuItem.setSelected(true);
        JRadioButtonMenuItem largeMenuItem = new JRadioButtonMenuItem("Large");
        largeMenuItem.setActionCommand("Large");
        this.labelBackground = new JCheckBoxMenuItem("Background", true);
        this.labelBackground.setActionCommand("Label.Background");
        this.labelBorder = new JCheckBoxMenuItem("Border", true);
        this.labelBorder.setActionCommand("Label.Border");
        this.labelOnlyOnHeavyAtoms = new JCheckBoxMenuItem("Show only on heavy atoms", Boolean.parseBoolean(graphicScene.getDrawProperty("Label.OnlyOnHeavyAtoms")));
        this.labelOnlyOnHeavyAtoms.setActionCommand("Label.OnlyOnHeavyAtoms");
        this.labelBackgroundColor = new JMenuItem("Background...");
        this.labelBackgroundColor.setActionCommand("Label.BackgroundColor");
        this.labelBackgroundColor.addActionListener(this);
        this.labelForegroundColor = new JMenuItem("Foreground...");
        this.labelForegroundColor.setActionCommand("Label.ForegroundColor");
        this.labelForegroundColor.addActionListener(this);
        this.labelBorderColor = new JMenuItem("Border...");
        this.labelBorderColor.setActionCommand("Label.BorderColor");
        this.labelBorderColor.addActionListener(this);
        JMenu qualityMenu = new JMenu("Quality");
        qualityMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.highMenuItem = new JRadioButtonMenuItem("High");
        this.highMenuItem.setActionCommand("High");
        this.mediumMenuItem = new JRadioButtonMenuItem("Medium");
        this.mediumMenuItem.setSelected(true);
        this.mediumMenuItem.setActionCommand("Medium");
        this.lowMenuItem = new JRadioButtonMenuItem("Low");
        this.lowMenuItem.setActionCommand("Low");
        this.labelsOnSelection = new JCheckBoxMenuItem("Labels on selection", false);
        this.depthcue = new JCheckBoxMenuItem("Depth cue", false);
        this.depthcue.setActionCommand("Depthcue");
        this.antialias = new JCheckBoxMenuItem("Anti-alias", false);
        this.optionsMenuItem = new JMenuItem("Options...");
        this.optionsMenuItem.setActionCommand("Options");
        this.optionsMenuItem.setMnemonic(80);
        JMenu animationMenu = new JMenu("Animation");
        animationMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenuItem demo = new JMenuItem("Play Demo");
        demo.setActionCommand("AnimationDemo");
        JMenuItem stopDemo = new JMenuItem("Stop Demo");
        stopDemo.setActionCommand("StopAnimationDemo");
        this.idleRotation = new JCheckBoxMenuItem("Auto Rotation", false);
        JMenu cellsMenu = new JMenu("Layout");
        cellsMenu.setMnemonic(76);
        cellsMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenuItem addrow = new JMenuItem("Add row");
        addrow.setActionCommand("Add row");
        JMenuItem addcol = new JMenuItem("Add column");
        addcol.setActionCommand("Add column");
        JMenuItem delrow = new JMenuItem("Delete row");
        delrow.setActionCommand("Delete row");
        JMenuItem delcol = new JMenuItem("Delete column");
        delcol.setActionCommand("Delete column");
        final JCheckBoxMenuItem synchronous = new JCheckBoxMenuItem("Synchronous mode", false);
        synchronous.setActionCommand("SynchronousMode");
        JMenuItem resetAll = new JMenuItem("Reset view in all cells");
        resetAll.setActionCommand("ResetAll");
        JMenu alignmentMenu = new JMenu("Alignment");
        alignmentMenu.setMnemonic(65);
        alignmentMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.rigidAlignment = new JMenuItem("Rigid for all molecule");
        this.rigidAlignment.setActionCommand("Rigid");
        this.rigidAlignment.setMnemonic(82);
        this.flexibleAlignment = new JMenuItem("Flexible for all molecule");
        this.flexibleAlignment.setActionCommand("Flexible");
        this.flexibleAlignment.setMnemonic(70);
        this.detailedAlignment = new JMenuItem("Details & align");
        this.detailedAlignment.setActionCommand("Details");
        this.detailedAlignment.setMnemonic(68);
        this.detailedDock = new JMenuItem("Details for pseudo dock");
        this.detailedDock.setActionCommand("Details for pseudo dock");
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        helpMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.contents = new JMenuItem("Contents");
        this.licenses = new JMenuItem("Licenses...");
        this.aboutjvm = new JMenuItem("About MarvinSpace");
        ButtonGroup labelsizebg = new ButtonGroup();
        labelsizebg.add(smallMenuItem);
        labelsizebg.add(medMenuItem);
        labelsizebg.add(largeMenuItem);
        ButtonGroup qualitybg = new ButtonGroup();
        qualitybg.add(this.highMenuItem);
        qualitybg.add(this.mediumMenuItem);
        qualitybg.add(this.lowMenuItem);
        this.add(fileMenu);
        fileMenu.add(this.newMenuItem);
        fileMenu.add(this.openMenuItem);
        fileMenu.add(this.openPDBMenuItem);
        fileMenu.add(this.openPropertyMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(this.saveMenuItem);
        fileMenu.add(this.saveImageMenuItem);
        fileMenu.add(this.exportImageMenuItem);
        fileMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean enabled = graphicScene.getActiveCellIndex() >= 0 && graphicScene.getCellCount() == 1;
                JMSpaceMenuBar.this.exportImageMenuItem.setEnabled(enabled);
            }
        });
        fileMenu.addSeparator();
        fileMenu.add(this.logCreate);
        fileMenu.add(this.logSaveView);
        fileMenu.add(this.logClose);
        fileMenu.add(this.logOpen);
        fileMenu.addSeparator();
        fileMenu.add(this.exitMenuItem);
        this.add(editMenu);
        editMenu.add(this.copyMenuItem);
        editMenu.add(this.cutMenuItem);
        editMenu.add(this.pasteMenuItem);
        editMenu.addSeparator();
        editMenu.add(this.sketchMenuItem);
        this.add(displayMenu);
        displayMenu.add(modeMenu);
        modeMenu.add(ligandMenu);
        ligandMenu.add(this.addHys);
        ligandMenu.add(this.addLps);
        modeMenu.add(proteinMenu);
        proteinMenu.add(this.praddHys);
        proteinMenu.add(this.praddLps);
        modeMenu.add(waterMenu);
        waterMenu.add(this.waddHys);
        waterMenu.add(this.waddLps);
        modeMenu.add(ionMenu);
        modeMenu.add(phpMenu);
        modeMenu.add(phaMenu);
        modeMenu.add(sdtMenu);
        modeMenu.add(secondaryMenu);
        modeMenu.add(labelMenu);
        labelMenu.add(this.l2dMenuItem);
        labelMenu.addSeparator();
        labelMenu.add(smallMenuItem);
        labelMenu.add(medMenuItem);
        labelMenu.add(largeMenuItem);
        labelMenu.addSeparator();
        labelMenu.add(this.labelBackground);
        labelMenu.add(this.labelBorder);
        displayMenu.add(colorMenu);
        colorMenu.add(cligandMenu);
        colorMenu.add(cproteinMenu);
        colorMenu.add(cwaterMenu);
        colorMenu.add(cionMenu);
        colorMenu.add(csurfaceMenu);
        colorMenu.add(csecondaryMenu);
        colorMenu.add(clabelMenu);
        clabelMenu.add(this.labelBackgroundColor);
        clabelMenu.add(this.labelForegroundColor);
        clabelMenu.add(this.labelBorderColor);
        displayMenu.add(qualityMenu);
        qualityMenu.add(this.highMenuItem);
        qualityMenu.add(this.mediumMenuItem);
        qualityMenu.add(this.lowMenuItem);
        displayMenu.addSeparator();
        displayMenu.add(this.depthcue);
        displayMenu.add(this.antialias);
        displayMenu.addSeparator();
        displayMenu.add(this.optionsMenuItem);
        this.add(showMenu);
        showMenu.add(labelsMenu);
        labelsMenu.add(atomsMI);
        labelsMenu.add(residuesMI);
        labelsMenu.add(moleculesMI);
        labelsMenu.add(secondaryMI);
        showMenu.add(surfaceMenu);
        surfaceMenu.add(showConnolly);
        surfaceMenu.add(showVDW);
        surfaceMenu.add(showSAS);
        surfaceMenu.addSeparator();
        surfaceMenu.add(showGauss);
        showMenu.add(ssMenuItem);
        showMenu.add(this.labelsOnSelection);
        showMenu.add(this.coordinateSystem);
        this.add(animationMenu);
        animationMenu.add(demo);
        animationMenu.add(stopDemo);
        animationMenu.add(this.idleRotation);
        this.add(cellsMenu);
        cellsMenu.add(addrow);
        cellsMenu.add(addcol);
        cellsMenu.add(delrow);
        cellsMenu.add(delcol);
        cellsMenu.add(resetAll);
        cellsMenu.addSeparator();
        cellsMenu.add(synchronous);
        this.add(alignmentMenu);
        alignmentMenu.add(this.rigidAlignment);
        alignmentMenu.add(this.flexibleAlignment);
        alignmentMenu.add(this.detailedAlignment);
        alignmentMenu.add(this.detailedDock);
        this.add(helpMenu);
        helpMenu.add(this.contents);
        helpMenu.add(this.licenses);
        helpMenu.add(this.aboutjvm);
        this.newMenuItem.addActionListener(this);
        this.openMenuItem.addActionListener(this);
        this.openPDBMenuItem.addActionListener(this);
        this.openPropertyMenuItem.addActionListener(this);
        this.saveImageMenuItem.addActionListener(this);
        this.exportImageMenuItem.addActionListener(this);
        this.loadSMenuItem.addActionListener(this);
        this.logCreate.addActionListener(this);
        this.logClose.addActionListener(this);
        this.logOpen.addActionListener(this);
        this.logSaveView.addActionListener(this);
        this.closeMenuItem.addActionListener(this);
        this.exitMenuItem.addActionListener(this);
        this.optionsMenuItem.addActionListener(this);
        this.antialias.addActionListener(this);
        this.depthcue.addActionListener(this);
        this.openMoleculesFC = new JFileChooser();
        this.openMoleculesFC.setMultiSelectionEnabled(true);
        this.openPropertiesFC = new JFileChooser();
        this.saveImegeFC = new JFileChooser();
        this.savePDBFC = new JFileChooser();
        this.save = new JFileChooser();
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMSpaceMenuBar.this.saveStrucs();
            }
        });
        MolFileFilter mff1 = new MolFileFilter("ALL_STRUCTURE_FILES");
        MolFileFilter mff2 = new MolFileFilter("mol");
        MolFileFilter mff3 = new MolFileFilter("cube");
        MolFileFilter mff4 = new MolFileFilter("pdb");
        this.openMoleculesFC.addChoosableFileFilter(mff2);
        this.openMoleculesFC.addChoosableFileFilter(mff3);
        this.openMoleculesFC.addChoosableFileFilter(mff4);
        this.openMoleculesFC.addChoosableFileFilter(mff1);
        this.openPropertiesFC.addChoosableFileFilter(mff3);
        this.addFileFilter(this.openPropertiesFC, ".phi80", "Charmm Grid Files (*.phi80)");
        this.saveImegeFC.setFileFilter(new ImageFilter("jpg"));
        this.saveImegeFC.setFileFilter(new ImageFilter("bmp"));
        this.saveImegeFC.setFileFilter(new ImageFilter("png"));
        this.savePDBFC.addChoosableFileFilter(mff4);
        this.save.addChoosableFileFilter(mff2);
        this.save.addChoosableFileFilter(new MolFileFilter("sdf"));
        this.save.addChoosableFileFilter(new MolFileFilter("mrv"));
        this.save.addChoosableFileFilter(mff1);
        ActionListener addHydrogensActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == JMSpaceMenuBar.this.addHys) {
                    graphicScene.processEvent("Ligand.Hydrogens", "" + JMSpaceMenuBar.this.addHys.getState());
                } else if (evt.getSource() == JMSpaceMenuBar.this.praddHys) {
                    graphicScene.processEvent("MacroMolecule.Hydrogens", "" + JMSpaceMenuBar.this.praddHys.getState());
                } else if (evt.getSource() == JMSpaceMenuBar.this.waddHys) {
                    graphicScene.processEvent("Water.Hydrogens", "" + JMSpaceMenuBar.this.waddHys.getState());
                }
                graphicScene.refresh();
            }
        };
        ActionListener addLonePairsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == JMSpaceMenuBar.this.addLps) {
                    graphicScene.processEvent("Ligand.LonePairs", "" + JMSpaceMenuBar.this.addLps.getState());
                } else if (evt.getSource() == JMSpaceMenuBar.this.praddLps) {
                    graphicScene.processEvent("MacroMolecule.LonePairs", "" + JMSpaceMenuBar.this.praddLps.getState());
                } else if (evt.getSource() == JMSpaceMenuBar.this.waddLps) {
                    graphicScene.processEvent("Water.LonePairs", "" + JMSpaceMenuBar.this.waddLps.getState());
                }
                graphicScene.refresh();
            }
        };
        ActionListener labelsOnSelectionActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphicScene.getEventHandler().setShowLabelsOnSelection(JMSpaceMenuBar.this.labelsOnSelection.getState());
            }
        };
        ActionListener coordinateSystemActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphicScene.getEventHandler().showCoordinateSystem(JMSpaceMenuBar.this.coordinateSystem.getState());
            }
        };
        ActionListener labelTypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == JMSpaceMenuBar.this.l2dMenuItem) {
                    graphicScene.processEvent(evt.getActionCommand(), "" + JMSpaceMenuBar.this.l2dMenuItem.getState());
                } else if (evt.getSource() == JMSpaceMenuBar.this.labelBackground) {
                    graphicScene.processEvent(evt.getActionCommand(), "" + JMSpaceMenuBar.this.labelBackground.getState());
                } else if (evt.getSource() == JMSpaceMenuBar.this.labelBorder) {
                    graphicScene.processEvent(evt.getActionCommand(), "" + JMSpaceMenuBar.this.labelBorder.getState());
                } else if (evt.getSource() == JMSpaceMenuBar.this.labelOnlyOnHeavyAtoms) {
                    try {
                        graphicScene.setDrawProperty(evt.getActionCommand(), Boolean.toString(JMSpaceMenuBar.this.labelOnlyOnHeavyAtoms.getState()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                graphicScene.refresh();
            }
        };
        ActionListener labelSizeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphicScene.processEvent("Label.Size", evt.getActionCommand());
                graphicScene.refresh();
            }
        };
        ActionListener labelsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                graphicScene.getEventHandler().createLabels(e.getActionCommand());
                graphicScene.refresh();
            }
        };
        ActionListener qualityActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphicScene.processEvent("Quality", evt.getActionCommand());
                graphicScene.refresh();
            }
        };
        ActionListener cellActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphicScene.processEvent("Layout", evt.getActionCommand());
                graphicScene.refresh();
            }
        };
        ActionListener synchronousActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphicScene.processEvent("SynchronousMode", "" + synchronous.getState());
            }
        };
        ActionListener resetAllActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        graphicScene.resetAll();
                        graphicScene.refresh();
                    }
                });
            }
        };
        ActionListener showSurfaceActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                graphicScene.processEvent("ShowSurface", evt.getActionCommand());
                graphicScene.refresh();
            }
        };
        ActionListener showSecondaryActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String type = graphicScene.getDrawProperty("SecondaryStructure.DrawType");
                graphicScene.processEvent("ShowSecondaryStructure", type);
                graphicScene.refresh();
            }
        };
        this.copyMenuItem.addActionListener(this);
        this.cutMenuItem.addActionListener(this);
        this.pasteMenuItem.addActionListener(this);
        this.sketchMenuItem.addActionListener(this);
        ssMenuItem.addActionListener(showSecondaryActionListener);
        this.labelsOnSelection.addActionListener(labelsOnSelectionActionListener);
        this.coordinateSystem.addActionListener(coordinateSystemActionListener);
        this.addHys.addActionListener(addHydrogensActionListener);
        this.praddHys.addActionListener(addHydrogensActionListener);
        this.waddHys.addActionListener(addHydrogensActionListener);
        this.addLps.addActionListener(addLonePairsActionListener);
        this.praddLps.addActionListener(addLonePairsActionListener);
        this.waddLps.addActionListener(addLonePairsActionListener);
        smallMenuItem.addActionListener(labelSizeActionListener);
        medMenuItem.addActionListener(labelSizeActionListener);
        largeMenuItem.addActionListener(labelSizeActionListener);
        this.l2dMenuItem.addActionListener(labelTypeActionListener);
        this.labelBackground.addActionListener(labelTypeActionListener);
        this.labelBorder.addActionListener(labelTypeActionListener);
        this.labelOnlyOnHeavyAtoms.addActionListener(labelTypeActionListener);
        this.highMenuItem.addActionListener(qualityActionListener);
        this.mediumMenuItem.addActionListener(qualityActionListener);
        this.lowMenuItem.addActionListener(qualityActionListener);
        this.depthcue.addActionListener(this);
        addrow.addActionListener(cellActionListener);
        addcol.addActionListener(cellActionListener);
        delrow.addActionListener(cellActionListener);
        delcol.addActionListener(cellActionListener);
        synchronous.addActionListener(synchronousActionListener);
        resetAll.addActionListener(resetAllActionListener);
        showVDW.addActionListener(showSurfaceActionListener);
        showSAS.addActionListener(showSurfaceActionListener);
        showGauss.addActionListener(showSurfaceActionListener);
        showConnolly.addActionListener(showSurfaceActionListener);
        atomsMI.addActionListener(labelsActionListener);
        bondsMI.addActionListener(labelsActionListener);
        residuesMI.addActionListener(labelsActionListener);
        moleculesMI.addActionListener(labelsActionListener);
        secondaryMI.addActionListener(labelsActionListener);
        this.align = new AlignmentForMSpace(graphicScene);
        this.rigidAlignment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMSpaceMenuBar.this.align.setAlignmentProperties(AlignmentProperties.GAUSS_FAST_EXTENDED_ATOMTYPE, AlignmentForMSpace.AlignmentFlexMode.ALL_RIGID);
                JMSpaceMenuBar.this.align.align();
            }
        });
        this.flexibleAlignment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMSpaceMenuBar.this.align.setAlignmentProperties(AlignmentProperties.GAUSS_FAST_EXTENDED_ATOMTYPE, AlignmentForMSpace.AlignmentFlexMode.ALL_FLEX);
                JMSpaceMenuBar.this.align.align();
            }
        });
        this.detailedAlignment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentDialog ad = new AlignmentDialog(graphicScene);
                ad.setVisible(true);
            }
        });
        this.detailedDock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockDialog dd = new DockDialog(graphicScene);
                dd.setVisible(true);
            }
        });
        demo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                graphicScene.getEventHandler().startAnimation();
            }
        });
        stopDemo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                graphicScene.getEventHandler().stopAnimation();
            }
        });
        this.idleRotation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                graphicScene.getEventHandler().idleRotation(JMSpaceMenuBar.this.idleRotation.getState());
            }
        });
    }

    private void addFileFilter(JFileChooser chooser, final String ext, final String desc) {
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f != null) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String fileName = f.getName().toLowerCase();
                    if (fileName.endsWith(ext)) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String getDescription() {
                return desc;
            }
        });
    }

    public void setHelpMenu(final JApplet applet) {
        this.contents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String s = "help/space/space-index.html";
                try {
                    URL url = new URL(applet.getCodeBase(), s);
                    applet.getAppletContext().showDocument(url, "_blank");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.licenses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog d = LicenseManagerGUI.createDialog(applet);
                d.setVisible(true);
            }
        });
        this.aboutjvm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!(applet instanceof ParentPanelIface)) {
                        return;
                    }
                    JMSpaceMenuBar.this.createAboutDialog((ParentPanelIface)((Object)applet));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void createAboutDialog(ParentPanelIface ppi) {
        Component parent;
        AboutDialogImpl ajvm = new AboutDialogImpl();
        for (parent = (Component)((Object)ppi); parent != null && !(parent instanceof Window); parent = parent.getParent()) {
        }
        ajvm.setParent((Window)parent);
        ajvm.setProgramName(ppi.getProgName());
        ajvm.setVersion(ppi.getVersion());
        ajvm.setGraphicsData(GraphicScene.GLInfo + "\n" + MSpaceInstaller.joglVersion);
        ajvm.show();
    }

    public void setHelpMenu(final JFrame frame) {
        this.contents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!(frame instanceof ParentPanelIface)) {
                    return;
                }
                String s = "help/space/space-index.html";
                try {
                    URL url = this.getClass().getResource("/" + s);
                    MarvinSpaceHelp win = new MarvinSpaceHelp();
                    win.callback("setTitle", "MarvinSpace Help");
                    win.callback("setPPanel", frame);
                    win.callback("showURL", url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.licenses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog d = LicenseManagerGUI.createDialog(frame);
                d.setVisible(true);
            }
        });
        this.aboutjvm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!(frame instanceof ParentPanelIface)) {
                        return;
                    }
                    JMSpaceMenuBar.this.createAboutDialog((ParentPanelIface)((Object)frame));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void antialiasActionPerformed() {
        this.graphicScene.setAntialias(this.antialias.getState());
    }

    private void depthcueActionPerformed() {
        this.graphicScene.processEvent("Depthcue", "" + this.depthcue.getState());
    }

    private int showCloseConfirmDialog() {
        return JOptionPane.showOptionDialog(this.graphicScene, confirmText, closeTitle, 0, 3, null, confirmOptions, confirmOptions[1]);
    }

    private int showToEmptyDialog() {
        return JOptionPane.showOptionDialog(this.graphicScene, toEmptyCell, toEmptyCellTitle, 0, 3, null, toEmptyCellOptions, toEmptyCellOptions[1]);
    }

    private String getLoadingErrorMessage() {
        return "Cannot load " + this.openMoleculesFC.getSelectedFile().getAbsolutePath();
    }

    private void newMenuItemActionPerformed() {
        int returnVal = this.openMoleculesFC.showOpenDialog(this.graphicScene);
        this.graphicScene.setCursor(Cursor.getPredefinedCursor(3));
        if (returnVal == 0) {
            final File[] files = this.openMoleculesFC.getSelectedFiles();
            if (files == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (JMSpaceMenuBar.this.graphicScene.getGraphicComponentCount() > 0 && JMSpaceMenuBar.this.showCloseConfirmDialog() != 0) {
                            JMSpaceMenuBar.this.graphicScene.removeAllComponents();
                            JMSpaceMenuBar.this.graphicScene.setSceneSize(1, 1);
                            JMSpaceMenuBar.this.graphicScene.setActiveCell(0);
                        }
                        boolean multicell = false;
                        for (int i = 0; i < files.length; ++i) {
                            if (i == 1) {
                                boolean bl = multicell = JMSpaceMenuBar.this.showToEmptyDialog() != 0;
                            }
                            if (multicell) {
                                JMSpaceMenuBar.this.graphicScene.createNewCell();
                            }
                            JMSpaceMenuBar.this.eventHandler.readMoleculeFile(files[i].getAbsolutePath());
                        }
                        JMSpaceMenuBar.this.graphicScene.resetAll();
                    }
                    catch (Throwable e) {
                        JMSpaceMenuBar.this.graphicScene.setCursor(Cursor.getPredefinedCursor(0));
                        JMSpaceMenuBar.this.eventHandler.handleMyErrors(e, JMSpaceMenuBar.this.getLoadingErrorMessage());
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JMSpaceMenuBar.this.graphicScene.refresh();
                }
            });
        }
        this.graphicScene.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void openMenuItemActionPerformed() {
        int returnVal = this.openMoleculesFC.showOpenDialog(this.graphicScene);
        this.graphicScene.setCursor(Cursor.getPredefinedCursor(3));
        if (returnVal == 0) {
            final File[] files = this.openMoleculesFC.getSelectedFiles();
            if (files == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean multicell = false;
                        for (int i = 0; i < files.length; ++i) {
                            if (i == 1) {
                                boolean bl = multicell = JMSpaceMenuBar.this.showToEmptyDialog() != 0;
                            }
                            if (multicell) {
                                JMSpaceMenuBar.this.graphicScene.createNewCell();
                            }
                            JMSpaceMenuBar.this.eventHandler.readMoleculeFile(files[i].getAbsolutePath());
                        }
                        JMSpaceMenuBar.this.graphicScene.resetView();
                    }
                    catch (Throwable e) {
                        JMSpaceMenuBar.this.graphicScene.setCursor(Cursor.getPredefinedCursor(0));
                        JMSpaceMenuBar.this.eventHandler.handleMyErrors(e, JMSpaceMenuBar.this.getLoadingErrorMessage());
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JMSpaceMenuBar.this.graphicScene.refresh();
                }
            });
        }
        this.graphicScene.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void openPDBActionPerformed() {
        this.pdbDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStrucs() {
        OutputStream out = null;
        MolExporter ex = null;
        try {
            this.save.showSaveDialog(this.graphicScene);
            File toSave = this.save.getSelectedFile();
            String filename = toSave.getName();
            String[] tmp = filename.split("[.]");
            String ext = tmp[tmp.length - 1];
            String[] acceptableExt = MFileFormatUtil.getMolfileFormats();
            String selExt = ((MolFileFilter)this.save.getFileFilter()).getExtension();
            boolean acc = false;
            for (int i = 0; i < acceptableExt.length && !acc; ++i) {
                if (!acceptableExt[i].equals(ext)) continue;
                acc = true;
            }
            if (!acc) {
                if (!selExt.equals("")) {
                    filename = filename + "." + selExt;
                    ext = selExt;
                    toSave = new File(this.save.getSelectedFile() + "." + ext);
                } else {
                    this.eventHandler.handleMyErrors("Cannot recognize molecule format.", "Error saving file", 0);
                    return;
                }
            }
            out = new FileOutputStream(toSave);
            ex = new MolExporter(out, ext);
            for (int c = 0; c < this.graphicScene.getCellCount(); ++c) {
                GraphicCell cell = this.graphicScene.getCell(c);
                for (int i = 0; i < cell.getComponentCount(); ++i) {
                    if (!(cell.getComponent(i) instanceof MoleculeComponent)) continue;
                    MoleculeComponent mc = (MoleculeComponent)cell.getComponent(i);
                    ex.write(mc.getMolecule());
                }
            }
        }
        catch (ClassCastException cc) {
            this.eventHandler.handleMyErrors("Cannot recognize molecule format.", "Error saving file", 0);
        }
        catch (FileNotFoundException f) {
            this.eventHandler.handleMyErrors("Cannot find file.", "Error saving file", 0);
        }
        catch (MolExportException mf) {
            this.eventHandler.handleMyErrors("Cannot recognize molecule format.", "Error saving file", 0);
        }
        catch (IOException ioe) {
            this.eventHandler.handleMyErrors("IO error occured.", "Error saving file", 0);
        }
        finally {
            try {
                if (ex != null) {
                    ex.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {
                this.eventHandler.handleMyErrors("IO error occured at closin file.", "Error saving file", 0);
            }
        }
    }

    private void createPDBDialog() {
        this.pdbDialog = new MSpaceDialog(this.graphicScene, "Open from RCSB Protein Data Bank", true);
        final JTextField tf = new JTextField();
        tf.setPreferredSize(new Dimension(100, 30));
        JLabel pl = new JLabel("Enter PDB code: ");
        JPanel tfp = new JPanel();
        tfp.setLayout(new BoxLayout(tfp, 0));
        tfp.add(Box.createHorizontalGlue());
        tfp.add(pl);
        tfp.add(Box.createRigidArea(new Dimension(20, 0)));
        tfp.add(tf);
        tfp.add(Box.createHorizontalGlue());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMSpaceMenuBar.this.pdbDialog.setVisible(false);
            }
        });
        JButton setButton = new JButton("Ok");
        setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String pdbId = tf.getText();
                if (pdbId != null) {
                    JMSpaceMenuBar.this.loadPDBFromRCSB(pdbId);
                }
                JMSpaceMenuBar.this.pdbDialog.setVisible(false);
            }
        });
        JButton saveButton = new JButton("Save as...");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String pdbId = tf.getText();
                if (pdbId == null) {
                    return;
                }
                JMSpaceMenuBar.this.savePDBFC.setSelectedFile(new File(pdbId + ".pdb"));
                int returnVal = JMSpaceMenuBar.this.savePDBFC.showSaveDialog(JMSpaceMenuBar.this.graphicScene);
                File pdbFile = null;
                if (returnVal == 0) {
                    pdbFile = JMSpaceMenuBar.this.savePDBFC.getSelectedFile();
                    if (pdbFile == null) {
                        JMSpaceMenuBar.this.eventHandler.handleMyErrors("PDB file could not be saved", "Warning", 2);
                    }
                    JMSpaceMenuBar.this.loadPDBFromRCSB(pdbId);
                    if (pdbFile != null) {
                        try {
                            URLConnection conn = new URL(MSpaceEasy.getRCSBLink(pdbId)).openConnection();
                            InputStream is = conn.getInputStream();
                            is = new MonitorableInputStream(is, conn.getContentLength());
                            OutputStreamWriter fw = new OutputStreamWriter(new FileOutputStream(pdbFile.getPath()));
                            int b = is.read();
                            while (b != -1) {
                                fw.write(b);
                                b = is.read();
                            }
                            fw.close();
                        }
                        catch (Exception e) {
                            JMSpaceMenuBar.this.eventHandler.handleMyErrors(e, "Error saving PDB file");
                        }
                    }
                    JMSpaceMenuBar.this.pdbDialog.setVisible(false);
                }
            }
        });
        this.pdbDialog.getRootPane().setDefaultButton(setButton);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1, 10, 0));
        buttonPane.add(setButton);
        buttonPane.add(cancelButton);
        buttonPane.add(saveButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(Box.createVerticalGlue());
        mainPanel.add(tfp);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        mainPanel.add(buttonPane);
        mainPanel.add(Box.createVerticalGlue());
        this.pdbDialog.setContentPane(mainPanel);
        this.pdbDialog.pack();
    }

    private void loadPDBFromRCSB(String pdbId) {
        try {
            this.eventHandler.startOperation("Connecting to http://www.rcsb.org...");
            MolInputStream ms = MSpaceEasy.getMolInputStream(MSpaceEasy.getRCSBLink(pdbId, true));
            this.eventHandler.finishOperation();
            this.eventHandler.readPDB(ms);
            this.graphicScene.resetView();
            this.eventHandler.refresh();
        }
        catch (Throwable ex) {
            this.eventHandler.handleMyErrors(ex.getMessage(), "Error loading PDB file", 0);
        }
    }

    private void openPropertyMenuItemActionPerformed() {
        File file;
        int returnVal = this.openPropertiesFC.showOpenDialog(this.graphicScene);
        if (returnVal == 0 && (file = this.openPropertiesFC.getSelectedFile()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JMSpaceMenuBar.this.eventHandler.readPropertyFile(file.getPath());
                }
            });
        }
    }

    private void saveImageMenuItemActionPerformed() {
        int returnVal = this.saveImegeFC.showSaveDialog(this.graphicScene);
        this.graphicScene.setCursor(Cursor.getPredefinedCursor(3));
        if (returnVal == 0 && this.saveImegeFC.getSelectedFile() != null) {
            String ext = "png";
            if (this.saveImegeFC.getFileFilter() instanceof ImageFilter) {
                ext = ((ImageFilter)this.saveImegeFC.getFileFilter()).getExtension();
            }
            if (this.confirmOverwrite(this.saveImegeFC.getSelectedFile().getPath(), ext) == 1) {
                this.saveImageMenuItemActionPerformed();
            }
            this.graphicScene.setAntialias(true);
            this.graphicScene.refresh();
            this.eventHandler.exportImage(this.saveImegeFC.getSelectedFile().getPath(), ext);
            this.graphicScene.setAntialias(false);
        }
        this.graphicScene.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void loadSurfaceMenuItemActionPerformed() {
    }

    private void logActionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("LogCreate")) {
            this.eventHandler.startLog();
        } else if (e.getActionCommand().equals("LogClose")) {
            this.eventHandler.closeLog();
        } else if (e.getActionCommand().equals("LogOpen")) {
            this.eventHandler.processLog();
        } else if (e.getActionCommand().equals("LogSaveView")) {
            this.eventHandler.logCurrentView();
        }
    }

    private void closeActionPerformed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = JOptionPane.showOptionDialog(JMSpaceMenuBar.this.graphicScene, JMSpaceMenuBar.closeText, JMSpaceMenuBar.closeTitle, 0, 3, null, closeOptions, closeOptions[1]);
                if (n != 0) {
                    JMSpaceMenuBar.this.graphicScene.removeAllComponents();
                    JMSpaceMenuBar.this.graphicScene.refresh();
                }
            }
        });
    }

    private void exitActionPerformed() {
        int n = JOptionPane.showOptionDialog(this.graphicScene, exitText, exitTitle, 0, 3, null, exitOptions, exitOptions[1]);
        if (n != 0) {
            System.exit(0);
        }
    }

    private void optionsMenuItemActionPerformed() {
        this.optionsDialog.setVisible(true);
    }

    private void editActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("Copy")) {
            this.graphicScene.getEventHandler().copy();
        } else if (evt.getActionCommand().equals("Cut")) {
            this.graphicScene.getEventHandler().cut();
        } else if (evt.getActionCommand().equals("Paste")) {
            this.graphicScene.getEventHandler().paste();
        } else if (evt.getActionCommand().equals("MSketch")) {
            this.openMarvinSketch();
        }
    }

    private void openMarvinSketch() {
        JFrame frame = new JFrame();
        frame.setTitle("MarvinSketch");
        MSpaceEasy.setIconImage(frame);
        final MSketchPane sp = new MSketchPane();
        frame.setContentPane(sp);
        JMenuBar menubar = sp.getJMenuBar();
        sp.setJMenuBar(null);
        frame.setJMenuBar(menubar);
        ArrayList molecules = this.eventHandler.getSelectedMolecules();
        Molecule mol = new Molecule();
        for (int i = 0; i < molecules.size(); ++i) {
            mol.fuse(((Molecule)molecules.get(i)).cloneMolecule());
        }
        sp.setMol(mol);
        PropertyChangeListener pcl = new PropertyChangeListener(){
            MoleculeComponent mc = null;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equalsIgnoreCase("mol")) {
                    if (this.mc != null && JMSpaceMenuBar.this.graphicScene.containsComponent(this.mc)) {
                        JMSpaceMenuBar.this.graphicScene.removeComponent(this.mc);
                        JMSpaceMenuBar.this.graphicScene.getEventHandler().updateSelectionBar(this.mc);
                    }
                    this.mc = JMSpaceMenuBar.this.graphicScene.getEventHandler().setMoleculeWithoutChange(sp.getMol(), false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JMSpaceMenuBar.this.graphicScene.refresh();
                        }
                    });
                }
            }
        };
        sp.addPropertyChangeListener(pcl);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public void setValues() {
        this.setDrawTypeValues("Ligand", this.ligandDrawTypes);
        this.setDrawTypeValues("MacroMolecule", this.proteinDrawTypes);
        this.setDrawTypeValues("Water", this.waterDrawTypes);
        this.setDrawTypeValues("Ion", this.ionDrawTypes);
        this.setDrawTypeValues("PharmacophorePoint", this.phpDrawTypes);
        this.setDrawTypeValues("PharmacophoreArrow", this.phaDrawTypes);
        this.setDrawTypeValues("Surface", this.surfaceDrawTypes);
        this.setDrawTypeValues("SecondaryStructure", this.secondaryDrawTypes);
        this.setColorTypeValues("Ligand", this.ligandColorTypes);
        this.setColorTypeValues("MacroMolecule", this.proteinColorTypes);
        this.setColorTypeValues("Water", this.waterColorTypes);
        this.setColorTypeValues("Ion", this.ionColorTypes);
        this.setColorTypeValues("Surface", this.surfaceColorTypes);
        this.setColorTypeValues("SecondaryStructure", this.secondaryColorTypes);
        this.setDepthCue();
        this.setHydrogens();
        this.setQuality();
    }

    public void setDepthcue(boolean state) {
        this.depthcue.setState(state);
    }

    public void setAntialias(boolean state) {
        this.antialias.setState(state);
    }

    private void setDrawTypeValues(String componentType, ArrayList rbcontainer) {
        String drawType = this.graphicScene.getDrawProperty(componentType + ".DrawType");
        if (drawType == null) {
            return;
        }
        for (JRadioButtonMenuItem rb : rbcontainer) {
            String s = StringUtil.replaceAll(rb.getText(), " ", "");
            if (!s.equalsIgnoreCase(drawType)) continue;
            rb.setSelected(true);
        }
    }

    private void setColorTypeValues(String componentType, ArrayList rbcontainer) {
        String colorType = this.graphicScene.getDrawProperty(componentType + ".ColorType");
        if (colorType == null) {
            return;
        }
        for (JRadioButtonMenuItem rb : rbcontainer) {
            String s = StringUtil.replaceAll(rb.getText(), " ", "");
            if (!s.equalsIgnoreCase(colorType)) continue;
            rb.setSelected(true);
        }
    }

    private void setDepthCue() {
        String dc = this.graphicScene.getDrawProperty("Depthcue");
        if (dc == null) {
            return;
        }
        this.depthcue.setSelected(Boolean.valueOf(dc));
    }

    private void setHydrogens() {
        String dh = this.graphicScene.getDrawProperty("Ligand.Hydrogens");
        if (dh != null) {
            this.addHys.setSelected(Boolean.valueOf(dh));
        }
        if ((dh = this.graphicScene.getDrawProperty("Ligand.LonePairs")) != null) {
            this.addLps.setSelected(Boolean.valueOf(dh));
        }
        if ((dh = this.graphicScene.getDrawProperty("MacroMolecule.Hydrogens")) != null) {
            this.praddHys.setSelected(Boolean.valueOf(dh));
        }
        if ((dh = this.graphicScene.getDrawProperty("MacroMolecule.LonePairs")) != null) {
            this.praddLps.setSelected(Boolean.valueOf(dh));
        }
        if ((dh = this.graphicScene.getDrawProperty("Water.Hydrogens")) != null) {
            this.waddHys.setSelected(Boolean.valueOf(dh));
        }
        if ((dh = this.graphicScene.getDrawProperty("Water.LonePairs")) != null) {
            this.waddLps.setSelected(Boolean.valueOf(dh));
        }
    }

    private void setQuality() {
        String dh = this.graphicScene.getDrawProperty("Quality");
        if (dh == null) {
            return;
        }
        if (dh.equalsIgnoreCase("Low")) {
            this.lowMenuItem.setSelected(true);
        } else if (dh.equalsIgnoreCase("Medium")) {
            this.mediumMenuItem.setSelected(true);
        } else if (dh.equalsIgnoreCase("High")) {
            this.highMenuItem.setSelected(true);
        }
    }

    private int confirmOverwrite(String fileName, String format2) {
        File f;
        if (!fileName.endsWith("." + format2) && !fileName.endsWith("." + format2.toUpperCase())) {
            fileName = fileName + "." + format2;
        }
        if ((f = new File(fileName)).exists()) {
            int mode = JOptionPane.showConfirmDialog(this.graphicScene, "File " + f.getName() + " exists. Overwrite?", "File exists", 0, 2);
            return mode == 0 ? 0 : 1;
        }
        return 2;
    }

    private void labelColorActionPerformed(ActionEvent e) {
        String cs = this.graphicScene.getDrawProperty(e.getActionCommand());
        Color col = cs == null ? Color.black : Color.decode(cs);
        Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Color", col);
        if (newColor != null) {
            this.graphicScene.processEvent(e.getActionCommand(), Colors.toHexString(newColor));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.openMenuItem) {
            this.openMenuItemActionPerformed();
        } else if (source == this.openPDBMenuItem) {
            this.openPDBActionPerformed();
        } else if (source == this.openPropertyMenuItem) {
            this.openPropertyMenuItemActionPerformed();
        } else if (source == this.newMenuItem) {
            this.newMenuItemActionPerformed();
        } else if (source == this.saveImageMenuItem) {
            this.saveImageMenuItemActionPerformed();
        } else if (source == this.exportImageMenuItem) {
            ExportImageDialog eid = new ExportImageDialog();
            eid.setVisible(true);
        } else if (source == this.optionsMenuItem) {
            this.optionsMenuItemActionPerformed();
        } else if (source == this.loadSMenuItem) {
            this.loadSurfaceMenuItemActionPerformed();
        } else if (source == this.closeMenuItem) {
            this.closeActionPerformed();
        } else if (source == this.exitMenuItem) {
            this.exitActionPerformed();
        } else if (source == this.antialias) {
            this.antialiasActionPerformed();
        } else if (source == this.depthcue) {
            this.depthcueActionPerformed();
        } else if (source == this.copyMenuItem || source == this.cutMenuItem || source == this.pasteMenuItem || source == this.sketchMenuItem) {
            this.editActionPerformed(e);
        } else if (source == this.labelBackgroundColor || source == this.labelForegroundColor || source == this.labelBorderColor) {
            this.labelColorActionPerformed(e);
        } else if (source == this.logCreate || source == this.logClose || source == this.logOpen || source == this.logSaveView) {
            this.logActionPerformed(e);
        }
    }

    private void createActionListeners() {
        this.drawTypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (JMSpaceMenuBar.this.ligandDrawTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("Ligand.DrawType", e.getActionCommand());
                } else if (JMSpaceMenuBar.this.proteinDrawTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("MacroMolecule.DrawType", e.getActionCommand());
                } else if (JMSpaceMenuBar.this.waterDrawTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("Water.DrawType", e.getActionCommand());
                } else if (JMSpaceMenuBar.this.ionDrawTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("Ion.DrawType", e.getActionCommand());
                } else if (JMSpaceMenuBar.this.phpDrawTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("PharmacophorePoint.DrawType", e.getActionCommand());
                } else if (JMSpaceMenuBar.this.phaDrawTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("PharmacophoreArrow.DrawType", e.getActionCommand());
                } else if (JMSpaceMenuBar.this.surfaceDrawTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("Surface.DrawType", e.getActionCommand());
                } else if (JMSpaceMenuBar.this.secondaryDrawTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("SecondaryStructure.DrawType", e.getActionCommand());
                }
                JMSpaceMenuBar.this.graphicScene.refresh();
            }
        };
        this.colorTypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (JMSpaceMenuBar.this.ligandColorTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("Ligand.ColorType", e.getActionCommand());
                } else if (JMSpaceMenuBar.this.proteinColorTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("MacroMolecule.ColorType", e.getActionCommand());
                } else if (JMSpaceMenuBar.this.waterColorTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("Water.ColorType", e.getActionCommand());
                } else if (JMSpaceMenuBar.this.ionColorTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("Ion.ColorType", e.getActionCommand());
                } else if (JMSpaceMenuBar.this.surfaceColorTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("Surface.ColorType", e.getActionCommand());
                } else if (JMSpaceMenuBar.this.secondaryColorTypes.contains(source)) {
                    JMSpaceMenuBar.this.graphicScene.processEvent("SecondaryStructure.ColorType", e.getActionCommand());
                }
                JMSpaceMenuBar.this.graphicScene.refresh();
            }
        };
    }

    private class ExportImageDialog
    extends MSpaceDialog {
        JFormattedTextField wField;
        JFormattedTextField hField;
        JRadioButtonMenuItem s0;
        JRadioButtonMenuItem s1;
        JRadioButtonMenuItem s2;
        JRadioButtonMenuItem s3;
        JRadioButtonMenuItem s4;
        JRadioButtonMenuItem s5;
        JRadioButtonMenuItem s6;
        JRadioButtonMenuItem s7;
        JFileChooser fc;
        PropertyChangeListener pcl;
        ActionListener al;
        int width;
        int height;

        ExportImageDialog() {
            super(JMSpaceMenuBar.this.graphicScene, "Export image", true);
            this.fc = new JFileChooser();
            this.pcl = null;
            this.al = null;
            this.width = JMSpaceMenuBar.this.graphicScene.getWidth();
            this.height = JMSpaceMenuBar.this.graphicScene.getHeight();
            this.createGUI();
            this.fc.setFileFilter(new ImageFilter("tga"));
            this.fc.setFileFilter(new ImageFilter("bmp"));
            this.fc.setFileFilter(new ImageFilter("jpg"));
            this.fc.setFileFilter(new ImageFilter("png"));
        }

        private void createGUI() {
            this.pcl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!ExportImageDialog.this.wField.isEnabled()) {
                        return;
                    }
                    ExportImageDialog.this.width = ((Number)ExportImageDialog.this.wField.getValue()).intValue();
                    ExportImageDialog.this.height = ((Number)ExportImageDialog.this.hField.getValue()).intValue();
                }
            };
            this.al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Object s = evt.getSource();
                    ExportImageDialog.this.wField.setEnabled(false);
                    ExportImageDialog.this.hField.setEnabled(false);
                    if (s == ExportImageDialog.this.s0) {
                        ExportImageDialog.this.width = JMSpaceMenuBar.this.graphicScene.getWidth();
                        ExportImageDialog.this.height = JMSpaceMenuBar.this.graphicScene.getHeight();
                    } else if (s == ExportImageDialog.this.s1) {
                        ExportImageDialog.this.width = 320;
                        ExportImageDialog.this.height = 240;
                    } else if (s == ExportImageDialog.this.s2) {
                        ExportImageDialog.this.width = 640;
                        ExportImageDialog.this.height = 480;
                    } else if (s == ExportImageDialog.this.s3) {
                        ExportImageDialog.this.width = 1024;
                        ExportImageDialog.this.height = 768;
                    } else if (s == ExportImageDialog.this.s4) {
                        ExportImageDialog.this.width = 1280;
                        ExportImageDialog.this.height = 960;
                    } else if (s == ExportImageDialog.this.s5) {
                        ExportImageDialog.this.width = 2000;
                        ExportImageDialog.this.height = 1500;
                    } else if (s == ExportImageDialog.this.s6) {
                        ExportImageDialog.this.width = 3200;
                        ExportImageDialog.this.height = 2400;
                    } else {
                        ExportImageDialog.this.wField.setEnabled(true);
                        ExportImageDialog.this.hField.setEnabled(true);
                    }
                }
            };
            this.s0 = new JRadioButtonMenuItem("Current size", true);
            this.s1 = new JRadioButtonMenuItem("320 x 240");
            this.s2 = new JRadioButtonMenuItem("640 x 480");
            this.s3 = new JRadioButtonMenuItem("1024 x 768");
            this.s4 = new JRadioButtonMenuItem("1280 x 960");
            this.s5 = new JRadioButtonMenuItem("2000 x 1500");
            this.s6 = new JRadioButtonMenuItem("3200 x 2400");
            this.s7 = new JRadioButtonMenuItem("Custom");
            this.s0.addActionListener(this.al);
            this.s1.addActionListener(this.al);
            this.s2.addActionListener(this.al);
            this.s3.addActionListener(this.al);
            this.s4.addActionListener(this.al);
            this.s5.addActionListener(this.al);
            this.s6.addActionListener(this.al);
            this.s7.addActionListener(this.al);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.s0);
            bg.add(this.s1);
            bg.add(this.s2);
            bg.add(this.s3);
            bg.add(this.s4);
            bg.add(this.s5);
            bg.add(this.s6);
            bg.add(this.s7);
            Dimension textFieldSize = new Dimension(40, 20);
            JLabel wLabel = new JLabel("Width (pixels)");
            this.wField = new JFormattedTextField();
            this.wField.setValue(new Integer(this.width));
            this.wField.setHorizontalAlignment(4);
            this.wField.setMaximumSize(textFieldSize);
            this.wField.setPreferredSize(textFieldSize);
            this.wField.setEnabled(false);
            this.wField.addPropertyChangeListener(this.pcl);
            JPanel wp = new JPanel();
            wp.setLayout(new BoxLayout(wp, 0));
            wp.setAlignmentY(0.0f);
            wp.add(Box.createRigidArea(new Dimension(20, 0)));
            wp.add(wLabel);
            wp.add(Box.createRigidArea(new Dimension(20, 0)));
            wp.add(this.wField);
            JLabel hLabel = new JLabel("Height (pixels)");
            this.hField = new JFormattedTextField();
            this.hField.setValue(new Integer(this.height));
            this.hField.setHorizontalAlignment(4);
            this.hField.setMaximumSize(textFieldSize);
            this.hField.setPreferredSize(textFieldSize);
            this.hField.setEnabled(false);
            this.hField.addPropertyChangeListener(this.pcl);
            JPanel hp = new JPanel();
            hp.setLayout(new BoxLayout(hp, 0));
            hp.setAlignmentY(0.0f);
            hp.add(Box.createRigidArea(new Dimension(20, 0)));
            hp.add(hLabel);
            hp.add(Box.createRigidArea(new Dimension(20, 0)));
            hp.add(this.hField);
            JPanel rYPanel = new JPanel();
            rYPanel.setLayout(new BoxLayout(rYPanel, 1));
            rYPanel.add(this.s0);
            rYPanel.add(this.s1);
            rYPanel.add(this.s2);
            rYPanel.add(this.s3);
            rYPanel.add(this.s4);
            rYPanel.add(this.s5);
            rYPanel.add(this.s6);
            rYPanel.add(this.s7);
            rYPanel.setMinimumSize(new Dimension(160, 140));
            JPanel rXPanel = new JPanel();
            rXPanel.setLayout(new BoxLayout(rXPanel, 0));
            rXPanel.add(Box.createHorizontalGlue());
            rXPanel.add(rYPanel);
            rXPanel.add(Box.createHorizontalGlue());
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(Box.createVerticalGlue());
            panel.add(Box.createRigidArea(new Dimension(0, 10)));
            panel.add(rXPanel);
            panel.add(Box.createRigidArea(new Dimension(0, 5)));
            panel.add(wp);
            panel.add(Box.createRigidArea(new Dimension(0, 5)));
            panel.add(hp);
            panel.add(Box.createRigidArea(new Dimension(0, 10)));
            panel.add(this.createButtonPane());
            panel.add(Box.createRigidArea(new Dimension(0, 10)));
            panel.add(Box.createVerticalGlue());
            panel.setPreferredSize(new Dimension(250, 250));
            this.getContentPane().add(panel);
            this.pack();
        }

        private JPanel createButtonPane() {
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ExportImageDialog.this.setVisible(false);
                    ExportImageDialog.this.dispose();
                }
            });
            JButton setButton = new JButton("Ok");
            setButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ExportImageDialog.this.setVisible(false);
                    ExportImageDialog.this.exportImageMenuItemActionPerformed();
                    ExportImageDialog.this.dispose();
                }
            });
            setButton.setActionCommand("Ok");
            this.getRootPane().setDefaultButton(setButton);
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new BoxLayout(buttonPane, 0));
            buttonPane.add(Box.createHorizontalGlue());
            buttonPane.add(setButton);
            buttonPane.add(Box.createRigidArea(new Dimension(20, 0)));
            buttonPane.add(cancelButton);
            buttonPane.add(Box.createHorizontalGlue());
            return buttonPane;
        }

        private void exportImageMenuItemActionPerformed() {
            int returnVal = this.fc.showSaveDialog(JMSpaceMenuBar.this.graphicScene);
            if (returnVal == 0 && this.fc.getSelectedFile() != null) {
                String ext = "tga";
                if (this.fc.getFileFilter() instanceof ImageFilter) {
                    ext = ((ImageFilter)this.fc.getFileFilter()).getExtension();
                }
                if (JMSpaceMenuBar.this.confirmOverwrite(this.fc.getSelectedFile().getPath(), ext) == 1) {
                    this.exportImageMenuItemActionPerformed();
                }
                final String extension = ext;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JMSpaceMenuBar.this.eventHandler.exportImage(ExportImageDialog.this.fc.getSelectedFile().getPath(), ExportImageDialog.this.width, ExportImageDialog.this.height, extension);
                    }
                });
            }
        }
    }

    private class ImageFilter
    extends FileFilter {
        String ext = "png";

        ImageFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null) {
                return extension.equalsIgnoreCase(this.ext);
            }
            return false;
        }

        public String getExtension() {
            return this.ext;
        }

        public String getExtension(File f) {
            String extension = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                extension = s.substring(i + 1).toLowerCase();
            }
            return extension;
        }

        @Override
        public String getDescription() {
            return this.ext.toUpperCase() + " Image";
        }
    }
}

