/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.MSpaceEventHandler;
import chemaxon.marvin.space.gui.MSpaceDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JMSpaceOptionsDialog
extends MSpaceDialog
implements PropertyChangeListener,
ActionListener,
ChangeListener {
    JTabbedPane tabbedPane = new JTabbedPane();
    private final GraphicScene graphicScene;
    private final MSpaceEventHandler eventHandler;
    private MSpaceOptions options = new MSpaceOptions();
    private MoleculeOptions ligandOptions;
    private MoleculeOptions proteinOptions;
    private MoleculeOptions waterOptions;
    private MoleculeOptions ionOptions;
    private ColorOptions colorOptions;
    private ControlOptions controlOptions;
    private SurfaceOptions surfaceOptions;
    private SecondaryStructureOptions secondaryOptions;
    private JLabel[] residueLabels;
    private int labelIndex;
    JFormattedTextField brtextField;
    JFormattedTextField bortextField;
    JFormattedTextField srtextField;
    JFormattedTextField lwtextField;
    JFormattedTextField bdtextField;
    JFormattedTextField bwtextField;
    JCheckBox dbo;
    JCheckBox scs;
    JCheckBox vdwBalls;
    JCheckBox bf;
    JFormattedTextField pbrtextField;
    JFormattedTextField pbortextField;
    JFormattedTextField psrtextField;
    JFormattedTextField plwtextField;
    JFormattedTextField pbdtextField;
    JFormattedTextField pbwtextField;
    JCheckBox pdbo;
    JCheckBox pscs;
    JCheckBox pvdwBalls;
    JFormattedTextField wbrtextField;
    JFormattedTextField wbortextField;
    JFormattedTextField wsrtextField;
    JFormattedTextField wlwtextField;
    JFormattedTextField wbdtextField;
    JFormattedTextField wbwtextField;
    JCheckBox wdbo;
    JCheckBox wscs;
    JCheckBox wvdwBalls;
    JFormattedTextField ibrtextField;
    JFormattedTextField ilwtextField;
    JButton ligandColor;
    JButton proteinColor;
    JButton waterColor;
    JButton ionColor;
    JButton surfaceColor;
    JButton helixColor;
    JButton sheetColor;
    JButton turnColor;
    JButton coilColor;
    JButton cColor;
    JButton hColor;
    JButton oColor;
    JButton nColor;
    JButton pColor;
    JButton sColor;
    JButton selColor;
    JButton uColor;
    JToggleButton bgcolor;
    JRadioButton defaultResidues;
    JRadioButton setorResidues;
    JComboBox rotation;
    JComboBox zoom;
    JComboBox popup;
    JComboBox translate;
    JComboBox controls;
    JRadioButton defaultStyle;
    JRadioButton customStyle;
    JCheckBox invertZoom;
    JCheckBox drawSphere;
    JCheckBox weakeningRotation;
    JCheckBox antialiasDisable;
    JCheckBox transparentBackground;
    JCheckBox smoothBackground;
    JCheckBox autoResolution;
    JCheckBox manResolution;
    JCheckBox simplification;
    JFormattedTextField probeRadius;
    JFormattedTextField gridStep;
    JFormattedTextField rotationAngle;
    JSpinner helixWidth;
    JSpinner helixDepth;
    JSpinner helixShift;
    JSpinner helixArrowWidth;
    JSpinner sheetWidth;
    JSpinner sheetDepth;
    JSpinner sheetArrowWidth;
    JSpinner coilWidth;
    JSpinner coilDepth;
    JCheckBox helixArrow;
    JCheckBox sheetArrow;
    JCheckBox coilUniform;
    JButton resetButton;
    JSpinner threads;
    Dimension spinnerMaxSize;
    Dimension labelSize;
    Dimension textFieldSize;

    public JMSpaceOptionsDialog(GraphicScene graphicScene, MSpaceEventHandler eventHandler) {
        super(graphicScene, "MarvinSpace Options", false);
        this.ligandOptions = this.options.ligandOptions;
        this.proteinOptions = this.options.proteinOptions;
        this.waterOptions = this.options.waterOptions;
        this.ionOptions = this.options.ionOptions;
        this.colorOptions = this.options.colorOptions;
        this.controlOptions = this.options.controlOptions;
        this.surfaceOptions = this.options.surfaceOptions;
        this.secondaryOptions = this.options.secondaryOptions;
        this.residueLabels = new JLabel[34];
        this.labelIndex = 0;
        this.spinnerMaxSize = new Dimension(100, 23);
        this.labelSize = new Dimension(80, 23);
        this.textFieldSize = new Dimension(50, 23);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.graphicScene = graphicScene;
        this.eventHandler = eventHandler;
        eventHandler.initOptions(this.options);
        this.createTabbedPane();
        JPanel tabbedPanel = new JPanel();
        tabbedPanel.setLayout(new BoxLayout(tabbedPanel, 0));
        tabbedPanel.add(Box.createRigidArea(new Dimension(7, 0)));
        tabbedPanel.add(this.tabbedPane);
        tabbedPanel.add(Box.createRigidArea(new Dimension(7, 0)));
        this.getContentPane().add(tabbedPanel);
        this.getContentPane().add(Box.createRigidArea(new Dimension(0, 7)));
        this.getContentPane().add(this.createButtonPane());
        this.getContentPane().add(Box.createRigidArea(new Dimension(0, 7)));
        this.pack();
    }

    public MSpaceOptions getOptions() {
        return this.options;
    }

    protected JPanel createButtonPane() {
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMSpaceOptionsDialog.this.setVisible(false);
            }
        });
        JButton setButton = new JButton("Ok");
        setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMSpaceOptionsDialog.this.eventHandler.setOptions();
                JMSpaceOptionsDialog.this.setVisible(false);
            }
        });
        setButton.setActionCommand("Ok");
        JButton applyButton = new JButton("Apply");
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMSpaceOptionsDialog.this.eventHandler.setOptions();
            }
        });
        this.getRootPane().setDefaultButton(setButton);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(setButton);
        buttonPane.add(Box.createRigidArea(new Dimension(20, 0)));
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(20, 0)));
        buttonPane.add(applyButton);
        buttonPane.add(Box.createHorizontalGlue());
        return buttonPane;
    }

    protected void createTabbedPane() {
        JComponent vPanel = this.createVisualizerPanel();
        this.tabbedPane.addTab("Visualizers", vPanel);
        JComponent surfacePanel = this.createSurfacePanel();
        this.tabbedPane.addTab("Surface", surfacePanel);
        JComponent secondaryPanel = this.createSecondaryPanel();
        this.tabbedPane.addTab("Secondary Structure", secondaryPanel);
        JComponent colorPanel = this.createColorPanel();
        this.tabbedPane.addTab("Colors", colorPanel);
        JComponent controlPanel = this.createControlPanel();
        this.tabbedPane.addTab("Controls", controlPanel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getOldValue() == null || e.getNewValue() == null) {
            return;
        }
        Object source = e.getSource();
        if (source == this.brtextField) {
            this.ligandOptions.setBallRadius(((Number)this.brtextField.getValue()).doubleValue());
        } else if (source == this.bortextField) {
            this.ligandOptions.setBondRadius(((Number)this.bortextField.getValue()).doubleValue());
        } else if (source == this.srtextField) {
            this.ligandOptions.setStickRadius(((Number)this.srtextField.getValue()).doubleValue());
        } else if (source == this.lwtextField) {
            this.ligandOptions.setLineWidth(((Number)this.lwtextField.getValue()).doubleValue());
        } else if (source == this.bdtextField) {
            this.ligandOptions.setBondDistance(((Number)this.bdtextField.getValue()).intValue());
        } else if (source == this.bwtextField) {
            this.ligandOptions.setBondWidth(((Number)this.bwtextField.getValue()).intValue());
        } else if (source == this.pbrtextField) {
            this.proteinOptions.setBallRadius(((Number)this.pbrtextField.getValue()).doubleValue());
        } else if (source == this.pbortextField) {
            this.proteinOptions.setBondRadius(((Number)this.pbortextField.getValue()).doubleValue());
        } else if (source == this.psrtextField) {
            this.proteinOptions.setStickRadius(((Number)this.psrtextField.getValue()).doubleValue());
        } else if (source == this.plwtextField) {
            this.proteinOptions.setLineWidth(((Number)this.plwtextField.getValue()).doubleValue());
        } else if (source == this.pbdtextField) {
            this.proteinOptions.setBondDistance(((Number)this.pbdtextField.getValue()).intValue());
        } else if (source == this.pbwtextField) {
            this.proteinOptions.setBondWidth(((Number)this.pbwtextField.getValue()).intValue());
        } else if (source == this.wbrtextField) {
            this.waterOptions.setBallRadius(((Number)this.wbrtextField.getValue()).doubleValue());
        } else if (source == this.wbortextField) {
            this.waterOptions.setBondRadius(((Number)this.wbortextField.getValue()).doubleValue());
        } else if (source == this.wsrtextField) {
            this.waterOptions.setStickRadius(((Number)this.wsrtextField.getValue()).doubleValue());
        } else if (source == this.wlwtextField) {
            this.waterOptions.setLineWidth(((Number)this.wlwtextField.getValue()).doubleValue());
        } else if (source == this.wbdtextField) {
            this.waterOptions.setBondDistance(((Number)this.wbdtextField.getValue()).intValue());
        } else if (source == this.wbwtextField) {
            this.waterOptions.setBondWidth(((Number)this.wbwtextField.getValue()).intValue());
        } else if (source == this.ibrtextField) {
            this.ionOptions.setBallRadius(((Number)this.ibrtextField.getValue()).doubleValue());
        } else if (source == this.ilwtextField) {
            this.ionOptions.setLineWidth(((Number)this.ilwtextField.getValue()).doubleValue());
        } else if (source == this.probeRadius) {
            this.surfaceOptions.setProbeRadius(((Number)this.probeRadius.getValue()).doubleValue());
        } else if (source == this.gridStep) {
            this.surfaceOptions.setGridSize(((Number)this.gridStep.getValue()).floatValue());
        } else if (source == this.rotationAngle) {
            this.controlOptions.setRotationAngle(((Number)this.rotationAngle.getValue()).floatValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.scs) {
            this.ligandOptions.setSmoothSticks(this.scs.isSelected());
        } else if (source == this.vdwBalls) {
            this.ligandOptions.setScaledBalls(this.vdwBalls.isSelected());
        } else if (source == this.dbo) {
            this.ligandOptions.setDisplayBondOrder(this.dbo.isSelected());
        } else if (source == this.bf) {
            this.ligandOptions.setBondFacing(this.bf.isSelected());
        } else if (source == this.pscs) {
            this.proteinOptions.setSmoothSticks(this.pscs.isSelected());
        } else if (source == this.pvdwBalls) {
            this.proteinOptions.setScaledBalls(this.pvdwBalls.isSelected());
        } else if (source == this.pdbo) {
            this.proteinOptions.setDisplayBondOrder(this.pdbo.isSelected());
        } else if (source == this.wscs) {
            this.waterOptions.setSmoothSticks(this.wscs.isSelected());
        } else if (source == this.wvdwBalls) {
            this.waterOptions.setScaledBalls(this.wvdwBalls.isSelected());
        } else if (source == this.wdbo) {
            this.waterOptions.setDisplayBondOrder(this.wdbo.isSelected());
        } else if (source == this.bgcolor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Background Color", this.colorOptions.getBackgroudColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setBackgroundColor(newColor);
                this.bgcolor.setIcon(this.getColorIcon(newColor));
            }
        } else if (source == this.ligandColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Ligand Color", this.colorOptions.getLigandColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setLigandColor(newColor);
                this.ligandColor.setIcon(this.getColorIcon(newColor));
            }
        } else if (source == this.proteinColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Protein Color", this.colorOptions.getProteinColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setProteinColor(newColor);
                this.proteinColor.setIcon(this.getColorIcon(newColor));
            }
        } else if (source == this.waterColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Water Color", this.colorOptions.getWaterColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setWaterColor(newColor);
                this.waterColor.setIcon(this.getColorIcon(newColor));
            }
        } else if (source == this.ionColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Ion Color", this.colorOptions.getIonColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setIonColor(newColor);
                this.ionColor.setIcon(this.getColorIcon(newColor));
            }
        } else if (source == this.surfaceColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Surface Color", this.colorOptions.getSurfaceColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setSurfaceColor(newColor);
                this.surfaceColor.setIcon(this.getColorIcon(newColor));
            }
        } else if (source == this.helixColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Helix Color", this.colorOptions.getHelixColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setHelixColor(newColor);
                this.helixColor.setIcon(this.getColorIcon(newColor));
            }
        } else if (source == this.sheetColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Sheet Color", this.colorOptions.getSheetColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setSheetColor(newColor);
                this.sheetColor.setIcon(this.getColorIcon(newColor));
            }
        } else if (source == this.turnColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Turn Color", this.colorOptions.getTurnColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setTurnColor(newColor);
                this.turnColor.setIcon(this.getColorIcon(newColor));
            }
        } else if (source == this.coilColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Coil Color", this.colorOptions.getCoilColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setCoilColor(newColor);
                this.coilColor.setIcon(this.getColorIcon(newColor));
            }
        } else if (source == this.resetButton) {
            this.helixWidth.setValue(new Float(1.2f));
            this.helixDepth.setValue(new Float(0.3f));
            this.helixShift.setValue(new Float(2.5f));
            this.helixArrowWidth.setValue(new Float(3.8f));
            this.helixArrow.setSelected(true);
            this.sheetWidth.setValue(new Float(1.2f));
            this.sheetDepth.setValue(new Float(0.4f));
            this.sheetArrowWidth.setValue(new Float(3.8f));
            this.sheetArrow.setSelected(true);
            this.coilWidth.setValue(new Float(0.3f));
            this.coilDepth.setValue(new Float(0.3f));
            this.coilUniform.setSelected(true);
            this.threads.setValue(new Integer(6));
        } else if (source == this.hColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Color", this.colorOptions.getHColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setHColor(newColor);
                this.hColor.setForeground(newColor);
            }
        } else if (source == this.cColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Color", this.colorOptions.getCColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setCColor(newColor);
                this.cColor.setForeground(newColor);
            }
        } else if (source == this.nColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Color", this.colorOptions.getNColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setNColor(newColor);
                this.nColor.setForeground(newColor);
            }
        } else if (source == this.oColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Color", this.colorOptions.getOColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setOColor(newColor);
                this.oColor.setForeground(newColor);
            }
        } else if (source == this.sColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Color", this.colorOptions.getSColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setSColor(newColor);
                this.sColor.setForeground(newColor);
            }
        } else if (source == this.pColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Color", this.colorOptions.getPColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setPColor(newColor);
                this.pColor.setForeground(newColor);
            }
        } else if (source == this.uColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Color", this.colorOptions.getUnknownColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setUnknownColor(newColor);
                this.uColor.setForeground(newColor);
            }
        } else if (source == this.selColor) {
            Color newColor = JColorChooser.showDialog(this.graphicScene, "Choose Color", this.colorOptions.getSelectedColor());
            this.setVisible(true);
            if (newColor != null) {
                this.colorOptions.setSelectedColor(newColor);
                this.selColor.setForeground(newColor);
            }
        } else if (source == this.defaultResidues) {
            this.colorOptions.setDefaultResidueColors(true);
            this.setLabelColors();
        } else if (source == this.setorResidues) {
            this.colorOptions.setDefaultResidueColors(false);
            this.setLabelColors();
        } else if (source == this.customStyle) {
            this.setCustomStyleEnabled(true);
        } else if (source == this.defaultStyle) {
            this.setCustomStyleEnabled(false);
            this.controlOptions.setRotationControl(0);
            this.controlOptions.setZoomControl(1);
            this.controlOptions.setPopupControl(2);
            this.controlOptions.setTranslationControl(2);
        } else if (source == this.rotation) {
            this.controlOptions.setRotationControl(this.rotation.getSelectedIndex());
        } else if (source == this.zoom) {
            this.controlOptions.setZoomControl(this.zoom.getSelectedIndex());
        } else if (source == this.popup) {
            if (this.popup.getSelectedIndex() == 0) {
                this.controlOptions.setPopupControl(2);
            }
        } else if (source == this.translate) {
            if (this.translate.getSelectedIndex() == 0) {
                this.controlOptions.setTranslationControl(0);
            }
            if (this.translate.getSelectedIndex() == 1) {
                this.controlOptions.setTranslationControl(1);
            }
            if (this.translate.getSelectedIndex() == 2) {
                this.controlOptions.setTranslationControl(2);
            }
        } else if (source == this.invertZoom) {
            this.controlOptions.setInvertZoom(this.invertZoom.isSelected());
        } else if (source == this.drawSphere) {
            this.controlOptions.setDrawSphere(this.drawSphere.isSelected());
        } else if (source == this.weakeningRotation) {
            this.controlOptions.setWeakeningRotation(this.weakeningRotation.isSelected());
        } else if (source == this.antialiasDisable) {
            this.controlOptions.setAntialiasDisable(this.antialiasDisable.isSelected());
        } else if (source == this.transparentBackground) {
            this.colorOptions.setBackgroundTransparency(this.transparentBackground.isSelected());
        } else if (source == this.smoothBackground) {
            this.colorOptions.setSmoothBackground(this.smoothBackground.isSelected());
        } else if (source == this.simplification) {
            this.surfaceOptions.setSimplificationEnabled(this.simplification.isSelected());
        } else if (source == this.autoResolution) {
            this.surfaceOptions.setAutoResolutionEnabled(this.autoResolution.isSelected());
            if (this.autoResolution.isSelected()) {
                this.gridStep.setEnabled(false);
            }
        } else if (source == this.manResolution) {
            this.surfaceOptions.setAutoResolutionEnabled(this.autoResolution.isSelected());
            if (this.manResolution.isSelected()) {
                this.gridStep.setEnabled(true);
            }
        } else if (source == this.helixArrow) {
            this.secondaryOptions.setHelixArrow(this.helixArrow.isSelected());
        } else if (source == this.sheetArrow) {
            this.secondaryOptions.setSheetArrow(this.sheetArrow.isSelected());
        } else if (source == this.coilUniform) {
            this.secondaryOptions.setCoilUniform(this.coilUniform.isSelected());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.helixWidth) {
            this.secondaryOptions.setHelixWidth(((Number)this.helixWidth.getValue()).floatValue());
            this.helixWidth.setToolTipText("" + this.secondaryOptions.helixWidth);
        } else if (source == this.helixDepth) {
            this.secondaryOptions.setHelixDepth(((Number)this.helixDepth.getValue()).floatValue());
            this.helixDepth.setToolTipText("" + this.secondaryOptions.helixDepth);
        } else if (source == this.helixShift) {
            this.secondaryOptions.setHelixShift(((Number)this.helixShift.getValue()).floatValue());
            this.helixShift.setToolTipText("" + this.secondaryOptions.helixShift);
        } else if (source == this.helixArrowWidth) {
            this.secondaryOptions.setHelixArrowWidth(((Number)this.helixArrowWidth.getValue()).floatValue());
            this.helixArrowWidth.setToolTipText("" + this.secondaryOptions.helixArrowWidth);
        } else if (source == this.sheetWidth) {
            this.secondaryOptions.setSheetWidth(((Number)this.sheetWidth.getValue()).floatValue());
            this.sheetWidth.setToolTipText("" + this.secondaryOptions.sheetWidth);
        } else if (source == this.sheetDepth) {
            this.secondaryOptions.setSheetDepth(((Number)this.sheetDepth.getValue()).floatValue());
            this.sheetDepth.setToolTipText("" + this.secondaryOptions.sheetDepth);
        } else if (source == this.sheetArrowWidth) {
            this.secondaryOptions.setSheetArrowWidth(((Number)this.sheetArrowWidth.getValue()).floatValue());
            this.sheetArrowWidth.setToolTipText("" + this.secondaryOptions.sheetArrowWidth);
        } else if (source == this.coilWidth) {
            this.secondaryOptions.setCoilWidth(((Number)this.coilWidth.getValue()).floatValue());
            this.coilWidth.setToolTipText("" + this.secondaryOptions.coilWidth);
        } else if (source == this.coilDepth) {
            this.secondaryOptions.setCoilDepth(((Number)this.coilDepth.getValue()).floatValue());
            this.coilDepth.setToolTipText("" + this.secondaryOptions.coilDepth);
        } else if (source == this.threads) {
            this.secondaryOptions.setThreads(((Number)this.threads.getValue()).intValue());
        }
    }

    protected JFormattedTextField createTextField(double v, GridBagLayout gbl, GridBagConstraints c) {
        JFormattedTextField tf = new JFormattedTextField();
        tf.setValue(new Double(v));
        tf.setHorizontalAlignment(4);
        tf.setPreferredSize(this.textFieldSize);
        tf.addPropertyChangeListener(this);
        gbl.setConstraints(tf, c);
        return tf;
    }

    protected JFormattedTextField createTextField(GridBagLayout gbl, GridBagConstraints c) {
        JFormattedTextField tf = new JFormattedTextField();
        tf.setHorizontalAlignment(4);
        tf.setValue("n/a");
        tf.setPreferredSize(this.textFieldSize);
        tf.setEnabled(false);
        gbl.setConstraints(tf, c);
        return tf;
    }

    protected JLabel createLabel(String l, GridBagLayout gbl, GridBagConstraints c) {
        JLabel label = new JLabel(l);
        gbl.setConstraints(label, c);
        return label;
    }

    protected JCheckBox createCheckBox(boolean b, GridBagLayout gbl, GridBagConstraints c) {
        JCheckBox jcb = new JCheckBox("", b);
        jcb.addActionListener(this);
        gbl.setConstraints(jcb, c);
        return jcb;
    }

    protected JCheckBox createCheckBox(GridBagLayout gbl, GridBagConstraints c) {
        JCheckBox jcb = new JCheckBox("");
        jcb.setEnabled(false);
        gbl.setConstraints(jcb, c);
        return jcb;
    }

    protected JComponent createVisualizerPanel() {
        JPanel vPanel = new JPanel(false);
        vPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        vPanel.setLayout(gbl);
        c.insets = new Insets(2, 3, 2, 3);
        c.gridwidth = 2;
        vPanel.add(this.createLabel(" ", gbl, c));
        c.gridwidth = 1;
        c.anchor = 13;
        vPanel.add(this.createLabel("Ligand", gbl, c));
        vPanel.add(this.createLabel("Protein", gbl, c));
        vPanel.add(this.createLabel("Water", gbl, c));
        c.gridwidth = 0;
        vPanel.add(this.createLabel("Ion", gbl, c));
        c.anchor = 17;
        c.gridwidth = 2;
        vPanel.add(this.createLabel("Ball radius", gbl, c));
        c.gridwidth = 1;
        this.brtextField = this.createTextField(this.ligandOptions.ballRadius, gbl, c);
        vPanel.add(this.brtextField);
        this.pbrtextField = this.createTextField(this.proteinOptions.ballRadius, gbl, c);
        vPanel.add(this.pbrtextField);
        this.wbrtextField = this.createTextField(this.waterOptions.ballRadius, gbl, c);
        vPanel.add(this.wbrtextField);
        c.gridwidth = 0;
        this.ibrtextField = this.createTextField(this.ionOptions.ballRadius, gbl, c);
        vPanel.add(this.ibrtextField);
        c.gridwidth = 2;
        vPanel.add(this.createLabel("Ball&Stick mode: bond radius", gbl, c));
        c.gridwidth = 1;
        this.bortextField = this.createTextField(this.ligandOptions.bondRadius, gbl, c);
        this.pbortextField = this.createTextField(this.proteinOptions.bondRadius, gbl, c);
        this.wbortextField = this.createTextField(this.waterOptions.bondRadius, gbl, c);
        c.gridwidth = 0;
        JFormattedTextField ibortextField = this.createTextField(gbl, c);
        vPanel.add(this.bortextField);
        vPanel.add(this.pbortextField);
        vPanel.add(this.wbortextField);
        vPanel.add(ibortextField);
        c.gridwidth = 2;
        vPanel.add(this.createLabel("Stick mode: bond radius", gbl, c));
        c.gridwidth = 1;
        this.srtextField = this.createTextField(this.ligandOptions.stickRadius, gbl, c);
        this.psrtextField = this.createTextField(this.proteinOptions.stickRadius, gbl, c);
        this.wsrtextField = this.createTextField(this.waterOptions.stickRadius, gbl, c);
        c.gridwidth = 0;
        JFormattedTextField isrtextField = this.createTextField(gbl, c);
        vPanel.add(this.srtextField);
        vPanel.add(this.psrtextField);
        vPanel.add(this.wsrtextField);
        vPanel.add(isrtextField);
        c.gridwidth = 2;
        vPanel.add(this.createLabel("Line width", gbl, c));
        c.gridwidth = 1;
        this.lwtextField = this.createTextField(this.ligandOptions.lineWidth, gbl, c);
        this.plwtextField = this.createTextField(this.proteinOptions.lineWidth, gbl, c);
        this.wlwtextField = this.createTextField(this.waterOptions.lineWidth, gbl, c);
        c.gridwidth = 0;
        this.ilwtextField = this.createTextField(this.ionOptions.lineWidth, gbl, c);
        vPanel.add(this.lwtextField);
        vPanel.add(this.plwtextField);
        vPanel.add(this.wlwtextField);
        vPanel.add(this.ilwtextField);
        c.gridwidth = 2;
        vPanel.add(this.createLabel("Double bond distance (%)", gbl, c));
        c.gridwidth = 1;
        this.bdtextField = this.createTextField(this.ligandOptions.bondDistance, gbl, c);
        this.pbdtextField = this.createTextField(this.proteinOptions.bondDistance, gbl, c);
        this.wbdtextField = this.createTextField(this.waterOptions.bondDistance, gbl, c);
        c.gridwidth = 0;
        JFormattedTextField ibdtextField = this.createTextField(gbl, c);
        vPanel.add(this.bdtextField);
        vPanel.add(this.pbdtextField);
        vPanel.add(this.wbdtextField);
        vPanel.add(ibdtextField);
        c.gridwidth = 2;
        vPanel.add(this.createLabel("Double bond width (%)", gbl, c));
        c.gridwidth = 1;
        this.bwtextField = this.createTextField(this.ligandOptions.bondWidth, gbl, c);
        this.pbwtextField = this.createTextField(this.proteinOptions.bondWidth, gbl, c);
        this.wbwtextField = this.createTextField(this.waterOptions.bondWidth, gbl, c);
        c.gridwidth = 0;
        JFormattedTextField ibwtextField = this.createTextField(gbl, c);
        vPanel.add(this.bwtextField);
        vPanel.add(this.pbwtextField);
        vPanel.add(this.wbwtextField);
        vPanel.add(ibwtextField);
        c.gridwidth = 2;
        vPanel.add(this.createLabel("Display bond order", gbl, c));
        c.anchor = 13;
        c.gridwidth = 1;
        this.dbo = this.createCheckBox(this.ligandOptions.displayBondOrder, gbl, c);
        vPanel.add(this.dbo);
        this.pdbo = this.createCheckBox(this.proteinOptions.displayBondOrder, gbl, c);
        vPanel.add(this.pdbo);
        this.wdbo = this.createCheckBox(this.waterOptions.displayBondOrder, gbl, c);
        vPanel.add(this.wdbo);
        c.gridwidth = 0;
        JCheckBox idbo = this.createCheckBox(gbl, c);
        vPanel.add(idbo);
        c.anchor = 17;
        c.gridwidth = 2;
        vPanel.add(this.createLabel("VdW scaled balls", gbl, c));
        c.anchor = 13;
        c.gridwidth = 1;
        this.vdwBalls = this.createCheckBox(this.ligandOptions.scaledBalls, gbl, c);
        vPanel.add(this.vdwBalls);
        this.pvdwBalls = this.createCheckBox(this.proteinOptions.scaledBalls, gbl, c);
        vPanel.add(this.pvdwBalls);
        this.wvdwBalls = this.createCheckBox(this.waterOptions.scaledBalls, gbl, c);
        vPanel.add(this.wvdwBalls);
        c.gridwidth = 0;
        JCheckBox pvdiBalls = this.createCheckBox(gbl, c);
        vPanel.add(pvdiBalls);
        c.anchor = 17;
        c.gridwidth = 2;
        vPanel.add(this.createLabel("Smooth colored sticks", gbl, c));
        c.anchor = 13;
        c.gridwidth = 1;
        this.scs = this.createCheckBox(this.ligandOptions.smoothSticks, gbl, c);
        vPanel.add(this.scs);
        this.pscs = this.createCheckBox(this.proteinOptions.smoothSticks, gbl, c);
        vPanel.add(this.pscs);
        this.wscs = this.createCheckBox(this.waterOptions.smoothSticks, gbl, c);
        vPanel.add(this.wscs);
        c.gridwidth = 0;
        JCheckBox iscs = this.createCheckBox(gbl, c);
        vPanel.add(iscs);
        c.anchor = 17;
        c.gridwidth = 2;
        vPanel.add(this.createLabel("Front facing bonds", gbl, c));
        c.anchor = 13;
        c.gridwidth = 1;
        this.bf = this.createCheckBox(this.ligandOptions.bondFacing, gbl, c);
        vPanel.add(this.bf);
        return vPanel;
    }

    protected JComponent createColorPanel() {
        JPanel colorPanel = new JPanel(false);
        colorPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        colorPanel.setLayout(gbl);
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        JPanel backgroundColor = new JPanel();
        backgroundColor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Background"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        backgroundColor.setLayout(new BoxLayout(backgroundColor, 1));
        JLabel bglabel = new JLabel("Color");
        this.bgcolor = new JToggleButton(this.getColorIcon(this.colorOptions.getBackgroudColor()));
        this.bgcolor.addActionListener(this);
        JPanel bg = new JPanel();
        bg.setLayout(new BoxLayout(bg, 0));
        bg.setAlignmentY(0.0f);
        bg.add(bglabel);
        bg.add(Box.createHorizontalGlue());
        bg.add(this.bgcolor);
        this.transparentBackground = new JCheckBox("Transparent", true);
        this.transparentBackground.addActionListener(this);
        this.smoothBackground = new JCheckBox("Smooth");
        this.smoothBackground.addActionListener(this);
        JPanel tr = new JPanel();
        tr.setLayout(new BoxLayout(tr, 0));
        tr.setAlignmentY(0.0f);
        tr.add(this.transparentBackground);
        tr.add(this.smoothBackground);
        backgroundColor.add(bg);
        backgroundColor.add(Box.createVerticalGlue());
        backgroundColor.add(tr);
        JPanel colorStylePanel = new JPanel();
        colorStylePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Atom Colors"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        colorStylePanel.setLayout(new GridLayout(3, 2));
        this.createAtomColorButtons();
        colorStylePanel.add(this.hColor);
        colorStylePanel.add(this.cColor);
        colorStylePanel.add(this.nColor);
        colorStylePanel.add(this.oColor);
        colorStylePanel.add(this.sColor);
        colorStylePanel.add(this.pColor);
        colorStylePanel.add(this.uColor);
        colorStylePanel.add(this.selColor);
        JPanel constantColor = new JPanel();
        constantColor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Constant colors"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        constantColor.setLayout(new GridLayout(5, 2, 2, 5));
        this.ligandColor = new JButton("Ligand", this.getColorIcon(this.colorOptions.getLigandColor()));
        this.ligandColor.setHorizontalAlignment(10);
        this.ligandColor.addActionListener(this);
        this.proteinColor = new JButton("Protein", this.getColorIcon(this.colorOptions.getProteinColor()));
        this.proteinColor.setHorizontalAlignment(10);
        this.proteinColor.addActionListener(this);
        this.waterColor = new JButton("Water", this.getColorIcon(this.colorOptions.getWaterColor()));
        this.waterColor.setHorizontalAlignment(10);
        this.waterColor.addActionListener(this);
        this.ionColor = new JButton("Ion", this.getColorIcon(this.colorOptions.getIonColor()));
        this.ionColor.setHorizontalAlignment(10);
        this.ionColor.addActionListener(this);
        this.surfaceColor = new JButton("Surface", this.getColorIcon(this.colorOptions.getSurfaceColor()));
        this.surfaceColor.setHorizontalAlignment(10);
        this.surfaceColor.addActionListener(this);
        this.helixColor = new JButton("Helix", this.getColorIcon(this.colorOptions.getHelixColor()));
        this.helixColor.setHorizontalAlignment(10);
        this.helixColor.addActionListener(this);
        this.sheetColor = new JButton("Sheet", this.getColorIcon(this.colorOptions.getSheetColor()));
        this.sheetColor.setHorizontalAlignment(10);
        this.sheetColor.addActionListener(this);
        this.turnColor = new JButton("Turn", this.getColorIcon(this.colorOptions.getTurnColor()));
        this.turnColor.setHorizontalAlignment(10);
        this.turnColor.addActionListener(this);
        this.coilColor = new JButton("Coil", this.getColorIcon(this.colorOptions.getCoilColor()));
        this.coilColor.setHorizontalAlignment(10);
        this.coilColor.addActionListener(this);
        constantColor.add(this.ligandColor);
        constantColor.add(this.helixColor);
        constantColor.add(this.proteinColor);
        constantColor.add(this.sheetColor);
        constantColor.add(this.waterColor);
        constantColor.add(this.turnColor);
        constantColor.add(this.ionColor);
        constantColor.add(this.coilColor);
        constantColor.add(this.surfaceColor);
        JPanel residuePanel = new JPanel();
        residuePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Residue colors"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        residuePanel.setLayout(new BoxLayout(residuePanel, 1));
        JPanel firstRowPanel = new JPanel();
        firstRowPanel.setLayout(new BoxLayout(firstRowPanel, 0));
        firstRowPanel.add(this.getResidueLabel("ALA"));
        firstRowPanel.add(Box.createHorizontalGlue());
        firstRowPanel.add(this.getResidueLabel("ARG"));
        firstRowPanel.add(Box.createHorizontalGlue());
        firstRowPanel.add(this.getResidueLabel("ASN"));
        firstRowPanel.add(Box.createHorizontalGlue());
        firstRowPanel.add(this.getResidueLabel("ASP"));
        firstRowPanel.add(Box.createHorizontalGlue());
        firstRowPanel.add(this.getResidueLabel("ASX"));
        firstRowPanel.add(Box.createHorizontalGlue());
        firstRowPanel.add(this.getResidueLabel("CYS"));
        firstRowPanel.add(Box.createHorizontalGlue());
        firstRowPanel.add(this.getResidueLabel("GLN"));
        firstRowPanel.add(Box.createHorizontalGlue());
        firstRowPanel.add(this.getResidueLabel("GLU"));
        firstRowPanel.add(Box.createHorizontalGlue());
        firstRowPanel.add(this.getResidueLabel("GLX"));
        firstRowPanel.add(Box.createHorizontalGlue());
        firstRowPanel.add(this.getResidueLabel("GLY"));
        firstRowPanel.add(Box.createHorizontalGlue());
        firstRowPanel.add(this.getResidueLabel("HIS"));
        residuePanel.add(firstRowPanel);
        JPanel secondRowPanel = new JPanel();
        secondRowPanel.setLayout(new BoxLayout(secondRowPanel, 0));
        secondRowPanel.add(this.getResidueLabel("ILE"));
        secondRowPanel.add(Box.createHorizontalGlue());
        secondRowPanel.add(this.getResidueLabel("LEU"));
        secondRowPanel.add(Box.createHorizontalGlue());
        secondRowPanel.add(this.getResidueLabel("LYS"));
        secondRowPanel.add(Box.createHorizontalGlue());
        secondRowPanel.add(this.getResidueLabel("MET"));
        secondRowPanel.add(Box.createHorizontalGlue());
        secondRowPanel.add(this.getResidueLabel("PHE"));
        secondRowPanel.add(Box.createHorizontalGlue());
        secondRowPanel.add(this.getResidueLabel("PRO"));
        secondRowPanel.add(Box.createHorizontalGlue());
        secondRowPanel.add(this.getResidueLabel("SER"));
        secondRowPanel.add(Box.createHorizontalGlue());
        secondRowPanel.add(this.getResidueLabel("THR"));
        secondRowPanel.add(Box.createHorizontalGlue());
        secondRowPanel.add(this.getResidueLabel("TRP"));
        secondRowPanel.add(Box.createHorizontalGlue());
        secondRowPanel.add(this.getResidueLabel("TYR"));
        secondRowPanel.add(Box.createHorizontalGlue());
        secondRowPanel.add(this.getResidueLabel("VAL"));
        residuePanel.add(secondRowPanel);
        JPanel thirdRowPanel = new JPanel();
        thirdRowPanel.setLayout(new BoxLayout(thirdRowPanel, 0));
        thirdRowPanel.add(Box.createHorizontalGlue());
        thirdRowPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        thirdRowPanel.add(this.getAminoLabel("A"));
        thirdRowPanel.add(this.getAminoLabel("+A"));
        thirdRowPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        thirdRowPanel.add(this.getAminoLabel("C"));
        thirdRowPanel.add(this.getAminoLabel("+C"));
        thirdRowPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        thirdRowPanel.add(this.getAminoLabel("G"));
        thirdRowPanel.add(this.getAminoLabel("+G"));
        thirdRowPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        thirdRowPanel.add(this.getAminoLabel("T"));
        thirdRowPanel.add(this.getAminoLabel("+T"));
        thirdRowPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        thirdRowPanel.add(this.getAminoLabel("I"));
        thirdRowPanel.add(this.getAminoLabel("+I"));
        thirdRowPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        thirdRowPanel.add(this.getAminoLabel("U"));
        thirdRowPanel.add(this.getAminoLabel("+U"));
        thirdRowPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        thirdRowPanel.add(Box.createHorizontalGlue());
        residuePanel.add(thirdRowPanel);
        JPanel fourthRowPanel = new JPanel();
        fourthRowPanel.setLayout(new BoxLayout(fourthRowPanel, 0));
        this.defaultResidues = new JRadioButton("Default colors", true);
        this.setorResidues = new JRadioButton("Setor colors");
        ButtonGroup rbg = new ButtonGroup();
        rbg.add(this.defaultResidues);
        rbg.add(this.setorResidues);
        fourthRowPanel.add(this.defaultResidues);
        fourthRowPanel.add(this.setorResidues);
        this.defaultResidues.addActionListener(this);
        this.setorResidues.addActionListener(this);
        residuePanel.add(fourthRowPanel);
        c.gridwidth = 1;
        c.gridheight = 2;
        c.weighty = 1.0;
        gbl.setConstraints(constantColor, c);
        colorPanel.add(constantColor);
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.gridheight = 1;
        gbl.setConstraints(backgroundColor, c);
        colorPanel.add(backgroundColor);
        gbl.setConstraints(colorStylePanel, c);
        colorPanel.add(colorStylePanel);
        c.weightx = 2.0;
        c.gridwidth = 0;
        gbl.setConstraints(residuePanel, c);
        colorPanel.add(residuePanel);
        return colorPanel;
    }

    private void setLabelColors() {
        for (int i = 0; i < this.residueLabels.length; ++i) {
            JLabel label = this.residueLabels[i];
            float[] c = null;
            c = this.defaultResidues.isSelected() ? Colors.getResidueColor(label.getText()) : Colors.getSETORResidueColor(label.getText());
            Color col = new Color(c[0], c[1], c[2]);
            label.setForeground(col);
            label.setToolTipText("Red: " + col.getRed() + " Green: " + col.getGreen() + " Blue: " + col.getBlue());
            label.repaint();
        }
    }

    protected JComponent createControlPanel() {
        JPanel controlPanel = new JPanel(false);
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.setAlignmentX(0.0f);
        this.defaultStyle = new JRadioButton("Default style");
        this.defaultStyle.addActionListener(this);
        this.customStyle = new JRadioButton("Custom style");
        this.customStyle.addActionListener(this);
        ButtonGroup controlStyles = new ButtonGroup();
        controlStyles.add(this.defaultStyle);
        controlStyles.add(this.customStyle);
        JPanel controlStylePanel = new JPanel(false);
        controlStylePanel.setLayout(new BoxLayout(controlStylePanel, 1));
        controlStylePanel.add(this.defaultStyle);
        controlStylePanel.add(this.customStyle);
        JPanel vcsPanel = new JPanel();
        vcsPanel.setLayout(new BoxLayout(vcsPanel, 0));
        vcsPanel.add(controlStylePanel);
        vcsPanel.add(Box.createHorizontalGlue());
        JPanel controlStylePanelWithCustoms = new JPanel(false);
        controlStylePanelWithCustoms.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Control style"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        controlStylePanelWithCustoms.setLayout(new BoxLayout(controlStylePanelWithCustoms, 1));
        controlStylePanelWithCustoms.add(vcsPanel);
        controlStylePanelWithCustoms.add(this.createCustomStyleControlPanel());
        JLabel raLabel = new JLabel("Demo rotation angle (degrees)");
        this.rotationAngle = new JFormattedTextField();
        this.rotationAngle.setValue(new Double(this.controlOptions.rotationAngle));
        this.rotationAngle.setHorizontalAlignment(4);
        this.rotationAngle.setMaximumSize(this.textFieldSize);
        this.rotationAngle.setPreferredSize(this.textFieldSize);
        this.rotationAngle.addPropertyChangeListener(this);
        JPanel br = new JPanel();
        br.setLayout(new BoxLayout(br, 0));
        br.add(Box.createHorizontalStrut(4));
        br.add(raLabel);
        br.add(Box.createHorizontalStrut(20));
        br.add(this.rotationAngle);
        br.add(Box.createHorizontalGlue());
        this.invertZoom = new JCheckBox("Invert zoom", this.controlOptions.invertZoom);
        this.invertZoom.addActionListener(this);
        this.drawSphere = new JCheckBox("Draw rotation sphere", this.controlOptions.drawSphere);
        this.drawSphere.addActionListener(this);
        this.weakeningRotation = new JCheckBox("Animated rotation", this.controlOptions.weakeningRotation);
        this.weakeningRotation.addActionListener(this);
        this.antialiasDisable = new JCheckBox("Disable antialias on mouse move", this.controlOptions.antialiasDisable);
        this.antialiasDisable.addActionListener(this);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 1));
        checkBoxPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        checkBoxPanel.add(this.invertZoom);
        checkBoxPanel.add(this.drawSphere);
        checkBoxPanel.add(this.weakeningRotation);
        checkBoxPanel.add(this.antialiasDisable);
        checkBoxPanel.add(Box.createVerticalGlue());
        JPanel chXPanel = new JPanel();
        chXPanel.setLayout(new BoxLayout(chXPanel, 0));
        chXPanel.add(checkBoxPanel);
        chXPanel.add(Box.createHorizontalGlue());
        JPanel cswcPanel = new JPanel();
        cswcPanel.setLayout(new BoxLayout(cswcPanel, 1));
        cswcPanel.add(controlStylePanelWithCustoms);
        cswcPanel.add(Box.createVerticalGlue());
        switch (this.controlOptions.controlStyle) {
            case 1: {
                this.defaultStyle.setSelected(true);
                this.setCustomStyleEnabled(false);
                break;
            }
            case 3: {
                this.customStyle.setSelected(true);
                this.setCustomStyleEnabled(true);
            }
        }
        controlPanel.add(cswcPanel);
        controlPanel.add(br);
        controlPanel.add(chXPanel);
        controlPanel.add(Box.createVerticalGlue());
        return controlPanel;
    }

    protected JComponent createSurfacePanel() {
        JPanel surfacePanel = new JPanel(false);
        surfacePanel.setLayout(new BoxLayout(surfacePanel, 0));
        Dimension textFieldSize = new Dimension(40, 20);
        JLabel prLabel = new JLabel("Probe radius");
        this.probeRadius = new JFormattedTextField();
        this.probeRadius.setValue(new Double(this.surfaceOptions.probeRadius));
        this.probeRadius.setHorizontalAlignment(4);
        this.probeRadius.setMaximumSize(textFieldSize);
        this.probeRadius.setPreferredSize(textFieldSize);
        this.probeRadius.addPropertyChangeListener(this);
        JPanel br = new JPanel();
        br.setLayout(new BoxLayout(br, 0));
        br.add(prLabel);
        br.add(Box.createHorizontalGlue());
        br.add(this.probeRadius);
        this.autoResolution = new JCheckBox("Automatic surface resolution", true);
        this.manResolution = new JCheckBox("Manual surface resolution", false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.autoResolution);
        bg.add(this.manResolution);
        this.autoResolution.addActionListener(this);
        this.manResolution.addActionListener(this);
        JPanel chPanel = new JPanel();
        chPanel.setLayout(new BoxLayout(chPanel, 1));
        chPanel.add(this.autoResolution);
        chPanel.add(this.manResolution);
        JPanel cxPanel = new JPanel();
        cxPanel.setLayout(new BoxLayout(cxPanel, 0));
        cxPanel.add(chPanel);
        cxPanel.add(Box.createHorizontalGlue());
        JLabel grLabel = new JLabel("Surface precision (\u00c5)");
        this.gridStep = new JFormattedTextField();
        this.gridStep.setValue(new Double(this.surfaceOptions.gridSize));
        this.gridStep.setHorizontalAlignment(4);
        this.gridStep.setMaximumSize(textFieldSize);
        this.gridStep.setPreferredSize(textFieldSize);
        this.gridStep.addPropertyChangeListener(this);
        JPanel gr = new JPanel();
        gr.setLayout(new BoxLayout(gr, 0));
        gr.add(Box.createRigidArea(new Dimension(60, 0)));
        gr.add(grLabel);
        gr.add(Box.createHorizontalGlue());
        gr.add(this.gridStep);
        this.gridStep.setEnabled(false);
        JPanel simpliPanel = new JPanel();
        simpliPanel.setLayout(new BoxLayout(simpliPanel, 1));
        this.simplification = new JCheckBox("Surface triangle count reduction", this.surfaceOptions.getSimplificationEnabled());
        this.simplification.addActionListener(this);
        simpliPanel.add(this.simplification);
        JPanel sxPanel = new JPanel();
        sxPanel.setLayout(new BoxLayout(sxPanel, 0));
        sxPanel.add(simpliPanel);
        sxPanel.add(Box.createHorizontalGlue());
        JPanel yPanel = new JPanel();
        yPanel.setLayout(new BoxLayout(yPanel, 1));
        yPanel.add(Box.createRigidArea(new Dimension(0, 30)));
        yPanel.add(br);
        yPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        yPanel.add(cxPanel);
        yPanel.add(gr);
        yPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        yPanel.add(sxPanel);
        yPanel.add(Box.createVerticalGlue());
        surfacePanel.add(Box.createRigidArea(new Dimension(20, 0)));
        surfacePanel.add(yPanel);
        surfacePanel.add(Box.createRigidArea(new Dimension(50, 0)));
        return surfacePanel;
    }

    protected JComponent createSecondaryPanel() {
        JPanel secondaryPanel = new JPanel(false);
        secondaryPanel.setLayout(new BoxLayout(secondaryPanel, 1));
        JPanel p1 = new JPanel(new GridLayout(1, 2));
        p1.add(this.createHelixPanel());
        p1.add(this.createSheetPanel());
        JPanel p2 = new JPanel(new GridLayout(1, 2));
        p2.add(this.createCoilPanel());
        p2.add(this.createSecPanel());
        secondaryPanel.add(p1);
        secondaryPanel.add(p2);
        return secondaryPanel;
    }

    protected JPanel createHelixPanel() {
        JPanel helixPanel = new JPanel();
        helixPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Helix"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        helixPanel.setLayout(new BoxLayout(helixPanel, 1));
        JLabel hwl = new JLabel("Width:");
        hwl.setPreferredSize(this.labelSize);
        this.helixWidth = new JSpinner(new SpinnerNumberModel(this.secondaryOptions.helixWidth, 0.1, 5.0, 0.1));
        this.helixWidth.setMaximumSize(this.spinnerMaxSize);
        this.helixWidth.addChangeListener(this);
        JPanel h1 = new JPanel();
        h1.setLayout(new BoxLayout(h1, 0));
        h1.add(hwl);
        h1.add(Box.createHorizontalGlue());
        h1.add(this.helixWidth);
        JLabel hdl = new JLabel("Depth:");
        hdl.setPreferredSize(this.labelSize);
        this.helixDepth = new JSpinner(new SpinnerNumberModel(this.secondaryOptions.helixDepth, 0.1, 5.0, 0.1));
        this.helixDepth.setMaximumSize(this.spinnerMaxSize);
        this.helixDepth.addChangeListener(this);
        JPanel h2 = new JPanel();
        h2.setLayout(new BoxLayout(h2, 0));
        h2.add(hdl);
        h2.add(Box.createHorizontalGlue());
        h2.add(this.helixDepth);
        JLabel hsl = new JLabel("Shift:");
        hsl.setPreferredSize(this.labelSize);
        this.helixShift = new JSpinner(new SpinnerNumberModel(this.secondaryOptions.helixShift, 0.1, 5.0, 0.1));
        this.helixShift.setMaximumSize(this.spinnerMaxSize);
        this.helixShift.addChangeListener(this);
        JPanel h3 = new JPanel();
        h3.setLayout(new BoxLayout(h3, 0));
        h3.add(hsl);
        h3.add(Box.createHorizontalGlue());
        h3.add(this.helixShift);
        this.helixArrow = new JCheckBox("Draw arrow", true);
        this.helixArrow.addActionListener(this);
        JPanel h4 = new JPanel();
        h4.setLayout(new BoxLayout(h4, 0));
        h4.add(this.helixArrow);
        h4.add(Box.createHorizontalGlue());
        JLabel hal = new JLabel("Arrow width:");
        hal.setPreferredSize(this.labelSize);
        this.helixArrowWidth = new JSpinner(new SpinnerNumberModel(this.secondaryOptions.helixArrowWidth, 0.1, 5.0, 0.1));
        this.helixArrowWidth.setMaximumSize(this.spinnerMaxSize);
        this.helixArrowWidth.addChangeListener(this);
        JPanel h5 = new JPanel();
        h5.setLayout(new BoxLayout(h5, 0));
        h5.add(hal);
        h5.add(Box.createHorizontalGlue());
        h5.add(this.helixArrowWidth);
        helixPanel.add(h1);
        helixPanel.add(h2);
        helixPanel.add(h3);
        helixPanel.add(h5);
        helixPanel.add(h4);
        return helixPanel;
    }

    protected JPanel createSheetPanel() {
        JPanel sheetPanel = new JPanel();
        sheetPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Sheet"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        sheetPanel.setLayout(new BoxLayout(sheetPanel, 1));
        JLabel hwl = new JLabel("Width:");
        hwl.setPreferredSize(this.labelSize);
        this.sheetWidth = new JSpinner(new SpinnerNumberModel(this.secondaryOptions.sheetWidth, 0.1, 5.0, 0.1));
        this.sheetWidth.setMaximumSize(this.spinnerMaxSize);
        this.sheetWidth.addChangeListener(this);
        JPanel h1 = new JPanel();
        h1.setLayout(new BoxLayout(h1, 0));
        h1.add(hwl);
        h1.add(Box.createHorizontalGlue());
        h1.add(this.sheetWidth);
        JLabel hdl = new JLabel("Depth:");
        hdl.setPreferredSize(this.labelSize);
        this.sheetDepth = new JSpinner(new SpinnerNumberModel(this.secondaryOptions.sheetDepth, 0.1, 5.0, 0.1));
        this.sheetDepth.setMaximumSize(this.spinnerMaxSize);
        this.sheetDepth.addChangeListener(this);
        JPanel h2 = new JPanel();
        h2.setLayout(new BoxLayout(h2, 0));
        h2.add(hdl);
        h2.add(Box.createHorizontalGlue());
        h2.add(this.sheetDepth);
        this.sheetArrow = new JCheckBox("Draw arrow", true);
        this.sheetArrow.addActionListener(this);
        JPanel h4 = new JPanel();
        h4.setLayout(new BoxLayout(h4, 0));
        h4.add(this.sheetArrow);
        h4.add(Box.createHorizontalGlue());
        JLabel sal = new JLabel("Arrow width:");
        sal.setPreferredSize(this.labelSize);
        this.sheetArrowWidth = new JSpinner(new SpinnerNumberModel(this.secondaryOptions.sheetArrowWidth, 0.1, 5.0, 0.1));
        this.sheetArrowWidth.setMaximumSize(this.spinnerMaxSize);
        this.sheetArrowWidth.addChangeListener(this);
        JPanel h5 = new JPanel();
        h5.setLayout(new BoxLayout(h5, 0));
        h5.add(sal);
        h5.add(Box.createHorizontalGlue());
        h5.add(this.sheetArrowWidth);
        sheetPanel.add(h1);
        sheetPanel.add(h2);
        sheetPanel.add(Box.createVerticalStrut(23));
        sheetPanel.add(h5);
        sheetPanel.add(h4);
        return sheetPanel;
    }

    protected JPanel createCoilPanel() {
        JPanel coilPanel = new JPanel();
        coilPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Coil"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        coilPanel.setLayout(new BoxLayout(coilPanel, 1));
        JLabel hwl = new JLabel("Width:");
        hwl.setPreferredSize(this.labelSize);
        this.coilWidth = new JSpinner(new SpinnerNumberModel(this.secondaryOptions.coilWidth, 0.1, 5.0, 0.1));
        this.coilWidth.setMaximumSize(this.spinnerMaxSize);
        this.coilWidth.addChangeListener(this);
        JPanel h1 = new JPanel();
        h1.setLayout(new BoxLayout(h1, 0));
        h1.add(hwl);
        h1.add(Box.createHorizontalGlue());
        h1.add(this.coilWidth);
        JLabel hdl = new JLabel("Depth:");
        hdl.setPreferredSize(this.labelSize);
        this.coilDepth = new JSpinner(new SpinnerNumberModel(this.secondaryOptions.coilDepth, 0.1, 5.0, 0.1));
        this.coilDepth.setMaximumSize(this.spinnerMaxSize);
        this.coilDepth.addChangeListener(this);
        JPanel h2 = new JPanel();
        h2.setLayout(new BoxLayout(h2, 0));
        h2.add(hdl);
        h2.add(Box.createHorizontalGlue());
        h2.add(this.coilDepth);
        this.coilUniform = new JCheckBox("Uniform", this.secondaryOptions.coilUniform);
        this.coilUniform.addActionListener(this);
        JPanel h3 = new JPanel();
        h3.setLayout(new BoxLayout(h3, 0));
        h3.add(this.coilUniform);
        h3.add(Box.createHorizontalGlue());
        coilPanel.add(h1);
        coilPanel.add(h2);
        coilPanel.add(h3);
        return coilPanel;
    }

    protected JPanel createSecPanel() {
        JPanel secPanel = new JPanel();
        secPanel.setLayout(new BoxLayout(secPanel, 1));
        secPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Global settings"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.resetButton = new JButton("Reset All");
        this.resetButton.addActionListener(this);
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        p1.add(this.resetButton);
        p1.add(Box.createHorizontalGlue());
        JLabel tl = new JLabel("Threads:");
        tl.setPreferredSize(this.labelSize);
        this.threads = new JSpinner(new SpinnerNumberModel(6, 3, 10, 1));
        this.threads.setMaximumSize(this.spinnerMaxSize);
        this.threads.addChangeListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        p2.add(tl);
        p2.add(Box.createHorizontalGlue());
        p2.add(this.threads);
        secPanel.add(Box.createVerticalStrut(10));
        secPanel.add(p2);
        secPanel.add(Box.createVerticalGlue());
        secPanel.add(p1);
        secPanel.add(Box.createVerticalStrut(10));
        return secPanel;
    }

    private JPanel createCustomStyleControlPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        String[] buttons = new String[]{"left button", "middle button", "right button"};
        Dimension comboBoxSize = new Dimension(150, 20);
        JLabel rLabel = new JLabel("Rotation");
        this.rotation = new JComboBox<String>(buttons);
        this.rotation.setSelectedIndex(this.controlOptions.rotation);
        this.rotation.addActionListener(this);
        this.rotation.setMaximumSize(comboBoxSize);
        this.rotation.setPreferredSize(comboBoxSize);
        JPanel rot = new JPanel();
        rot.setLayout(new BoxLayout(rot, 0));
        rot.add(Box.createRigidArea(new Dimension(50, 0)));
        rot.add(rLabel);
        rot.add(Box.createHorizontalGlue());
        rot.add(this.rotation);
        JLabel zLabel = new JLabel("Zoom");
        this.zoom = new JComboBox<String>(buttons);
        this.zoom.setSelectedIndex(this.controlOptions.zoom);
        this.zoom.addActionListener(this);
        this.zoom.setMaximumSize(comboBoxSize);
        this.zoom.setPreferredSize(comboBoxSize);
        JPanel zoomPanel = new JPanel();
        zoomPanel.setLayout(new BoxLayout(zoomPanel, 0));
        zoomPanel.add(Box.createRigidArea(new Dimension(50, 0)));
        zoomPanel.add(zLabel);
        zoomPanel.add(Box.createHorizontalGlue());
        zoomPanel.add(this.zoom);
        JLabel pLabel = new JLabel("Popup");
        String[] pop = new String[]{"right button", "double left button"};
        this.popup = new JComboBox<String>(pop);
        if (this.controlOptions.popup == 2) {
            this.popup.setSelectedIndex(0);
        } else {
            this.popup.setSelectedIndex(1);
        }
        this.popup.addActionListener(this);
        this.popup.setMaximumSize(comboBoxSize);
        this.popup.setPreferredSize(comboBoxSize);
        JPanel popupPanel = new JPanel();
        popupPanel.setLayout(new BoxLayout(popupPanel, 0));
        popupPanel.add(Box.createRigidArea(new Dimension(50, 0)));
        popupPanel.add(pLabel);
        popupPanel.add(Box.createHorizontalGlue());
        popupPanel.add(this.popup);
        JLabel tLabel = new JLabel("Translate");
        String[] tr = new String[]{"left button", "middle button", "right button"};
        this.translate = new JComboBox<String>(tr);
        if (this.controlOptions.translation == 0) {
            this.translate.setSelectedIndex(0);
        } else if (this.controlOptions.translation == 1) {
            this.translate.setSelectedIndex(1);
        } else if (this.controlOptions.translation == 2) {
            this.translate.setSelectedIndex(2);
        }
        this.translate.addActionListener(this);
        this.translate.setMaximumSize(comboBoxSize);
        this.translate.setPreferredSize(comboBoxSize);
        JPanel trPanel = new JPanel();
        trPanel.setLayout(new BoxLayout(trPanel, 0));
        trPanel.add(Box.createRigidArea(new Dimension(50, 0)));
        trPanel.add(tLabel);
        trPanel.add(Box.createHorizontalGlue());
        trPanel.add(this.translate);
        panel.add(rot);
        panel.add(zoomPanel);
        panel.add(trPanel);
        panel.add(popupPanel);
        return panel;
    }

    private JLabel getResidueLabel(String res) {
        JLabel rLabel = new JLabel(res);
        float[] c = Colors.getResidueColor(res);
        Color col = new Color(c[0], c[1], c[2]);
        rLabel.setForeground(col);
        rLabel.setToolTipText("Red: " + col.getRed() + " Green: " + col.getGreen() + " Blue: " + col.getBlue());
        rLabel.setMinimumSize(new Dimension(30, 20));
        rLabel.setPreferredSize(new Dimension(30, 20));
        this.residueLabels[this.labelIndex++] = rLabel;
        return rLabel;
    }

    private JLabel getAminoLabel(String res1) {
        JLabel rLabel = new JLabel(res1);
        float[] c = Colors.getResidueColor(res1);
        Color col = new Color(c[0], c[1], c[2]);
        rLabel.setForeground(col);
        rLabel.setToolTipText("Red: " + col.getRed() + " Green: " + col.getGreen() + " Blue: " + col.getBlue());
        rLabel.setMinimumSize(new Dimension(20, 20));
        rLabel.setPreferredSize(new Dimension(20, 20));
        this.residueLabels[this.labelIndex++] = rLabel;
        return rLabel;
    }

    private void createAtomColorButtons() {
        this.hColor = new JButton("H");
        this.hColor.setForeground(this.colorOptions.getHColor());
        this.hColor.addActionListener(this);
        this.cColor = new JButton("C");
        this.cColor.setForeground(this.colorOptions.getCColor());
        this.cColor.addActionListener(this);
        this.nColor = new JButton("N");
        this.nColor.setForeground(this.colorOptions.getNColor());
        this.nColor.addActionListener(this);
        this.oColor = new JButton("O");
        this.oColor.setForeground(this.colorOptions.getOColor());
        this.oColor.addActionListener(this);
        this.sColor = new JButton("S");
        this.sColor.setForeground(this.colorOptions.getSColor());
        this.sColor.addActionListener(this);
        this.pColor = new JButton("P");
        this.pColor.setForeground(this.colorOptions.getPColor());
        this.pColor.addActionListener(this);
        this.uColor = new JButton("Unk");
        this.uColor.setForeground(this.colorOptions.getUnknownColor());
        this.uColor.addActionListener(this);
        this.selColor = new JButton("Sel");
        this.selColor.setForeground(this.colorOptions.getSelectedColor());
        this.selColor.addActionListener(this);
    }

    protected ImageIcon getColorIcon(Color c) {
        ImageIcon icon = new ImageIcon();
        BufferedImage rect = new BufferedImage(20, 12, 1);
        Graphics2D gr = rect.createGraphics();
        gr.setColor(c);
        gr.fill3DRect(0, 0, 20, 12, true);
        icon.setImage(rect);
        return icon;
    }

    private void setCustomStyleEnabled(boolean b) {
        this.rotation.setEnabled(b);
        this.zoom.setEnabled(b);
        this.popup.setEnabled(b);
        this.translate.setEnabled(b);
    }

    protected JComponent makeTextPanel(String text) {
        JPanel panel = new JPanel(false);
        JLabel filler = new JLabel(text);
        filler.setHorizontalAlignment(0);
        panel.setLayout(new GridLayout(1, 1));
        panel.add(filler);
        return panel;
    }

    public class MoleculeOptions {
        private double ballRadius;
        private double bondRadius;
        private double stickRadius;
        private double lineWidth;
        private int bondDistance;
        private int bondWidth;
        private boolean displayBondOrder;
        private boolean scaledBalls;
        private boolean smoothSticks;
        private boolean bondFacing;
        private boolean bondFacingChanged = false;
        private boolean ballRadiusChanged = false;
        private boolean bondRadiusChanged = false;
        private boolean stickRadiusChanged = false;
        private boolean lineWidthChanged = false;
        private boolean bondDistanceChanged = false;
        private boolean bondWidthChanged = false;
        private boolean smoothSticksChanged = false;
        private boolean scaledBallsChanged = false;
        private boolean displayBondOrderChanged = false;

        public void init(double ballRadius, double bondRadius, double stickRadius, double lineWidth, int bondDistance, int bondWidth, boolean displayBondOrder, boolean scaledBalls, boolean smoothSticks, boolean bondFacing) {
            this.ballRadius = ballRadius;
            this.bondRadius = bondRadius;
            this.stickRadius = stickRadius;
            this.lineWidth = lineWidth;
            this.bondDistance = bondDistance;
            this.bondWidth = bondWidth;
            this.displayBondOrder = displayBondOrder;
            this.scaledBalls = scaledBalls;
            this.smoothSticks = smoothSticks;
            this.bondFacing = bondFacing;
        }

        public boolean ballRadiusChanged() {
            return this.ballRadiusChanged;
        }

        public double getBallRadius() {
            this.ballRadiusChanged = false;
            return this.ballRadius;
        }

        public void setBallRadius(double v) {
            if (v == this.ballRadius) {
                return;
            }
            this.ballRadius = v;
            this.ballRadiusChanged = true;
        }

        public void setBondFacing(boolean v) {
            if (v == this.bondFacing) {
                return;
            }
            this.bondFacing = v;
            this.bondFacingChanged = true;
        }

        public boolean getBondFacing() {
            this.bondFacingChanged = false;
            return this.bondFacing;
        }

        public boolean bondFacingChanged() {
            return this.bondFacingChanged;
        }

        public boolean bondRadiusChanged() {
            return this.bondRadiusChanged;
        }

        public double getBondRadius() {
            this.bondRadiusChanged = false;
            return this.bondRadius;
        }

        public void setBondRadius(double v) {
            if (v == this.bondRadius) {
                return;
            }
            this.bondRadius = v;
            this.bondRadiusChanged = true;
        }

        public boolean stickRadiusChanged() {
            return this.stickRadiusChanged;
        }

        public double getStickRadius() {
            this.stickRadiusChanged = false;
            return this.stickRadius;
        }

        public void setStickRadius(double v) {
            if (v == this.stickRadius) {
                return;
            }
            this.stickRadius = v;
            this.stickRadiusChanged = true;
        }

        public boolean lineWidthChanged() {
            return this.lineWidthChanged;
        }

        public double getLineWidth() {
            this.lineWidthChanged = false;
            return this.lineWidth;
        }

        public void setLineWidth(double v) {
            if (v == this.lineWidth) {
                return;
            }
            this.lineWidth = v;
            this.lineWidthChanged = true;
        }

        public boolean bondDistanceChanged() {
            return this.bondDistanceChanged;
        }

        public int getBondDistance() {
            this.bondDistanceChanged = false;
            return this.bondDistance;
        }

        public void setBondDistance(int v) {
            if (v == this.bondDistance) {
                return;
            }
            this.bondDistance = v;
            this.bondDistanceChanged = true;
        }

        public boolean bondWidthChanged() {
            return this.bondWidthChanged;
        }

        public int getBondWidth() {
            this.bondWidthChanged = false;
            return this.bondWidth;
        }

        public void setBondWidth(int v) {
            if (v == this.bondWidth) {
                return;
            }
            this.bondWidth = v;
            this.bondWidthChanged = true;
        }

        public boolean displayBondOrderChanged() {
            return this.displayBondOrderChanged;
        }

        public boolean getDisplayBondOrder() {
            this.displayBondOrderChanged = true;
            return this.displayBondOrder;
        }

        public void setDisplayBondOrder(boolean v) {
            if (v == this.displayBondOrder) {
                return;
            }
            this.displayBondOrder = v;
            this.displayBondOrderChanged = true;
        }

        public boolean scaledBallsChanged() {
            return this.scaledBallsChanged;
        }

        public boolean getScaledBalls() {
            this.scaledBallsChanged = false;
            return this.scaledBalls;
        }

        public void setScaledBalls(boolean v) {
            if (this.scaledBalls == v) {
                return;
            }
            this.scaledBalls = v;
            this.scaledBallsChanged = true;
        }

        public boolean smoothSticksChanged() {
            return this.smoothSticksChanged;
        }

        public boolean getSmoothSticks() {
            this.smoothSticksChanged = false;
            return this.smoothSticks;
        }

        public void setSmoothSticks(boolean v) {
            if (v == this.smoothSticks) {
                return;
            }
            this.smoothSticks = v;
            this.smoothSticksChanged = true;
        }
    }

    public class ColorOptions {
        private Color background;
        private Color ligand;
        private Color protein;
        private Color water;
        private Color ion;
        private Color surface;
        private Color helix;
        private Color sheet;
        private Color turn;
        private Color coil;
        private Color h;
        private Color c;
        private Color n;
        private Color o;
        private Color s;
        private Color p;
        private Color unknown;
        private Color selected;
        private boolean transparent;
        private boolean smooth;
        private boolean defaultResidues = true;
        private boolean backgroundChanged = false;
        private boolean backgroundTrChanged = false;
        private boolean backgroundSChanged = false;
        private boolean ligandChanged = false;
        private boolean proteinChanged = false;
        private boolean waterChanged = false;
        private boolean ionChanged = false;
        private boolean surfaceChanged = false;
        private boolean cpkChanged = false;
        private boolean unknownChanged = false;
        private boolean selectedChanged = false;
        private boolean residueColorsChanged = false;
        private boolean helixChanged = false;
        private boolean sheetChanged = false;
        private boolean turnChanged = false;
        private boolean coilChanged = false;

        public void init(Color background, boolean transparent, boolean smooth, Color ligand, Color protein, Color water, Color ion, Color surface, byte[] helix, byte[] sheet, byte[] turn, byte[] coil, boolean defaultResidues) {
            this.background = background;
            this.transparent = transparent;
            this.smooth = smooth;
            this.ligand = ligand;
            this.protein = protein;
            this.water = water;
            this.ion = ion;
            this.surface = surface;
            this.helix = new Color(2 * helix[0], 2 * helix[1], 2 * helix[2]);
            this.sheet = new Color(2 * sheet[0], 2 * sheet[1], 2 * sheet[2]);
            this.turn = new Color(2 * turn[0], 2 * turn[1], 2 * turn[2]);
            this.coil = new Color(2 * coil[0], 2 * coil[1], 2 * coil[2]);
            this.defaultResidues = defaultResidues;
            this.initCPK(Colors.hColor, Colors.cColor, Colors.nColor, Colors.oColor, Colors.sColor, Colors.pColor);
            this.unknown = new Color(2 * Colors.unknownAtom[0], 2 * Colors.unknownAtom[1], 2 * Colors.unknownAtom[2]);
            this.selected = new Color(2 * Colors.selected[0], 2 * Colors.selected[1], 2 * Colors.selected[2]);
        }

        public void initCPK(byte[] h, byte[] c, byte[] n, byte[] o, byte[] s, byte[] p) {
            this.h = new Color(2 * h[0], 2 * h[1], 2 * h[2]);
            this.c = new Color(2 * c[0], 2 * c[1], 2 * c[2]);
            this.n = new Color(2 * n[0], 2 * n[1], 2 * n[2]);
            this.o = new Color(2 * o[0], 2 * o[1], 2 * o[2]);
            this.s = new Color(2 * s[0], 2 * s[1], 2 * s[2]);
            this.p = new Color(2 * p[0], 2 * p[1], 2 * p[2]);
        }

        public boolean backgroundColorChanged() {
            return this.backgroundChanged;
        }

        public Color getBackgroudColor() {
            this.backgroundChanged = false;
            return this.background;
        }

        public void setBackgroundColor(Color c) {
            if (this.background.equals(c)) {
                return;
            }
            this.background = c;
            this.backgroundChanged = true;
        }

        public boolean backgroundTransparencyChanged() {
            return this.backgroundTrChanged;
        }

        public boolean getBackgroudTransparency() {
            this.backgroundTrChanged = false;
            return this.transparent;
        }

        public void setBackgroundTransparency(boolean b) {
            if (this.transparent == b) {
                return;
            }
            this.transparent = b;
            this.backgroundTrChanged = true;
        }

        public boolean smoothBackgroundChanged() {
            return this.backgroundSChanged;
        }

        public boolean getSmoothBackgroud() {
            this.backgroundSChanged = false;
            return this.smooth;
        }

        public void setSmoothBackground(boolean b) {
            if (this.smooth == b) {
                return;
            }
            this.smooth = b;
            this.backgroundSChanged = true;
        }

        public boolean ligandColorChanged() {
            return this.ligandChanged;
        }

        public Color getLigandColor() {
            this.ligandChanged = false;
            return this.ligand;
        }

        public void setLigandColor(Color c) {
            if (this.ligand.equals(c)) {
                return;
            }
            this.ligand = c;
            this.ligandChanged = true;
        }

        public boolean proteinColorChanged() {
            return this.proteinChanged;
        }

        public Color getProteinColor() {
            this.proteinChanged = false;
            return this.protein;
        }

        public void setProteinColor(Color c) {
            if (this.protein.equals(c)) {
                return;
            }
            this.protein = c;
            this.proteinChanged = true;
        }

        public boolean waterColorChanged() {
            return this.waterChanged;
        }

        public Color getWaterColor() {
            this.waterChanged = false;
            return this.water;
        }

        public void setWaterColor(Color c) {
            if (this.water.equals(c)) {
                return;
            }
            this.water = c;
            this.waterChanged = true;
        }

        public boolean ionColorChanged() {
            return this.ionChanged;
        }

        public Color getIonColor() {
            this.ionChanged = false;
            return this.ion;
        }

        public void setIonColor(Color c) {
            if (this.ion.equals(c)) {
                return;
            }
            this.ion = c;
            this.ionChanged = true;
        }

        public boolean surfaceColorChanged() {
            return this.surfaceChanged;
        }

        public Color getSurfaceColor() {
            this.surfaceChanged = false;
            return this.surface;
        }

        public void setSurfaceColor(Color c) {
            if (this.surface.equals(c)) {
                return;
            }
            this.surface = c;
            this.surfaceChanged = true;
        }

        public boolean helixColorChanged() {
            return this.helixChanged;
        }

        public Color getHelixColor() {
            this.helixChanged = false;
            return this.helix;
        }

        public void setHelixColor(Color c) {
            if (this.helix.equals(c)) {
                return;
            }
            this.helix = c;
            this.helixChanged = true;
        }

        public boolean sheetColorChanged() {
            return this.sheetChanged;
        }

        public Color getSheetColor() {
            this.sheetChanged = false;
            return this.sheet;
        }

        public void setSheetColor(Color c) {
            if (this.sheet.equals(c)) {
                return;
            }
            this.sheet = c;
            this.sheetChanged = true;
        }

        public boolean turnColorChanged() {
            return this.turnChanged;
        }

        public Color getTurnColor() {
            this.turnChanged = false;
            return this.turn;
        }

        public void setTurnColor(Color c) {
            if (this.turn.equals(c)) {
                return;
            }
            this.turn = c;
            this.turnChanged = true;
        }

        public boolean coilColorChanged() {
            return this.coilChanged;
        }

        public Color getCoilColor() {
            this.coilChanged = false;
            return this.coil;
        }

        public void setCoilColor(Color c) {
            if (this.coil.equals(c)) {
                return;
            }
            this.coil = c;
            this.coilChanged = true;
        }

        public boolean cpkChanged() {
            return this.cpkChanged;
        }

        public Color getHColor() {
            this.cpkChanged = false;
            return this.h;
        }

        public Color getCColor() {
            this.cpkChanged = false;
            return this.c;
        }

        public Color getNColor() {
            this.cpkChanged = false;
            return this.n;
        }

        public Color getOColor() {
            this.cpkChanged = false;
            return this.o;
        }

        public Color getSColor() {
            this.cpkChanged = false;
            return this.s;
        }

        public Color getPColor() {
            this.cpkChanged = false;
            return this.p;
        }

        public void setHColor(Color c) {
            if (this.h.equals(c)) {
                return;
            }
            this.h = c;
            this.cpkChanged = true;
        }

        public void setCColor(Color c) {
            if (this.c.equals(c)) {
                return;
            }
            this.c = c;
            this.cpkChanged = true;
        }

        public void setNColor(Color c) {
            if (this.n.equals(c)) {
                return;
            }
            this.n = c;
            this.cpkChanged = true;
        }

        public void setOColor(Color c) {
            if (this.o.equals(c)) {
                return;
            }
            this.o = c;
            this.cpkChanged = true;
        }

        public void setSColor(Color c) {
            if (this.s.equals(c)) {
                return;
            }
            this.s = c;
            this.cpkChanged = true;
        }

        public void setPColor(Color c) {
            if (this.p.equals(c)) {
                return;
            }
            this.p = c;
            this.cpkChanged = true;
        }

        public boolean unknownColorChanged() {
            return this.unknownChanged;
        }

        public Color getUnknownColor() {
            this.unknownChanged = false;
            return this.unknown;
        }

        public void setUnknownColor(Color c) {
            if (this.unknown.equals(c)) {
                return;
            }
            this.unknown = c;
            this.unknownChanged = true;
        }

        public boolean selectedColorChanged() {
            return this.selectedChanged;
        }

        public Color getSelectedColor() {
            this.selectedChanged = false;
            return this.selected;
        }

        public void setSelectedColor(Color c) {
            if (this.selected.equals(c)) {
                return;
            }
            this.selected = c;
            this.selectedChanged = true;
        }

        public boolean residueColorsChanged() {
            return this.residueColorsChanged;
        }

        public boolean isDefaultResidueColors() {
            this.residueColorsChanged = false;
            return this.defaultResidues;
        }

        public void setDefaultResidueColors(boolean b) {
            if (this.defaultResidues == b) {
                return;
            }
            this.defaultResidues = b;
            this.residueColorsChanged = true;
        }
    }

    public class ControlOptions {
        public static final int DEFAULT_STYLE = 1;
        public static final int CUSTOM_STYLE = 3;
        public static final int LEFT_BUTTON = 0;
        public static final int MIDDLE_BUTTON = 1;
        public static final int RIGHT_BUTTON = 2;
        public static final int DOUBLE_LEFT_BUTTON = 3;
        public static final int MOUSE_WHEEL = 4;
        public static final int DEFAULT_ROTATION = 0;
        public static final int DEFAULT_ZOOM = 1;
        public static final int DEFAULT_POPUP = 2;
        public static final int DEFAULT_TRANSLATION = 2;
        private boolean invertZoom;
        private boolean drawSphere;
        private boolean weakeningRotation;
        private boolean antialiasDisable;
        private int controlStyle = 1;
        private int rotation = 0;
        private int zoom = 1;
        private int popup = 2;
        private int translation = 2;
        private float rotationAngle;
        private boolean invertzoomChanged = false;
        private boolean drawSphereChanged = false;
        private boolean weakeningRotationChanged = false;
        private boolean controlStyleChanged = false;
        private boolean rotationChanged = false;
        private boolean zoomChanged = false;
        private boolean popupChanged = false;
        private boolean translationChanged = false;
        private boolean antialiasDisableChanged = false;
        private boolean rotationAngleChanged = false;

        public void init(int controlStyle, boolean invertZoom, boolean drawSphere, boolean weakeningRotation, boolean antialiasDisable, float rotationAngle) {
            this.controlStyle = controlStyle;
            if (controlStyle == 1) {
                this.rotation = 0;
                this.zoom = 1;
                this.popup = 2;
                this.translation = 2;
            }
            this.invertZoom = invertZoom;
            this.drawSphere = drawSphere;
            this.weakeningRotation = weakeningRotation;
            this.antialiasDisable = antialiasDisable;
            this.rotationAngle = rotationAngle;
        }

        public int transformToAwtMouseEvent(int v) {
            switch (v) {
                case 0: {
                    return 1024;
                }
                case 1: {
                    return 2048;
                }
            }
            return 4096;
        }

        public boolean controlStyleChanged() {
            return this.controlStyleChanged;
        }

        public int getControlStyle() {
            this.controlStyleChanged = false;
            return this.controlStyle;
        }

        public void setControlStyle(int v) {
            if (v == this.controlStyle) {
                return;
            }
            this.controlStyle = v;
            this.controlStyleChanged = true;
        }

        public boolean rotationControlChanged() {
            return this.rotationChanged;
        }

        public int getRotationControl() {
            this.rotationChanged = false;
            return this.transformToAwtMouseEvent(this.rotation);
        }

        public void setRotationControl(int v) {
            if (v == this.rotation) {
                return;
            }
            this.rotation = v;
            this.rotationChanged = true;
        }

        public boolean zoomControlChanged() {
            return this.zoomChanged;
        }

        public int getZoomControl() {
            this.zoomChanged = false;
            return this.transformToAwtMouseEvent(this.zoom);
        }

        public void setZoomControl(int v) {
            if (v == this.zoom) {
                return;
            }
            this.zoom = v;
            this.zoomChanged = true;
        }

        public boolean popupControlChanged() {
            return this.popupChanged;
        }

        public int getPopupControl() {
            this.popupChanged = false;
            return this.popup;
        }

        public void setPopupControl(int v) {
            if (v == this.popup) {
                return;
            }
            this.popup = v;
            this.popupChanged = true;
        }

        public boolean translationControlChanged() {
            return this.translationChanged;
        }

        public int getTranslationControl() {
            this.translationChanged = false;
            return this.transformToAwtMouseEvent(this.translation);
        }

        public void setTranslationControl(int v) {
            if (v == this.translation) {
                return;
            }
            this.translation = v;
            this.translationChanged = true;
        }

        public boolean invertZoomChanged() {
            return this.invertzoomChanged;
        }

        public boolean getInvertZoom() {
            this.invertzoomChanged = false;
            return this.invertZoom;
        }

        public void setInvertZoom(boolean v) {
            if (v == this.invertZoom) {
                return;
            }
            this.invertZoom = v;
            this.invertzoomChanged = true;
        }

        public boolean drawSphereChanged() {
            return this.drawSphereChanged;
        }

        public boolean getDrawSphere() {
            this.drawSphereChanged = false;
            return this.drawSphere;
        }

        public void setDrawSphere(boolean v) {
            if (v == this.drawSphere) {
                return;
            }
            this.drawSphere = v;
            this.drawSphereChanged = true;
        }

        public boolean weakeningRotationChanged() {
            return this.weakeningRotationChanged;
        }

        public boolean getWeakeningRotation() {
            this.weakeningRotationChanged = false;
            return this.weakeningRotation;
        }

        public void setWeakeningRotation(boolean v) {
            if (v == this.weakeningRotation) {
                return;
            }
            this.weakeningRotation = v;
            this.weakeningRotationChanged = true;
        }

        public boolean antialiasDisableChanged() {
            return this.antialiasDisableChanged;
        }

        public boolean getAntialiasDisable() {
            this.antialiasDisableChanged = false;
            return this.antialiasDisable;
        }

        public void setAntialiasDisable(boolean v) {
            if (v == this.antialiasDisable) {
                return;
            }
            this.antialiasDisable = v;
            this.antialiasDisableChanged = true;
        }

        public boolean rotationAngleChanged() {
            return this.rotationAngleChanged;
        }

        public float getRotationAngle() {
            this.rotationAngleChanged = false;
            return this.rotationAngle;
        }

        public void setRotationAngle(float rotationAngle) {
            if (rotationAngle == this.rotationAngle) {
                return;
            }
            this.rotationAngle = rotationAngle;
            this.rotationAngleChanged = true;
        }
    }

    public class SecondaryStructureOptions {
        private float helixWidth;
        private float helixDepth;
        private float helixShift;
        private float sheetWidth;
        private float sheetDepth;
        private float coilWidth;
        private float coilDepth;
        private float helixArrowWidth;
        private float sheetArrowWidth;
        private boolean helixArrow;
        private boolean sheetArrow;
        private boolean coilUniform;
        private int threads;
        private boolean hwchanged;
        private boolean hdchanged;
        private boolean hschanged;
        private boolean harrowchanged;
        private boolean hachanged;
        private boolean swchanged;
        private boolean sdchanged;
        private boolean sarrowchanged;
        private boolean sachanged;
        private boolean cwchanged;
        private boolean cdchanged;
        private boolean cuniformchanged;
        private boolean threadsChanged;

        public float getValue(int state) {
            return 0.1f * (float)(state + 1);
        }

        public int getState(float value) {
            return (int)(value / 0.1f) - 1;
        }

        public void init(float hw, float hd, float hs, float haw, boolean ha, float sw, float sd, float saw, boolean sa, float cw, float cd, boolean cu, int threads) {
            this.helixWidth = hw;
            this.helixDepth = hd;
            this.helixShift = hs;
            this.helixArrow = ha;
            this.helixArrowWidth = haw;
            this.sheetWidth = sw;
            this.sheetDepth = sd;
            this.sheetArrow = sa;
            this.sheetArrowWidth = saw;
            this.coilWidth = cw;
            this.coilDepth = cd;
            this.coilUniform = cu;
            this.threads = threads;
        }

        public float getHelixWidth() {
            this.hwchanged = false;
            return this.helixWidth;
        }

        public void setHelixWidth(float v) {
            if (this.helixWidth == v) {
                return;
            }
            this.helixWidth = v;
            this.hwchanged = true;
        }

        public boolean helixWidthChanged() {
            return this.hwchanged;
        }

        public float getHelixDepth() {
            this.hdchanged = false;
            return this.helixDepth;
        }

        public void setHelixDepth(float v) {
            if (this.helixDepth == v) {
                return;
            }
            this.helixDepth = v;
            this.hdchanged = true;
        }

        public boolean helixDepthChanged() {
            return this.hdchanged;
        }

        public float getHelixShift() {
            this.hschanged = false;
            return this.helixShift;
        }

        public void setHelixShift(float v) {
            if (this.helixShift == v) {
                return;
            }
            this.helixShift = v;
            this.hschanged = true;
        }

        public boolean helixShiftChanged() {
            return this.hschanged;
        }

        public float getHelixArrowWidth() {
            this.hachanged = false;
            return this.helixArrowWidth;
        }

        public void setHelixArrowWidth(float v) {
            if (this.helixArrowWidth == v) {
                return;
            }
            this.helixArrowWidth = v;
            this.hachanged = true;
        }

        public boolean helixArrowWidthChanged() {
            return this.hachanged;
        }

        public boolean getHelixArrow() {
            this.harrowchanged = false;
            return this.helixArrow;
        }

        public void setHelixArrow(boolean b) {
            if (this.helixArrow == b) {
                return;
            }
            this.helixArrow = b;
            this.harrowchanged = true;
        }

        public boolean helixArrowChanged() {
            return this.harrowchanged;
        }

        public float getSheetWidth() {
            this.swchanged = false;
            return this.sheetWidth;
        }

        public void setSheetWidth(float v) {
            if (this.sheetWidth == v) {
                return;
            }
            this.sheetWidth = v;
            this.swchanged = true;
        }

        public boolean sheetWidthChanged() {
            return this.swchanged;
        }

        public float getSheetDepth() {
            this.sdchanged = false;
            return this.sheetDepth;
        }

        public void setSheetDepth(float v) {
            if (this.sheetDepth == v) {
                return;
            }
            this.sheetDepth = v;
            this.sdchanged = true;
        }

        public boolean sheetDepthChanged() {
            return this.sdchanged;
        }

        public float getSheetArrowWidth() {
            this.sachanged = false;
            return this.sheetArrowWidth;
        }

        public void setSheetArrowWidth(float v) {
            if (this.sheetArrowWidth == v) {
                return;
            }
            this.sheetArrowWidth = v;
            this.sachanged = true;
        }

        public boolean sheetArrowWidthChanged() {
            return this.sachanged;
        }

        public boolean getSheetArrow() {
            this.sarrowchanged = false;
            return this.sheetArrow;
        }

        public void setSheetArrow(boolean b) {
            if (this.sheetArrow == b) {
                return;
            }
            this.sheetArrow = b;
            this.sarrowchanged = true;
        }

        public boolean sheetArrowChanged() {
            return this.sarrowchanged;
        }

        public float getCoilWidth() {
            this.cwchanged = false;
            return this.coilWidth;
        }

        public void setCoilWidth(float v) {
            if (this.coilWidth == v) {
                return;
            }
            this.coilWidth = v;
            this.cwchanged = true;
        }

        public boolean coilWidthChanged() {
            return this.cwchanged;
        }

        public float getCoilDepth() {
            this.cdchanged = false;
            return this.coilDepth;
        }

        public void setCoilDepth(float v) {
            if (this.coilDepth == v) {
                return;
            }
            this.coilDepth = v;
            this.cdchanged = true;
        }

        public boolean coilDepthChanged() {
            return this.cdchanged;
        }

        public boolean getCoilUniform() {
            this.cuniformchanged = false;
            return this.coilUniform;
        }

        public void setCoilUniform(boolean b) {
            if (this.coilUniform == b) {
                return;
            }
            this.coilUniform = b;
            this.cuniformchanged = true;
        }

        public boolean coilUniformChanged() {
            return this.cuniformchanged;
        }

        public int getThreads() {
            this.threadsChanged = false;
            return this.threads;
        }

        public void setThreads(int v) {
            if (this.threads == v) {
                return;
            }
            this.threads = v;
            this.threadsChanged = true;
        }

        public boolean threadsChanged() {
            return this.threadsChanged;
        }
    }

    public class SurfaceOptions {
        private boolean autoResolution;
        private boolean simplification;
        private double probeRadius;
        private float gridSize;
        private boolean autoResolutionChanged;
        private boolean simplificationChanged;
        private boolean probeRadiusChanged;
        private boolean gridSizeChanged;

        public void init(boolean autoResolution, boolean simplification, double probeRadius, float gridSize) {
            this.autoResolution = autoResolution;
            this.simplification = simplification;
            this.probeRadius = probeRadius;
            this.gridSize = gridSize;
        }

        public boolean autoResolutionChanged() {
            return this.autoResolutionChanged;
        }

        public boolean simplificationChanged() {
            return this.simplificationChanged;
        }

        public boolean getAutoResolutionEnabled() {
            this.autoResolutionChanged = false;
            return this.autoResolution;
        }

        public boolean getSimplificationEnabled() {
            this.simplificationChanged = false;
            return this.simplification;
        }

        public void setAutoResolutionEnabled(boolean v) {
            if (v == this.autoResolution) {
                return;
            }
            this.autoResolution = v;
            this.autoResolutionChanged = true;
        }

        public void setSimplificationEnabled(boolean v) {
            if (v == this.simplification) {
                return;
            }
            this.simplification = v;
            this.simplificationChanged = true;
        }

        public boolean probeRadiusChanged() {
            return this.probeRadiusChanged;
        }

        public double getProbeRadius() {
            this.probeRadiusChanged = false;
            return this.probeRadius;
        }

        public void setProbeRadius(double v) {
            if (v == this.probeRadius) {
                return;
            }
            this.probeRadius = v;
            this.probeRadiusChanged = true;
        }

        public boolean gridSizeChanged() {
            return this.gridSizeChanged;
        }

        public float getGridSize() {
            this.gridSizeChanged = false;
            return this.gridSize;
        }

        public void setGridSize(float v) {
            if (v == this.gridSize) {
                return;
            }
            this.gridSize = v;
            this.gridSizeChanged = true;
        }
    }

    public class MSpaceOptions {
        public MoleculeOptions ligandOptions;
        public MoleculeOptions proteinOptions;
        public MoleculeOptions waterOptions;
        public MoleculeOptions ionOptions;
        public ColorOptions colorOptions;
        public ControlOptions controlOptions;
        public SurfaceOptions surfaceOptions;
        public SecondaryStructureOptions secondaryOptions;

        public MSpaceOptions() {
            this.ligandOptions = new MoleculeOptions();
            this.proteinOptions = new MoleculeOptions();
            this.waterOptions = new MoleculeOptions();
            this.ionOptions = new MoleculeOptions();
            this.colorOptions = new ColorOptions();
            this.controlOptions = new ControlOptions();
            this.surfaceOptions = new SurfaceOptions();
            this.secondaryOptions = new SecondaryStructureOptions();
        }
    }
}

