/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.space.GraphicCell;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.PolymerVisualizer;
import chemaxon.marvin.space.monitor.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class JMSpacePopupMenu
extends JPopupMenu {
    public JMSpacePopupMenu(final GraphicScene graphicScene) {
        this.setLightWeightPopupEnabled(false);
        JMenuItem resetView = new JMenuItem("Best fit");
        resetView.setActionCommand("ResetView");
        JMenuItem zoomPocket = new JMenuItem("Zoom to pocket");
        zoomPocket.setActionCommand("ZoomPocket");
        JMenuItem extendSelection = new JMenuItem("Extend selection to residues");
        extendSelection.setActionCommand("ExtendSelection");
        JMenu hide = new JMenu("Hide");
        hide.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenuItem hideSelected = new JMenuItem("Selected");
        hideSelected.setActionCommand("HideSelected");
        JMenuItem hideUnselected = new JMenuItem("Unselected");
        hideUnselected.setActionCommand("HideUnselected");
        JMenuItem hideAllM = new JMenuItem("All Monitors");
        hideAllM.setActionCommand("HideAllMonitors");
        JMenuItem hideAllL = new JMenuItem("All Labels");
        hideAllL.setActionCommand("HideAllLabels");
        JMenu fade = new JMenu("Fade");
        fade.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenuItem fadeSelected = new JMenuItem("Selected");
        fadeSelected.setActionCommand("FadeSelected");
        JMenuItem fadeUnselected = new JMenuItem("Unselected");
        fadeUnselected.setActionCommand("FadeUnselected");
        JMenu delete = new JMenu("Delete");
        delete.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenuItem deleteSelected = new JMenuItem("Selected Components");
        deleteSelected.setActionCommand("DeleteSelected");
        JMenuItem deleteUnselected = new JMenuItem("Unselected Components");
        deleteUnselected.setActionCommand("DeleteUnselected");
        JMenuItem deleteUnselectedM = new JMenuItem("Unselected Monitors");
        deleteUnselectedM.setActionCommand("DeleteUnselectedMonitors");
        JMenuItem deleteL = new JMenuItem("All Labels");
        deleteL.setActionCommand("DeleteLabels");
        JMenu show = new JMenu("Show");
        show.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenuItem showAllC = new JMenuItem("All Components");
        showAllC.setActionCommand("ShowAllComponents");
        JMenuItem showAllM = new JMenuItem("All Monitors");
        showAllM.setActionCommand("ShowAllMonitors");
        JMenuItem showAllL = new JMenuItem("All Labels");
        showAllL.setActionCommand("ShowAllLabels");
        JMenuItem showFaded = new JMenuItem("Faded");
        showFaded.setActionCommand("ShowFaded");
        this.add(resetView);
        this.add(zoomPocket);
        this.add(extendSelection);
        this.addSeparator();
        this.add(show);
        show.add(showAllC);
        show.add(showAllM);
        show.add(showAllL);
        show.add(showFaded);
        this.add(hide);
        hide.add(hideSelected);
        hide.add(hideUnselected);
        hide.add(hideAllM);
        hide.add(hideAllL);
        this.add(fade);
        fade.add(fadeSelected);
        fade.add(fadeUnselected);
        this.add(delete);
        delete.add(deleteSelected);
        delete.add(deleteUnselected);
        delete.add(deleteUnselectedM);
        delete.add(deleteL);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getActionCommand().equals("ResetView")) {
                    graphicScene.getEventHandler().resetView();
                } else if (evt.getActionCommand().equals("ZoomPocket")) {
                    graphicScene.getEventHandler().zoomToPocket();
                } else if (evt.getActionCommand().equals("ExtendSelection")) {
                    GraphicCell cell = graphicScene.getActiveCell();
                    if (cell != null) {
                        Iterator ci = cell.getComponentIterator();
                        while (ci.hasNext()) {
                            GraphicComponent gc = (GraphicComponent)ci.next();
                            if (!(gc instanceof MacroMoleculeComponent)) continue;
                            Iterator<MacroMoleculeComponent.MoleculeVisualizer> mvi = ((MacroMoleculeComponent)gc).getComponentIterator();
                            while (mvi.hasNext()) {
                                MacroMoleculeComponent.MoleculeVisualizer mv = mvi.next();
                                if (!(mv instanceof PolymerVisualizer)) continue;
                                ((PolymerVisualizer)mv).extendSelectionToResidues();
                            }
                        }
                    }
                } else if (evt.getActionCommand().equals("ShowAllComponents")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.showAllComponents();
                        }
                    });
                } else if (evt.getActionCommand().equals("ShowAllMonitors")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.showAllMonitors();
                        }
                    });
                } else if (evt.getActionCommand().equals("ShowAllLabels")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.showAllComponents(Label.class);
                        }
                    });
                } else if (evt.getActionCommand().equals("ShowFaded")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.showFaded();
                        }
                    });
                } else if (evt.getActionCommand().equals("HideAllMonitors")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.hideAllMonitors();
                        }
                    });
                } else if (evt.getActionCommand().equals("HideAllLabels")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.hideAllComponents(Label.class);
                        }
                    });
                } else if (evt.getActionCommand().equals("HideSelected")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.hideSelectedComponents();
                        }
                    });
                } else if (evt.getActionCommand().equals("HideUnselected")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.hideUnselectedComponents();
                        }
                    });
                } else if (evt.getActionCommand().equals("FadeSelected")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.fadeSelectedComponents();
                        }
                    });
                } else if (evt.getActionCommand().equals("FadeUnselected")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.fadeUnselectedComponents();
                        }
                    });
                } else if (evt.getActionCommand().equals("DeleteSelected")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.removeSelectedComponents();
                        }
                    });
                } else if (evt.getActionCommand().equals("DeleteUnselected")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.removeUnselectedComponents();
                        }
                    });
                } else if (evt.getActionCommand().equals("DeleteUnselectedMonitors")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.removeUnselectedMonitors();
                        }
                    });
                } else if (evt.getActionCommand().equals("DeleteLabels")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            graphicScene.removeAllComponents(Label.class);
                        }
                    });
                }
            }
        };
        resetView.addActionListener(al);
        zoomPocket.addActionListener(al);
        extendSelection.addActionListener(al);
        showAllC.addActionListener(al);
        showAllM.addActionListener(al);
        showAllL.addActionListener(al);
        showFaded.addActionListener(al);
        hideAllM.addActionListener(al);
        hideAllL.addActionListener(al);
        hideSelected.addActionListener(al);
        hideUnselected.addActionListener(al);
        fadeSelected.addActionListener(al);
        fadeUnselected.addActionListener(al);
        deleteSelected.addActionListener(al);
        deleteUnselected.addActionListener(al);
        deleteUnselectedM.addActionListener(al);
        deleteL.addActionListener(al);
    }
}

