/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.space.ProgressBarInterface;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class JMSpaceProgressBar
implements ProgressBarInterface {
    Component component;
    String note = " ";
    String message = " ";
    int min;
    int max;
    int progress;
    JProgressBar progressBar;
    JLabel noteLabel;
    JLabel messageLabel;
    JPanel progressPanel;
    boolean canceled;
    boolean started;
    boolean indeterminate;
    boolean labelChanged;

    public JMSpaceProgressBar(Component component, String message, String note, int minimum, int maximum) {
        this.component = component;
        this.message = message;
        this.note = note;
        this.min = minimum;
        this.max = maximum;
        this.createDialog();
    }

    public JMSpaceProgressBar(Component component, String message, String note) {
        this.component = component;
        this.message = message;
        this.note = note;
        this.min = 0;
        this.max = 100;
        this.indeterminate = true;
        this.createDialog();
    }

    @Override
    public void start() {
        if (this.indeterminate) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setValue(this.min);
            this.progressBar.setStringPainted(true);
        }
        this.started = true;
    }

    @Override
    public void stop() {
        if (this.progressBar.isIndeterminate()) {
            this.progressBar.setIndeterminate(false);
        }
        if (!this.indeterminate) {
            this.progressBar.setValue(this.min);
            this.progressBar.setStringPainted(false);
        }
        this.setMessage(" ");
        this.started = false;
        this.indeterminate = true;
    }

    @Override
    public void setProgress(int progress) {
        if (!this.started) {
            return;
        }
        this.progress = progress;
        if (this.indeterminate) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setStringPainted(true);
            this.indeterminate = false;
        }
        this.progressBar.setValue(progress);
        this.refresh();
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int minimum) {
        this.min = minimum;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int maximum) {
        this.max = maximum;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        if (this.noteLabel != null) {
            this.noteLabel.setText(note);
            this.labelChanged = true;
        } else {
            this.note = note;
        }
    }

    @Override
    public void setMessage(String message) {
        if (this.messageLabel != null) {
            this.messageLabel.setText(message);
            this.labelChanged = true;
        } else {
            this.message = "" + message;
        }
    }

    public JPanel getProgressPanel() {
        return this.progressPanel;
    }

    public void refresh() {
        if (this.labelChanged) {
            this.progressPanel.validate();
        }
        this.progressPanel.paintImmediately(this.progressPanel.getVisibleRect());
    }

    private void createDialog() {
        if (this.indeterminate) {
            this.progressBar = new JProgressBar();
        } else {
            this.progressBar = new JProgressBar(this.min, this.max);
            this.progressBar.setStringPainted(true);
        }
        this.messageLabel = new JLabel(this.message);
        this.noteLabel = new JLabel(this.note);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 1));
        this.progressPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.progressPanel.add(this.messageLabel);
        this.progressPanel.add(this.progressBar);
    }
}

