/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.MSpaceEventHandler;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.PolymerVisualizer;
import chemaxon.marvin.space.UsableObject;
import chemaxon.marvin.space.gui.JMSpaceTreePopup;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JMSpaceTree
extends JPanel {
    protected JMSpaceTreePopup popup;
    protected FixedHeightJTree tree;
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected MSpaceEventHandler eventHandler;
    private boolean visibilityChange = false;
    private boolean visibilityState;

    public JMSpaceTree(GraphicScene graphicScene) {
        super(new GridLayout(1, 0));
        this.eventHandler = graphicScene.getEventHandler();
        this.popup = new JMSpaceTreePopup(graphicScene, this);
        this.setBackground(new Color(100, 0, 0));
        this.rootNode = new DefaultMutableTreeNode("Components");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new FixedHeightJTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        ColorRenderer renderer = new ColorRenderer();
        this.tree.setCellRenderer(renderer);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        ImageIcon icon = new ImageIcon();
        BufferedImage rect = new BufferedImage(20, 10, 1);
        Graphics2D gr = rect.createGraphics();
        gr.setBackground(Color.WHITE);
        gr.fill3DRect(0, 0, 20, 10, true);
        gr.setColor(Color.BLACK);
        gr.draw3DRect(0, 0, 20, 10, true);
        icon.setImage(rect);
        renderer.setOpenIcon(icon);
        ImageIcon cicon = new ImageIcon();
        BufferedImage crect = new BufferedImage(20, 10, 1);
        Graphics2D cgr = crect.createGraphics();
        cgr.setColor(Color.BLACK);
        cgr.fill3DRect(0, 0, 20, 10, true);
        cicon.setImage(crect);
        renderer.setClosedIcon(cicon);
        this.add(scrollPane);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)JMSpaceTree.this.tree.getLastSelectedPathComponent();
                if (node == null || node == JMSpaceTree.this.rootNode) {
                    return;
                }
                JMSpaceTree.this.eventHandler.selectionOccured(node);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = JMSpaceTree.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow == -1) {
                    JMSpaceTree.this.tree.clearSelection();
                    JMSpaceTree.this.eventHandler.clearHighLighting(null, true);
                }
                if (e.isPopupTrigger()) {
                    JMSpaceTree.this.tree.setSelectionRow(selRow);
                    if (JMSpaceTree.this.getLastSelectedObject() == null) {
                        return;
                    }
                    JMenu actMenu = JMSpaceTree.this.popup.getMenu();
                    JMSpaceTree.this.popup.removePreviouslyAddedMenu();
                    JMSpaceTree.this.popup.addMenu(actMenu);
                    JMSpaceTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    Rectangle rect = JMSpaceTree.this.tree.getRowBounds(selRow);
                    if (rect != null && (double)e.getX() - rect.getMinX() < 20.0) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)JMSpaceTree.this.tree.getLastSelectedPathComponent();
                        if (node == null || node == JMSpaceTree.this.rootNode) {
                            return;
                        }
                        JMSpaceTree.this.visibilityState = JMSpaceTree.this.eventHandler.iconClicked(node);
                        JMSpaceTree.this.visibilityChange = true;
                    }
                }
                JMSpaceTree.this.refreshTree();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (JMSpaceTree.this.visibilityChange) {
                    JMSpaceTree.this.eventHandler.refresh();
                    JMSpaceTree.this.visibilityChange = false;
                }
                int selRow = JMSpaceTree.this.tree.getRowForLocation(e.getX(), e.getY());
                if (e.isPopupTrigger()) {
                    JMSpaceTree.this.tree.setSelectionRow(selRow);
                    if (JMSpaceTree.this.getLastSelectedObject() == null) {
                        return;
                    }
                    JMenu actMenu = JMSpaceTree.this.popup.getMenu();
                    JMSpaceTree.this.popup.removePreviouslyAddedMenu();
                    JMSpaceTree.this.popup.addMenu(actMenu);
                    JMSpaceTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.tree.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TreePath path;
                if (JMSpaceTree.this.visibilityChange && (path = JMSpaceTree.this.tree.getPathForLocation(e.getX(), e.getY())) != null) {
                    JMSpaceTree.this.eventHandler.iconDragged((DefaultMutableTreeNode)path.getLastPathComponent(), JMSpaceTree.this.visibilityState);
                    JMSpaceTree.this.refreshTree();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public void setDropTarget(DropTargetListener dl) {
        this.tree.setDropTarget(new DropTarget(this.tree, dl));
    }

    public Component getDragComponent() {
        return this.tree;
    }

    public void drag(DragSource dragSource, DragGestureEvent dge, DragSourceListener dl) {
        if (this.visibilityChange) {
            return;
        }
        UsableObject cuo = this.getLastSelectedObject();
        if (cuo == null) {
            return;
        }
        Molecule mol = null;
        if (cuo instanceof MoleculeComponent) {
            mol = ((MoleculeComponent)cuo).getMolecule();
        } else if (cuo instanceof PolymerVisualizer) {
            mol = ((PolymerVisualizer)cuo).toMolecule();
        } else if (cuo instanceof MacroMoleculeComponent) {
            mol = ((MacroMoleculeComponent)cuo).getMolecule();
        } else {
            return;
        }
        if (mol == null) {
            return;
        }
        try {
            Transferable ss = ClipboardHandler.getTransferableFor(mol, null);
            dragSource.startDrag(dge, DragSource.DefaultCopyDrop, ss, dl);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void refreshTree() {
        this.treeModel.nodeChanged(this.rootNode);
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public DefaultMutableTreeNode getNode(Object o) {
        Enumeration<TreeNode> children = this.rootNode.children();
        return this.innerGetNode(o, children);
    }

    private DefaultMutableTreeNode innerGetNode(Object o, Enumeration children) {
        while (children.hasMoreElements()) {
            Object next = children.nextElement();
            if (!(next instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode ret = this.innerGetNode(o, ((DefaultMutableTreeNode)next).children());
            if (ret != this.rootNode) {
                return ret;
            }
            UsableObject cuo = (UsableObject)((DefaultMutableTreeNode)next).getUserObject();
            if (cuo != o) continue;
            return (DefaultMutableTreeNode)next;
        }
        return this.rootNode;
    }

    public UsableObject getLastSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null || node == this.rootNode) {
            return null;
        }
        return (UsableObject)node.getUserObject();
    }

    public DefaultMutableTreeNode getLastSelectedNode() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }

    public void removeCurrentNode() {
        this.removeNode((DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent());
    }

    public void removeNode(DefaultMutableTreeNode node) {
        this.treeModel.removeNodeFromParent(node);
    }

    public void addSubTreeToParent(DefaultMutableTreeNode subtree) {
        this.treeModel.insertNodeInto(subtree, this.rootNode, this.rootNode.getChildCount());
        this.tree.expandPath(new TreePath(subtree.getPath()));
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        this.tree.makeVisible(new TreePath(childNode.getPath()));
        return childNode;
    }

    public class FixedHeightJTree
    extends JTree {
        private boolean firstPaint;

        public FixedHeightJTree(TreeModel newModel) {
            super(newModel);
            this.firstPaint = true;
        }

        @Override
        public void setFont(Font f) {
            this.firstPaint = true;
            super.setFont(f);
        }

        private void calcFixedHeight(Graphics g) {
            g.setFont(this.getFont());
            this.setRowHeight(g.getFontMetrics().getHeight());
            this.firstPaint = false;
        }

        @Override
        public void paint(Graphics g) {
            if (this.firstPaint) {
                this.calcFixedHeight(g);
                return;
            }
            super.paint(g);
        }
    }

    public class ColorRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            UsableObject cuo;
            DefaultMutableTreeNode node;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf) {
                int height = 10;
                ImageIcon icon = new ImageIcon();
                BufferedImage rect = new BufferedImage(2 * height, height, 1);
                Graphics2D gr = rect.createGraphics();
                gr.setColor(this.getColor(value));
                gr.fill3DRect(0, 0, 2 * height, height, true);
                this.drawGrid(gr, value);
                icon.setImage(rect);
                this.setIcon(icon);
            }
            if ((node = (DefaultMutableTreeNode)value).getUserObject() instanceof UsableObject && !(cuo = (UsableObject)node.getUserObject()).getGraphicComponent().getCell().isActive()) {
                this.setForeground(Color.LIGHT_GRAY);
            }
            return this;
        }

        private Color getColor(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof UsableObject) {
                UsableObject uo = (UsableObject)node.getUserObject();
                if (!uo.isVisible()) {
                    return uo.getColor().darker();
                }
                return uo.getColor();
            }
            return Color.red;
        }

        private void drawGrid(Graphics2D gr, Object value) {
            UsableObject uo;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof UsableObject && !(uo = (UsableObject)node.getUserObject()).isVisible()) {
                gr.setColor(Color.black);
                gr.drawLine(2, 4, 18, 4);
                gr.drawLine(2, 6, 18, 6);
                gr.drawLine(4, 2, 4, 8);
                gr.drawLine(6, 2, 6, 8);
                gr.drawLine(8, 2, 8, 8);
                gr.drawLine(10, 2, 10, 8);
                gr.drawLine(12, 2, 12, 8);
                gr.drawLine(14, 2, 14, 8);
                gr.drawLine(16, 2, 16, 8);
            }
        }
    }
}

