/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.beans.MSketchPane;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.GraphicScene;
import chemaxon.marvin.space.IonVisualizer;
import chemaxon.marvin.space.MSpaceEasy;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.MolecularSurfaceComponent;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.PharmacophoreArrow;
import chemaxon.marvin.space.PharmacophorePoint;
import chemaxon.marvin.space.PolymerVisualizer;
import chemaxon.marvin.space.SecondaryStructureComponent;
import chemaxon.marvin.space.UsableObject;
import chemaxon.marvin.space.WaterVisualizer;
import chemaxon.marvin.space.gui.AlignmentForMSpace;
import chemaxon.marvin.space.gui.GuiFactory;
import chemaxon.marvin.space.gui.JMSpaceTree;
import chemaxon.marvin.space.gui.PDBInfo;
import chemaxon.struc.Molecule;
import chemaxon.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.filechooser.FileFilter;

public class JMSpaceTreePopup
extends JPopupMenu
implements ActionListener {
    private final GraphicScene graphicScene;
    private final JMSpaceTree tree;
    static final Object[] willExpandOptions = new Object[]{"No", "Yes"};
    static final String willExpandText = "This component will be removed from the scene. Are you sure?";
    static final String willExpandTitle = "Close Component";
    JMenu ligandMenu;
    JMenu proteinMenu;
    JMenu waterMenu;
    JMenu ionMenu;
    JMenu phMenu;
    JMenu phaMenu;
    JMenu surfaceMenu;
    JMenu secondaryMenu;
    JMenu qualityMenu;
    JMenu surfaceLigandMenu;
    JMenu surfaceProteinMenu;
    JMenu shapeLigandMenu;
    JMenu shapeProteinMenu;
    JMenuItem saveMenuItem;
    JMenuItem closeMenuItem;
    JMenuItem selectNeighborhoodMenuItem;
    JMenuItem zoomToPocketMenuItem;
    JMenuItem extendSelectionMenuItem;
    JMenuItem reduceTriangleCountMenuItem;
    JMenuItem openMarvinSketch;
    JMenuItem displayInfo;
    JMenuItem shapeOverlapMenu;
    JCheckBoxMenuItem selectedMenuItem;
    JCheckBoxMenuItem visibleMenuItem;
    JCheckBoxMenuItem significantDrawing;
    JCheckBoxMenuItem showVolume;
    JCheckBoxMenuItem highlighted;
    JFileChooser saveLigandFC;
    JMenu previouslyAddedMenu = null;
    ActionListener drawTypeActionListener;
    ActionListener colorTypeActionListener;
    ActionListener addHydrogensActionListener;
    ActionListener addLonePairsActionListener;
    private ArrayList ligandDrawTypes;
    private ArrayList proteinDrawTypes;
    private ArrayList waterDrawTypes;
    private ArrayList ionDrawTypes;
    private ArrayList secondaryDrawTypes;
    private ArrayList phpDrawTypes;
    private ArrayList phaDrawTypes;
    private ArrayList surfaceDrawTypes;
    private ArrayList ligandColorTypes;
    private ArrayList proteinColorTypes;
    private ArrayList waterColorTypes;
    private ArrayList ionColorTypes;
    private ArrayList secondaryColorTypes;
    private ArrayList surfaceColorTypes;
    private JCheckBoxMenuItem addHys;
    private JCheckBoxMenuItem praddHys;
    private JCheckBoxMenuItem waddHys;
    private JCheckBoxMenuItem addLps;
    private JCheckBoxMenuItem praddLps;
    private JCheckBoxMenuItem waddLps;
    private JCheckBoxMenuItem phAcceptor;
    private JCheckBoxMenuItem phDonor;
    private JCheckBoxMenuItem phAromatic;
    private JCheckBoxMenuItem phHydrophobic;
    private JCheckBoxMenuItem phAnionic;
    private JCheckBoxMenuItem phCationic;
    private JCheckBoxMenuItem phExcluded;
    private JRadioButtonMenuItem highMenuItem;
    private JRadioButtonMenuItem mediumMenuItem;
    private JRadioButtonMenuItem lowMenuItem;

    public JMSpaceTreePopup(GraphicScene graphicScene, JMSpaceTree jtree) {
        this.graphicScene = graphicScene;
        this.tree = jtree;
        this.setLightWeightPopupEnabled(false);
        this.selectedMenuItem = new JCheckBoxMenuItem("Selected");
        this.visibleMenuItem = new JCheckBoxMenuItem("Visible");
        this.highlighted = new JCheckBoxMenuItem("Highlighted");
        this.saveMenuItem = new JMenuItem("Save as...");
        this.saveLigandFC = new JFileChooser();
        MolFileFilter mff2 = new MolFileFilter("mol");
        MolFileFilter mff3 = new MolFileFilter("cube");
        MolFileFilter mff4 = new MolFileFilter("pdb");
        this.saveLigandFC.addChoosableFileFilter(mff2);
        this.saveLigandFC.addChoosableFileFilter(mff3);
        this.saveLigandFC.addChoosableFileFilter(mff4);
        this.closeMenuItem = new JMenuItem("Close");
        this.closeMenuItem.setActionCommand("Close");
        this.selectNeighborhoodMenuItem = new JMenuItem("Select neighborhood");
        this.zoomToPocketMenuItem = new JMenuItem("Zoom to pocket");
        this.openMarvinSketch = new JMenuItem("Open in MarvinSketch");
        this.displayInfo = new JMenuItem("Information...");
        try {
            Class.forName("chemaxon.marvin.beans.MSketchPane");
        }
        catch (Exception e) {
            this.openMarvinSketch.setEnabled(false);
        }
        this.extendSelectionMenuItem = new JMenuItem("Extend selection to residues");
        this.add(this.selectedMenuItem);
        this.add(this.visibleMenuItem);
        this.add(this.closeMenuItem);
        this.createMenus();
        this.selectedMenuItem.addActionListener(this);
        this.visibleMenuItem.addActionListener(this);
        this.saveMenuItem.addActionListener(this);
        this.closeMenuItem.addActionListener(this);
        this.highlighted.addActionListener(this);
        this.selectNeighborhoodMenuItem.addActionListener(this);
        this.zoomToPocketMenuItem.addActionListener(this);
        this.openMarvinSketch.addActionListener(this);
        this.extendSelectionMenuItem.addActionListener(this);
        this.displayInfo.addActionListener(this);
    }

    public JMenu getMenu() {
        UsableObject uo = this.tree.getLastSelectedObject();
        this.closeMenuItem.setEnabled(true);
        this.qualityMenu.setEnabled(true);
        if (uo == null) {
            return null;
        }
        this.remove(this.shapeOverlapMenu);
        if (uo instanceof MoleculeComponent) {
            this.add(this.highlighted);
            this.add(this.selectNeighborhoodMenuItem);
            this.add(this.zoomToPocketMenuItem);
            this.add(this.saveMenuItem);
            this.add(this.openMarvinSketch);
            this.add(this.surfaceLigandMenu);
            this.add(this.shapeLigandMenu);
        } else {
            this.remove(this.highlighted);
            this.remove(this.selectNeighborhoodMenuItem);
            this.remove(this.zoomToPocketMenuItem);
            this.remove(this.saveMenuItem);
            this.remove(this.openMarvinSketch);
            this.remove(this.surfaceLigandMenu);
            this.remove(this.shapeLigandMenu);
        }
        if (uo instanceof PolymerVisualizer) {
            this.add(this.extendSelectionMenuItem);
            this.add(this.openMarvinSketch);
            this.add(this.surfaceProteinMenu);
        } else {
            this.remove(this.extendSelectionMenuItem);
            this.remove(this.surfaceProteinMenu);
        }
        if (uo instanceof MacroMoleculeComponent) {
            this.add(this.displayInfo);
        } else {
            this.remove(this.displayInfo);
        }
        if (uo instanceof AlignmentForMSpace.AlignmentResultMoleculeComponent) {
            this.remove(this.shapeLigandMenu);
            this.add(this.shapeOverlapMenu);
        }
        if (uo.isGraphicComponent()) {
            this.setGraphicComponentValues(uo.getGraphicComponent());
        } else {
            MacroMoleculeComponent.MoleculeVisualizer mv = (MacroMoleculeComponent.MoleculeVisualizer)((Object)uo);
            if (mv.getMacroMoleculeComponent() != null) {
                this.closeMenuItem.setEnabled(false);
            }
            if (mv instanceof MoleculeComponent) {
                this.setMoleculeVisualizerValues(mv, "Ligand");
                this.setLigandValues((MoleculeComponent)mv);
                return this.ligandMenu;
            }
            if (mv instanceof WaterVisualizer) {
                this.setMoleculeVisualizerValues(mv, "Water");
                this.setWaterValues((WaterVisualizer)mv);
                return this.waterMenu;
            }
            if (mv instanceof IonVisualizer) {
                this.setMoleculeVisualizerValues(mv, "Ion");
                this.setIonValues((IonVisualizer)mv);
                return this.ionMenu;
            }
            if (mv instanceof PolymerVisualizer) {
                this.setMoleculeVisualizerValues(mv, "MacroMolecule");
                this.setProteinValues((PolymerVisualizer)mv);
                return this.proteinMenu;
            }
        }
        if (uo instanceof MolecularSurfaceComponent) {
            this.setSurfaceValues((MolecularSurfaceComponent)uo);
            this.qualityMenu.setEnabled(false);
            return this.surfaceMenu;
        }
        if (uo instanceof PharmacophorePoint) {
            this.setPharmacophoreValues((PharmacophorePoint)uo);
            return this.phMenu;
        }
        if (uo instanceof PharmacophoreArrow) {
            this.setPharmacophoreArrowValues((PharmacophoreArrow)uo);
            return this.phaMenu;
        }
        if (uo instanceof SecondaryStructureComponent) {
            this.setSecondaryStructureValues((SecondaryStructureComponent)uo);
            return this.secondaryMenu;
        }
        return new JMenu("Properties");
    }

    public void addMenu(JMenu menu) {
        if (menu == null) {
            return;
        }
        this.previouslyAddedMenu = menu;
        menu.add(this.qualityMenu);
        this.add(menu);
    }

    public void removePreviouslyAddedMenu() {
        if (this.previouslyAddedMenu != null) {
            this.remove(this.previouslyAddedMenu);
        }
    }

    private void setValues(MacroMoleculeComponent.MoleculeVisualizer mv, String type, String componentType, ArrayList rbcontainer) {
        String t = mv.getDrawProperty(componentType + "." + type);
        if (t == null) {
            t = mv.getDrawProperty(type);
        }
        if (t == null) {
            System.out.println(type + " is not properly set in " + componentType + ".");
            return;
        }
        for (JRadioButtonMenuItem rb : rbcontainer) {
            String s = StringUtil.replaceAll(rb.getText(), " ", "");
            if (!s.equalsIgnoreCase(t)) continue;
            rb.setSelected(true);
        }
    }

    private void setValues(GraphicComponent gc, String type, String componentType, ArrayList rbcontainer) {
        String t = gc.getDrawProperty(componentType + "." + type);
        if (t == null) {
            t = gc.getDrawProperty(type);
        }
        if (t == null) {
            System.out.println(type + " is not properly set in " + componentType + ".");
            return;
        }
        for (JRadioButtonMenuItem rb : rbcontainer) {
            String s = StringUtil.replaceAll(rb.getText(), " ", "");
            if (!s.equalsIgnoreCase(t)) continue;
            rb.setSelected(true);
        }
    }

    private void setLigandValues(MoleculeComponent mv) {
        this.setValues(mv, "DrawType", "Ligand", this.ligandDrawTypes);
        this.setValues(mv, "ColorType", "Ligand", this.ligandColorTypes);
        String hydrogens = mv.getDrawProperty("Ligand.Hydrogens");
        this.addHys.setState(hydrogens != null && hydrogens.equals("true"));
        String lps = mv.getDrawProperty("Ligand.LonePairs");
        this.addLps.setState(lps != null && lps.equals("true"));
        this.highlighted.setState(mv.isHighlighted());
    }

    private void setProteinValues(PolymerVisualizer mv) {
        this.setValues(mv, "DrawType", "MacroMolecule", this.proteinDrawTypes);
        this.setValues(mv, "ColorType", "MacroMolecule", this.proteinColorTypes);
        String hydrogens = mv.getDrawProperty("MacroMolecule.Hydrogens");
        this.praddHys.setState(hydrogens != null && hydrogens.equals("true"));
        String lps = mv.getDrawProperty("MacroMolecule.LonePairs");
        this.praddLps.setState(lps != null && lps.equals("true"));
    }

    private void setWaterValues(WaterVisualizer mv) {
        this.setValues(mv, "DrawType", "Water", this.waterDrawTypes);
        this.setValues(mv, "ColorType", "Water", this.waterColorTypes);
        String hydrogens = mv.getDrawProperty("Water.Hydrogens");
        this.waddHys.setState(hydrogens != null && hydrogens.equals("true"));
        String lps = mv.getDrawProperty("Water.LonePairs");
        this.waddLps.setState(lps != null && lps.equals("true"));
    }

    private void setIonValues(IonVisualizer mv) {
        this.setValues(mv, "DrawType", "Ion", this.ionDrawTypes);
        this.setValues(mv, "ColorType", "Ion", this.ionColorTypes);
    }

    private void setPharmacophoreValues(PharmacophorePoint ph) {
        this.setValues(ph, "DrawType", "PharmacophorePoint", this.phpDrawTypes);
        this.phAcceptor.setState(ph.isAcceptor());
        this.phDonor.setState(ph.isDonor());
        this.phAromatic.setState(ph.isAromatic());
        this.phHydrophobic.setState(ph.isHydrophobic());
        this.phAnionic.setState(ph.isAnionic());
        this.phCationic.setState(ph.isCationic());
        this.phExcluded.setState(ph.isExcluded());
    }

    private void setPharmacophoreArrowValues(PharmacophoreArrow pha) {
        this.setValues(pha, "DrawType", "PharmacophoreArrow", this.phaDrawTypes);
    }

    private void setSurfaceValues(MolecularSurfaceComponent surface) {
        this.setValues(surface, "DrawType", "Surface", this.surfaceDrawTypes);
        this.setValues(surface, "ColorType", "Surface", this.surfaceColorTypes);
        this.showVolume.setEnabled(surface.getColorType() == 7);
        if (this.showVolume.isEnabled()) {
            this.showVolume.setState(surface.isVolumeVisible());
        }
    }

    private void setSecondaryStructureValues(SecondaryStructureComponent ssc) {
        this.setValues(ssc, "DrawType", "SecondaryStructure", this.secondaryDrawTypes);
        this.setValues(ssc, "ColorType", "SecondaryStructure", this.secondaryColorTypes);
    }

    private void setGraphicComponentValues(GraphicComponent gc) {
        this.selectedMenuItem.setState(gc.isSelected());
        this.visibleMenuItem.setState(gc.isVisible());
        int quality = gc.getRenderingQuality();
        switch (quality) {
            case 3: {
                this.highMenuItem.setSelected(true);
                break;
            }
            case 2: {
                this.mediumMenuItem.setSelected(true);
                break;
            }
            default: {
                this.lowMenuItem.setSelected(true);
            }
        }
    }

    private void setMoleculeVisualizerValues(MacroMoleculeComponent.MoleculeVisualizer mv, String name) {
        this.selectedMenuItem.setState(mv.isSelected());
        this.visibleMenuItem.setState(mv.isVisible());
        String quality = mv.getDrawProperty(name + ".Quality");
        if (quality == null) {
            System.out.println("Quality is not properly set in " + name + ".");
        } else if (quality.equalsIgnoreCase("High")) {
            this.highMenuItem.setSelected(true);
        } else if (quality.equalsIgnoreCase("Medium")) {
            this.mediumMenuItem.setSelected(true);
        } else if (quality.equalsIgnoreCase("Low")) {
            this.lowMenuItem.setSelected(true);
        }
    }

    private void createMenus() {
        GuiFactory guiFactory = new GuiFactory();
        this.createActionListeners();
        this.ligandMenu = new JMenu("Properties");
        this.ligandMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.proteinMenu = new JMenu("Properties");
        this.proteinMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.waterMenu = new JMenu("Properties");
        this.waterMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.ionMenu = new JMenu("Properties");
        this.ionMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.phMenu = new JMenu("Properties");
        this.phMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.phaMenu = new JMenu("Properties");
        this.phaMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.surfaceMenu = new JMenu("Properties");
        this.surfaceMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.secondaryMenu = new JMenu("Properties");
        this.secondaryMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.ligandDrawTypes = new ArrayList();
        JMenu dligandMenu = guiFactory.getRadioButtonMenu("Draw Type", GuiFactory.ligandDrawTypes, this.ligandDrawTypes, this.drawTypeActionListener);
        this.proteinDrawTypes = new ArrayList();
        JMenu dproteinMenu = guiFactory.getRadioButtonMenu("Draw Type", GuiFactory.proteinDrawTypes, this.proteinDrawTypes, this.drawTypeActionListener);
        this.secondaryDrawTypes = new ArrayList();
        JMenu dsecondaryMenu = guiFactory.getRadioButtonMenu("Draw Type", GuiFactory.secondaryDrawTypes, this.secondaryDrawTypes, this.drawTypeActionListener);
        this.waterDrawTypes = new ArrayList();
        JMenu dwaterMenu = guiFactory.getRadioButtonMenu("Draw Type", GuiFactory.waterDrawTypes, this.waterDrawTypes, this.drawTypeActionListener);
        this.ionDrawTypes = new ArrayList();
        JMenu dionMenu = guiFactory.getRadioButtonMenu("Draw Type", GuiFactory.ionDrawTypes, this.ionDrawTypes, this.drawTypeActionListener);
        String[] phpdt = new String[]{"Dotted", "Mesh", "Solid", "Transparent"};
        this.phpDrawTypes = new ArrayList();
        JMenu dtphMenu = guiFactory.getRadioButtonMenu("Draw Type", phpdt, this.phpDrawTypes, this.drawTypeActionListener);
        String[] phadt = new String[]{"Mesh", "Solid", "Transparent"};
        this.phaDrawTypes = new ArrayList();
        JMenu dtphaMenu = guiFactory.getRadioButtonMenu("Draw Type", phadt, this.phaDrawTypes, this.drawTypeActionListener);
        String[] surfdt = new String[]{"Dot", "Mesh", "Solid", "Transparent"};
        this.surfaceDrawTypes = new ArrayList();
        JMenu sdtMenu = guiFactory.getRadioButtonMenu("Draw Type", surfdt, this.surfaceDrawTypes, this.drawTypeActionListener);
        String[] lct = new String[]{"Constant", "CPK"};
        this.ligandColorTypes = new ArrayList();
        JMenu cligandMenu = guiFactory.getRadioButtonMenu("Color Type", lct, this.ligandColorTypes, this.colorTypeActionListener);
        String[] pct = new String[]{"Constant", "CPK", "Residue", "Chain", "Secondary Structure", "Rainbow", "B-factor"};
        this.proteinColorTypes = new ArrayList();
        JMenu cproteinMenu = guiFactory.getRadioButtonMenu("Color Type", pct, this.proteinColorTypes, this.colorTypeActionListener);
        String[] wct = new String[]{"Constant", "CPK"};
        this.waterColorTypes = new ArrayList();
        JMenu cwaterMenu = guiFactory.getRadioButtonMenu("Color Type", wct, this.waterColorTypes, this.colorTypeActionListener);
        String[] ict = new String[]{"Constant", "CPK"};
        this.ionColorTypes = new ArrayList();
        JMenu cionMenu = guiFactory.getRadioButtonMenu("Color Type", ict, this.ionColorTypes, this.colorTypeActionListener);
        String[] surfct = new String[]{"Constant", "Atom Type", "Residue Type", "Chain Type", "Electrostatic Potential", "Secondary Structure Type", "Rainbow", "B-factor"};
        this.surfaceColorTypes = new ArrayList();
        JMenu csurfaceMenu = guiFactory.getRadioButtonMenu("Color Type", surfct, this.surfaceColorTypes, this.colorTypeActionListener);
        String[] secct = new String[]{"Constant", "Residue", "Chain", "Secondary Structure", "Rainbow", "B-factor"};
        this.secondaryColorTypes = new ArrayList();
        JMenu csecondaryMenu = guiFactory.getRadioButtonMenu("Color Type", secct, this.secondaryColorTypes, this.colorTypeActionListener);
        this.surfaceLigandMenu = new JMenu("Surface");
        this.surfaceLigandMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.surfaceProteinMenu = new JMenu("Surface");
        this.surfaceProteinMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.shapeLigandMenu = new JMenu("Molecular Shape");
        this.shapeLigandMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.shapeOverlapMenu = new JMenuItem("Shape of Molecular Overlap");
        this.shapeProteinMenu = new JMenu("Molecular Shape");
        this.shapeProteinMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenu tphMenu = new JMenu("Type");
        tphMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.addHys = new JCheckBoxMenuItem("Hydrogens", false);
        this.praddHys = new JCheckBoxMenuItem("Hydrogens", false);
        this.waddHys = new JCheckBoxMenuItem("Hydrogens", false);
        this.addLps = new JCheckBoxMenuItem("Lone Pairs", true);
        this.praddLps = new JCheckBoxMenuItem("Lone Pairs", true);
        this.waddLps = new JCheckBoxMenuItem("Lone Pairs", false);
        JMenuItem lshowVDW = new JMenuItem("van der Waals");
        lshowVDW.setActionCommand("van der Waals");
        JMenuItem lshowSAS = new JMenuItem("Solvent accessible");
        lshowSAS.setActionCommand("Solvent-accessible");
        JMenuItem lshowGauss = new JMenuItem("Blobby");
        lshowGauss.setActionCommand("Blobby");
        JMenuItem lshowConnolly = new JMenuItem("Connolly");
        lshowConnolly.setActionCommand("Connolly");
        JMenuItem showVDW = new JMenuItem("van der waals");
        showVDW.setActionCommand("van der Waals");
        JMenuItem showSAS = new JMenuItem("Solvent accessible");
        showSAS.setActionCommand("Solvent-accessible");
        JMenuItem showGauss = new JMenuItem("Blobby");
        showGauss.setActionCommand("Blobby");
        JMenuItem showConnolly = new JMenuItem("Connolly");
        showConnolly.setActionCommand("Connolly");
        JMenuItem lshowAtomTypes = new JMenuItem("ATOM_TYPES");
        lshowAtomTypes.setActionCommand("ATOM_TYPES");
        JMenuItem lshowExtendedAtomTypes = new JMenuItem("EXTENDED_ATOMTYPES");
        lshowExtendedAtomTypes.setActionCommand("EXTENDED_ATOMTYPES");
        JMenuItem lshowPharmacophore = new JMenuItem("PHARMACOPHORE");
        lshowPharmacophore.setActionCommand("PHARMACOPHORE");
        JMenuItem lshowSame = new JMenuItem("SAME");
        lshowSame.setActionCommand("SAME");
        JMenuItem showAtomTypes = new JMenuItem("ATOM_TYPES");
        showAtomTypes.setActionCommand("ATOM_TYPES");
        JMenuItem showExtendedAtomTypes = new JMenuItem("EXTENDED_ATOMTYPES");
        showExtendedAtomTypes.setActionCommand("EXTENDED_ATOMTYPES");
        JMenuItem showPharmacophore = new JMenuItem("PHARMACOPHORE");
        lshowPharmacophore.setActionCommand("PHARMACOPHORE");
        JMenuItem showSame = new JMenuItem("SAME");
        lshowSame.setActionCommand("SAME");
        this.reduceTriangleCountMenuItem = new JMenuItem("Reduce triangle count");
        this.reduceTriangleCountMenuItem.setActionCommand("Surface.Simplification");
        this.significantDrawing = new JCheckBoxMenuItem("Significant drawing");
        this.significantDrawing.setActionCommand("Surface.SignificantDrawing");
        this.showVolume = new JCheckBoxMenuItem("Show Volume");
        this.showVolume.setActionCommand("Surface.ShowVolume");
        this.phAcceptor = new JCheckBoxMenuItem("Acceptor", true);
        this.phAcceptor.setActionCommand("PharmacophorePoint.Acceptor");
        this.phDonor = new JCheckBoxMenuItem("Donor", false);
        this.phDonor.setActionCommand("PharmacophorePoint.Donor");
        this.phHydrophobic = new JCheckBoxMenuItem("Hydrophobic", false);
        this.phHydrophobic.setActionCommand("PharmacophorePoint.Hydrophobic");
        this.phAromatic = new JCheckBoxMenuItem("Aromatic", false);
        this.phAromatic.setActionCommand("PharmacophorePoint.Aromatic");
        this.phAnionic = new JCheckBoxMenuItem("Anionic", false);
        this.phAnionic.setActionCommand("PharmacophorePoint.Anionic");
        this.phCationic = new JCheckBoxMenuItem("Cationic", false);
        this.phCationic.setActionCommand("PharmacophorePoint.Cationic");
        this.phExcluded = new JCheckBoxMenuItem("Excluded", false);
        this.phExcluded.setActionCommand("PharmacophorePoint.Excluded");
        this.qualityMenu = new JMenu("Quality");
        this.qualityMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.highMenuItem = new JRadioButtonMenuItem("High");
        this.highMenuItem.setActionCommand("High");
        this.mediumMenuItem = new JRadioButtonMenuItem("Medium");
        this.mediumMenuItem.setSelected(true);
        this.mediumMenuItem.setActionCommand("Medium");
        this.lowMenuItem = new JRadioButtonMenuItem("Low");
        this.lowMenuItem.setActionCommand("Low");
        ButtonGroup qualitybg = new ButtonGroup();
        qualitybg.add(this.highMenuItem);
        qualitybg.add(this.mediumMenuItem);
        qualitybg.add(this.lowMenuItem);
        dligandMenu.add(this.addHys);
        dligandMenu.add(this.addLps);
        dproteinMenu.add(this.praddHys);
        dproteinMenu.add(this.praddLps);
        dwaterMenu.add(this.waddHys);
        dwaterMenu.add(this.waddLps);
        this.phMenu.add(tphMenu);
        tphMenu.add(this.phAcceptor);
        tphMenu.add(this.phDonor);
        tphMenu.add(this.phHydrophobic);
        tphMenu.add(this.phAromatic);
        tphMenu.add(this.phAnionic);
        tphMenu.add(this.phCationic);
        tphMenu.add(this.phExcluded);
        this.phMenu.add(dtphMenu);
        this.phaMenu.add(dtphaMenu);
        this.surfaceLigandMenu.add(lshowConnolly);
        this.surfaceLigandMenu.add(lshowVDW);
        this.surfaceLigandMenu.add(lshowSAS);
        this.surfaceLigandMenu.addSeparator();
        this.surfaceLigandMenu.add(lshowGauss);
        this.surfaceProteinMenu.add(showConnolly);
        this.surfaceProteinMenu.add(showVDW);
        this.surfaceProteinMenu.add(showSAS);
        this.surfaceProteinMenu.addSeparator();
        this.surfaceProteinMenu.add(showGauss);
        this.shapeLigandMenu.add(lshowAtomTypes);
        this.shapeLigandMenu.add(lshowExtendedAtomTypes);
        this.shapeLigandMenu.add(lshowPharmacophore);
        this.shapeLigandMenu.add(lshowSame);
        this.shapeProteinMenu.add(showAtomTypes);
        this.shapeProteinMenu.add(showExtendedAtomTypes);
        this.shapeProteinMenu.add(showPharmacophore);
        this.shapeProteinMenu.add(showSame);
        this.qualityMenu.add(this.highMenuItem);
        this.qualityMenu.add(this.mediumMenuItem);
        this.qualityMenu.add(this.lowMenuItem);
        this.ligandMenu.add(dligandMenu);
        this.ligandMenu.add(cligandMenu);
        this.ligandMenu.add(this.surfaceLigandMenu);
        this.proteinMenu.add(dproteinMenu);
        this.proteinMenu.add(cproteinMenu);
        this.proteinMenu.add(this.surfaceProteinMenu);
        this.waterMenu.add(dwaterMenu);
        this.waterMenu.add(cwaterMenu);
        this.ionMenu.add(dionMenu);
        this.ionMenu.add(cionMenu);
        this.surfaceMenu.add(this.significantDrawing);
        this.surfaceMenu.add(this.showVolume);
        this.surfaceMenu.add(this.reduceTriangleCountMenuItem);
        this.surfaceMenu.add(sdtMenu);
        this.surfaceMenu.add(csurfaceMenu);
        this.secondaryMenu.add(dsecondaryMenu);
        this.secondaryMenu.add(csecondaryMenu);
        ActionListener phTypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == JMSpaceTreePopup.this.phAcceptor) {
                    JMSpaceTreePopup.this.phTypeChanged(JMSpaceTreePopup.this.phAcceptor, new JCheckBoxMenuItem[]{JMSpaceTreePopup.this.phExcluded, JMSpaceTreePopup.this.phHydrophobic});
                } else if (evt.getSource() == JMSpaceTreePopup.this.phDonor) {
                    JMSpaceTreePopup.this.phTypeChanged(JMSpaceTreePopup.this.phDonor, new JCheckBoxMenuItem[]{JMSpaceTreePopup.this.phExcluded, JMSpaceTreePopup.this.phHydrophobic});
                } else if (evt.getSource() == JMSpaceTreePopup.this.phHydrophobic) {
                    JMSpaceTreePopup.this.phTypeChanged(JMSpaceTreePopup.this.phHydrophobic, new JCheckBoxMenuItem[]{JMSpaceTreePopup.this.phExcluded, JMSpaceTreePopup.this.phDonor, JMSpaceTreePopup.this.phAcceptor});
                } else if (evt.getSource() == JMSpaceTreePopup.this.phAromatic) {
                    JMSpaceTreePopup.this.phTypeChanged(JMSpaceTreePopup.this.phAromatic, new JCheckBoxMenuItem[]{JMSpaceTreePopup.this.phExcluded});
                } else if (evt.getSource() == JMSpaceTreePopup.this.phAnionic) {
                    JMSpaceTreePopup.this.phTypeChanged(JMSpaceTreePopup.this.phAnionic, new JCheckBoxMenuItem[]{JMSpaceTreePopup.this.phExcluded, JMSpaceTreePopup.this.phCationic});
                } else if (evt.getSource() == JMSpaceTreePopup.this.phCationic) {
                    JMSpaceTreePopup.this.phTypeChanged(JMSpaceTreePopup.this.phCationic, new JCheckBoxMenuItem[]{JMSpaceTreePopup.this.phExcluded, JMSpaceTreePopup.this.phAnionic});
                } else if (evt.getSource() == JMSpaceTreePopup.this.phExcluded) {
                    JMSpaceTreePopup.this.phTypeChanged(JMSpaceTreePopup.this.phExcluded, new JCheckBoxMenuItem[]{JMSpaceTreePopup.this.phAcceptor, JMSpaceTreePopup.this.phDonor, JMSpaceTreePopup.this.phHydrophobic, JMSpaceTreePopup.this.phAromatic, JMSpaceTreePopup.this.phAnionic, JMSpaceTreePopup.this.phCationic});
                }
            }
        };
        ActionListener prSecondaryActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsableObject obj = JMSpaceTreePopup.this.tree.getLastSelectedObject();
                if (obj != null) {
                    JMSpaceTreePopup.this.graphicScene.processComponentEvent(obj, "MacroMolecule.SecondaryStructure." + evt.getActionCommand(), "" + ((JCheckBoxMenuItem)evt.getSource()).getState());
                    JMSpaceTreePopup.this.graphicScene.refresh();
                }
            }
        };
        ActionListener qualityActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsableObject obj = JMSpaceTreePopup.this.tree.getLastSelectedObject();
                if (obj != null) {
                    JMSpaceTreePopup.this.graphicScene.processComponentEvent(obj, "Quality", evt.getActionCommand());
                    JMSpaceTreePopup.this.graphicScene.refresh();
                }
            }
        };
        ActionListener showSurfaceActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsableObject obj = JMSpaceTreePopup.this.tree.getLastSelectedObject();
                if (obj != null) {
                    MacroMoleculeComponent.MoleculeVisualizer mv = (MacroMoleculeComponent.MoleculeVisualizer)((Object)obj);
                    JMSpaceTreePopup.this.graphicScene.getEventHandler().computeSurface(mv, evt.getActionCommand());
                    JMSpaceTreePopup.this.graphicScene.getEventHandler().registerEvent("ShowSurface", evt.getActionCommand(), obj);
                    JMSpaceTreePopup.this.graphicScene.refresh();
                }
            }
        };
        ActionListener showShapeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsableObject obj = JMSpaceTreePopup.this.tree.getLastSelectedObject();
                if (obj != null) {
                    try {
                        if (!(obj instanceof MacroMoleculeComponent.MoleculeVisualizer)) {
                            System.err.println("Unhandled molecule component type: " + ((Object)obj).toString());
                            return;
                        }
                        MacroMoleculeComponent.MoleculeVisualizer mv = (MacroMoleculeComponent.MoleculeVisualizer)((Object)obj);
                        JMSpaceTreePopup.this.graphicScene.getEventHandler().computeShape(mv, evt.getActionCommand());
                        JMSpaceTreePopup.this.graphicScene.getEventHandler().registerEvent("ShowMolecularShape", evt.getActionCommand(), obj);
                        JMSpaceTreePopup.this.graphicScene.refresh();
                    }
                    catch (AlignmentException ex) {
                        Logger.getLogger(JMSpaceTreePopup.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(JMSpaceTreePopup.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        };
        this.phAcceptor.addActionListener(phTypeActionListener);
        this.phDonor.addActionListener(phTypeActionListener);
        this.phHydrophobic.addActionListener(phTypeActionListener);
        this.phAromatic.addActionListener(phTypeActionListener);
        this.phAnionic.addActionListener(phTypeActionListener);
        this.phCationic.addActionListener(phTypeActionListener);
        this.phExcluded.addActionListener(phTypeActionListener);
        this.highMenuItem.addActionListener(qualityActionListener);
        this.mediumMenuItem.addActionListener(qualityActionListener);
        this.lowMenuItem.addActionListener(qualityActionListener);
        lshowVDW.addActionListener(showSurfaceActionListener);
        lshowSAS.addActionListener(showSurfaceActionListener);
        lshowGauss.addActionListener(showSurfaceActionListener);
        lshowConnolly.addActionListener(showSurfaceActionListener);
        showVDW.addActionListener(showSurfaceActionListener);
        showSAS.addActionListener(showSurfaceActionListener);
        showGauss.addActionListener(showSurfaceActionListener);
        showConnolly.addActionListener(showSurfaceActionListener);
        lshowAtomTypes.addActionListener(showShapeActionListener);
        lshowExtendedAtomTypes.addActionListener(showShapeActionListener);
        lshowPharmacophore.addActionListener(showShapeActionListener);
        lshowSame.addActionListener(showShapeActionListener);
        this.shapeOverlapMenu.addActionListener(showShapeActionListener);
        showAtomTypes.addActionListener(showShapeActionListener);
        showExtendedAtomTypes.addActionListener(showShapeActionListener);
        showPharmacophore.addActionListener(showShapeActionListener);
        showSame.addActionListener(showShapeActionListener);
        this.addHys.addActionListener(this.addHydrogensActionListener);
        this.praddHys.addActionListener(this.addHydrogensActionListener);
        this.waddHys.addActionListener(this.addHydrogensActionListener);
        this.addLps.addActionListener(this.addLonePairsActionListener);
        this.praddLps.addActionListener(this.addLonePairsActionListener);
        this.waddLps.addActionListener(this.addLonePairsActionListener);
        this.reduceTriangleCountMenuItem.addActionListener(this);
        this.significantDrawing.addActionListener(this);
        this.showVolume.addActionListener(this);
    }

    private void createActionListeners() {
        this.drawTypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (JMSpaceTreePopup.this.surfaceDrawTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentDrawTypeActionPerformed("Surface", e);
                } else if (JMSpaceTreePopup.this.ligandDrawTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentDrawTypeActionPerformed("Ligand", e);
                } else if (JMSpaceTreePopup.this.proteinDrawTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentDrawTypeActionPerformed("MacroMolecule", e);
                } else if (JMSpaceTreePopup.this.waterDrawTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentDrawTypeActionPerformed("Water", e);
                } else if (JMSpaceTreePopup.this.ionDrawTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentDrawTypeActionPerformed("Ion", e);
                } else if (JMSpaceTreePopup.this.phpDrawTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentDrawTypeActionPerformed("PharmacophorePoint", e);
                } else if (JMSpaceTreePopup.this.phaDrawTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentDrawTypeActionPerformed("PharmacophoreArrow", e);
                } else if (JMSpaceTreePopup.this.secondaryDrawTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentDrawTypeActionPerformed("SecondaryStructure", e);
                }
            }
        };
        this.colorTypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (JMSpaceTreePopup.this.ligandColorTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentColorTypeActionPerformed("Ligand", e);
                } else if (JMSpaceTreePopup.this.proteinColorTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentColorTypeActionPerformed("MacroMolecule", e);
                } else if (JMSpaceTreePopup.this.waterColorTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentColorTypeActionPerformed("Water", e);
                } else if (JMSpaceTreePopup.this.ionColorTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentColorTypeActionPerformed("Ion", e);
                } else if (JMSpaceTreePopup.this.surfaceColorTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentColorTypeActionPerformed("Surface", e);
                } else if (JMSpaceTreePopup.this.secondaryColorTypes.contains(source)) {
                    JMSpaceTreePopup.this.componentColorTypeActionPerformed("SecondaryStructure", e);
                }
            }
        };
        this.addHydrogensActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsableObject obj = JMSpaceTreePopup.this.tree.getLastSelectedObject();
                if (obj == null) {
                    return;
                }
                if (evt.getSource() == JMSpaceTreePopup.this.addHys) {
                    JMSpaceTreePopup.this.graphicScene.processComponentEvent(obj, "Ligand.Hydrogens", "" + JMSpaceTreePopup.this.addHys.getState());
                } else if (evt.getSource() == JMSpaceTreePopup.this.praddHys) {
                    JMSpaceTreePopup.this.graphicScene.processComponentEvent(obj, "MacroMolecule.Hydrogens", "" + JMSpaceTreePopup.this.praddHys.getState());
                } else if (evt.getSource() == JMSpaceTreePopup.this.waddHys) {
                    JMSpaceTreePopup.this.graphicScene.processComponentEvent(obj, "Water.Hydrogens", "" + JMSpaceTreePopup.this.waddHys.getState());
                }
                JMSpaceTreePopup.this.graphicScene.refresh();
            }
        };
        this.addLonePairsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UsableObject obj = JMSpaceTreePopup.this.tree.getLastSelectedObject();
                if (obj == null) {
                    return;
                }
                if (evt.getSource() == JMSpaceTreePopup.this.addLps) {
                    JMSpaceTreePopup.this.graphicScene.processComponentEvent(obj, "Ligand.LonePairs", "" + JMSpaceTreePopup.this.addLps.getState());
                } else if (evt.getSource() == JMSpaceTreePopup.this.praddLps) {
                    JMSpaceTreePopup.this.graphicScene.processComponentEvent(obj, "MacroMolecule.LonePairs", "" + JMSpaceTreePopup.this.praddLps.getState());
                } else if (evt.getSource() == JMSpaceTreePopup.this.waddLps) {
                    JMSpaceTreePopup.this.graphicScene.processComponentEvent(obj, "Water.LonePairs", "" + JMSpaceTreePopup.this.waddLps.getState());
                }
                JMSpaceTreePopup.this.graphicScene.refresh();
            }
        };
    }

    private void phTypeChanged(JCheckBoxMenuItem phCheckBox, JCheckBoxMenuItem[] excluded) {
        UsableObject obj = this.tree.getLastSelectedObject();
        if (obj != null) {
            this.graphicScene.processComponentEvent(obj, phCheckBox.getActionCommand(), "" + phCheckBox.getState());
            for (int i = 0; i < excluded.length; ++i) {
                if (!excluded[i].getState()) continue;
                excluded[i].setState(false);
                this.graphicScene.processComponentEvent(obj, excluded[i].getActionCommand(), "" + excluded[i].getState());
            }
            this.graphicScene.refresh();
        }
    }

    private void componentDrawTypeActionPerformed(String componentType, ActionEvent evt) {
        UsableObject obj = this.tree.getLastSelectedObject();
        if (obj != null) {
            this.graphicScene.processComponentEvent(obj, componentType + ".DrawType", evt.getActionCommand());
            this.graphicScene.refresh();
        }
    }

    private void componentColorTypeActionPerformed(String componentType, ActionEvent evt) {
        UsableObject obj = this.tree.getLastSelectedObject();
        if (obj != null) {
            this.graphicScene.processComponentEvent(obj, componentType + ".ColorType", evt.getActionCommand());
            this.graphicScene.refresh();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UsableObject obj;
        Object source = e.getSource();
        if (source == this.selectedMenuItem) {
            UsableObject uo = this.tree.getLastSelectedObject();
            if (this.selectedMenuItem.getState()) {
                uo.select();
                this.graphicScene.getEventHandler().registerEvent("select", "", uo);
            } else {
                uo.unSelect();
                this.graphicScene.getEventHandler().registerEvent("unSelect", "", uo);
            }
        } else if (source == this.visibleMenuItem) {
            this.tree.getLastSelectedObject().setVisible(this.visibleMenuItem.getState());
            this.graphicScene.getEventHandler().registerEvent("setVisible", "" + this.visibleMenuItem.getState(), this.tree.getLastSelectedObject());
            if (!this.tree.getLastSelectedNode().isLeaf()) {
                this.tree.refreshTree();
            }
        } else if (source == this.saveMenuItem) {
            this.saveActionPerformed();
        } else if (source == this.closeMenuItem) {
            this.closeActionPerformed();
        } else if (source == this.openMarvinSketch) {
            this.openMarvinSketch();
        } else if (source == this.displayInfo) {
            UsableObject obj2 = this.tree.getLastSelectedObject();
            if (obj2 instanceof MacroMoleculeComponent) {
                try {
                    PDBInfo pdbInfo = new PDBInfo(this.graphicScene, ((MacroMoleculeComponent)obj2).getMacroMolecule());
                    pdbInfo.setVisible(true);
                }
                catch (Exception ex) {
                    this.graphicScene.getEventHandler().handleMyErrors(ex, "Error");
                }
            }
        } else if (source == this.highlighted) {
            UsableObject obj3 = this.tree.getLastSelectedObject();
            if (obj3 instanceof MoleculeComponent) {
                ((MoleculeComponent)obj3).setHighlighted(this.highlighted.getState());
            }
        } else if (source == this.selectNeighborhoodMenuItem) {
            UsableObject obj4 = this.tree.getLastSelectedObject();
            if (obj4 instanceof MoleculeComponent) {
                BoundingBox bb = new BoundingBox();
                bb.setWithCondition(((MoleculeComponent)obj4).getBoundingBox());
                bb.extend(2.0f);
                this.graphicScene.getActiveCell().selectComponentElementsInside(bb);
            }
        } else if (source == this.zoomToPocketMenuItem) {
            UsableObject obj5 = this.tree.getLastSelectedObject();
            if (obj5 instanceof MoleculeComponent) {
                MoleculeComponent mc = (MoleculeComponent)obj5;
                this.graphicScene.getEventHandler().zoomToPocket(mc);
            }
        } else if (source == this.extendSelectionMenuItem) {
            UsableObject obj6 = this.tree.getLastSelectedObject();
            if (obj6 instanceof PolymerVisualizer) {
                ((PolymerVisualizer)obj6).extendSelectionToResidues();
            }
        } else if (source == this.reduceTriangleCountMenuItem) {
            UsableObject obj7 = this.tree.getLastSelectedObject();
            if (obj7 != null && obj7 instanceof MolecularSurfaceComponent) {
                this.graphicScene.getEventHandler().surfaceSimplification((MolecularSurfaceComponent)obj7);
            }
        } else if (source == this.significantDrawing) {
            UsableObject obj8 = this.tree.getLastSelectedObject();
            if (obj8 != null && obj8 instanceof MolecularSurfaceComponent) {
                try {
                    this.graphicScene.getEventHandler().registerEvent("exclusiveDrawing", "" + this.significantDrawing.getState(), obj8);
                    ((MolecularSurfaceComponent)obj8).setExclusiveDrawing(this.significantDrawing.getState());
                }
                catch (Exception ex) {
                    this.graphicScene.getEventHandler().handleMyErrors(ex, "Error");
                }
            }
        } else if (source == this.showVolume && (obj = this.tree.getLastSelectedObject()) != null && obj instanceof MolecularSurfaceComponent) {
            ((MolecularSurfaceComponent)obj).showVolume(this.showVolume.getState());
        }
        this.graphicScene.refresh();
    }

    private void saveActionPerformed() {
        int returnVal;
        UsableObject obj = this.tree.getLastSelectedObject();
        Molecule mol = null;
        if (obj instanceof MoleculeComponent) {
            mol = ((MoleculeComponent)obj).getMolecule();
        }
        if ((returnVal = this.saveLigandFC.showSaveDialog(this.graphicScene)) == 0 && this.saveLigandFC.getSelectedFile() != null) {
            if (this.confirmOverwrite(this.saveLigandFC.getSelectedFile()) == 1) {
                this.saveActionPerformed();
            }
            File newfile = this.saveLigandFC.getSelectedFile();
            FileFilter ff = this.saveLigandFC.getFileFilter();
            MolFileFilter mff = null;
            String fmt = null;
            String ext = MFileFormatUtil.getFileExtensionLC(newfile);
            if (ff instanceof MolFileFilter) {
                mff = (MolFileFilter)ff;
                fmt = mff.getFormat();
                if (ext == null) {
                    ext = mff.getExtension();
                    newfile = new File(newfile.getPath() + "." + ext);
                }
            }
            if (ext == null) {
                if (fmt != null) {
                    ext = fmt;
                    newfile = new File(newfile.getPath() + "." + ext);
                }
            } else if (!(mff != null && mff.accept(newfile) || fmt != null && fmt.equals("sybyl") && ext.equals("mol"))) {
                fmt = MFileFormatUtil.getMostLikelyMolFormat("." + ext);
            }
            if (fmt == null) {
                JOptionPane.showMessageDialog(null, "Cannot determine output format from extension for file " + newfile.getName(), "Unknown output file format", 0);
                return;
            }
            this.save(newfile, mol.toFormat(fmt));
        }
    }

    private void closeActionPerformed() {
        int n;
        UsableObject obj = this.tree.getLastSelectedObject();
        if (obj != null && obj.isGraphicComponent() && (n = JOptionPane.showOptionDialog(this.tree, willExpandText, willExpandTitle, 0, 3, null, willExpandOptions, willExpandOptions[1])) != 0) {
            this.graphicScene.removeComponent(obj.getGraphicComponent());
            this.tree.removeCurrentNode();
            this.graphicScene.refresh();
        }
    }

    private void openMarvinSketch() {
        JFrame frame = new JFrame();
        frame.setTitle("MarvinSketch");
        MSpaceEasy.setIconImage(frame);
        final MSketchPane sp = new MSketchPane();
        if (this.tree.getLastSelectedObject() instanceof MoleculeComponent) {
            MoleculeComponent mc = (MoleculeComponent)this.tree.getLastSelectedObject();
            sp.setMol(mc.getMolecule());
            mc.setVisible(false);
        }
        MoleculeComponent newmc = null;
        try {
            newmc = this.graphicScene.getEventHandler().setMoleculeWithoutChange(sp.getMol(), false);
            this.graphicScene.refresh();
        }
        catch (Exception e) {
            this.graphicScene.getEventHandler().handleMyErrors(e, "Error");
        }
        final MoleculeComponent molc = newmc;
        PropertyChangeListener pcl = new PropertyChangeListener(){
            MoleculeComponent mc = null;
            boolean first = true;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equalsIgnoreCase("mol")) {
                    try {
                        if (this.first) {
                            this.mc = molc;
                            this.first = false;
                        }
                        if (this.mc != null && JMSpaceTreePopup.this.graphicScene.containsComponent(this.mc)) {
                            JMSpaceTreePopup.this.graphicScene.removeComponent(this.mc);
                            JMSpaceTreePopup.this.graphicScene.getEventHandler().updateSelectionBar(this.mc);
                        }
                        this.mc = JMSpaceTreePopup.this.graphicScene.getEventHandler().setMoleculeWithoutChange(sp.getMol().cloneMolecule(), false);
                        JMSpaceTreePopup.this.graphicScene.refresh();
                    }
                    catch (Exception e) {
                        JMSpaceTreePopup.this.graphicScene.getEventHandler().handleMyErrors(e, "Error");
                    }
                }
            }
        };
        sp.addPropertyChangeListener(pcl);
        frame.getContentPane().add(sp);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    private boolean save(File f, String moleculeStr) {
        StringBuffer sb = new StringBuffer();
        if (moleculeStr != null) {
            sb.append(moleculeStr);
        }
        return this.simpleWrite(f, sb.toString(), false);
    }

    private boolean simpleWrite(File f, String molstr, boolean append) {
        String eol = System.getProperty("line.separator");
        try {
            int eolindex;
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(f.getPath(), append), "UTF-8");
            int index = 0;
            do {
                if ((eolindex = molstr.indexOf(10, index)) == -1) {
                    eolindex = molstr.length();
                }
                fw.write(molstr.substring(index, eolindex));
                fw.write(eol);
            } while ((index = eolindex + 1) < molstr.length());
            fw.close();
        }
        catch (IOException ex) {
            this.graphicScene.getEventHandler().handleMyErrors(ex, "Error");
            return false;
        }
        return true;
    }

    private int confirmOverwrite(File f) {
        if (f.exists()) {
            int mode = JOptionPane.showConfirmDialog(this.graphicScene, "File " + f.getName() + " exists. Overwrite?", "File exists", 0, 2);
            return mode == 0 ? 0 : 1;
        }
        return 2;
    }
}

