/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.core.util.PDBResidues;
import chemaxon.marvin.space.MSpaceEasy;
import chemaxon.marvin.space.gui.MSpaceFrame;
import chemaxon.util.ArgumentException;
import chemaxon.util.CLQ;
import chemaxon.util.FindCodeBase;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;

public class MSpace
extends MSpaceFrame {
    protected MSpaceEasy mspace;
    protected static CLQ cmdLine = null;
    protected static boolean animation = false;
    protected static boolean idleRotation = false;
    protected static final String HELP_MESSAGE = "MarvinSpace 3D Molecular Structure Viewer, (C) ChemAxon Ltd., 2007-2008\nUsage: mspace [options] [files...] [smiles...]\nOptions:\n  -h, --help                   this help message\n  -v, --verbose                verbose mode\n  -r, --rows <rowcount>        number of rows in multiple cell display\n  -c, --columns <colcount>     number of columns in multiple cell display\n  -n, --nMols <molcount>       maximum number of molecules to display (default: 1000)\n  -q, --quality ( L[ow], M[ed], H[igh] )\n                       display quality (default: Med)\n  -                            read stuctures from standard input\n";
    protected static final int MAX_COLUMN_COUNT = 5;
    protected static final int MAX_ROW_COUNT = 4;
    protected static final int MAX_MOL_COUNT = 1000;
    static boolean verbose = false;
    static boolean skipinstall = false;
    protected static int rowCount = 1;
    protected static int colCount = 1;
    protected static boolean multicell = false;
    protected static boolean singleCell = false;
    protected static int maxMolCount = 1;
    protected static String displayQuality = "Medium";
    protected static Properties sceneProperties = new Properties();
    protected static boolean readStdin = false;
    protected static ArrayList infileName = new ArrayList();
    protected static ArrayList moleculesFromStIn = new ArrayList();
    protected static boolean processLogFile = false;
    protected static boolean processLogFileRepeat = false;
    protected static InputStream logIs = null;

    public static void main(String[] args) {
        cmdLine = new CLQ(args, null);
        MSpace.processCmdLine();
        if (verbose) {
            System.setProperty("jogl.verbose", "true");
        }
        PDBResidues.readPartialCharges();
        new MSpace();
    }

    public MSpace() {
        MSpaceEasy.setIconImage(this);
        this.setTitle("MarvinSpace " + version);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        screenSize.setSize(0.75 * (double)screenSize.width, 0.75 * (double)screenSize.height);
        this.setSize(screenSize);
        this.setLocationRelativeTo(null);
        try {
            this.mspace = new MSpaceEasy(rowCount, colCount, !skipinstall, verbose, null);
        }
        catch (Exception e) {
            return;
        }
        this.mspace.addSelectionPanelAndProgressBar(this);
        this.mspace.addMenuBar(this);
        this.mspace.addToolBar(this);
        this.mspace.addPopupMenu();
        this.pack();
        this.setSize(screenSize);
        this.setVisible(true);
        try {
            this.mspace.processArguments(maxMolCount, infileName, moleculesFromStIn, readStdin, multicell, singleCell, sceneProperties, displayQuality);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (idleRotation) {
            this.mspace.getEventHandler().idleRotation(true);
        }
        if (processLogFile) {
            this.mspace.getEventHandler().processLog(logIs, processLogFileRepeat);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MSpace.this.setVisible(false);
                MSpace.this.dispose();
            }
        });
    }

    protected static void processCmdLine() {
        try {
            CLQ.Parameter qParam;
            CLQ.Parameter nParam;
            CLQ.Parameter rParam;
            CLQ.Parameter cParam;
            if (cmdLine.lookup("-h", "--help", "", 1, false, false) != null) {
                System.out.println(HELP_MESSAGE);
                System.exit(-1);
            }
            boolean bl = verbose = cmdLine.lookup("-v", "--verbose", "", 1, false, false) != null;
            if (!skipinstall) {
                skipinstall = cmdLine.lookup("-s", "--skipinstall", "", 1, false, false) != null;
            }
            animation = cmdLine.lookup("-a", "--animate", "", 1, false, false) != null;
            idleRotation = cmdLine.lookup("-i", "--idleRotation", "", 1, false, false) != null;
            CLQ.Parameter lParam = cmdLine.lookup("-lr", "--log", "", 2, false, false);
            if (lParam == null) {
                lParam = cmdLine.lookup("-l", "--log", "", 2, false, false);
            } else {
                processLogFileRepeat = true;
            }
            if (lParam != null) {
                String logFileName = lParam.getString();
                if (MSpaceEasy.isURL(logFileName)) {
                    try {
                        URL url = new URL(logFileName);
                        URLConnection conn = url.openConnection();
                        logIs = conn.getInputStream();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    File logFile = new File(logFileName);
                    if (!logFile.exists()) {
                        logFile = new File(FindCodeBase.getCodeBaseDir() + File.separator + logFileName);
                    }
                    try {
                        logIs = new FileInputStream(logFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                boolean bl2 = processLogFile = logIs != null;
                if (!processLogFile) {
                    System.out.println("Invalid Log Param: " + logFileName);
                } else {
                    System.out.println("Log Param Found: " + logFileName);
                }
            }
            int n = colCount = (cParam = cmdLine.lookup("-c", "--columns", "", 2, false, false)) != null ? cParam.getInt() : 1;
            if (colCount > 5) {
                colCount = 5;
            }
            int n2 = rowCount = (rParam = cmdLine.lookup("-r", "--rows", "", 2, false, false)) != null ? rParam.getInt() : 1;
            if (rowCount > 4) {
                rowCount = 4;
            }
            int n3 = maxMolCount = (nParam = cmdLine.lookup("-n", "--nMols", "", 2, false, false)) != null ? nParam.getInt() : 1000;
            if (maxMolCount > 1000) {
                maxMolCount = 1000;
            }
            multicell = cmdLine.lookup("--multiCell", "", 1, false, false) != null;
            boolean bl3 = singleCell = cmdLine.lookup("--singleCell", "", 1, false, false) != null;
            if (rParam != null || cParam != null) {
                multicell = true;
                if (maxMolCount > rowCount * colCount) {
                    maxMolCount = rowCount * colCount;
                }
            }
            if ((qParam = cmdLine.lookup("-q", "--quality", "", 2, false, false)) != null) {
                String q = qParam.getString();
                if (q.equalsIgnoreCase("low") || q.equalsIgnoreCase("l")) {
                    displayQuality = "Low";
                } else if (q.equalsIgnoreCase("med") || q.equalsIgnoreCase("m")) {
                    displayQuality = "Medium";
                } else if (q.equalsIgnoreCase("high") || q.equalsIgnoreCase("h")) {
                    displayQuality = "High";
                } else {
                    System.err.println("Invalid display quality: " + q + ", using default value.");
                }
            }
            CLQ.Parameter pParam = cmdLine.lookup("-p", "", 3, false, false);
            while (pParam != null) {
                sceneProperties.setProperty(pParam.getString(0), pParam.getString(1));
                pParam = cmdLine.lookup("-p", "", 3, false, false);
            }
            readStdin = cmdLine.lookup("-", "", 1, false, false) != null;
            String unused = cmdLine.notUsed();
            while (unused != null) {
                File f = new File(unused);
                if (f.exists() || MSpaceEasy.isURL(unused)) {
                    infileName.add(unused);
                } else {
                    moleculesFromStIn.add(unused);
                }
                unused = cmdLine.notUsed();
            }
        }
        catch (ArgumentException e) {
            e.printStackTrace();
        }
    }
}

