/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.marvin.space.gui.MSpaceDialog;
import chemaxon.struc.MacroMolecule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class PDBInfo
extends MSpaceDialog {
    private static final String NL = System.getProperty("line.separator");
    JButton close;
    MacroMolecule mm = null;
    Document doc = null;
    SimpleAttributeSet[] attrs = null;

    public PDBInfo(Component parent, MacroMolecule mm) throws Exception {
        super((Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent), "Macromolecule Information");
        this.mm = mm;
        this.createGUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void insert(String s) throws Exception {
        this.doc.insertString(this.doc.getLength(), s, this.attrs[0]);
    }

    private void insertBold(String s) throws Exception {
        this.doc.insertString(this.doc.getLength(), s, this.attrs[1]);
    }

    private void createGUI() throws Exception {
        JLabel name = new JLabel(this.mm.getName());
        name.setFont(name.getFont().deriveFont(1));
        name.setHorizontalAlignment(0);
        JTextPane textPane = new JTextPane();
        StyledDocument styledDoc = textPane.getStyledDocument();
        if (!(styledDoc instanceof AbstractDocument)) {
            throw new Exception("Error creating abstract document");
        }
        this.doc = styledDoc;
        this.attrs = new SimpleAttributeSet[2];
        this.attrs[0] = new SimpleAttributeSet();
        this.attrs[1] = new SimpleAttributeSet(this.attrs[0]);
        StyleConstants.setBold(this.attrs[1], true);
        this.insertBold("Header: ");
        this.insert(this.mm.getHeader() + NL);
        this.insertBold("Title: ");
        this.insert(this.mm.getTitle() + NL);
        this.insertBold("Source: ");
        this.insert(this.mm.getSource() + NL);
        this.insertBold("Keywords: ");
        this.insert(this.mm.getKeywords() + NL);
        this.insertBold("Exp. data: ");
        this.insert(this.mm.getExpData() + NL);
        this.insertBold("Author: ");
        this.insert(this.mm.getAuthor() + NL);
        MacroMolecule.ComponentIterator i = this.mm.getIterator();
        while (i.hasNext()) {
            MacroMolecule.Component c = i.next();
            this.insertBold(c.getName());
            if (c instanceof MacroMolecule.Polymer) {
                this.insert(": " + c.getAtomCount() + " atom(s)");
                if (c.getBondIterator(true).getCount() > 0) {
                    this.insert(", " + c.getBondIterator(true).getCount() + " bond(s)");
                }
                if (c.getHydrogenCount() > 0) {
                    this.insert(", " + c.getHydrogenCount() + " hydrogens");
                }
                MacroMolecule.Polymer poly = (MacroMolecule.Polymer)c;
                this.insert(NL + "   " + poly.getResidueCount() + " residues, ");
                this.insert(poly.getSequenceResidueCount() + " sequence residues");
                if (c instanceof MacroMolecule.Protein) {
                    MacroMolecule.Protein p = (MacroMolecule.Protein)c;
                    MacroMolecule.Protein.HelixIterator hi = p.getHelixIterator();
                    int hii = 0;
                    while (hi.hasNext()) {
                        hi.next();
                        ++hii;
                    }
                    this.insert(NL + "   " + hii + " helices, ");
                    MacroMolecule.Protein.SheetIterator si = p.getSheetIterator();
                    int sii = 0;
                    while (si.hasNext()) {
                        si.next();
                        ++sii;
                    }
                    this.insert(sii + " sheets, ");
                    MacroMolecule.Protein.TurnIterator ti = p.getTurnIterator();
                    int tii = 0;
                    while (ti.hasNext()) {
                        ti.next();
                        ++tii;
                    }
                    this.insert(tii + " turns");
                }
            } else if (c instanceof MacroMolecule.HeteroComponent) {
                MacroMolecule.HeteroComponent hc = (MacroMolecule.HeteroComponent)c;
                if (hc.isLigand()) {
                    this.insert(": " + c.getAtomCount() + " atom(s)");
                    if (c.getBondIterator(true).getCount() > 0) {
                        this.insert(", " + c.getBondIterator(true).getCount() + " bond(s)");
                    }
                    if (c.getHydrogenCount() > 0) {
                        this.insert(", " + c.getHydrogenCount() + " hydrogens");
                    }
                } else if (hc instanceof MacroMolecule.Water) {
                    this.insert(": " + c.getAtomCount() + " molecule(s)");
                }
            }
            this.insert(NL);
        }
        textPane.setCaretPosition(0);
        textPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textPane);
        scrollPane.setPreferredSize(new Dimension(500, 400));
        this.close = new JButton("Close");
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PDBInfo.this.setVisible(false);
                PDBInfo.this.dispose();
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(name);
        mainPanel.add(scrollPane);
        mainPanel.add(this.close);
        this.setContentPane(mainPanel);
    }
}

