/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gui;

import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.space.MSpaceEasy;
import chemaxon.marvin.space.MSpacePluginDisplay;
import chemaxon.marvin.util.text.EncodingUtil;
import chemaxon.struc.Molecule;
import chemaxon.util.StringUtil;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JApplet;

public class PluginApplet
extends JApplet {
    Molecule[] mols = null;
    int precision = -1;
    String palette = "Blue to Red";
    ArrayList resultValues = null;
    String[] propertyTexts = null;
    MSpaceEasy mspace;

    public PluginApplet() {
        try {
            System.setProperty("jogl.verbose", "true");
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getParameter(String name) {
        String value = super.getParameter(name);
        return value != null ? EncodingUtil.decodeJs(value) : null;
    }

    public void setMolecule(String mol) {
        try {
            Molecule m;
            ArrayList<Molecule> molecules = new ArrayList<Molecule>();
            MolInputStream ms = MSpaceEasy.getMolInputStream(mol);
            MolImporter mi = ms.getFormat().equals("cube") ? new MolImporter(ms, "f2.2,V") : new MolImporter(ms);
            while ((m = mi.read()) != null) {
                molecules.add(m);
            }
            Molecule[] mols = new Molecule[molecules.size()];
            molecules.toArray(mols);
            this.putToMoleculeArray(mols);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void putToMoleculeArray(Molecule[] mols) {
        if (mols == null || mols.length == 0) {
            return;
        }
        if (this.mols == null) {
            this.mols = new Molecule[mols.length];
            System.arraycopy(mols, 0, this.mols, 0, mols.length);
        } else {
            Molecule[] newMols = new Molecule[mols.length + this.mols.length];
            System.arraycopy(this.mols, 0, newMols, 0, this.mols.length);
            System.arraycopy(mols, 0, newMols, this.mols.length, mols.length);
        }
    }

    public void setMolecules(String mols, String separator) {
        String[] molecules = StringUtil.split(mols, separator);
        for (int i = 0; i < molecules.length; ++i) {
            this.setMolecule(molecules[i]);
        }
    }

    public void setResultValue(String resultValue) {
        if (this.resultValues == null) {
            this.resultValues = new ArrayList();
        }
        String[] values = StringUtil.split(resultValue, ",");
        ArrayList<Float> valueList = new ArrayList<Float>();
        for (int i = 0; i < values.length; ++i) {
            valueList.add(Float.valueOf(values[i]));
        }
        this.resultValues.add(valueList);
    }

    public void setResultValues(String resultValues) {
        this.resultValues = new ArrayList();
        String[] values = StringUtil.split(resultValues, ";");
        for (int i = 0; i < values.length; ++i) {
            this.setResultValue(values[i]);
        }
    }

    public void setPropertyText(String pt) {
        this.propertyTexts = new String[1];
        this.propertyTexts[0] = pt;
    }

    public void setPropertyTexts(String pt) {
        this.propertyTexts = StringUtil.split(pt, ";");
    }

    public void setPrecision(String p) {
        this.precision = Integer.valueOf(p);
    }

    public void setPalette(String palette) {
        this.palette = palette;
    }

    @Override
    public void init() {
        try {
            String palette;
            this.mspace = new MSpaceEasy(true, false, this.getCodeBase());
            String mol = this.getParameter("molecule");
            if (mol != null) {
                String propertyText;
                this.setMolecule(mol);
                String resultValue = this.getParameter("resultValue");
                if (resultValue != null) {
                    this.setResultValue(resultValue);
                }
                if ((propertyText = this.getParameter("propertyText")) != null) {
                    this.setPropertyText(propertyText);
                }
            } else {
                String propertyTexts;
                String resultValues;
                String mols = this.getParameter("molecules");
                if (mols != null) {
                    String molSeparator = this.getParameter("molSeparator");
                    this.setMolecules(mols, molSeparator);
                }
                if ((resultValues = this.getParameter("resultValues")) != null) {
                    this.setResultValues(resultValues);
                }
                if ((propertyTexts = this.getParameter("propertyTexts")) != null) {
                    this.setPropertyTexts(propertyTexts);
                }
            }
            String precision = this.getParameter("precision");
            if (precision != null) {
                this.setPrecision(precision);
            }
            if ((palette = this.getParameter("palette")) != null) {
                this.setPalette(palette);
            }
            this.create();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void create() {
        try {
            if (this.mols != null) {
                MSpacePluginDisplay mspd = new MSpacePluginDisplay(true, this.getCodeBase());
                mspd.callback("setMolecules", this.mols);
                mspd.callback("setResultValues", this.resultValues);
                mspd.callback("setPrecision", new Integer(this.precision));
                mspd.callback("setPalette", this.palette);
                mspd.callback("setPropertyTexts", this.propertyTexts);
                this.setContentPane(mspd.getMSpaceDialog(Color.black).getContentPane());
            } else {
                MSpaceEasy mspace = new MSpaceEasy(true, false, this.getCodeBase());
                mspace.addCanvas(this.getContentPane());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

