/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.monitor;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.monitor.MeasurementMonitor;

public class AngleMonitor
extends MeasurementMonitor {
    private static final int ITEM_COUNT = 3;

    public AngleMonitor() {
        this.measure = "\u00b0";
    }

    @Override
    public double measurement() {
        if (this.measurement != -1.0) {
            return this.measurement;
        }
        this.measurement = GeomCalc.angle(this.selectedItemCoordinates[0], this.selectedItemCoordinates[1], this.selectedItemCoordinates[2]);
        return this.measurement;
    }

    @Override
    public int maximumItemCount() {
        return 3;
    }

    @Override
    public void getCoordinates(float[] c) {
        if (this.isFull()) {
            this.selectedItems[1].getCoordinates(c);
        }
    }

    @Override
    public void draw() {
        if (!this.visible || this.hasInvisibleItem()) {
            return;
        }
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        this.gl.glEnable(2852);
        this.gl.glLineStipple(1, (short)-3856);
        this.gl.glLineWidth(4.0f);
        this.gl.glColor3bv(Colors.black, 0);
        this.gl.glBegin(3);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[0]), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[1]), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[2]), 0);
        this.gl.glEnd();
        this.gl.glDisable(2852);
        this.drawCircle(this.selectedItemCoordinates[0], this.selectedItemCoordinates[1], this.selectedItemCoordinates[2]);
        this.gl.glEnable(2852);
        this.gl.glLineWidth(2.0f);
        this.gl.glColor3bv(this.getMonitorColor(), 0);
        this.gl.glBegin(3);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[0]), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[1]), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[2]), 0);
        this.gl.glEnd();
        this.gl.glDisable(2852);
        this.drawCircle(this.selectedItemCoordinates[0], this.selectedItemCoordinates[1], this.selectedItemCoordinates[2]);
        this.gl.glDisable(3042);
        this.gl.glEnable(2896);
    }

    private void drawCircle(int p1, int p2, int p3) {
        int a = GeomCalc.sub(p1, p2);
        int b = GeomCalc.sub(p3, p2);
        GeomCalc.normalize(a);
        GeomCalc.normalize(b);
        int n = GeomCalc.cross(a, b);
        GeomCalc.normalize(n);
        int c = GeomCalc.cross(n, a);
        GeomCalc.normalize(c);
        this.gl.glPushMatrix();
        this.gl.glTranslated((double)GeomCalc.getX(p2), (double)GeomCalc.getY(p2), (double)GeomCalc.getZ(p2));
        int r = GeomCalc.newVector();
        int circlePoints = 20;
        double angle = GeomCalc.angleRadian(a, b);
        this.gl.glBegin(3);
        for (int i = 0; i < circlePoints + 1; ++i) {
            double anglei = angle * (double)i / (double)circlePoints;
            GeomCalc.setVector(r, 0.0f, 0.0f, 0.0f);
            int sa = GeomCalc.mult(a, (float)Math.cos(anglei));
            GeomCalc.increase(r, sa);
            int sb = GeomCalc.mult(c, (float)Math.sin(anglei));
            GeomCalc.increase(r, sb);
            GeomCalc.deleteVector(sa);
            GeomCalc.deleteVector(sb);
            if (angle > 1.5707963267948966) {
                GeomCalc.scale(r, 0.7f);
            }
            this.gl.glVertex3fv(GeomCalc.getVector(r), 0);
        }
        this.gl.glEnd();
        this.gl.glPopMatrix();
        GeomCalc.deleteVector(a);
        GeomCalc.deleteVector(b);
        GeomCalc.deleteVector(n);
        GeomCalc.deleteVector(c);
        GeomCalc.deleteVector(r);
    }
}

