/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.monitor;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.monitor.DihedralControl;
import chemaxon.marvin.space.monitor.MeasurementMonitor;

public class DihedralMonitor
extends MeasurementMonitor {
    private static final double DEFAULT_RADIUS = 0.5;
    private static final int ITEM_COUNT = 4;
    protected DihedralControl control = null;
    private MoleculeComponent mc = null;
    private double radius = 0.5;

    public DihedralMonitor() {
        this.measure = "\u00b0";
    }

    @Override
    public int maximumItemCount() {
        return 4;
    }

    @Override
    public void getCoordinates(float[] c) {
        if (this.isFull()) {
            int h = GeomCalc.half(this.selectedItemCoordinates[1], this.selectedItemCoordinates[2]);
            c[0] = GeomCalc.getX(h);
            c[1] = GeomCalc.getY(h);
            c[2] = GeomCalc.getZ(h);
            GeomCalc.deleteVector(h);
        }
    }

    @Override
    public void select() {
        if (!this.active) {
            this.active = true;
            this.setControl(new DihedralControl(this));
        } else if (this.control != null) {
            this.control.flip();
        }
    }

    @Override
    public void unSelect() {
        super.unSelect();
        this.control = null;
    }

    public GraphicComponent getComponent() {
        return this.mc;
    }

    public void setControl(DihedralControl control) {
        this.control = control;
        if (this.correctElements()) {
            this.control.setComponent(this.getComponent());
            this.control.setAtoms(this.selectedItems[1].getElementIndex(), this.selectedItems[2].getElementIndex());
        } else {
            this.control = null;
        }
    }

    public void control(int v) {
        if (this.control != null) {
            this.control.control(v);
        }
    }

    @Override
    public double measurement() {
        if (this.measurement != -1.0) {
            return this.measurement;
        }
        this.measurement = GeomCalc.dihedral(this.selectedItemCoordinates[0], this.selectedItemCoordinates[1], this.selectedItemCoordinates[2], this.selectedItemCoordinates[3]);
        return this.measurement;
    }

    @Override
    public void draw() {
        if (!this.visible || this.hasInvisibleItem()) {
            return;
        }
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        int p1 = GeomCalc.sub(this.selectedItemCoordinates[0], this.selectedItemCoordinates[1]);
        GeomCalc.scale(p1, 0.5f);
        int p2 = GeomCalc.sub(this.selectedItemCoordinates[2], this.selectedItemCoordinates[1]);
        GeomCalc.scale(p2, 0.5f);
        int a = GeomCalc.add(p1, p2);
        GeomCalc.increase(a, this.selectedItemCoordinates[1]);
        int p3 = GeomCalc.sub(this.selectedItemCoordinates[1], this.selectedItemCoordinates[2]);
        GeomCalc.scale(p3, 0.5f);
        int p4 = GeomCalc.sub(this.selectedItemCoordinates[3], this.selectedItemCoordinates[2]);
        GeomCalc.scale(p4, 0.5f);
        int b = GeomCalc.add(p3, p4);
        GeomCalc.increase(b, this.selectedItemCoordinates[2]);
        GeomCalc.increase(p1, this.selectedItemCoordinates[1]);
        GeomCalc.increase(p2, this.selectedItemCoordinates[1]);
        GeomCalc.increase(p4, this.selectedItemCoordinates[2]);
        this.gl.glEnable(2852);
        this.gl.glLineStipple(1, (short)-3856);
        this.gl.glLineWidth(4.0f);
        this.gl.glColor3bv(Colors.black, 0);
        this.gl.glBegin(3);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[0]), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[1]), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[2]), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[3]), 0);
        this.gl.glEnd();
        this.gl.glLineWidth(2.0f);
        this.gl.glColor3bv(this.getMonitorColor(), 0);
        this.gl.glBegin(3);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[0]), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[1]), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[2]), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[3]), 0);
        this.gl.glEnd();
        this.gl.glDisable(2852);
        this.gl.glLineWidth(4.0f);
        this.gl.glColor3bv(Colors.black, 0);
        this.gl.glBegin(3);
        this.gl.glVertex3fv(GeomCalc.getVector(p1), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(a), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(p2), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(b), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(p4), 0);
        this.gl.glEnd();
        this.gl.glLineWidth(2.0f);
        this.gl.glColor3bv(this.getMonitorColor(), 0);
        this.gl.glBegin(3);
        this.gl.glVertex3fv(GeomCalc.getVector(p1), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(a), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(p2), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(b), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(p4), 0);
        this.gl.glEnd();
        GeomCalc.deleteVector(p1);
        GeomCalc.deleteVector(p2);
        GeomCalc.deleteVector(p3);
        GeomCalc.deleteVector(p4);
        GeomCalc.deleteVector(a);
        GeomCalc.deleteVector(b);
        this.gl.glLineWidth(4.0f);
        this.gl.glColor3bv(Colors.black, 0);
        this.drawCircle(this.selectedItemCoordinates[0], this.selectedItemCoordinates[1], this.selectedItemCoordinates[2], this.selectedItemCoordinates[3]);
        this.gl.glLineWidth(2.0f);
        this.gl.glColor3bv(this.getMonitorColor(), 0);
        this.drawCircle(this.selectedItemCoordinates[0], this.selectedItemCoordinates[1], this.selectedItemCoordinates[2], this.selectedItemCoordinates[3]);
        this.gl.glDisable(3042);
        this.gl.glEnable(2896);
    }

    @Override
    protected byte[] getMonitorColor() {
        if (this.control != null) {
            return this.control.getColor();
        }
        return super.getMonitorColor();
    }

    private void drawCircle(int p1, int p2, int p3, int p4) {
        int n = GeomCalc.sub(p3, p2);
        GeomCalc.normalize(n);
        int c = GeomCalc.half(p2, p3);
        this.gl.glPushMatrix();
        if (this.control == null) {
            this.gl.glTranslated((double)GeomCalc.getX(c), (double)GeomCalc.getY(c), (double)GeomCalc.getZ(c));
        } else {
            int d = this.control.flipped ? GeomCalc.sub(p3, c) : GeomCalc.sub(p2, c);
            GeomCalc.scale(d, 0.33f);
            GeomCalc.increase(d, c);
            this.gl.glTranslated((double)GeomCalc.getX(d), (double)GeomCalc.getY(d), (double)GeomCalc.getZ(d));
            GeomCalc.deleteVector(d);
        }
        double angle = Math.acos(GeomCalc.getZ(n)) * 180.0 / Math.PI;
        this.gl.glRotated(angle, (double)(-GeomCalc.getY(n)), (double)GeomCalc.getX(n), 0.0);
        int circlePoints = 40;
        this.gl.glBegin(3);
        for (int i = 0; i < circlePoints + 1; ++i) {
            double anglei = 4.71238898038469 * (double)i / (double)circlePoints;
            this.gl.glVertex3d(this.radius * Math.cos(anglei), this.radius * Math.sin(anglei), 0.0);
        }
        this.gl.glEnd();
        if (this.measurement < 0.0) {
            this.gl.glBegin(3);
            this.gl.glVertex3d(-0.07, -(this.radius - 0.07), 0.0);
            this.gl.glVertex3d(0.0, -this.radius, 0.0);
            this.gl.glVertex3d(-0.1, -(this.radius + 0.05), 0.0);
            this.gl.glEnd();
        } else {
            this.gl.glBegin(3);
            this.gl.glVertex3d(this.radius - 0.07, 0.07, 0.0);
            this.gl.glVertex3d(this.radius, 0.0, 0.0);
            this.gl.glVertex3d(this.radius + 0.05, 0.1, 0.0);
            this.gl.glEnd();
        }
        this.gl.glPopMatrix();
        GeomCalc.deleteVector(n);
        GeomCalc.deleteVector(c);
    }

    private void drawArc(int p0, int p1, int p2) {
        this.gl.glPushMatrix();
        this.glTransformXEToV(p1, p2);
        double arc = Math.PI * 2;
        int circlePoints = 40;
        this.gl.glBegin(3);
        for (int i = 0; i < circlePoints + 1; ++i) {
            double anglei = arc * (double)i / (double)circlePoints;
            this.gl.glVertex3d(this.radius * Math.cos(anglei), this.radius * Math.sin(anglei), 0.0);
        }
        this.gl.glEnd();
        this.gl.glPopMatrix();
    }

    private void glTransformXEToV(int n1, int n2) {
        int directionVector = GeomCalc.sub(n2, n1);
        GeomCalc.normalize(directionVector);
        double angle = Math.acos(GeomCalc.getX(directionVector)) * 180.0 / Math.PI;
        this.gl.glTranslated((double)GeomCalc.getX(n1), (double)GeomCalc.getY(n1), (double)GeomCalc.getZ(n1));
        this.gl.glRotated(angle, 0.0, (double)(-GeomCalc.getZ(directionVector)), (double)GeomCalc.getY(directionVector));
        GeomCalc.deleteVector(directionVector);
    }

    private boolean correctElements() {
        return this.selectedItems[0].getComponent() == this.selectedItems[1].getComponent() && this.selectedItems[0].getComponent() == this.selectedItems[2].getComponent() && this.selectedItems[0].getComponent() == this.selectedItems[3].getComponent() && this.correctType(this.selectedItems[0]);
    }

    private boolean correctType(ComponentElement item) {
        if (item.getComponent() instanceof MoleculeComponent) {
            this.mc = (MoleculeComponent)item.getComponent();
            return true;
        }
        if (item.getComponent() instanceof MacroMoleculeComponent) {
            MacroMoleculeComponent mmc = (MacroMoleculeComponent)item.getComponent();
            MacroMoleculeComponent.MoleculeVisualizer mmv = mmc.getComponent(item.getComponentPartId());
            if (mmv instanceof MoleculeComponent) {
                this.mc = (MoleculeComponent)mmv;
                return true;
            }
            return false;
        }
        return false;
    }
}

