/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.render;

import chemaxon.marvin.space.render.Renderer;
import javax.media.opengl.GL;

public class Cylinder
extends Renderer {
    private double baseRadius = 1.0;
    private double topRadius = 1.0;
    private double height = 1.0;
    private int slices = 8;
    private int stacks = 1;
    private int vertexCount = 0;

    public Cylinder() {
    }

    public Cylinder(double radius, double height, int slices, int stacks) {
        this.baseRadius = radius;
        this.topRadius = radius;
        this.height = height;
        this.slices = slices;
        this.stacks = stacks;
    }

    public Cylinder(double baseRadius, double topRadius, double height, int slices) {
        this.baseRadius = baseRadius;
        this.topRadius = topRadius;
        this.height = height;
        this.slices = slices;
    }

    public void draw(GL gl, byte[] c1, byte[] c2) {
        gl.glVertexPointer(3, 5126, 0, this.vertices.position(0));
        gl.glNormalPointer(5126, 0, this.normals.position(0));
        gl.glBegin(this.getElementType());
        for (int i = 0; i < this.getVertexCount(); ++i) {
            if ((double)i / 2.0 == (double)(i / 2)) {
                gl.glColor3bv(c1, 0);
            } else {
                gl.glColor3bv(c2, 0);
            }
            gl.glArrayElement(i);
        }
        gl.glEnd();
    }

    public void create() {
        if (this.created) {
            return;
        }
        this.directDraw = true;
        this.allocate();
        double da = Math.PI * 2 / (double)this.slices;
        double dr = (this.topRadius - this.baseRadius) / (double)this.stacks;
        double dz = this.height / (double)this.stacks;
        double nz = (float)((this.baseRadius - this.topRadius) / this.height);
        double z = 0.0;
        double r = this.baseRadius;
        for (int j = 0; j < this.stacks; ++j) {
            for (int i = 0; i <= this.slices; ++i) {
                double y;
                double x;
                if (i == this.slices) {
                    x = 0.0;
                    y = 1.0;
                } else {
                    x = Math.sin((double)i * da);
                    y = Math.cos((double)i * da);
                }
                this.putNormal((float)x, (float)y, (float)nz);
                this.putVertex((float)(x * r), (float)(y * r), (float)z);
                this.putNormal((float)x, (float)y, (float)nz);
                this.putVertex((float)(x * (r + dr)), (float)(y * (r + dr)), (float)(z + dz));
            }
            r += dr;
            z += dz;
        }
        this.created = true;
    }

    private void putVertex(float x, float y, float z) {
        this.vertices.put(x);
        this.vertices.put(y);
        this.vertices.put(z);
        ++this.vertexCount;
    }

    private void putNormal(float x, float y, float z) {
        this.normals.put(x);
        this.normals.put(y);
        this.normals.put(z);
    }

    @Override
    public int getVertexCount() {
        return 2 * this.stacks * (this.slices + 1);
    }

    @Override
    public int getTriangleCount() {
        return 2 * this.stacks * this.slices;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double h) {
        this.height = h;
    }

    public double getRadius() {
        return this.baseRadius;
    }

    public void setRadius(double radius) {
        this.baseRadius = radius;
        this.topRadius = radius;
    }

    @Override
    public int getElementType() {
        return 5;
    }
}

