/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.render;

import chemaxon.marvin.space.render.Sphere;
import chemaxon.marvin.space.render.UniformSphere;
import java.util.HashMap;

public class Spheres {
    HashMap spheres = new HashMap();
    SphereKey sk = new SphereKey();

    public Sphere getSphere(int precision, double radius) {
        this.sk.setPrecision(precision);
        this.sk.setRadius(radius);
        Sphere sp = (Sphere)this.spheres.get(this.sk);
        if (sp != null) {
            return sp;
        }
        sp = new Sphere(precision);
        sp.setRadius(radius);
        sp.create();
        this.spheres.put(new SphereKey(precision, radius), sp);
        return sp;
    }

    public UniformSphere getUniformSphere(int precision, float radius) {
        this.sk.setPrecision(precision);
        this.sk.setRadius(radius);
        UniformSphere sp = (UniformSphere)this.spheres.get(this.sk);
        if (sp != null) {
            return sp;
        }
        sp = new UniformSphere(precision);
        sp.setRadius(radius);
        sp.create(true);
        this.spheres.put(new SphereKey(precision, radius), sp);
        return sp;
    }

    public class SphereKey {
        int precision;
        double radius;

        SphereKey() {
        }

        SphereKey(int precision, double radius) {
            this.precision = precision;
            this.radius = radius;
        }

        public int hashCode() {
            return this.precision + (int)(100.0 * this.radius);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SphereKey)) {
                return false;
            }
            SphereKey sk = (SphereKey)obj;
            return sk.radius == this.radius && sk.precision == this.precision;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public void setRadius(double radius) {
            this.radius = radius;
        }
    }
}

