/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.util;

import chemaxon.marvin.modules.mprop.VolumetricData;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CharmmGridImport {
    public static final int DOUBLE_BYTE_COUNT = 8;
    public static final int FLOAT_BYTE_COUNT = 4;
    public static final int INTEGER_BYTE_COUNT = 4;
    private static String integerS = "integer";
    private static String longS = "long";
    private static String floatS = "float";
    private static String doubleS = "double";
    byte[] dataRecord4 = new byte[4];
    byte[] dataRecord8 = new byte[8];
    ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    DataInputStream is;
    Object progressBar;
    Method progressMethod;

    public CharmmGridImport(InputStream is) {
        this.is = new DataInputStream(is);
    }

    public int getByteCount() throws IOException {
        int i = 0;
        while (this.is.read() != -1) {
            ++i;
        }
        return i;
    }

    public void setProgressBar(Object progressBar) {
        try {
            this.progressMethod = progressBar.getClass().getMethod("setProgress", Integer.TYPE);
            this.progressBar = progressBar;
        }
        catch (Exception e) {
            this.progressBar = null;
        }
    }

    private void setProgress(int i) {
        try {
            if (this.progressBar != null) {
                this.progressMethod.invoke(this.progressBar, new Integer(i));
            }
        }
        catch (Exception e) {
            this.progressBar = null;
        }
    }

    public void readVolumetricData(VolumetricData vdata) throws IOException {
        int recordLength = this.readInteger();
        if (recordLength != 44) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
        }
        vdata.size[2] = this.readInteger();
        System.out.println("NCLX=" + vdata.size[2]);
        vdata.size[1] = this.readInteger();
        System.out.println("NCLY=" + vdata.size[1]);
        vdata.size[0] = this.readInteger();
        System.out.println("NCLZ=" + vdata.size[0]);
        double dcel = this.readDouble();
        System.out.println("DCEL=" + dcel);
        vdata.step[0] = (float)dcel;
        vdata.step[1] = (float)dcel;
        vdata.step[2] = (float)dcel;
        double centerx = this.readDouble();
        vdata.origo[0] = (float)(centerx - dcel * (double)(vdata.size[2] - 1) / 2.0);
        System.out.println("XBCEN=" + centerx);
        double centery = this.readDouble();
        vdata.origo[1] = (float)(centery - dcel * (double)(vdata.size[1] - 1) / 2.0);
        System.out.println("YBCEN=" + centery);
        double centerz = this.readDouble();
        vdata.origo[2] = (float)(centerz - dcel * (double)(vdata.size[0] - 1) / 2.0);
        System.out.println("ZBCEN=" + centerz);
        this.readInteger();
        this.setProgress(5);
        this.readInteger();
        for (int i = 0; i < 48; ++i) {
            if (this.is.read() != -1) continue;
            throw new IOException("End of file reached.");
        }
        this.readInteger();
        this.setProgress(10);
        int gridSize = this.readInteger();
        int rgs = 4 * vdata.size[2] * vdata.size[1] * vdata.size[0];
        if (gridSize != rgs) {
            System.out.println("Warning: grid size mismatch.");
            System.out.println("Required number of bytes is NCLX * NCLY * NCLZ * 4 = " + rgs);
            System.out.println("Number of bytes given: " + gridSize);
        }
        vdata.grid = new float[vdata.size[0]][vdata.size[1]][vdata.size[2]];
        int pl = 90 / vdata.size[2];
        for (int ix = 0; ix < vdata.size[2]; ++ix) {
            for (int iy = 0; iy < vdata.size[1]; ++iy) {
                for (int iz = 0; iz < vdata.size[0]; ++iz) {
                    vdata.grid[iz][iy][ix] = this.readFloat();
                }
            }
            this.setProgress(10 + ix * pl);
        }
        this.readInteger();
        this.setProgress(99);
        this.is.close();
    }

    private void readGrid(VolumetricData vdata, int i, int j, int k, boolean inci, boolean incj, boolean inck) throws IOException {
        if (inci) {
            for (int ii = 0; ii < vdata.size[i]; ++ii) {
                int kk;
                int jj;
                if (incj) {
                    for (jj = 0; jj < vdata.size[j]; ++jj) {
                        if (inck) {
                            for (kk = 0; kk < vdata.size[k]; ++kk) {
                                vdata.grid[ii][jj][kk] = this.readFloat();
                            }
                            continue;
                        }
                        for (kk = vdata.size[k] - 1; kk >= 0; --kk) {
                            vdata.grid[ii][jj][kk] = this.readFloat();
                        }
                    }
                    continue;
                }
                for (jj = vdata.size[j] - 1; jj >= 0; --jj) {
                    if (inck) {
                        for (kk = 0; kk < vdata.size[k]; ++kk) {
                            vdata.grid[ii][jj][kk] = this.readFloat();
                        }
                        continue;
                    }
                    for (kk = vdata.size[k] - 1; kk >= 0; --kk) {
                        vdata.grid[ii][jj][kk] = this.readFloat();
                    }
                }
            }
        } else {
            for (int ii = vdata.size[i] - 1; ii >= 0; --ii) {
                int kk;
                int jj;
                if (incj) {
                    for (jj = 0; jj < vdata.size[j]; ++jj) {
                        if (inck) {
                            for (kk = 0; kk < vdata.size[k]; ++kk) {
                                vdata.grid[ii][jj][kk] = this.readFloat();
                            }
                            continue;
                        }
                        for (kk = vdata.size[k] - 1; kk >= 0; --kk) {
                            vdata.grid[ii][jj][kk] = this.readFloat();
                        }
                    }
                    continue;
                }
                for (jj = vdata.size[j] - 1; jj >= 0; --jj) {
                    if (inck) {
                        for (kk = 0; kk < vdata.size[k]; ++kk) {
                            vdata.grid[ii][jj][kk] = this.readFloat();
                        }
                        continue;
                    }
                    for (kk = vdata.size[k] - 1; kk >= 0; --kk) {
                        vdata.grid[ii][jj][kk] = this.readFloat();
                    }
                }
            }
        }
    }

    private int readInteger() throws IOException {
        for (int i = 0; i < 4; ++i) {
            this.dataRecord4[i] = this.readByte(integerS);
        }
        return ByteBuffer.wrap(this.dataRecord4).order(this.byteOrder).getInt();
    }

    private long readLong() throws IOException {
        for (int i = 0; i < 8; ++i) {
            this.dataRecord8[i] = this.readByte(longS);
        }
        return ByteBuffer.wrap(this.dataRecord8).order(this.byteOrder).getLong();
    }

    private float readFloat() throws IOException {
        for (int i = 0; i < 4; ++i) {
            this.dataRecord4[i] = this.readByte(floatS);
        }
        return ByteBuffer.wrap(this.dataRecord4).order(this.byteOrder).getFloat();
    }

    private double readDouble() throws IOException {
        for (int i = 0; i < 8; ++i) {
            this.dataRecord8[i] = this.readByte(doubleS);
        }
        return ByteBuffer.wrap(this.dataRecord8).order(this.byteOrder).getDouble();
    }

    private byte readByte(String b) throws IOException {
        int i = this.is.read();
        if (i == -1) {
            System.out.println("Error reading " + b);
            return 0;
        }
        return (byte)i;
    }
}

