/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing;

import chemaxon.marvin.swing.MActionComponent;
import chemaxon.marvin.util.SwingUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ActionMenuItem
extends JMenuItem
implements MActionComponent {
    private static final long serialVersionUID = 2939865755214258229L;
    private static int numRefsInActions = 0;
    private transient boolean notInReadObject = true;
    private transient Action action = null;
    private transient Object target;
    private PropertyChangeListener listener;

    public ActionMenuItem(Action a) {
        this(a, null);
    }

    ActionMenuItem(Action a, Object t) {
        super((String)a.getValue("Name"));
        ActionMenuItem.init(this, a);
        this.listener = new ActionPropertyChangeListener(this, a);
        a.addPropertyChangeListener(this.listener);
        ++numRefsInActions;
        this.action = a;
        this.target = t;
    }

    @Override
    public Object getCurrentTarget() {
        return this.target;
    }

    @Override
    public void removeFromAction() {
        --numRefsInActions;
        this.action.removePropertyChangeListener(this.listener);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (this.notInReadObject) {
            ActionMenuItem.propertyChange(this, ev);
        }
    }

    static void init(JMenuItem b, Action action) {
        Icon icon;
        Integer mnemo;
        b.setActionCommand((String)action.getValue("ActionCommandKey"));
        KeyStroke accel = (KeyStroke)action.getValue("AcceleratorKey");
        if (accel != null) {
            b.setAccelerator(accel);
            SwingUtil.initCtrlShortcutForMac(b);
        }
        if ((mnemo = (Integer)action.getValue("MnemonicKey")) != null) {
            b.setMnemonic(mnemo);
        }
        if ((icon = (Icon)action.getValue("SmallIcon")) != null) {
            b.setIcon(icon);
        }
        b.setEnabled(action.isEnabled());
        Object o = action.getValue("selected");
        b.setSelected(o != null && o instanceof Boolean && (Boolean)o != false);
        b.addActionListener(action);
    }

    static void propertyChange(JMenuItem b, PropertyChangeEvent ev) {
        String key = ev.getPropertyName();
        Object o = ev.getNewValue();
        if (key.equals("Name")) {
            try {
                b.setText((String)o);
            }
            catch (NullPointerException ex) {
                ActionMenuItem.handleNullPointerException(b, "setText('" + (String)o + "')");
            }
        } else if (key.equals("selected")) {
            boolean s = o instanceof Boolean && (Boolean)o != false;
            b.setSelected(s);
        } else if (key.equals("enabled")) {
            boolean s = o instanceof Boolean && (Boolean)o != false;
            b.setEnabled(s);
        } else if (key.equals("MnemonicKey")) {
            try {
                b.setMnemonic((Integer)o);
            }
            catch (NullPointerException ex) {
                int c = (Integer)o;
                ActionMenuItem.handleNullPointerException(b, "setMnemonic('" + (char)c + "')");
            }
        }
    }

    private static void handleNullPointerException(Object b, String where) {
        String clname = b.getClass().getName();
        int k = clname.lastIndexOf(46);
        if (k >= 0) {
            clname = clname.substring(k + 1);
        }
        System.err.println("ActionMenuItem.propertyChange: NullPointerException catched at " + clname + "@" + Integer.toString(b.hashCode(), 16) + "." + where);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.defaultWriteObject();
        oos.writeObject(this.action);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize menu item with future version (" + version + ")");
        }
        ois.defaultReadObject();
        this.action = (Action)ois.readObject();
        SwingUtil.initCtrlShortcutForMac(this);
        this.notInReadObject = true;
    }

    private static class OwnedWeakReference
    extends WeakReference {
        private ActionPropertyChangeListener owner;

        OwnedWeakReference(Object target, ReferenceQueue queue, ActionPropertyChangeListener owner) {
            super(target, queue);
            this.owner = owner;
        }

        public ActionPropertyChangeListener getOwner() {
            return this.owner;
        }
    }

    private static class ActionPropertyChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static ReferenceQueue queue;
        private transient OwnedWeakReference target;
        private Action action;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ReferenceQueue getQueue() {
            Class<ActionPropertyChangeListener> clazz = ActionPropertyChangeListener.class;
            synchronized (ActionPropertyChangeListener.class) {
                if (queue == null) {
                    queue = new ReferenceQueue();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return queue;
            }
        }

        public ActionPropertyChangeListener(JMenuItem c, Action a) {
            this.setTarget(c);
            this.action = a;
        }

        @Override
        public final void propertyChange(PropertyChangeEvent e) {
            JMenuItem target = this.getTarget();
            if (target == null) {
                this.getAction().removePropertyChangeListener(this);
            } else {
                this.actionPropertyChanged(target, this.getAction(), e);
            }
        }

        protected void actionPropertyChanged(JMenuItem target, Action action, PropertyChangeEvent e) {
            ActionMenuItem.propertyChange(target, e);
        }

        private void setTarget(JMenuItem c) {
            OwnedWeakReference r;
            ReferenceQueue queue = ActionPropertyChangeListener.getQueue();
            while ((r = (OwnedWeakReference)queue.poll()) != null) {
                ActionPropertyChangeListener oldPCL = r.getOwner();
                Action oldAction = oldPCL.getAction();
                if (oldAction == null) continue;
                oldAction.removePropertyChangeListener(oldPCL);
            }
            this.target = new OwnedWeakReference(c, queue, this);
        }

        public JMenuItem getTarget() {
            if (this.target == null) {
                return null;
            }
            return (JMenuItem)this.target.get();
        }

        public Action getAction() {
            return this.action;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeObject(this.getTarget());
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            JMenuItem target = (JMenuItem)s.readObject();
            if (target != null) {
                this.setTarget(target);
            }
        }
    }
}

