/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing;

import chemaxon.marvin.swing.Collaction;
import chemaxon.marvin.swing.MAction;
import chemaxon.marvin.swing.action.CopyAction;
import chemaxon.marvin.swing.action.CutAction;
import chemaxon.marvin.swing.action.PasteAction;
import chemaxon.marvin.swing.action.SelectAllAction;
import chemaxon.marvin.swing.action.WindowCloseAction;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.util.text.LocaleUtil;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JMenu;

public class BasicActions
extends Collaction {
    public static final ResourceBundle RESOURCES = BasicActions.getResourceBundle(BasicActions.class.getName());
    private MAction copyAction;
    private MAction cutAction;
    private MAction pasteAction;
    private MAction selectAllAction;
    private MAction closeWindowAction;
    public static final String FILE_MENU_NAME = "file";
    public static final String RECENT_FILE_MENU_NAME = "recentfiles";

    public void addCCCPActions(CCCPListener l) {
        this.copyAction = new CopyAction(RESOURCES, l);
        this.add(this.copyAction);
        this.cutAction = new CutAction(RESOURCES, l);
        this.add(this.cutAction);
        this.pasteAction = new PasteAction(RESOURCES, l);
        this.add(this.pasteAction);
    }

    public void addSelectAllAction(SelectAllListener l) {
        this.selectAllAction = new SelectAllAction(RESOURCES, l);
        this.add(this.selectAllAction);
    }

    public void addWindowCloseAction(Window w, WindowListener l) {
        this.closeWindowAction = new WindowCloseAction(RESOURCES, w, l);
        this.add(this.closeWindowAction);
    }

    public MAction getCopyAction() {
        return this.copyAction;
    }

    public MAction getCutAction() {
        return this.cutAction;
    }

    public MAction getPasteAction() {
        return this.pasteAction;
    }

    public MAction getSelectAllAction() {
        return this.selectAllAction;
    }

    public MAction getWindowCloseAction() {
        return this.closeWindowAction;
    }

    public static JMenu createFileMenu() {
        JMenu filemenu = SwingUtil.createMenu(RESOURCES, FILE_MENU_NAME);
        filemenu.setName(FILE_MENU_NAME);
        return filemenu;
    }

    public static JMenu createEditMenu(boolean mnemo) {
        return SwingUtil.createMenu(RESOURCES, "edit", mnemo);
    }

    public static JMenu createViewMenu() {
        return SwingUtil.createMenu(RESOURCES, "view");
    }

    public static JMenu createStructureMenu(boolean mnemo) {
        return SwingUtil.createMenu(RESOURCES, "structure", mnemo);
    }

    public static JMenu createNewMenu() {
        return SwingUtil.createMenu(RESOURCES, "new");
    }

    public static JMenu createRecentFileListMenu() {
        JMenu menu = SwingUtil.createMenu(RESOURCES, RECENT_FILE_MENU_NAME);
        menu.setName(RECENT_FILE_MENU_NAME);
        return menu;
    }

    public static ResourceBundle getResourceBundle(String name) {
        String locales = null;
        if (RESOURCES != null) {
            try {
                locales = RESOURCES.getString("LOCALES");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return LocaleUtil.getResourceBundle(name, locales);
    }

    public static interface SelectAllListener {
        public void doSelectAll();
    }

    public static interface CCCPListener {
        public void doCopy();

        public void doCut();

        public void doPaste();
    }
}

