/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing;

import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class ImageFileFilter
extends FileFilter {
    public static final int T_BITMAP = 1;
    public static final int T_VECTOR = 2;
    public static final int T_ALL = 3;
    private static final String[] FORMATS;
    private static final String[] FORMAT_DESC;
    private static final String[][] FORMAT_EXTS;
    private String[] exts;
    private String desc;
    private String format;

    public ImageFileFilter(String format2) {
        this.format = format2;
        this.exts = null;
        this.desc = null;
        for (int i = 0; i < FORMATS.length; ++i) {
            if (!format2.equals(FORMATS[i])) continue;
            this.desc = FORMAT_DESC[i];
            this.exts = FORMAT_EXTS[i];
            break;
        }
        StringBuffer sbuf = new StringBuffer(this.desc);
        sbuf.append(" (");
        for (int i = 0; i < this.exts.length; ++i) {
            sbuf.append("*.");
            sbuf.append(this.exts[i]);
            if (i >= this.exts.length - 1) continue;
            sbuf.append(' ');
        }
        sbuf.append(')');
        this.desc = sbuf.toString();
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String s = f.getName().toLowerCase();
            for (int i = 0; i < this.exts.length; ++i) {
                String ext = this.exts[i];
                if (!s.endsWith(ext) && !ext.equals("*")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public String getFormat() {
        return this.format;
    }

    public String getExtension() {
        return this.exts[0];
    }

    public static ImageFileFilter[] createAll(int types, Set<String> disabledFormats) {
        ArrayList<ImageFileFilter> v = new ArrayList<ImageFileFilter>();
        for (int i = 0; i < FORMATS.length; ++i) {
            String fmt = FORMATS[i];
            if (disabledFormats.contains(fmt)) continue;
            v.add(new ImageFileFilter(fmt));
        }
        ImageFileFilter[] ff = new ImageFileFilter[v.size()];
        v.toArray(ff);
        return ff;
    }

    public static String extensionFromFormat(String fmt, int types, Set<String> disabledFormats) {
        for (int i = 0; i < FORMATS.length; ++i) {
            if (!FORMATS[i].equals(fmt) || disabledFormats.contains(FORMATS[i])) continue;
            return FORMAT_EXTS[i][0];
        }
        return null;
    }

    public static String formatFromExtension(String ext, int types, Set<String> disabledFormats) {
        if (ext == null) {
            return null;
        }
        ext = ext.toLowerCase();
        for (int i = 0; i < FORMATS.length; ++i) {
            for (int j = 0; j < FORMAT_EXTS[i].length; ++j) {
                if (!FORMAT_EXTS[i][j].equals(ext) || disabledFormats.contains(FORMATS[i])) continue;
                return FORMATS[i];
            }
        }
        return null;
    }

    static {
        MFileFormat[] formats = MFileFormatUtil.findFormats(null, 512L, 528L);
        int n = formats.length;
        FORMATS = new String[n];
        FORMAT_DESC = new String[n];
        FORMAT_EXTS = new String[n][];
        for (int i = 0; i < n; ++i) {
            ImageFileFilter.FORMATS[i] = formats[i].getName();
            ImageFileFilter.FORMAT_DESC[i] = formats[i].getDescription();
            ImageFileFilter.FORMAT_EXTS[i] = formats[i].getExtensions();
        }
    }
}

