/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.image.exporter.ImageExport;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.HourglassHandler;
import chemaxon.marvin.util.MarvinModule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class SaveImageTool {
    private Container parentContainer;
    private HourglassHandler hourglassHandler;
    private File imageFile = null;
    private String imageSaveFormat = "png";
    private URL imageSaveURL = null;
    private URL imageShowURL = null;
    private double relativeMagnification;
    private Object exportModule;
    private Color backgroundColor;
    private boolean isTransparent;
    private Dimension imageSize;
    private transient CallbackIface saveImageModule = null;
    private transient MarvinModule exportImageOptionsDialog = null;
    private transient MarvinModule pngExportOptsDialog = null;
    private transient MarvinModule jpegExportOptsDialog = null;
    private transient MarvinModule svgExportOptsDialog = null;
    private transient MarvinModule vectGraphicsExportOptsDialog = null;
    private transient MarvinModule pdfGraphicsExportOptsDialog = null;
    public Object eventSource;
    public PropertyChangeSupport changeListeners = null;

    public SaveImageTool(Object source, Container parent, HourglassHandler hourglass) {
        this.eventSource = source;
        this.parentContainer = parent;
        this.hourglassHandler = hourglass;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public URL getImageShowURL() {
        return this.imageShowURL;
    }

    public void setImageShowURL(URL url) {
        this.imageShowURL = url;
    }

    public URL getImageSaveURL() {
        return this.imageSaveURL;
    }

    public void setImageSaveURL(URL url) {
        this.imageSaveURL = url;
    }

    public final String getFormat() {
        return this.imageSaveFormat;
    }

    public final void setFormat(String fmt) {
        this.imageSaveFormat = fmt;
    }

    public final Container getParentContainer() {
        return this.parentContainer;
    }

    public final HourglassHandler getHourglassHandler() {
        return this.hourglassHandler;
    }

    public final boolean showFileChooser(int types, String defname) {
        CallbackIface mm = this.saveImageModule;
        if (mm == null) {
            try {
                mm = (CallbackIface)MarvinModule.load("swing.SaveImageFileChoose", null, null, this.getHourglassHandler());
                mm.callback("setParentComponent", this.getParentContainer());
                mm.callback("setDefName", defname);
                mm.callback("setFormat", this.imageSaveFormat);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.saveImageModule = mm;
        }
        Object[] args = new Object[]{new Integer(types), defname};
        String[] r = null;
        if (mm != null) {
            r = (String[])mm.callback("show", args);
        }
        if (r != null) {
            this.imageFile = new File(r[0]);
            this.imageSaveFormat = r[1];
            return true;
        }
        return false;
    }

    public Object[] createInitialImages(Dimension d, Color bg, double mag, int n) {
        MarvinModule mm = null;
        String fmt = this.imageSaveFormat;
        if (fmt.equals("png")) {
            mm = this.pngExportOptsDialog;
            if (mm == null) {
                this.pngExportOptsDialog = mm = (MarvinModule)MarvinModule.load("swing.PngExportOptsDialog", this.getHourglassHandler());
            }
        } else if (fmt.equals("jpeg")) {
            mm = this.jpegExportOptsDialog;
            if (mm == null) {
                this.jpegExportOptsDialog = mm = (MarvinModule)MarvinModule.load("swing.JpegExportOptsDialog", this.getHourglassHandler());
            }
        } else if (fmt.equals("svg")) {
            mm = this.svgExportOptsDialog;
            if (mm == null) {
                try {
                    mm = (MarvinModule)MarvinModule.load("swing.SvgExportOptsDialog", this.getHourglassHandler());
                }
                catch (NoClassDefFoundError ex) {
                    // empty catch block
                }
                if (mm == null) {
                    this.missingBatikError();
                    return null;
                }
                this.svgExportOptsDialog = mm;
            }
        } else if (fmt.equals("emf") || fmt.equals("pdf")) {
            mm = fmt.equals("pdf") ? this.pdfGraphicsExportOptsDialog : this.vectGraphicsExportOptsDialog;
            if (mm == null) {
                mm = (MarvinModule)MarvinModule.load("swing.VectGraphicsExportOptsDialog", this.getHourglassHandler());
                MolExportModule eem = null;
                try {
                    eem = MFileFormatUtil.createExportModule(fmt);
                }
                catch (MolExportException ex) {
                    // empty catch block
                }
                if (eem == null) {
                    this.missingFreehepError(fmt);
                    return null;
                }
                if (fmt.equals("pdf")) {
                    this.pdfGraphicsExportOptsDialog = mm;
                    mm.modfunc("noalpha");
                } else {
                    this.vectGraphicsExportOptsDialog = mm;
                }
            }
        } else {
            mm = this.exportImageOptionsDialog;
            if (mm == null) {
                this.exportImageOptionsDialog = mm = (MarvinModule)MarvinModule.load("swing.ImageExportOptsDialog", this.getHourglassHandler());
            }
        }
        Object[] args = new Object[]{d, new Double(mag), bg, this, fmt, new Integer(n)};
        Object[] imgs = (Object[])mm.modfunc(args);
        this.relativeMagnification = (Double)mm.modfunc("getMag");
        this.exportModule = mm.modfunc("createExportModule");
        this.backgroundColor = (Color)mm.modfunc("getBackground");
        this.imageSize = (Dimension)mm.modfunc("getImageSize");
        this.isTransparent = (Boolean)mm.modfunc("isTransparent");
        return imgs;
    }

    public final void setMolSourceOnImageExport(String source) {
        if (this.exportModule instanceof ImageExport) {
            ((ImageExport)this.exportModule).setMolSource(source);
        }
    }

    public final double getMagnification() {
        return this.relativeMagnification;
    }

    public final Object getExportModule() {
        return this.exportModule;
    }

    public final boolean isTransparent() {
        return this.isTransparent;
    }

    public final Color getBackground() {
        return this.backgroundColor;
    }

    public final Dimension getImageSize() {
        return this.imageSize;
    }

    public final void exportImage(Object[] imgs) {
        Hashtable<String, Object> args = new Hashtable<String, Object>();
        args.put("saveImageTool", this);
        args.put("format", this.imageSaveFormat);
        args.put("file", this.imageFile != null ? this.imageFile.getPath() : null);
        if (this.exportModule != null) {
            args.put("exportModule", this.exportModule);
        }
        MarvinModule mm = (MarvinModule)MarvinModule.load("swing.Export2dImage", this.getHourglassHandler());
        args.put("images", imgs);
        if (mm != null) {
            mm.modfunc(args);
        }
    }

    public static final Image[] createBackgroundImages(Component comp, Dimension d, int rgba, int n) {
        int[] pixels = new int[d.width * d.height];
        for (int x = 0; x < pixels.length; ++x) {
            pixels[x] = rgba;
        }
        for (int i = d.width; i < pixels.length; i += d.width) {
            System.arraycopy(pixels, 0, pixels, i, d.width);
        }
        MemoryImageSource mis = new MemoryImageSource(d.width, d.height, pixels, 0, d.width);
        Image[] imgs = new Image[n];
        Object[] creatorArgs = new Object[]{d, new Integer(rgba)};
        CallbackIface creator = (CallbackIface)MarvinModule.load("CreateImage", null);
        for (int i = 0; i < imgs.length; ++i) {
            imgs[i] = creator != null ? (Image)creator.callback(null, creatorArgs) : comp.createImage(d.width, d.height);
            if (imgs[i] == null) continue;
            Image tmp = comp.createImage(mis);
            Graphics g = imgs[i].getGraphics();
            g.drawImage(tmp, 0, 0, null);
            tmp.flush();
        }
        return imgs;
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new PropertyChangeSupport(this.eventSource);
        }
        this.changeListeners.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeListeners != null) {
            this.changeListeners.removePropertyChangeListener(l);
        }
    }

    private void missingBatikError() {
        String msg = "Cannot export Scalable Vector Graphics without the Apache Batik\nlibrary (http://xml.apache.org/batik).";
        this.errorMessageDialog("Cannot export SVG", msg);
    }

    private void missingFreehepError(String fmt) {
        String msg = "Cannot export " + fmt + " without freehep jars.";
        this.errorMessageDialog("Cannot export " + fmt, msg);
    }

    private void errorMessageDialog(final String title, final String msg) {
        Timer t = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JOptionPane.showMessageDialog(SaveImageTool.this.getParentContainer(), msg, title, 0);
            }
        });
        t.setRepeats(false);
        t.start();
    }
}

