/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing;

import chemaxon.marvin.swing.ActionRadioButtonMenuItem;
import chemaxon.marvin.swing.ToggleButtonAction;
import chemaxon.marvin.swing.ToggleButtonActionGroupCleanUp;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class ToggleButtonActionGroup
implements Serializable {
    private static final long serialVersionUID = 5722808204737522586L;
    public static final int NO_1ST_ROW_IN_2ND_COLUMN = 1;
    public static final int NO_1ST_ROW_IN_3RD_COLUMN = 2;
    private boolean enabled = true;
    private int currentIndex = -1;
    private Object[] values;
    private ToggleButtonAction emptyAction;
    private ToggleButtonAction[] actions;
    private PropertyChangeSupport changeListeners;
    private EventListenerList actionListeners = new EventListenerList();
    private String propertyName;
    private Vector emptyRadioButtons;
    private KeyStroke[][] keyStrokes;

    public ToggleButtonActionGroup(String key, Object[] vals, String[] labels) {
        this.propertyName = key;
        this.values = vals;
        this.actions = new ToggleButtonAction[vals.length];
        this.keyStrokes = new KeyStroke[vals.length][];
        this.createToggleButtonActions(key, labels, vals, this.enabled);
        this.changeListeners = new PropertyChangeSupport(this);
        this.emptyRadioButtons = new Vector();
    }

    private void createToggleButtonActions(String key, String[] labels, Object[] vals, boolean enabled) {
        for (int i = 0; i < this.actions.length; ++i) {
            final int index = i;
            this.actions[i] = new ToggleButtonAction(key + "-" + vals[i], labels[i]);
            this.actions[i].setSelected(i == this.currentIndex);
            this.actions[i].setEnabled(enabled);
            this.actions[i].addPropertyChangeListener(new MyPropertyChangeListener());
            this.actions[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String cmd = ev.getActionCommand();
                    if (index != ToggleButtonActionGroup.this.getSelectedIndex()) {
                        ToggleButtonActionGroup.this.setSelectedIndex(index);
                    }
                    ToggleButtonActionGroup.this.fireActionEvent(cmd, this, ev.getModifiers());
                }
            });
        }
        this.emptyAction = new ToggleButtonAction("empty", "");
        this.emptyAction.setSelected(this.currentIndex < 0 || this.currentIndex >= this.actions.length);
        this.emptyAction.addPropertyChangeListener(new MyPropertyChangeListener());
    }

    private void fireActionEvent(String cmd, Object src, int mod) {
        Object[] listeners = this.actionListeners.getListenerList();
        ActionEvent ev2 = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (ev2 == null) {
                ev2 = new ActionEvent(src, 1001, cmd, mod);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(ev2);
        }
    }

    public Object getValue() {
        return this.values[this.currentIndex];
    }

    public void setValue(Object v) {
        if (v == null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] != null) continue;
                this.setSelectedIndex(i);
                return;
            }
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                Object vi = this.values[i];
                if (vi == null || !this.values[i].equals(v)) continue;
                this.setSelectedIndex(i);
                return;
            }
            throw new IllegalArgumentException("Invalid value \"" + v.toString() + "\"");
        }
        this.setSelectedIndex(-1);
    }

    public int getSelectedIndex() {
        return this.currentIndex;
    }

    public void setSelectedIndex(int i) {
        int oldi = this.currentIndex;
        if (oldi != i) {
            this.currentIndex = i;
            if (oldi >= 0) {
                this.actions[oldi].setSelected(false);
            } else {
                this.emptyAction.setSelected(false);
            }
            if (i >= 0) {
                this.actions[i].setSelected(true);
            } else {
                this.emptyAction.setSelected(true);
            }
            this.changeListeners.firePropertyChange(this.propertyName, oldi >= 0 ? this.values[oldi] : null, i >= 0 ? this.values[i] : null);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setAccelerator(int i, KeyStroke accel) {
        this.actions[i].putValue("AcceleratorKey", accel);
        this.keyStrokes[i] = new KeyStroke[]{accel};
    }

    public void setAccelerators(int i, KeyStroke[] accel) {
        this.actions[i].putValue("AcceleratorKey", accel[0]);
        this.keyStrokes[i] = accel;
    }

    public void initInputMap(JComponent c, int condition) {
        InputMap imap = c.getInputMap(condition);
        for (int i = 0; i < this.actions.length; ++i) {
            ToggleButtonAction action = this.actions[i];
            Object cmd = this.values[i];
            KeyStroke[] strokes = this.keyStrokes[i];
            if (action == null || strokes == null) continue;
            for (int j = 0; j < strokes.length; ++j) {
                imap.put(strokes[j], cmd);
            }
            c.getActionMap().put(cmd, action);
        }
    }

    public boolean isEnabled(int i) {
        return this.actions[i].isEnabled();
    }

    public void setEnabled(int i, boolean e) {
        this.actions[i].setEnabled(e);
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].setEnabled(e);
        }
    }

    public ActionRadioButtonMenuItem[] addTo(JMenu menu) {
        return this.addTo(menu, 0, 0, null);
    }

    public ActionRadioButtonMenuItem[] addTo(JMenu menu, int maxrows, int flags) {
        return this.addTo(menu, maxrows, flags, null);
    }

    public ActionRadioButtonMenuItem[] addTo(JMenu menu, int maxrows, int flags, Object t) {
        ButtonGroup g = new ButtonGroup();
        ActionRadioButtonMenuItem[] mis = ToggleButtonActionGroup.add(this.actions, g, menu, maxrows, flags, t);
        ActionRadioButtonMenuItem empty = new ActionRadioButtonMenuItem(this.emptyAction, t);
        g.add(empty);
        this.emptyRadioButtons.addElement(empty);
        if ((flags & 4) != 0) {
            ActionRadioButtonMenuItem[] mis2 = new ActionRadioButtonMenuItem[this.actions.length + 1];
            System.arraycopy(mis, 0, mis2, 1, this.actions.length);
            mis2[0] = empty;
            new ToggleButtonActionGroupCleanUp(menu, mis2);
        }
        return mis;
    }

    protected static ActionRadioButtonMenuItem[] add(ToggleButtonAction[] actions, ButtonGroup group, JMenu menu, int maxrows, int flags, Object t) {
        ActionRadioButtonMenuItem[] mis = new ActionRadioButtonMenuItem[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            mis[i] = new ActionRadioButtonMenuItem(actions[i], t);
            menu.add(mis[i]);
            actions[i].setMenuItem(mis[i], flags);
            group.add(mis[i]);
        }
        if (maxrows > 0) {
            int cols = (mis.length + maxrows - 1) / maxrows;
            int rows = (mis.length + cols - 1) / cols;
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            menu.getPopupMenu().setLayout(gbl);
            for (int i = 0; i < mis.length; ++i) {
                if ((flags & 1) != 0) {
                    if (i < rows) {
                        gbc.gridx = 0;
                        gbc.gridy = i;
                    } else {
                        gbc.gridx = 1 + (i - rows) / (rows - 1);
                        gbc.gridy = 1 + (i - rows) % (rows - 1);
                    }
                } else if ((flags & 2) != 0) {
                    if (i < 2 * rows) {
                        gbc.gridx = i / rows;
                        gbc.gridy = i % rows;
                    } else {
                        gbc.gridx = 2 + (i - 2 * rows) / (rows - 1);
                        gbc.gridy = 1 + (i - 2 * rows) % (rows - 1);
                    }
                } else {
                    gbc.gridx = i / rows;
                    gbc.gridy = i % rows;
                }
                gbl.setConstraints(mis[i], gbc);
            }
        }
        if (menu.getItemCount() < 1) {
            menu.setEnabled(false);
        }
        return mis;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeListeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeListeners.removePropertyChangeListener(l);
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(ActionListener.class, l);
    }

    public void cleanup() {
        Vector v = this.emptyRadioButtons;
        for (int i = 0; i < this.emptyRadioButtons.size(); ++i) {
            PropertyChangeListener l = (PropertyChangeListener)v.elementAt(i);
            this.emptyAction.removePropertyChangeListener(l);
        }
        v.removeAllElements();
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener,
    Serializable {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (ToggleButtonActionGroup.this.actions == null) {
                return;
            }
            Object src = ev.getSource();
            String key = ev.getPropertyName();
            Object val = ev.getNewValue();
            if (key.equals("selected") && src instanceof ToggleButtonAction && val.equals(Boolean.TRUE)) {
                for (int i = 0; i < ToggleButtonActionGroup.this.actions.length; ++i) {
                    if (ToggleButtonActionGroup.this.actions[i] != src) continue;
                    int oldi = ToggleButtonActionGroup.this.currentIndex;
                    if (oldi != i) {
                        ToggleButtonActionGroup.this.currentIndex = i;
                        if (oldi >= 0) {
                            ToggleButtonActionGroup.this.actions[oldi].setSelected(false);
                        } else {
                            ToggleButtonActionGroup.this.emptyAction.setSelected(false);
                        }
                        ToggleButtonActionGroup.this.actions[i].setSelected(true);
                        ToggleButtonActionGroup.this.changeListeners.firePropertyChange(ToggleButtonActionGroup.this.propertyName, oldi >= 0 ? ToggleButtonActionGroup.this.values[oldi] : null, i >= 0 ? ToggleButtonActionGroup.this.values[i] : null);
                    }
                    return;
                }
                int oldi = ToggleButtonActionGroup.this.currentIndex;
                if (ToggleButtonActionGroup.this.emptyAction == src && oldi >= 0) {
                    ToggleButtonActionGroup.this.currentIndex = -1;
                    ToggleButtonActionGroup.this.actions[oldi].setSelected(false);
                    ToggleButtonActionGroup.this.emptyAction.setSelected(true);
                    ToggleButtonActionGroup.this.changeListeners.firePropertyChange(ToggleButtonActionGroup.this.propertyName, ToggleButtonActionGroup.this.values[oldi], null);
                }
            }
        }
    }
}

