/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing.modules;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.swing.SaveImageTool;
import chemaxon.marvin.util.MarvinModule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ImageExportOptsDialog
extends MarvinModule
implements ActionListener,
ItemListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    protected boolean canceled;
    protected boolean badvalue = false;
    protected JDialog dialog;
    protected boolean encodeAlpha = false;
    protected boolean saveSource = true;
    protected int alphaValue = 0;
    protected Color bgColor;
    protected boolean isTransparent;
    protected JComboBox compressionLevelCombo;
    protected int compressionLevel = 9;
    protected JCheckBox compressionCheckBox;
    protected boolean compressionEnabled = false;
    private SaveImageTool saveImageTool;
    private String format;
    private Dimension imageSize;
    private JTextField relMagTextField;
    private JTextField absMagTextField;
    private JTextField widthTextField;
    private JTextField heightTextField;
    private double absMagValue;
    private double relMagValue = 1.0;
    private JCheckBox alphaCheckBox;
    private JCheckBox saveSourceCheckBox;
    private ButtonGroup alphaGroup;
    private JRadioButton transparentBgRadioBtn;
    private JRadioButton opaqueBgRadioBtn;
    private int alphaBgIndex = 0;

    @Override
    public Object modfunc(Object arg) {
        if (arg instanceof Object[]) {
            Object[] args = (Object[])arg;
            this.imageSize = (Dimension)args[0];
            this.absMagValue = (Double)args[1];
            this.bgColor = (Color)args[2];
            this.saveImageTool = (SaveImageTool)args[3];
            this.format = (String)args[4];
            int numImages = (Integer)args[5];
            Container parent = this.saveImageTool.getParentContainer();
            while (!(parent instanceof Frame)) {
                parent = parent.getParent();
            }
            this.dialog = new JDialog((Frame)parent, "Image Export Options", true);
            Container contentPane = this.dialog.getContentPane();
            GridBagLayout gbl = new GridBagLayout();
            contentPane.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 10;
            gbc.insets.top = 10;
            gbc.insets.left = 10;
            gbc.insets.right = 10;
            gbl.setConstraints(this.addSizePanel(this.dialog), gbc);
            this.addPanels(gbl, gbc, this.dialog);
            gbc.anchor = 10;
            gbc.insets.top = 20;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 2;
            gbl.setConstraints(this.addOkCancelPanel(this.dialog), gbc);
            this.showDialog();
            if (!this.canceled) {
                this.imageSize.width = (int)((double)this.imageSize.width * this.relMagValue + 0.5);
                this.imageSize.height = (int)((double)this.imageSize.height * this.relMagValue + 0.5);
                return this.createBackgrounds(this.imageSize, numImages);
            }
        } else {
            if (arg.equals("getMag")) {
                return new Double(this.relMagValue);
            }
            if (arg.equals("getBackground")) {
                return this.getBackground();
            }
            if (arg.equals("isTransparent")) {
                return this.isTransparent;
            }
            if (arg.equals("getImageSize")) {
                return this.imageSize;
            }
            if (arg.equals("createExportModule")) {
                return this.createExportModule();
            }
        }
        return null;
    }

    public Dimension getImageSize() {
        return this.imageSize;
    }

    public Color getBackground() {
        Color c = this.bgColor;
        if (this.encodeAlpha && this.isAlphaSupported()) {
            c = new Color(this.bgColor.getRed(), this.bgColor.getGreen(), this.bgColor.getBlue(), this.alphaValue);
        }
        return c;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (cmd.equals("ok")) {
            if (!this.badvalue) {
                this.dialog.setVisible(false);
                this.canceled = false;
            }
        } else if (cmd.equals("cancel")) {
            this.dialog.setVisible(false);
        }
        this.badvalue = false;
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        JRadioButton b;
        Object t = ev.getSource();
        if (t == this.compressionCheckBox) {
            this.compressionEnabled = this.compressionCheckBox.isSelected();
        } else if (t == this.compressionLevelCombo) {
            this.compressionLevel = this.compressionLevelCombo.getSelectedIndex();
        } else if (t == this.alphaCheckBox) {
            this.setAlpha();
        } else if (t == this.saveSourceCheckBox) {
            this.saveSource = this.saveSourceCheckBox.isSelected();
        } else if (t instanceof JRadioButton && (b = (JRadioButton)t).isSelected()) {
            this.setAlpha();
        }
        this.badvalue = false;
    }

    @Override
    public void focusGained(FocusEvent ev) {
    }

    @Override
    public void focusLost(FocusEvent ev) {
        JTextField t;
        Object src = ev.getSource();
        this.badvalue = false;
        if (src instanceof JTextField && ((t = (JTextField)src) == this.relMagTextField || t == this.absMagTextField || t == this.widthTextField || t == this.heightTextField)) {
            double x = -1.0;
            try {
                x = Double.valueOf(t.getText());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (x > 0.0) {
                if (t == this.relMagTextField) {
                    this.relMagValue = x;
                } else if (t == this.absMagTextField) {
                    this.relMagValue = x / this.absMagValue;
                } else if (t == this.widthTextField) {
                    this.relMagValue = (double)Math.round(x) / (double)this.imageSize.width;
                } else if (t == this.heightTextField) {
                    this.relMagValue = (double)Math.round(x) / (double)this.imageSize.height;
                }
                this.relMagTextField.setText(String.valueOf(this.relMagValue));
                this.absMagTextField.setText(String.valueOf(this.absMagValue * this.relMagValue));
                this.widthTextField.setText(String.valueOf((int)(this.relMagValue * (double)this.imageSize.width + 0.5)));
                this.heightTextField.setText(String.valueOf((int)(this.relMagValue * (double)this.imageSize.height + 0.5)));
            } else {
                if (t == this.relMagTextField) {
                    this.relMagTextField.setText(String.valueOf(this.relMagValue));
                } else if (t == this.absMagTextField) {
                    this.absMagTextField.setText(String.valueOf(this.absMagValue * this.relMagValue));
                } else if (t == this.widthTextField) {
                    this.widthTextField.setText(String.valueOf((int)(this.relMagValue * (double)this.imageSize.width + 0.5)));
                } else if (t == this.heightTextField) {
                    this.heightTextField.setText(String.valueOf((int)(this.relMagValue * (double)this.imageSize.height + 0.5)));
                }
                this.badvalue = true;
                JOptionPane.showMessageDialog(this.dialog, "Scale and sizes must be positive numbers.", "Invalid value", 0);
            }
        }
    }

    protected Object[] createBackgrounds(Dimension d, int n) {
        int rgba = this.bgColor.getRGB() & 0xFFFFFF;
        int n2 = this.encodeAlpha && this.isAlphaSupported() ? this.alphaValue << 24 : -16777216;
        Container comp = this.saveImageTool.getParentContainer();
        return SaveImageTool.createBackgroundImages(comp, d, rgba |= n2, n);
    }

    protected boolean isAlphaSupported() {
        return false;
    }

    protected JPanel addSizePanel(JDialog dial) {
        JPanel panel = new JPanel();
        panel = new JPanel();
        dial.getContentPane().add(panel);
        GridBagLayout gbl1 = new GridBagLayout();
        gbl1 = new GridBagLayout();
        panel.setLayout(gbl1);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Size"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JLabel label = new JLabel("Relative scale:");
        panel.add(label);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.insets.right = 10;
        gbc1.weighty = 1.0;
        gbc1.anchor = 18;
        gbl1.setConstraints(label, gbc1);
        this.relMagTextField = new JTextField(17);
        panel.add(this.relMagTextField);
        this.relMagTextField.setText(String.valueOf(this.relMagValue));
        this.relMagTextField.addFocusListener(this);
        ++gbc1.gridx;
        gbc1.insets.right = 0;
        gbl1.setConstraints(this.relMagTextField, gbc1);
        label = new JLabel("Absolute scale:");
        panel.add(label);
        gbc1.gridx = 0;
        ++gbc1.gridy;
        gbc1.insets.right = 10;
        gbl1.setConstraints(label, gbc1);
        this.absMagTextField = new JTextField(17);
        panel.add(this.absMagTextField);
        this.absMagTextField.setText(String.valueOf(this.relMagValue * this.absMagValue));
        this.absMagTextField.addFocusListener(this);
        ++gbc1.gridx;
        gbc1.insets.right = 0;
        gbl1.setConstraints(this.absMagTextField, gbc1);
        JPanel panel2 = new JPanel();
        panel.add(panel2);
        gbc1.gridx = 0;
        ++gbc1.gridy;
        gbc1.gridwidth = 2;
        gbc1.insets.top = 5;
        gbl1.setConstraints(panel2, gbc1);
        gbc1.gridwidth = 1;
        GridBagLayout gbl2 = new GridBagLayout();
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbl2 = new GridBagLayout();
        panel2.setLayout(gbl2);
        label = new JLabel("Width:");
        panel2.add(label);
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 18;
        gbc2.insets.right = 10;
        gbl2.setConstraints(label, gbc2);
        this.widthTextField = new JTextField(4);
        panel2.add(this.widthTextField);
        this.widthTextField.setText(String.valueOf((int)((double)this.imageSize.width * this.relMagValue)));
        this.widthTextField.addFocusListener(this);
        ++gbc2.gridx;
        gbl2.setConstraints(this.widthTextField, gbc2);
        label = new JLabel("Height:");
        panel2.add(label);
        ++gbc2.gridx;
        gbl2.setConstraints(label, gbc2);
        this.heightTextField = new JTextField(4);
        panel2.add(this.heightTextField);
        this.heightTextField.setText(String.valueOf((int)((double)this.imageSize.height * this.relMagValue)));
        this.heightTextField.addFocusListener(this);
        ++gbc2.gridx;
        gbl2.setConstraints(this.heightTextField, gbc2);
        return panel;
    }

    protected JPanel addSaveSourcePanel(JDialog dial) {
        JPanel panel = new JPanel();
        dial.getContentPane().add(panel);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Save source"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.saveSourceCheckBox = new JCheckBox("Save molecule source into image comment", this.saveSource);
        this.saveSourceCheckBox.addItemListener(this);
        panel.add(this.saveSourceCheckBox);
        return panel;
    }

    protected JPanel addOkCancelPanel(JDialog dial) {
        JPanel panel = new JPanel();
        dial.getContentPane().add(panel);
        JButton btn = new JButton("OK");
        panel.add(btn);
        btn.setActionCommand("ok");
        btn.setMnemonic('O');
        btn.addActionListener(this);
        btn = new JButton("Cancel");
        panel.add(btn);
        btn.setActionCommand("cancel");
        btn.setMnemonic('C');
        btn.addActionListener(this);
        return panel;
    }

    protected void showDialog() {
        double prevRelMagValue = this.relMagValue;
        boolean prevEncodeAlpha = this.encodeAlpha;
        int prevAlphaValue = this.alphaValue;
        int prevAlphaBgIndex = this.alphaBgIndex;
        boolean prevCompressionEnabled = this.compressionEnabled;
        int prevCompressionLevel = this.compressionLevel;
        boolean prevSaveSource = this.saveSource;
        this.canceled = true;
        this.dialog.pack();
        try {
            Method m = JDialog.class.getMethod("setLocationRelativeTo", Component.class);
            m.invoke((Object)this.dialog, this.saveImageTool.getParentContainer());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.dialog.setVisible(true);
        if (this.canceled) {
            this.encodeAlpha = prevEncodeAlpha;
            this.alphaValue = prevAlphaValue;
            this.alphaBgIndex = prevAlphaBgIndex;
            this.relMagValue = prevRelMagValue;
            this.compressionEnabled = prevCompressionEnabled;
            this.compressionLevel = prevCompressionLevel;
            this.saveSource = prevSaveSource;
        }
    }

    protected void addPanels(GridBagLayout gbl, GridBagConstraints gbc, JDialog dial) {
    }

    protected Object createExportModule() {
        try {
            return MFileFormatUtil.createExportModule(this.format);
        }
        catch (MolExportException ex) {
            return null;
        }
    }

    protected JCheckBox addCompressionCheckBox(JDialog dial) {
        JCheckBox cb;
        this.compressionCheckBox = cb = new JCheckBox("Compression");
        cb.setSelected(this.compressionEnabled);
        cb.addItemListener(this);
        dial.getContentPane().add(cb);
        return cb;
    }

    protected JPanel addCompressionLevelPanel(JDialog dial) {
        JPanel panel = new JPanel();
        dial.getContentPane().add(panel);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Compression"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout gbl1 = new GridBagLayout();
        panel.setLayout(gbl1);
        JLabel label = new JLabel("Level:");
        panel.add(label);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.insets.right = 10;
        gbl1.setConstraints(label, gbc1);
        String[] levels2 = new String[10];
        for (int i = 0; i < levels2.length; ++i) {
            levels2[i] = String.valueOf(i);
        }
        this.compressionLevelCombo = new JComboBox<String>(levels2);
        panel.add(this.compressionLevelCombo);
        this.compressionLevelCombo.setSelectedIndex(this.compressionLevel);
        this.compressionLevelCombo.addItemListener(this);
        return panel;
    }

    protected JPanel addAlphaPanel(JDialog dial) {
        JPanel panel = new JPanel();
        dial.getContentPane().add(panel);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Alpha channel"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout gbl1 = new GridBagLayout();
        panel.setLayout(gbl1);
        this.alphaCheckBox = new JCheckBox("Use");
        this.alphaCheckBox.setEnabled(this.isAlphaSupported());
        this.alphaCheckBox.setSelected(this.encodeAlpha);
        this.alphaCheckBox.addItemListener(this);
        panel.add(this.alphaCheckBox);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.insets.top = 0;
        gbc1.insets.right = 10;
        gbc1.weighty = 1.0;
        gbc1.anchor = 18;
        gbl1.setConstraints(this.alphaCheckBox, gbc1);
        JPanel panel2 = new JPanel();
        panel.add(panel2);
        ++gbc1.gridx;
        gbc1.insets.right = 0;
        gbl1.setConstraints(panel2, gbc1);
        GridBagLayout gbl2 = new GridBagLayout();
        panel2.setLayout(gbl2);
        panel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Background"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.transparentBgRadioBtn = new JRadioButton("Transparent");
        panel2.add(this.transparentBgRadioBtn);
        this.transparentBgRadioBtn.setSelected(this.alphaBgIndex == 0);
        this.transparentBgRadioBtn.addItemListener(this);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 18;
        gbl2.setConstraints(this.transparentBgRadioBtn, gbc2);
        this.opaqueBgRadioBtn = new JRadioButton("Opaque");
        panel2.add(this.opaqueBgRadioBtn);
        this.opaqueBgRadioBtn.setSelected(this.alphaBgIndex == 1);
        this.opaqueBgRadioBtn.addItemListener(this);
        ++gbc2.gridy;
        gbl2.setConstraints(this.opaqueBgRadioBtn, gbc2);
        this.alphaGroup = new ButtonGroup();
        this.alphaGroup.add(this.transparentBgRadioBtn);
        this.alphaGroup.add(this.opaqueBgRadioBtn);
        this.setAlpha();
        return panel;
    }

    protected void setAlpha() {
        boolean alphaSupported = this.isAlphaSupported();
        this.encodeAlpha = this.alphaCheckBox.isSelected();
        if (this.transparentBgRadioBtn.isSelected()) {
            this.alphaBgIndex = 0;
            this.isTransparent = true;
        } else if (this.opaqueBgRadioBtn.isSelected()) {
            this.alphaBgIndex = 1;
            this.isTransparent = false;
        }
        this.transparentBgRadioBtn.setEnabled(this.encodeAlpha && alphaSupported);
        this.opaqueBgRadioBtn.setEnabled(this.encodeAlpha && alphaSupported);
        this.alphaValue = this.alphaBgIndex == 0 ? 0 : 255;
    }
}

