/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing.modules;

import chemaxon.marvin.io.image.exporter.JpegExport;
import chemaxon.marvin.swing.modules.ImageExportOptsDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JpegExportOptsDialog
extends ImageExportOptsDialog {
    private static final long serialVersionUID = 1L;
    private JTextField qualityTextField;
    private int qualityValue = 90;

    @Override
    protected Object createExportModule() {
        JpegExport p = new JpegExport();
        p.qualityValue = this.qualityValue;
        p.saveSource = this.saveSource;
        return p;
    }

    @Override
    protected void showDialog() {
        int prevQuality = this.qualityValue;
        super.showDialog();
        if (this.canceled) {
            this.qualityValue = prevQuality;
        }
    }

    @Override
    protected void addPanels(GridBagLayout gbl, GridBagConstraints gbc, JDialog dial) {
        ++gbc.gridy;
        gbc.anchor = 18;
        gbl.setConstraints(this.addSaveSourcePanel(dial), gbc);
        ++gbc.gridy;
        gbc.anchor = 18;
        gbl.setConstraints(this.addQualityPanel(dial), gbc);
    }

    @Override
    public void focusLost(FocusEvent ev) {
        JTextField t;
        super.focusLost(ev);
        Object src = ev.getSource();
        if (src instanceof JTextField && (t = (JTextField)src) == this.qualityTextField) {
            double x = -1.0;
            try {
                x = Double.valueOf(t.getText());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            int q = (int)Math.round(x);
            if (q >= 0 && q <= 100) {
                this.qualityValue = q;
                this.qualityTextField.setText(String.valueOf(q));
            } else {
                this.qualityTextField.setText(String.valueOf(this.qualityValue));
                this.badvalue = true;
                JOptionPane.showMessageDialog(this.dialog, "Quality must be an integer in the range 1...100.", "Invalid value", 0);
            }
        }
    }

    protected JPanel addQualityPanel(JDialog dial) {
        JPanel panel = new JPanel();
        dial.getContentPane().add(panel);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Quality"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout gbl1 = new GridBagLayout();
        panel.setLayout(gbl1);
        JLabel label = new JLabel("Value:");
        panel.add(label);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.gridwidth = 1;
        gbc1.weightx = 1.0;
        gbc1.anchor = 18;
        gbc1.insets.right = 10;
        gbl1.setConstraints(label, gbc1);
        this.qualityTextField = new JTextField(3);
        panel.add(this.qualityTextField);
        this.qualityTextField.setText(String.valueOf(this.qualityValue));
        this.qualityTextField.addFocusListener(this);
        ++gbc1.gridx;
        gbl1.setConstraints(this.qualityTextField, gbc1);
        label = new JLabel("Integer between 0 and 100.");
        panel.add(label);
        ++gbc1.gridx;
        gbc1.insets.right = 0;
        gbl1.setConstraints(label, gbc1);
        label = new JLabel("Higher quality means lower");
        panel.add(label);
        ++gbc1.gridy;
        gbl1.setConstraints(label, gbc1);
        label = new JLabel("compression rate.");
        panel.add(label);
        ++gbc1.gridy;
        gbl1.setConstraints(label, gbc1);
        return panel;
    }
}

