/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing.modules;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.swing.ImageFileFilter;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.Environment;
import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class SaveImageFileChoose
implements CallbackIface {
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle(SaveImageFileChoose.class.getName());
    private static boolean EMF_SUPPORTED = Environment.IMAGECOPY_ENABLED;
    private static boolean PDF_SUPPORTED = Environment.IMAGECOPY_ENABLED;
    private boolean batik_lib_present;
    private Component parentComponent = null;
    protected String imageFile = null;
    private String currentFormat;
    private File cwd = null;
    private HashSet<String> disabledFormats;

    public SaveImageFileChoose() {
        try {
            this.cwd = Environment.MACOS && Environment.getCodeBase() != null ? new File(System.getProperty("user.home")) : new File(System.getProperty("user.dir"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.currentFormat = "jpeg";
        this.disabledFormats = new HashSet();
        this.disabledFormats.add("osraimage");
        if (!EMF_SUPPORTED) {
            this.disabledFormats.add("emf");
        }
        if (!PDF_SUPPORTED) {
            this.disabledFormats.add("pdf");
        }
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setParentComponent")) {
            this.parentComponent = (Component)arg;
            this.init();
        } else if (method.equals("setFormat")) {
            this.currentFormat = (String)arg;
        } else if (method.equals("show")) {
            Object[] args = (Object[])arg;
            Integer types = (Integer)args[0];
            String defname = (String)args[1];
            return this.show(types, defname);
        }
        return null;
    }

    private void init() {
        this.batik_lib_present = false;
        try {
            if (Environment.getCodeBase() == null) {
                Class.forName("org.apache.batik.svggen.SVGGraphics2D");
            }
            this.batik_lib_present = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!this.batik_lib_present) {
            this.disabledFormats.add("svg");
            this.disabledFormats.add("svgz");
        }
    }

    private String[] show(int types, String defname) {
        String[] stringArray;
        ImageFileFilter[] filters = ImageFileFilter.createAll(types, this.disabledFormats);
        File imgf = null;
        do {
            JFileChooser w = this.makeChooser(filters, defname);
            w.setDialogTitle(RESOURCES.getString("title"));
            int r = w.showSaveDialog(this.parentComponent);
            if (r == 0) {
                boolean overwr;
                imgf = w.getSelectedFile();
                if (imgf == null) continue;
                FileFilter ff = w.getFileFilter();
                String fmt = ff instanceof ImageFileFilter ? ((ImageFileFilter)ff).getFormat() : null;
                this.setCwd(imgf);
                String imgfname = imgf.getName();
                String ext = imgfname.toLowerCase();
                int opti = ext.lastIndexOf(46);
                ext = opti != -1 ? ext.substring(opti + 1) : null;
                String fmtx = ImageFileFilter.formatFromExtension(ext, types, this.disabledFormats);
                if (fmtx != null) {
                    fmt = fmtx;
                    for (int i = 0; i < filters.length; ++i) {
                        if (!filters[i].getFormat().equals(fmtx)) continue;
                        ff = filters[i];
                        break;
                    }
                }
                if (fmt != null && fmtx == null) {
                    ext = ImageFileFilter.extensionFromFormat(fmt, types, this.disabledFormats);
                    imgf = new File(imgf.getParent(), imgfname + "." + ext);
                }
                if (fmt == null) {
                    JOptionPane.showMessageDialog(this.parentComponent, "File format cannot be recognized", "Cannot guess file format", 0);
                    continue;
                }
                this.currentFormat = fmt;
                if (imgf.exists() && !(overwr = SaveImageFileChoose.showOverwriteDialog(imgf))) continue;
                break;
            }
            imgf = null;
        } while (imgf != null);
        if (imgf != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = imgf.getPath();
            stringArray = stringArray2;
            stringArray2[1] = this.currentFormat;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private JFileChooser makeChooser(ImageFileFilter[] filters, String defname) {
        if (this.parentComponent != null && this.parentComponent instanceof MolPanel) {
            this.cwd = ((MolPanel)this.parentComponent).getFile() == null ? ((MolPanel)this.parentComponent).getSaveCwdFromUserSettings() : ((MolPanel)this.parentComponent).getDirectory();
        }
        ImageFileFilter ff = null;
        if (this.currentFormat != null) {
            for (int i = 0; i < filters.length; ++i) {
                if (!filters[i].getFormat().equals(this.currentFormat)) continue;
                ff = filters[i];
                break;
            }
        }
        MyFileChooser w = this.cwd != null ? new MyFileChooser(this.cwd) : new MyFileChooser();
        for (int i = 0; i < filters.length; ++i) {
            w.addChoosableFileFilter(filters[i]);
        }
        if (ff != null) {
            ((JFileChooser)w).setFileFilter(ff);
        }
        if (defname != null) {
            defname = this.getDefaultName(defname, ff);
            w.setSelectedFile(this.cwd != null ? new File(this.cwd, defname) : new File(defname));
        }
        return w;
    }

    public String getDefaultName(String str, ImageFileFilter ff) {
        String[] fopts = MFileFormatUtil.splitFileAndOptions(str);
        String s = new File(fopts[0]).getName();
        String ext0 = MFileFormatUtil.getKnownExtension(s);
        String ext = ff.getExtension();
        if (ext0 != null) {
            int opti = s.lastIndexOf(46);
            s = s.substring(0, opti + 1) + ext;
        } else {
            s = s + "." + ext;
        }
        return s;
    }

    private static boolean showOverwriteDialog(File f) {
        Object[] opts = new String[]{"Yes", "No"};
        int r = JOptionPane.showOptionDialog(null, "File " + f.getName() + " exists. Overwrite?", "File exists", 1, 3, null, opts, opts[0]);
        return r == 0;
    }

    private void setCwd(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                this.cwd = f;
            } else {
                String s = f.getParent();
                if (s != null) {
                    this.cwd = new File(s);
                }
            }
            ((MolPanel)this.parentComponent).setSaveCwdToUserSettings(f);
        }
    }

    private class MyFileChooser
    extends JFileChooser {
        private static final long serialVersionUID = 1L;

        public MyFileChooser() {
        }

        public MyFileChooser(File cwd) {
            super(cwd);
        }

        @Override
        public void setFileFilter(FileFilter ff) {
            File selfile = this.getSelectedFile();
            super.setFileFilter(ff);
            if (selfile != null && ff != null && ff instanceof ImageFileFilter) {
                String defname = SaveImageFileChoose.this.getDefaultName(selfile.getName(), (ImageFileFilter)ff);
                this.setSelectedFile(new File(selfile.getParent(), defname));
            }
        }
    }
}

