/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing.moleculeview;

import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.swing.moleculeview.MarkController;
import chemaxon.marvin.swing.moleculeview.MoleculeViewComponent;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class MarkableMoleculeViewComponent
extends MoleculeViewComponent {
    private MarkController markController;

    public MarkableMoleculeViewComponent() {
    }

    public MarkableMoleculeViewComponent(MolPainterCommon common) {
        super(common);
    }

    public MarkableMoleculeViewComponent(MolPainterCommon common, MarkController controller) {
        this(common);
        this.setMarkController(controller);
    }

    public MarkableMoleculeViewComponent(MarkController controller) {
        this();
        this.setMarkController(controller);
    }

    @Override
    public void setMolecule(Molecule molecule) {
        Molecule mol = molecule.cloneMoleculeWithDocument();
        this.setCopiedMolecule(mol);
    }

    public void setCopiedMolecule(Molecule molecule) {
        super.setMolecule(molecule);
        this.getMarkController().clearAll();
    }

    public MarkController getMarkController() {
        if (this.markController == null) {
            this.markController = new MarkController(false, 0, true);
            this.markController.setView(this);
        }
        return this.markController;
    }

    public void setMarkController(MarkController controller) {
        if (controller == null) {
            return;
        }
        this.markController = controller;
        if (this.markController.getView() != this) {
            this.markController.setView(this);
        }
    }

    public void changeProperty(final String name, final Integer oldValue, final Integer newValue) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MarkableMoleculeViewComponent.this.firePropertyChange(name, oldValue, newValue);
            }
        });
    }

    public void clearAll() {
        this.getMarkController().clearAll();
    }

    public Map<Integer, Set<Integer>> convertColorMarksToNumberMarks() {
        return this.getMarkController().convertColorMarksToNumberMarks();
    }

    public Map<Color, Set<Integer>> convertNumberMarksToColorMarks(Collection<Color> forbiddenColors) {
        return this.getMarkController().convertNumberMarksToColorMarks(forbiddenColors);
    }

    public int getAtomMarkMode() {
        return this.getMarkController().getAtomMarkMode();
    }

    public void setAtomMarkMode(int mode) {
        this.getMarkController().setAtomMarkMode(mode);
    }

    public void highlightAtoms(Set<Integer> atomIndexes, Color color) {
        this.getMarkController().highlightAtoms(atomIndexes, color);
    }

    public boolean isHighlightEnabled() {
        return this.getMarkController().isHighlightEnabled();
    }

    public void setHighlightEnabled(boolean highlightEnabled) {
        this.getMarkController().setHighlightEnabled(highlightEnabled);
    }

    public boolean isUnmarkAndUnhighlightEqualSetsOnly() {
        return this.getMarkController().isUnmarkAndUnhighlightEqualSetsOnly();
    }

    public void markAtoms(Set<Integer> atomIndexes, Color color) {
        this.getMarkController().markAtoms(atomIndexes, color);
    }

    public void markAtoms(Set<Integer> atomIndexes, int markNumber) {
        this.getMarkController().markAtoms(atomIndexes, markNumber);
    }

    public void removeColorMark(Color color) {
        this.getMarkController().removeColorMark(color);
    }

    public void removeColorMark(Set<Integer> atomIndexes) {
        this.getMarkController().removeColorMark(atomIndexes);
    }

    public void removeColorMarks() {
        this.getMarkController().removeColorMarks();
    }

    public void removeHighLight(Color color) {
        this.getMarkController().removeHighLight(color);
    }

    public void removeHighLight(Set<Integer> atomIndexes) {
        this.getMarkController().removeHighLight(atomIndexes);
    }

    public void removeHighLights() {
        this.getMarkController().removeHighLights();
    }

    public void removeNumberMark(int markNumber) {
        this.getMarkController().removeNumberMark(markNumber);
    }

    public void removeNumberMark(Set<Integer> atomIndexes) {
        this.getMarkController().removeNumberMark(atomIndexes);
    }

    public void removeNumberMarks() {
        this.getMarkController().removeNumberMarks();
    }
}

