/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing.moleculeview;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import java.awt.Dimension;
import java.awt.Point;

public final class MolTransformUtil {
    public static final double RELATIVE_PAINTER_SCALEFACTOR = 0.6;
    public static final int NOT_AN_RGROUP = -1;

    public static double calcAngle(Point start, Point center, Point end) {
        Point centerToStart = MolTransformUtil.getDifference(start, center);
        Point centerToEnd = MolTransformUtil.getDifference(end, center);
        Point startToEnd = MolTransformUtil.getDifference(end, start);
        double sLength = MolTransformUtil.getLength(centerToStart);
        double eLength = MolTransformUtil.getLength(centerToEnd);
        double diffLength = MolTransformUtil.getLength(MolTransformUtil.getDifference(centerToStart, centerToEnd));
        if (eLength * sLength == 0.0) {
            return 0.0;
        }
        double angle = Math.acos(Math.min(1.0, diffLength * diffLength - sLength * sLength - eLength * eLength) / (-2.0 * sLength * eLength));
        return centerToStart.x * startToEnd.y - centerToStart.y * startToEnd.x > 0 ? -angle : angle;
    }

    public static Point getDifference(Point minuend, Point substrahend) {
        return new Point(minuend.x - substrahend.x, minuend.y - substrahend.y);
    }

    private static double getLength(Point point) {
        return Math.sqrt(point.x * point.x + point.y * point.y);
    }

    public static void translate(int dx, int dy, MolPainter painter) {
        Point corner = painter.getCorner();
        painter.setCorner(new Point(corner.x + dx, corner.y + dy));
    }

    public static void scale(double scalingVolume, Point fixPoint, MolPainter painter) {
        CTransform3D scaling = new CTransform3D();
        scaling.setScale(scalingVolume);
        painter.transform(scaling, true);
        Point corner = painter.getCorner();
        painter.setCorner(new Point(-fixPoint.x - (int)Math.round(scalingVolume * (double)(-corner.x - fixPoint.x)), -fixPoint.y - (int)Math.round(scalingVolume * (double)(-corner.y - fixPoint.y))));
    }

    public static void rotate(DPoint3 center, double xAngle, double yAngle, double zAngle, MolPainter painter) {
        CTransform3D rotation = new CTransform3D();
        if (xAngle != 0.0) {
            rotation.setRotation(1.0, 0.0, 0.0, xAngle);
            rotation.setRotationCenter(center);
            painter.transform(rotation, false);
        }
        if (yAngle != 0.0) {
            rotation.setIdentity();
            rotation.setRotation(0.0, 1.0, 0.0, yAngle);
            rotation.setRotationCenter(center);
            painter.transform(rotation, false);
        }
        if (zAngle != 0.0) {
            rotation.setIdentity();
            rotation.setRotation(0.0, 0.0, 1.0, zAngle);
            rotation.setRotationCenter(center);
            painter.transform(rotation, false);
        }
    }

    private static void zoomToFragment(MoleculeGraph[] molGraphArray, DPoint3 center, Dimension componentSize, MolPainter painter, int rGroupID, double scaleFactor) {
        painter.fitFragment(molGraphArray, rGroupID, componentSize);
        DPoint3 fragCenter = center == null ? MolTransformUtil.calcMolGraphsCenter(molGraphArray) : center;
        Point centerInPixels = painter.calcGP(fragCenter.x, fragCenter.y, fragCenter.z);
        Point panelCenter = new Point(componentSize.width / 2, componentSize.height / 2);
        MolTransformUtil.translate(centerInPixels.x - panelCenter.x, centerInPixels.y - panelCenter.y, painter);
        MolTransformUtil.scale(scaleFactor, panelCenter, painter);
    }

    public static void zoomToFragment(MoleculeGraph[] molGraphArray, DPoint3 center, Dimension componentSize, MolPainter painter) {
        MolTransformUtil.zoomToFragment(molGraphArray, center, componentSize, painter, 0, 0.6);
    }

    public static void zoomToFragment(MoleculeGraph[] molGraphArray, DPoint3 center, Dimension componentSize, MolPainter painter, double scaleFactor) {
        MolTransformUtil.zoomToFragment(molGraphArray, center, componentSize, painter, 0, scaleFactor);
    }

    public static void zoomToFragment(MoleculeGraph[] molGraphArray, Dimension componentSize, MolPainter painter, int rGroupID) {
        MolTransformUtil.zoomToFragment(molGraphArray, null, componentSize, painter, rGroupID, 0.6);
    }

    public static void zoomToFragment(MoleculeGraph[] molGraphArray, Dimension componentSize, MolPainter painter, int rGroupID, double scaleFactor) {
        MolTransformUtil.zoomToFragment(molGraphArray, null, componentSize, painter, rGroupID, scaleFactor);
    }

    public static void zoomToFragment(MoleculeGraph[] molGraphArray, Dimension componentSize, MolPainter painter) {
        MolTransformUtil.zoomToFragment(molGraphArray, null, componentSize, painter, -1, 0.6);
    }

    public static void zoomToFragment(MoleculeGraph[] molGraphArray, Dimension componentSize, MolPainter painter, double scaleFactor) {
        MolTransformUtil.zoomToFragment(molGraphArray, null, componentSize, painter, -1, scaleFactor);
    }

    private static DPoint3 calcMolGraphsCenter(MoleculeGraph[] molGraphArray) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (MoleculeGraph graph : molGraphArray) {
            for (MolAtom atom : graph.getAtomArray()) {
                minX = Math.min(minX, atom.getX());
                minY = Math.min(minY, atom.getY());
                minZ = Math.min(minZ, atom.getZ());
                maxX = Math.max(maxX, atom.getX());
                maxY = Math.max(maxY, atom.getY());
                maxZ = Math.max(maxZ, atom.getZ());
            }
        }
        return new DPoint3((minX + maxX) / 2.0, (minY + maxY) / 2.0, (minZ + maxZ) / 2.0);
    }
}

