/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing.moleculeview;

import chemaxon.marvin.swing.moleculeview.RGroupData;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class RGMoleculeGraphUtils {
    public static MoleculeGraph[] getRGroupGraphArray(int rGroupID, RgMolecule rgmol) {
        int index = rgmol.findRgroupIndex(rGroupID);
        if (index == -1) {
            return null;
        }
        MoleculeGraph[] mg = new MoleculeGraph[rgmol.getRgroupMemberCount(index)];
        for (int j = 0; j < mg.length; ++j) {
            mg[j] = rgmol.getRgroupMemberG(index, j);
        }
        return mg;
    }

    public static List<RGroupData> getChildGroups(MoleculeGraph graph, RgMolecule rgMol, boolean onlyDefinedGroups) {
        ArrayList<RGroupData> rGroupList = new ArrayList<RGroupData>();
        ArrayList<Integer> rGroupNumbers = new ArrayList<Integer>();
        for (MolAtom atom : graph.getAtomArray()) {
            if (atom.getAtno() != 134) continue;
            rGroupNumbers.add(atom.getRgroup());
        }
        if (rGroupNumbers.isEmpty()) {
            return null;
        }
        Collections.sort(rGroupNumbers);
        Iterator i$ = rGroupNumbers.iterator();
        while (i$.hasNext()) {
            int rGroupID = (Integer)i$.next();
            MoleculeGraph[] graphs = RGMoleculeGraphUtils.getRGroupGraphArray(rGroupID, rgMol);
            if (graphs == null && onlyDefinedGroups) continue;
            rGroupList.add(new RGroupData(rGroupID, graphs));
        }
        return rGroupList;
    }

    public static boolean hasDefinedChildGroups(MoleculeGraph graph, RgMolecule rgMol) {
        int rGroupID = -1;
        for (MolAtom atom : graph.getAtomArray()) {
            int rGroupIndex;
            if (atom.getAtno() != 134 || (rGroupIndex = rgMol.findRgroupIndex(rGroupID = atom.getRgroup())) == -1 || rgMol.getRgroupMemberCount(rGroupIndex) <= 0 || rgMol.getRgroupMemberG(rGroupIndex, 0) == null) continue;
            return true;
        }
        return false;
    }
}

