/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.action.manager;

import chemaxon.marvin.uif.action.ActionProperties;
import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.Category;
import chemaxon.marvin.uif.action.PropertiesConfigurer;
import chemaxon.marvin.uif.action.RegistryEvent;
import chemaxon.marvin.uif.action.RegistryListener;
import chemaxon.marvin.uif.action.manager.ActionStub;
import chemaxon.marvin.uif.action.manager.InitializationEvent;
import chemaxon.marvin.uif.action.manager.InitializationListener;
import chemaxon.marvin.uif.action.support.ActionAdapter;
import chemaxon.marvin.uif.action.support.BundleBasedConfigurer;
import chemaxon.marvin.uif.action.support.DelegatingProperties;
import chemaxon.marvin.uif.action.support.WeakRegistryListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.event.EventListenerList;

public class ActionManager
implements ActionRegistry,
RegistryListener {
    private final Map<String, ActionStub> stubs;
    private final Map<String, Entry> actions;
    private final Map<Action, String> reverseMap;
    private final Map<String, Category> categoryMap;
    private ActionRegistry parent;
    private EventListenerList listenerList;
    private List<PropertiesConfigurer> configurers;

    public ActionManager() {
        this(null);
    }

    public ActionManager(ActionRegistry parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addRegistryListener(new WeakRegistryListener(this, parent));
        }
        this.actions = Collections.synchronizedMap(new HashMap());
        this.stubs = Collections.synchronizedMap(new HashMap());
        this.reverseMap = Collections.synchronizedMap(new HashMap());
        this.categoryMap = Collections.synchronizedMap(new LinkedHashMap());
        this.listenerList = new EventListenerList();
        this.configurers = new ArrayList<PropertiesConfigurer>();
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.addConfigurer(new BundleBasedConfigurer(bundle));
    }

    @Override
    public void addConfigurer(PropertiesConfigurer configurer) {
        this.configureInitializedActions(configurer);
        this.configurers.add(configurer);
    }

    public PropertiesConfigurer[] getConfigurers() {
        return this.configurers.toArray(new PropertiesConfigurer[this.configurers.size()]);
    }

    public void addInitializationListener(InitializationListener l) {
        this.listenerList.add(InitializationListener.class, l);
    }

    public void removeInitializationListener(InitializationListener l) {
        this.listenerList.remove(InitializationListener.class, l);
    }

    @Override
    public void addRegistryListener(RegistryListener l) {
        this.listenerList.add(RegistryListener.class, l);
    }

    @Override
    public void removeRegistryListener(RegistryListener l) {
        this.listenerList.remove(RegistryListener.class, l);
    }

    public final ActionRegistry getParent() {
        return this.parent;
    }

    protected void actionInitializationDone(String id) {
        InitializationEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != InitializationListener.class) continue;
            if (event == null) {
                event = new InitializationEvent(this, id);
            }
            ((InitializationListener)listeners[i + 1]).actionInitialized(event);
        }
    }

    private void fireRegistryEvent(String id, boolean register) {
        RegistryEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RegistryListener.class) continue;
            if (event == null) {
                event = new RegistryEvent(this, id);
            }
            if (register) {
                ((RegistryListener)listeners[i + 1]).actionRegistered(event);
                continue;
            }
            ((RegistryListener)listeners[i + 1]).actionRemoved(event);
        }
    }

    protected void fireActionRegistered(String id) {
        this.fireRegistryEvent(id, true);
    }

    protected void fireActionRemoved(String id) {
        this.fireRegistryEvent(id, false);
    }

    @Override
    public void register(String id, Action action) {
        this.register(id, null, action);
    }

    @Override
    public void register(String id, String categoryID, Action action) {
        if (id == null) {
            throw new NullPointerException("Action id cannot be null!");
        }
        if (action == null) {
            throw new NullPointerException("Action cannot be null!");
        }
        if (this.getID(action) != null) {
            throw new IllegalArgumentException("Action already registered with id " + this.getID(action) + "!");
        }
        if (action.getValue("ActionCommandKey") == null) {
            action.putValue("ActionCommandKey", id);
        }
        if (action instanceof ActionStub) {
            this.stubs.put(id, (ActionStub)action);
            this.actions.put(id, new Entry(id, categoryID));
        } else {
            this.actions.put(id, new Entry(id, categoryID, action));
            this.reverseMap.put(action, id);
        }
        this.fireActionRegistered(id);
    }

    @Override
    public void remove(String id) {
        if (id == null) {
            return;
        }
        Entry entry = this.actions.remove(id);
        if (entry != null) {
            this.reverseMap.remove(entry.action);
            if (!this.hasAction(id)) {
                this.fireActionRemoved(id);
            }
        }
    }

    @Override
    public boolean hasAction(String id) {
        return this.actions.containsKey(id) || this.parent != null && this.parent.hasAction(id);
    }

    boolean hasLocalAction(String id) {
        return this.actions.containsKey(id);
    }

    public boolean hasCategory(String id) {
        return this.getCategory(id) != null;
    }

    @Override
    public Category getCategory(String id) {
        Category result = this.categoryMap.get(id);
        if (result == null && this.parent != null) {
            result = this.parent.getCategory(id);
        }
        return result;
    }

    @Override
    public String[] getCategoryIDs() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.parent != null) {
            result.addAll(Arrays.asList(this.parent.getCategoryIDs()));
        }
        for (String key : this.categoryMap.keySet()) {
            result.add(key);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public void registerCategory(Category category) {
        if (this.hasCategory(category.getID())) {
            throw new IllegalArgumentException("Category " + category.getID() + " already registered!");
        }
        this.categoryMap.put(category.getID(), category);
    }

    @Override
    public String getActionCategoryID(String actionID) {
        if (this.hasLocalAction(actionID)) {
            return this.getEntry(actionID).getCategoryID();
        }
        if (this.parent != null && this.parent.hasAction(actionID)) {
            return this.parent.getActionCategoryID(actionID);
        }
        return null;
    }

    private Entry getEntry(String id) {
        return this.actions.get(id);
    }

    @Override
    public Action getAction(String id) {
        return this.hasLocalAction(id) ? this.getLocalAction(id) : this.getActionFromParent(id);
    }

    private Action getLocalAction(String id) {
        assert (this.hasLocalAction(id));
        if (this.getEntry(id).isInitialized()) {
            return this.getEntry(id).getAction();
        }
        this.initializeAction(id);
        return this.hasLocalAction(id) ? this.getEntry(id).getAction() : null;
    }

    private void initializeAction(String id) {
        if (this.stubs.containsKey(id)) {
            Action result = this.stubs.remove(id).newInstance();
            if (result == null) {
                this.stubs.remove(id);
                this.actions.remove(id);
                return;
            }
            this.getEntry(id).setAction(result);
            this.reverseMap.put(result, id);
        }
        this.getEntry(id).initialize();
        this.actionInitializationDone(id);
    }

    public Action getActionOrStub(String id) {
        if (!this.hasLocalAction(id)) {
            return this.getActionFromParent(id);
        }
        return this.stubs.containsKey(id) ? (Action)this.stubs.get(id) : this.getEntry((String)id).action;
    }

    @Override
    public String getID(Action action) {
        String result = this.getLocalID(action);
        if (result == null && this.parent != null) {
            result = this.parent.getID(action);
        }
        return result;
    }

    private String getLocalID(Action action) {
        return this.reverseMap.get(action);
    }

    @Override
    public String[] getActionIDs() {
        this.ensureStubActionsExists();
        ArrayList<String> result = new ArrayList<String>();
        if (this.parent != null) {
            result.addAll(Arrays.asList(this.parent.getActionIDs()));
        }
        result.addAll(this.actions.keySet());
        return result.toArray(new String[0]);
    }

    private void ensureStubActionsExists() {
        String[] ids;
        for (String id : ids = this.stubs.keySet().toArray(new String[this.stubs.size()])) {
            if (!this.stubs.get(id).canReturnNull()) continue;
            this.initializeAction(id);
        }
    }

    protected Action getActionFromParent(String id) {
        return this.parent != null ? this.parent.getAction(id) : null;
    }

    @Override
    public ActionProperties getActionFace(String id, String faceName) {
        if (this.hasLocalAction(id)) {
            return this.getEntry(id).getActionProperies(faceName);
        }
        return this.parent != null ? this.parent.getActionFace(id, faceName) : null;
    }

    @Override
    public void actionRegistered(RegistryEvent e) {
        if (!this.hasLocalAction(e.getActionID())) {
            this.fireActionRegistered(e.getActionID());
        }
    }

    @Override
    public void actionRemoved(RegistryEvent e) {
        if (!this.hasLocalAction(e.getActionID())) {
            this.fireActionRemoved(e.getActionID());
        }
    }

    void configure(String id, String context, ActionProperties properties) {
        for (PropertiesConfigurer configurer : this.configurers) {
            configurer.configure(id, context, properties);
        }
    }

    private void configureInitializedActions(PropertiesConfigurer configurer) {
        for (Entry entry : this.actions.values()) {
            if (!entry.isInitialized()) continue;
            entry.reconfigure(configurer);
        }
    }

    private class PropertiesEntry {
        private ActionAdapter adapter;
        private Map<String, ActionProperties> contextMap;
        private String id;

        PropertiesEntry(String id) {
            this.id = id;
            this.contextMap = new HashMap<String, ActionProperties>(5);
        }

        public ActionProperties getDefault() {
            if (this.adapter == null) {
                this.adapter = new ActionAdapter(ActionManager.this.getAction(this.id));
                ActionManager.this.configure(this.id, null, this.adapter);
            }
            return this.adapter;
        }

        private String getFallback(String context) {
            if ("toolpopup".equals(context)) {
                return "popup";
            }
            if ("popup".equals(context)) {
                return "menu";
            }
            if ("menu".equals(context)) {
                return "default";
            }
            if ("toolbar".equals(context)) {
                return "default";
            }
            return null;
        }

        public ActionProperties getProperties(String context) {
            if (context == null || "default".equals(context)) {
                return this.getDefault();
            }
            ActionProperties result = this.contextMap.get(context);
            if (result == null) {
                ActionProperties parentProperties = this.getProperties(this.getFallback(context));
                result = new DelegatingProperties(parentProperties);
                ActionManager.this.configure(this.id, context, result);
                this.contextMap.put(context, result);
            }
            return result;
        }

        public void reconfigure(PropertiesConfigurer configurer) {
            for (String context : this.contextMap.keySet()) {
                configurer.configure(this.id, context, this.contextMap.get(context));
            }
        }
    }

    private class Entry {
        public Action action;
        private String categoryID;
        private String id;
        private PropertiesEntry manager;
        private boolean initialized;

        public Entry(String id, String categoryID) {
            this(id, categoryID, null);
        }

        public Entry(String id, String categoryID, Action action) {
            this.id = id;
            this.categoryID = categoryID;
            this.action = action;
        }

        public void reconfigure(PropertiesConfigurer configurer) {
            this.manager.reconfigure(configurer);
        }

        public String getCategoryID() {
            return this.categoryID;
        }

        public void setAction(Action action) {
            this.action = action;
        }

        public Action getAction() {
            this.initialize();
            return this.action;
        }

        public void initialize() {
            if (!this.initialized) {
                this.initialized = true;
                this.getManager().getDefault();
            }
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        private PropertiesEntry getManager() {
            if (this.manager == null) {
                this.manager = new PropertiesEntry(this.id);
            }
            return this.manager;
        }

        public ActionProperties getActionProperies(String context) {
            return this.getManager().getProperties(context);
        }
    }
}

