/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.action.manager;

import chemaxon.marvin.uif.action.ActionProperties;
import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.Category;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.marvin.uif.action.PropertiesConfigurer;
import chemaxon.marvin.uif.action.RegistryEvent;
import chemaxon.marvin.uif.action.RegistryListener;
import chemaxon.marvin.uif.action.support.WeakRegistryListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.event.EventListenerList;

public class ContextActionRegistry
implements ActionRegistry,
RegistryListener {
    private ActionRegistry delegate;
    private Context context;
    private Map<String, Action> actionCache;
    private EventListenerList listenerList;

    public ContextActionRegistry(ActionRegistry delegate, Context context) {
        this.delegate = delegate;
        this.context = context;
        this.actionCache = new HashMap<String, Action>();
        this.listenerList = new EventListenerList();
        delegate.addRegistryListener(new WeakRegistryListener(this, delegate));
    }

    @Override
    public Action getAction(String id) {
        if (this.actionCache.containsKey(id)) {
            return this.actionCache.get(id);
        }
        Action result = this.delegate.getAction(id);
        if (result == null) {
            return null;
        }
        if (Boolean.FALSE.equals(result.getValue("VisibleInPopup"))) {
            return null;
        }
        if (Boolean.FALSE.equals(result.getValue("DisabledActionVisibleInPopup")) && !result.isEnabled()) {
            return null;
        }
        if (this.context == null) {
            return result;
        }
        if (result instanceof PopupActionProvider) {
            result = this.createLocalInstance(id, (PopupActionProvider)result);
        }
        return result;
    }

    @Override
    public void remove(String id) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private Action createLocalInstance(String id, PopupActionProvider provider) {
        Action result = provider.createLocalInstance(this.context);
        if (result == null) {
            return null;
        }
        this.actionCache.put(id, result);
        return result;
    }

    @Override
    public boolean hasAction(String id) {
        return this.actionCache.containsKey(id) || this.delegate.hasAction(id);
    }

    @Override
    public String getID(Action action) {
        if (action == null) {
            return null;
        }
        String result = this.findCachedID(action);
        if (result == null) {
            result = this.delegate.getID(action);
        }
        return result;
    }

    private String findCachedID(Action action) {
        for (Map.Entry<String, Action> entry : this.actionCache.entrySet()) {
            if (!action.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void addRegistryListener(RegistryListener l) {
        this.listenerList.add(RegistryListener.class, l);
    }

    @Override
    public void removeRegistryListener(RegistryListener l) {
        this.listenerList.remove(RegistryListener.class, l);
    }

    private void fireActionRegistered(String id) {
        Object[] listeners = this.listenerList.getListenerList();
        RegistryEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RegistryListener.class) continue;
            if (e == null) {
                e = new RegistryEvent(this, id);
            }
            ((RegistryListener)listeners[i + 1]).actionRegistered(e);
        }
    }

    private void fireActionRemoved(String id) {
        if (this.listenerList.getListenerCount(RegistryListener.class) == 0) {
            return;
        }
        RegistryEvent e = new RegistryEvent(this, id);
        RegistryListener[] listeners = (RegistryListener[])this.listenerList.getListeners(RegistryListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].actionRemoved(e);
        }
    }

    @Override
    public String getActionCategoryID(String id) {
        return this.delegate.getActionCategoryID(id);
    }

    @Override
    public String[] getActionIDs() {
        return this.delegate.getActionIDs();
    }

    @Override
    public Category getCategory(String categoryID) {
        return this.delegate.getCategory(categoryID);
    }

    @Override
    public String[] getCategoryIDs() {
        return this.delegate.getCategoryIDs();
    }

    @Override
    public void addConfigurer(PropertiesConfigurer configurer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void register(String id, Action action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void register(String id, String categoryID, Action action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerCategory(Category category) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActionProperties getActionFace(String id, String contextID) {
        return this.delegate.getActionFace(id, contextID);
    }

    @Override
    public void actionRegistered(RegistryEvent e) {
        this.fireActionRegistered(e.getActionID());
    }

    @Override
    public void actionRemoved(RegistryEvent e) {
        this.fireActionRemoved(e.getActionID());
    }
}

