/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.action.manager;

import chemaxon.marvin.uif.action.manager.ActionStub;
import chemaxon.marvin.uif.action.manager.EnumHelper;
import chemaxon.marvin.uif.action.manager.EnumeratedAction;
import chemaxon.marvin.uif.action.manager.EnumeratedAction2;
import chemaxon.marvin.uif.util.swing.NullAction;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class DefaultActionStub
extends AbstractAction
implements ActionStub {
    private final String className;
    private final int index;
    private final String enumID;

    public DefaultActionStub(String className) {
        this(className, -1, null);
    }

    public DefaultActionStub(String className, int index, String enumID) {
        this.className = className;
        this.index = index;
        this.enumID = enumID;
    }

    @Override
    public boolean canReturnNull() {
        return false;
    }

    protected void init(Action action) {
        Object[] keys = this.getKeys();
        if (keys == null) {
            return;
        }
        for (Object key : keys) {
            action.putValue(key.toString(), this.getValue(key.toString()));
        }
        if (this.isValidAction(action)) {
            this.copy((EnumeratedAction)((Object)action));
        }
        if (this.isValidAction2(action)) {
            this.copy((EnumeratedAction2)action);
        }
    }

    private boolean isValidAction(Action action) {
        return action instanceof EnumeratedAction && this.index != -1;
    }

    private boolean isValidAction2(Action action) {
        return action instanceof EnumeratedAction2 && this.enumID != null;
    }

    private <E> void copy(EnumeratedAction<E> a) {
        a.setValue(a.getValues()[this.index]);
    }

    private <E extends Enum<E>> void copy(EnumeratedAction2<E> a) {
        a.setValue(EnumHelper.valueOf(a.getType(), this.enumID));
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Action newInstance() {
        Action result;
        try {
            Class<?> clazz = Class.forName(this.className);
            result = (Action)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.showError("Invalid action class for");
            result = new NullAction();
        }
        catch (InstantiationException e) {
            this.showError("Cannot instantiate action class for");
            e.printStackTrace();
            result = new NullAction();
        }
        catch (IllegalAccessException e) {
            this.showError("Cannot instantiate action class for");
            e.printStackTrace();
            result = new NullAction();
        }
        this.init(result);
        return result;
    }

    private void showError(String msg) {
        System.err.println(msg + " [" + this.getValue("ActionCommandKey") + "]:" + this.className);
    }
}

