/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.action.manager;

import chemaxon.marvin.uif.action.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class SimpleContext
implements Context {
    private static final Context EMPTY_CONTEXT = new SimpleContext(Collections.EMPTY_SET);
    private LinkedList<Entry> content = new LinkedList();

    public SimpleContext(Collection<?> content) {
        this();
        for (Object object : content) {
            this.bind(object);
        }
    }

    public SimpleContext() {
    }

    public static Context emptyContext() {
        return EMPTY_CONTEXT;
    }

    public void bind(Object value) {
        this.bind(value.getClass(), value);
    }

    public void bind(Class<?> iface, Object value) {
        this.content.add(new Entry(iface, value));
    }

    public <E> E lookup(Class<E> clazz) {
        for (Entry entry : this.content) {
            if (!entry.isInstanceOf(clazz)) continue;
            return clazz.cast(entry.getValue());
        }
        return null;
    }

    public <E> Collection<E> lookupAll(Class<E> clazz) {
        ArrayList<E> result = new ArrayList<E>();
        for (Entry o : this.content) {
            if (!o.isInstanceOf(clazz)) continue;
            result.add(clazz.cast(o.getValue()));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SimpleContext)) {
            return false;
        }
        return this.content.equals(((SimpleContext)obj).content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    @Override
    public Context clone() {
        SimpleContext result;
        try {
            result = (SimpleContext)super.clone();
        }
        catch (CloneNotSupportedException ignored) {
            return null;
        }
        result.content = new LinkedList<Entry>(this.content);
        return result;
    }

    private static class Entry {
        private Class<?> clazz;
        private Object value;

        public Entry(Class<?> clazz, Object value) {
            this.clazz = clazz;
            this.value = value;
        }

        public boolean isInstanceOf(Class<?> c) {
            return c.isAssignableFrom(this.clazz);
        }

        public Object getValue() {
            return this.value;
        }
    }
}

