/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.action.support;

import chemaxon.marvin.uif.action.ActionGroup;
import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.RegistryEvent;
import chemaxon.marvin.uif.action.RegistryListener;
import chemaxon.marvin.uif.action.support.AbstractExtendedAction;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class DefaultActionGroup
extends AbstractAction
implements ActionGroup,
RegistryListener,
PropertyChangeListener {
    private ActionRegistry registry;
    private Action defaultAction;
    private List<Action> actions;
    private String defaultID;
    private String[] ids;
    private Set<String> idSet;

    public DefaultActionGroup(ActionRegistry registry, String defaultID, String[] ids) {
        this.init(registry, defaultID, ids);
    }

    public DefaultActionGroup() {
    }

    public void init(ActionRegistry aRegistry, String aDefaultID, String[] actionIDs) {
        this.registry = aRegistry;
        this.defaultID = aDefaultID != null ? aDefaultID : actionIDs[0];
        this.ids = (String[])actionIDs.clone();
        this.idSet = new HashSet<String>(Arrays.asList(actionIDs));
        aRegistry.addRegistryListener(this);
    }

    protected boolean contains(String id) {
        return this.idSet.contains(id);
    }

    protected ActionRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public Action[] getActions() {
        this.initActions();
        return this.actions.toArray(new Action[this.actions.size()]);
    }

    @Override
    public Action getDefaultAction() {
        this.initDefaultAction();
        return this.defaultAction;
    }

    @Override
    public void setDefaultAction(Action action) {
        Action oldValue = this.defaultAction;
        this.defaultAction = action;
        this.firePropertyChange("defaultAction", oldValue, this.defaultAction);
    }

    private void initDefaultAction() {
        if (this.defaultID == null) {
            return;
        }
        this.defaultAction = this.registry.getAction(this.defaultID);
        if (this.defaultAction == null) {
            this.defaultAction = this.findAnAction();
        } else {
            this.defaultID = null;
        }
    }

    private Action findAnAction() {
        for (String id : this.ids) {
            if (!this.registry.hasAction(id)) continue;
            return this.registry.getAction(id);
        }
        return null;
    }

    private void initActions() {
        if (this.actions != null) {
            return;
        }
        this.actions = new ArrayList<Action>(this.ids.length);
        for (String id : this.ids) {
            Action action = this.registry.getAction(id);
            if (action != null) {
                this.addHandler(action);
            }
            this.actions.add(action);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    protected void addHandler(Action action) {
        action.removePropertyChangeListener(this);
        action.addPropertyChangeListener(this);
    }

    @Override
    public void actionRegistered(RegistryEvent e) {
        if (this.contains(e.getActionID())) {
            this.clearActions();
            this.addHandler(this.getRegistry().getAction(e.getActionID()));
            if (e.getActionID().equals(this.defaultID) && (this.defaultAction == null || !AbstractExtendedAction.isSelected(this.defaultAction))) {
                this.setDefaultAction(this.registry.getAction(this.defaultID));
            }
        }
    }

    private void clearActions() {
        List<Action> oldValue = this.actions;
        this.actions = null;
        if (oldValue != null) {
            this.initActions();
        }
        this.firePropertyChange("actions", oldValue, this.actions);
    }

    @Override
    public void actionRemoved(RegistryEvent e) {
        if (this.contains(e.getActionID()) && this.actions != null) {
            for (Action action : this.actions) {
                if (!e.getActionID().equals(action.getValue("ActionCommandKey"))) continue;
                action.removePropertyChangeListener(this);
            }
            this.clearActions();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("Selected".equals(e.getPropertyName()) && Boolean.TRUE.equals(e.getNewValue())) {
            this.setDefaultAction((Action)e.getSource());
        }
    }
}

