/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.action.support;

import chemaxon.marvin.uif.action.ActionProperties;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JMenuItem;

public class LabelInfo {
    public static final char MNEMONIC_CHAR = '&';
    public static final int NO_MNEMONIC = 0;
    private String name;
    private int mnemonic;
    private int mnemonicIndex;

    public LabelInfo() {
        this(null);
    }

    public LabelInfo(String name) {
        this(name, 0);
    }

    public LabelInfo(String name, Integer mnemonic) {
        this(name, mnemonic != null ? mnemonic : 0);
    }

    public LabelInfo(String name, int mnemonic) {
        this(name, mnemonic, LabelInfo.findMnemonicIndex(name, mnemonic));
    }

    public LabelInfo(String name, Integer mnemonic, Integer mnemonicIndex) {
        this(name, mnemonic != null ? mnemonic : 0, mnemonicIndex != null ? mnemonicIndex : -1);
    }

    public LabelInfo(String name, int mnemonic, int mnemonicIndex) {
        this.name = name;
        this.mnemonic = mnemonic;
        this.mnemonicIndex = mnemonicIndex;
    }

    public static LabelInfo parse(Action action) {
        return new LabelInfo((String)action.getValue("Name"), (Integer)action.getValue("MnemonicKey"), (Integer)action.getValue("SwingDisplayedMnemonicIndexKey"));
    }

    public static LabelInfo parse(String encodedName) {
        if (encodedName == null) {
            return new LabelInfo(null);
        }
        int mnemonicIndex = LabelInfo.getMnemonicIndex(encodedName);
        if (mnemonicIndex == -1) {
            return new LabelInfo(LabelInfo.decode(encodedName));
        }
        char mnemonic = Character.toUpperCase(encodedName.charAt(mnemonicIndex + 1));
        String prefix = LabelInfo.decode(encodedName.substring(0, mnemonicIndex));
        String suffix = LabelInfo.decode(encodedName.substring(mnemonicIndex + 1));
        return new LabelInfo(prefix + suffix, mnemonic, prefix.length());
    }

    public static void configure(Action action, String name) {
        LabelInfo.parse(name).configure(action);
    }

    private static String decode(String name) {
        if (name.indexOf(38) == -1) {
            return name;
        }
        return name.replaceAll(new String(new char[]{'&', '&'}), Character.toString('&'));
    }

    private static String encode(String name) {
        if (name.indexOf(38) == -1) {
            return name;
        }
        return name.replaceAll(Character.toString('&'), new String(new char[]{'&', '&'}));
    }

    private static int getMnemonicIndex(String encodedName) {
        if (encodedName == null) {
            return -1;
        }
        int index = encodedName.indexOf(38);
        while (index != -1) {
            if (index + 1 < encodedName.length()) {
                if (encodedName.charAt(index + 1) != '&') {
                    return index;
                }
                ++index;
            }
            index = encodedName.indexOf(38, index + 1);
        }
        return -1;
    }

    private static int findMnemonicIndex(String str, int mnemonic) {
        if (str == null || mnemonic == 0) {
            return -1;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = str.indexOf(uc);
        int lci = str.indexOf(lc);
        if (uci == -1) {
            return lci;
        }
        if (lci == -1) {
            return uci;
        }
        return lci < uci ? lci : uci;
    }

    public String getEncodedString() {
        if (this.mnemonicIndex == -1 || this.name == null) {
            return this.name;
        }
        return LabelInfo.encode(this.name.substring(0, this.mnemonicIndex)) + '&' + LabelInfo.encode(this.name.substring(this.mnemonicIndex));
    }

    public String getName() {
        return this.name;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public void configure(Action action) {
        action.putValue("Name", this.name);
        action.putValue("MnemonicKey", new Integer(this.mnemonic));
        action.putValue("SwingDisplayedMnemonicIndexKey", new Integer(this.mnemonicIndex));
    }

    public void configure(JMenuItem menu) {
        menu.setText(this.name);
        menu.setMnemonic(this.mnemonic);
        menu.setDisplayedMnemonicIndex(this.mnemonicIndex);
    }

    public void configure(JLabel label) {
        label.setText(this.name);
        label.setDisplayedMnemonic(this.mnemonic);
        label.setDisplayedMnemonicIndex(this.mnemonicIndex);
    }

    public void configure(ActionProperties properties) {
        properties.setName(this.name);
        if (this.name != null) {
            properties.setMnemonicKey(new Integer(this.mnemonic));
            properties.setDisplayedMnemonicIndex(new Integer(this.mnemonicIndex));
        } else {
            properties.setMnemonicKey(null);
            properties.setDisplayedMnemonicIndex(null);
        }
    }
}

