/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.action.support;

import chemaxon.marvin.uif.action.support.AbstractExtendedAction;
import chemaxon.marvin.uif.util.listener.ActionPropertyChangeListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;

public class ToggleButtonBinding {
    private PropertyChangeListener changeListener;
    private ItemListener itemListener;

    public static ToggleButtonBinding bind(AbstractButton button, Action action) {
        return new ToggleButtonBinding(button, action);
    }

    private ToggleButtonBinding(AbstractButton button, Action action) {
        this.changeListener = new SelectionListener(button, action);
        this.itemListener = new ItemChangeHandler(action);
        button.setSelected(AbstractExtendedAction.isSelected(action));
        action.addPropertyChangeListener(this.changeListener);
        button.addItemListener(this.itemListener);
    }

    private static class ItemChangeHandler
    implements ItemListener {
        private Action action;

        public ItemChangeHandler(Action action) {
            this.action = action;
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            boolean isActionSelected;
            if (!(evt.getSource() instanceof AbstractButton)) {
                return;
            }
            AbstractButton button = (AbstractButton)evt.getSource();
            boolean selected = button.isSelected();
            if (selected != (isActionSelected = AbstractExtendedAction.isSelected(this.action))) {
                this.action.putValue("Selected", selected ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    private static class SelectionListener
    extends ActionPropertyChangeListener {
        private static final long serialVersionUID = 1L;

        public SelectionListener(AbstractButton button, Action action) {
            super((Object)button, action);
        }

        @Override
        protected void actionPropertyChanged(Object target, Action action, PropertyChangeEvent e) {
            AbstractButton button;
            if (!"Selected".equals(e.getPropertyName())) {
                return;
            }
            boolean selected = AbstractExtendedAction.isSelected(action);
            if (selected != (button = (AbstractButton)target).isSelected()) {
                button.setSelected(selected);
            }
        }
    }
}

