/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.aloe;

import cb.aloe.swing.tools.DockPane;
import cb.aloe.swing.tools.DockingEvent;
import cb.aloe.swing.tools.DockingListener;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.RegistryEvent;
import chemaxon.marvin.uif.model.RegistryListener;
import chemaxon.marvin.uif.model.ToolBarGroup;
import chemaxon.marvin.uif.module.GUIModule;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.marvin.uif.util.listener.AbstractWeakListener;
import chemaxon.marvin.uif.util.listener.WeakPropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class AloeDockHandler
implements DockingListener {
    private DockPane pane;
    private JRootPane rootPane;
    private boolean rootPaneChanged;
    private JMenuBar menuBar;
    private GUIModule module;
    private GUIRegistry registry;
    private RegistryListener listener;
    private boolean handleMenubar;
    private PropertyChangeListener moduleListener;
    private EventListenerList listenerList;

    public AloeDockHandler(JRootPane rootPane, DockPane pane, GUIModule module, boolean handleMenuBar) {
        this.module = module;
        this.pane = pane;
        this.listenerList = new EventListenerList();
        this.moduleListener = new ModuleHandler(this, module);
        module.addPropertyChangeListener(this.moduleListener);
        this.handleMenubar = handleMenuBar;
        pane.setDraggingEnabled(module.isToolbarFloatable());
        this.setRegistry(module.getGUIRegistry());
        this.setRootPane(rootPane);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public void setHandleMenuBar(boolean handleMenuBar) {
        if (this.handleMenubar == handleMenuBar) {
            return;
        }
        this.removeMenuBar();
        this.handleMenubar = handleMenuBar;
        this.addMenuBar();
    }

    public void dispose() {
        this.module.removePropertyChangeListener(this.moduleListener);
    }

    protected void fireChangeEvent() {
        ChangeEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (event == null) {
                event = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public void setRootPane(JRootPane aRootPane) {
        if (aRootPane == this.rootPane) {
            return;
        }
        if (this.rootPane != null) {
            this.removeMenuBar();
        }
        this.rootPane = aRootPane;
        this.rootPaneChanged = false;
        if (this.rootPane != null) {
            this.addMenuBar();
        }
    }

    private void setRegistry(GUIRegistry aRegistry) {
        if (this.registry == aRegistry) {
            return;
        }
        this.removeListeners();
        this.removeToolBars();
        this.removeMenuBar();
        this.registry = aRegistry;
        if (this.registry != null) {
            this.addToolBars();
            this.addMenuBar();
            this.addListeners();
        }
        this.pane.revalidate();
    }

    private void addListeners() {
        this.pane.addDockingListener((DockingListener)this);
        if (this.registry != null) {
            this.listener = new RegistryHandler(this, this.registry);
            this.registry.addRegistryListener(this.listener);
        }
    }

    private void removeListeners() {
        this.pane.removeDockingListener((DockingListener)this);
        if (this.registry != null) {
            this.registry.removeRegistryListener(this.listener);
            this.listener = null;
        }
    }

    private void addMenuBar() {
        if (this.registry == null || !this.handleMenubar) {
            return;
        }
        this.menuBar = this.module.getMenuBar();
        if (this.rootPane != null && this.menuBar != null && !this.rootPaneChanged) {
            this.rootPane.setJMenuBar(this.menuBar);
            this.rootPane.revalidate();
            this.rootPane.repaint();
        }
    }

    private void removeMenuBar() {
        if (!this.handleMenubar) {
            return;
        }
        this.removeMenuBarImpl();
    }

    private void removeMenuBarImpl() {
        if (this.menuBar == null) {
            return;
        }
        JRootPane parent = null;
        if (this.rootPane != null && this.rootPane.getJMenuBar() == this.menuBar) {
            parent = this.rootPane;
        } else {
            this.rootPaneChanged = true;
        }
        if (parent != null && parent.getJMenuBar() == this.menuBar) {
            parent.setJMenuBar(null);
            parent.revalidate();
            parent.repaint();
        }
        this.menuBar = null;
    }

    private void removeToolBars() {
        for (String id : this.pane.getToolBarNames()) {
            this.pane.removeToolBar(id);
        }
    }

    private void addToolBars() {
        ArrayList<ToolBarGroup> toolbars = new ArrayList<ToolBarGroup>();
        for (String id : this.module.getToolBarIDs()) {
            toolbars.add(this.module.getGUIRegistry().getToolBar(id));
        }
        Collections.sort(toolbars, new ToolBarComparator());
        this.normalizeToolbars(toolbars);
        for (ToolBarGroup toolBarGroup : toolbars) {
            this.addToolBar(toolBarGroup.getID());
        }
    }

    private void normalizeToolbars(List<ToolBarGroup> toolbars) {
        String lastAnchor = "dummy";
        int lastRow = -1;
        int currentRow = -1;
        for (ToolBarGroup item : toolbars) {
            if (!Utils.equals(lastAnchor, item.getAnchor())) {
                lastAnchor = item.getAnchor();
                lastRow = item.getRow();
                item.setRow(0);
                currentRow = 0;
                continue;
            }
            if (item.getRow() > lastRow) {
                lastRow = item.getRow();
                ++currentRow;
            }
            item.setRow(currentRow);
        }
    }

    private void registryChanged() {
        this.setRegistry(this.module.getGUIRegistry());
        this.fireChangeEvent();
    }

    private void toolBarAdded(RegistryEvent e) {
        ToolBarGroup group = (ToolBarGroup)e.getGroup();
        if (group.getRow() == -1) {
            group.setRow(this.pane.getPreferredRow(this.getBond(group.getAnchor())));
        }
        this.addToolBar(e.getGroup().getID());
    }

    private void toolBarRemoved(RegistryEvent e) {
        this.pane.removeToolBar(e.getGroup().getID());
    }

    public void toolBarDocked(DockingEvent de) {
        this.toolBarChanged(de);
    }

    public void toolBarFloated(DockingEvent de) {
    }

    public void toolBarHidden(DockingEvent de) {
        this.toolBarChanged(de);
    }

    private void toolBarChanged(DockingEvent de) {
        String id = this.getToolBarID(de.getToolBar());
        ToolBarGroup group = this.module.getGUIRegistry().getToolBar(id);
        if (group != null) {
            group.setVisible(this.pane.isToolBarVisible(id));
            group.setAnchor(this.getAnchor(de.getEdge()));
            group.setRow(de.getRow());
            group.setIndex(de.getIndex());
        }
        this.fireChangeEvent();
    }

    private void addToolBar(String id) {
        ToolBarGroup toolbar = this.module.getGUIRegistry().getToolBar(id);
        int anchor = this.getBond(toolbar.getAnchor());
        int row = toolbar.getRow();
        int index = toolbar.getIndex();
        boolean b = toolbar.isVisible();
        JToolBar t = this.module.getToolBar(toolbar.getID());
        if (row != -1 && index != -1) {
            this.pane.addToolBar(t, toolbar.getID(), anchor, row, index, true);
        } else {
            this.pane.addToolBar(t, toolbar.getID(), anchor, true);
        }
        this.pane.getToolBar(id).setFloatable(this.pane.isDraggingEnabled());
        if (!b) {
            this.pane.hideToolBar(toolbar.getID());
        }
    }

    private String getToolBarID(JToolBar toolbar) {
        String[] ids = this.pane.getToolBarNames();
        for (int i = 0; i < ids.length; ++i) {
            if (this.pane.getToolBar(ids[i]) != toolbar) continue;
            return ids[i];
        }
        return null;
    }

    private int getBond(String anchor) {
        if ("north".equals(anchor)) {
            return 1;
        }
        if ("west".equals(anchor)) {
            return 7;
        }
        if ("east".equals(anchor)) {
            return 3;
        }
        if ("south".equals(anchor)) {
            return 5;
        }
        return 1;
    }

    private String getAnchor(int edge) {
        switch (edge) {
            case 1: {
                return "north";
            }
            case 3: {
                return "east";
            }
            case 7: {
                return "west";
            }
            case 5: {
                return "south";
            }
        }
        return "north";
    }

    public void updateToolbarFloatable() {
        this.pane.setDraggingEnabled(this.module.isToolbarFloatable());
        for (JToolBar toolbar : this.pane.getToolBars()) {
            toolbar.setFloatable(this.pane.isDraggingEnabled());
        }
    }

    private static class ToolBarComparator
    implements Comparator<ToolBarGroup> {
        private ToolBarComparator() {
        }

        @Override
        public int compare(ToolBarGroup d0, ToolBarGroup d1) {
            if (d0.getAnchor() == null && d1.getAnchor() != null) {
                return -1;
            }
            if (d0.getAnchor() != null && d1.getAnchor() == null) {
                return 1;
            }
            if (d0.getAnchor() != null && !d0.getAnchor().equals(d1.getAnchor())) {
                return d0.getAnchor().compareTo(d1.getAnchor());
            }
            if (d0.getRow() != d1.getRow()) {
                return d0.getRow() - d1.getRow();
            }
            return d0.getIndex() - d1.getIndex();
        }
    }

    private static class ModuleHandler
    extends WeakPropertyChangeListener {
        public ModuleHandler(AloeDockHandler target, GUIModule source) {
            super(target, source);
        }

        @Override
        protected void propertyChanged(Object target, Object source, PropertyChangeEvent evt) {
            if ("guiRegistry".equals(evt.getPropertyName())) {
                ((AloeDockHandler)target).registryChanged();
            } else if ("toolbarFloatable".equals(evt.getPropertyName())) {
                ((AloeDockHandler)target).updateToolbarFloatable();
            }
        }
    }

    private static class RegistryHandler
    extends AbstractWeakListener
    implements RegistryListener {
        public RegistryHandler(AloeDockHandler target, GUIRegistry source) {
            super(target, source, RegistryListener.class);
        }

        @Override
        public void popupAdded(RegistryEvent e) {
        }

        @Override
        public void popupRemoved(RegistryEvent e) {
        }

        @Override
        public void toolBarAdded(RegistryEvent e) {
            AloeDockHandler handler = (AloeDockHandler)this.getTarget();
            if (handler != null) {
                handler.toolBarAdded(e);
            }
        }

        @Override
        public void toolBarRemoved(RegistryEvent e) {
            AloeDockHandler handler = (AloeDockHandler)this.getTarget();
            if (handler != null) {
                handler.toolBarRemoved(e);
            }
        }

        @Override
        public void menuBarAdded(RegistryEvent e) {
            AloeDockHandler handler = (AloeDockHandler)this.getTarget();
            if (handler != null) {
                handler.addMenuBar();
            }
        }

        @Override
        public void menuBarRemoved(RegistryEvent e) {
            AloeDockHandler handler = (AloeDockHandler)this.getTarget();
            if (handler != null) {
                handler.removeMenuBar();
            }
        }
    }
}

