/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.manager.ActionManager;
import chemaxon.marvin.uif.builder.ConfigurationRegistry;
import chemaxon.marvin.uif.builder.impl.action.ActionSet;
import chemaxon.marvin.uif.builder.impl.action.Module;
import chemaxon.marvin.uif.builder.impl.action.ShortcutsInfo;
import chemaxon.marvin.uif.builder.impl.config.Configuration;
import chemaxon.marvin.uif.builder.impl.config.CustomizationInfo;
import chemaxon.marvin.uif.builder.impl.config.RegistryComparator;
import chemaxon.marvin.uif.builder.parser.ObjectParser;
import chemaxon.marvin.uif.builder.parser.ObjectReader;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.module.ConfigurationException;
import chemaxon.marvin.uif.module.Configurer;
import chemaxon.marvin.uif.module.ModuleConfiguration;
import chemaxon.marvin.uif.module.support.DefaultGUIRegistry;
import chemaxon.marvin.uif.shortcut.ShortcutManager;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.marvin.uif.util.bean.Model;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class DefaultModuleConfiguration
extends Model
implements ModuleConfiguration {
    private static final String CUSTOM_ID_PREFIX = "custom-";
    private static final short MY_MAGIC_VERSION = 1;
    private String path;
    private LinkedHashMap<String, GUIRegistry> registries;
    private Map<String, GUIRegistry> registryDefaults;
    private Map<String, Configuration> configurations;
    private Map<String, Configuration> customizations;
    private String active;
    private ActionSet actionSet;

    public DefaultModuleConfiguration(Module module) {
        this.init();
        this.load(module);
    }

    public DefaultModuleConfiguration(URL url) throws ConfigurationException {
        this.init();
        this.load(url);
    }

    public DefaultModuleConfiguration(InputStream stream) throws ConfigurationException {
        this.init();
        this.load(stream);
    }

    public DefaultModuleConfiguration() {
        this.init();
    }

    private void init() {
        this.configurations = new LinkedHashMap<String, Configuration>(3);
        this.actionSet = new ActionSet();
        this.customizations = new HashMap<String, Configuration>(3);
    }

    private synchronized void checkInit() {
        if (this.isInitialized()) {
            return;
        }
        this.registries = new LinkedHashMap(3);
        this.registryDefaults = new LinkedHashMap<String, GUIRegistry>(3);
        if (this.active == null && this.hasRegistry("default")) {
            this.active = "default";
        }
    }

    private GUIRegistry createCustomRegistry(String id) {
        return this.createRegistryImpl(id, this.getCustomization(id));
    }

    private GUIRegistry createRegistryFromConfiguraiton(String id) {
        return this.createRegistryImpl(id, this.getConfiguration(id));
    }

    private GUIRegistry createRegistryImpl(String id, Configuration config) {
        GUIRegistry registry;
        if (config.getParent() != null) {
            GUIRegistry parent = this.getRegistryDefaults(config.getParent());
            registry = (GUIRegistry)parent.clone();
            registry.setParentID(config.getParent());
            registry.setID(config.getID());
        } else {
            registry = new DefaultGUIRegistry(id);
        }
        config.configure(registry);
        return registry;
    }

    public void load(InputStream input) throws ConfigurationException {
        this.load(input, null);
    }

    public void load(InputStream input, ResourceBundle bundle) throws ConfigurationException {
        this.checkState();
        try {
            this.load((Module)ObjectParser.parse(new BufferedInputStream(input), bundle));
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public void load(File file) throws ConfigurationException {
        this.checkState();
        this.load(file, null);
    }

    public void load(File file, ResourceBundle bundle) throws ConfigurationException {
        this.checkState();
        try {
            this.load(new FileInputStream(file), bundle);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(e);
        }
    }

    public void load(URL url) throws ConfigurationException {
        this.load(url, null);
    }

    public void load(URL url, ResourceBundle bundle) throws ConfigurationException {
        this.checkState();
        try {
            this.load(url.openStream(), bundle);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    public void load(Module module) {
        if (module.getActionSet() != null) {
            this.actionSet.add(module.getActionSet());
        }
        String[] ids = module.getConfigurationIDs();
        for (int i = 0; i < ids.length; ++i) {
            String convertedID = this.convertID(ids[i]);
            Configuration config = this.getConfiguration(convertedID);
            if (config != null) {
                config.add(module.getConfiguration(ids[i]));
                continue;
            }
            this.configurations.put(convertedID, module.getConfiguration(ids[i]));
        }
    }

    private Configuration getCustomization(String id) {
        return this.customizations.get(id);
    }

    private Configuration getConfiguration(String convertedID) {
        return this.getConfiguration(convertedID, true);
    }

    private Configuration getConfiguration(String convertedID, boolean resolveInclude) {
        Configuration result = this.configurations.get(convertedID);
        if (result == null) {
            return result;
        }
        if (result.getIncludePath() != null && !result.hasEntries() && resolveInclude) {
            String resource = result.getIncludePath();
            if (resource.startsWith("/")) {
                resource = resource.substring(1);
            } else {
                if (this.path == null) {
                    System.err.println("Cannot resolve relative resource id " + resource);
                    return result;
                }
                resource = this.path + "/" + resource;
            }
            try {
                resource = "/" + resource;
                Configuration conf = ConfigurationRegistry.getInstance().getActionUI(this.getClass(), resource);
                result.add(conf);
            }
            catch (ConfigurationException e) {
                System.err.println("Failed to load configuration from " + resource);
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public void loadConfiguration(InputStream is) throws IOException {
        try {
            this.checkInit();
            CustomizationInfo customization = (CustomizationInfo)ObjectParser.parse(is, null);
            Configuration[] configurationList = customization.getConfigurations();
            for (int i = 0; i < configurationList.length; ++i) {
                Configuration configuration = configurationList[i];
                if (this.isRegistryInitialized(configuration.getID())) {
                    configuration.configure(this.getRegistry(configuration.getID()));
                    continue;
                }
                this.customizations.put(configuration.getID(), configuration);
            }
            this.setActive(customization.getActive());
        }
        catch (Exception e) {
            IOException exception = new IOException("Configuration loading failed!");
            exception.initCause(e);
            throw exception;
        }
        finally {
            Utils.close(is);
        }
    }

    @Override
    public void saveConfiguration(OutputStream os) throws IOException {
        CustomizationInfo info = new CustomizationInfo();
        info.setActive(this.convertID(this.getActive()));
        String[] ids = this.getRegistryIDs();
        for (int i = 0; i < ids.length; ++i) {
            Configuration config = this.createConfiguration(ids[i]);
            if (config == null) continue;
            info.addConfiguration(config);
        }
        try {
            ObjectReader.write(info, os);
        }
        catch (Exception e) {
            IOException exception = new IOException("Configuration writing failed!");
            exception.initCause(e);
            throw exception;
        }
        finally {
            Utils.close(os);
        }
    }

    private Configuration createConfiguration(String id) {
        if (this.customizations.containsKey(id)) {
            return this.customizations.get(id);
        }
        if (this.registries.containsKey(id)) {
            return new RegistryComparator(this.getParentRegistry(id), this.getRegistry(id)).compare();
        }
        return null;
    }

    @Override
    public void exportConfiguration(OutputStream os, String registryID, boolean serialize) throws IOException {
        this.checkInit();
        if (!this.hasRegistry(registryID)) {
            throw new IllegalArgumentException("Invalid registry id: " + registryID + ".");
        }
        if (serialize) {
            this.serializeConfiguration(os, registryID);
        } else {
            this.exportConfiguration(os, registryID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeConfiguration(OutputStream os, String registryID) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new Utils.VersionedOutputStream(os, 1));
            this.getRegistry(registryID).writeExternal(oos);
        }
        catch (Throwable throwable) {
            Utils.close(oos);
            throw throwable;
        }
        Utils.close(oos);
    }

    private void exportConfiguration(OutputStream os, String registryID) throws IOException {
        try {
            CustomizationInfo info = new CustomizationInfo(registryID);
            Configuration configuration = this.createConfiguration(registryID);
            configuration.setDisplayName(this.getRegistryName(registryID));
            info.addConfiguration(configuration);
            ObjectReader.write(info, os);
        }
        catch (TransformerException e) {
            IOException ioe = new IOException("Configuration export failed!");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            Utils.close(os);
        }
    }

    @Override
    public String importConfiguration(InputStream is, boolean serialized) throws IOException {
        this.checkInit();
        if (serialized) {
            return this.deserializedConfiguration(is);
        }
        return this.importConfiguration(is);
    }

    private String deserializedConfiguration(InputStream is) throws IOException {
        Utils.VersionedInputStream bis = new Utils.VersionedInputStream(is);
        GUIRegistry registry = null;
        if (bis.getVersion() == 1) {
            registry = new DefaultGUIRegistry();
        }
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            if (registry != null) {
                registry.readExternal(ois);
            } else {
                registry = (GUIRegistry)ois.readObject();
            }
        }
        catch (ClassNotFoundException e) {
            IOException ioe = new IOException("Configuration import failed!\n" + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            Utils.close(ois);
            Utils.close(bis);
        }
        String id = this.generateID();
        if (!this.hasRegistry(registry.getParentID())) {
            registry.setParentID("default");
        }
        registry.setID(id);
        if (this.collectNames().contains(registry.getDisplayName())) {
            registry.setDisplayName(this.generateName(registry.getDisplayName()));
        }
        this.addRegistry(registry, false);
        return id;
    }

    private String importConfiguration(InputStream is) throws IOException {
        try {
            CustomizationInfo info = (CustomizationInfo)ObjectParser.parse(is, null);
            Configuration[] configs = info.getConfigurations();
            Configuration config = configs[0];
            String id = this.generateID();
            if (config.getParent() == null) {
                if (this.hasRegistry(config.getID())) {
                    config.setParent(config.getID());
                } else {
                    String string = null;
                    return string;
                }
            }
            config.setID(id);
            if (this.collectNames().contains(config.getDisplayName())) {
                config.setDisplayName(this.generateName(config.getDisplayName()));
            }
            this.customizations.put(id, config);
            String string = id;
            return string;
        }
        catch (SAXException e) {
            IOException ioe = new IOException("Configuration import failed!\n" + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            Utils.close(is);
        }
    }

    private GUIRegistry getParentRegistry(String id) {
        if (this.getRegistryDefaults(id) != null) {
            return this.getRegistryDefaults(id);
        }
        GUIRegistry registry = this.getRegistry(id);
        return this.getParentRegistry(registry.getParentID());
    }

    @Override
    public ActionRegistry createActions(ActionRegistry registry, Configurer[] actionConfigurers) {
        ActionManager result = new ActionManager(registry);
        this.actionSet.installActions(result, actionConfigurers);
        return result;
    }

    @Override
    public ShortcutManager createShortcutManager() {
        ShortcutManager result = new ShortcutManager();
        this.actionSet.installShortcuts(result);
        return result;
    }

    private void checkState() {
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot load GUI definitions after initialization is done!");
        }
    }

    private boolean isInitialized() {
        return this.registries != null;
    }

    @Override
    public void loadShortcutConfiguration(ShortcutManager shortcutManager, InputStream is) throws IOException {
        try {
            this.checkInit();
            ShortcutsInfo info = (ShortcutsInfo)ObjectParser.parse(new BufferedInputStream(is), null);
            shortcutManager.clear();
            info.installShortcuts(shortcutManager);
        }
        catch (SAXException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {}
        }
    }

    @Override
    public void saveShortcutConfiguration(ShortcutManager manager, OutputStream os) throws IOException {
        ShortcutsInfo info = new ShortcutsInfo(manager);
        try {
            ObjectReader.write(info, os);
        }
        catch (TransformerException e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
        finally {
            try {
                os.close();
            }
            catch (IOException ignored) {}
        }
    }

    public void addRegistryDefaults(GUIRegistry registry) {
        this.checkInit();
        String id2 = registry.getID();
        String id = this.convertID(id2);
        this.registryDefaults.put(id, registry);
    }

    private String convertID(String id) {
        return id != null ? id : "default";
    }

    @Override
    public GUIRegistry getRegistry(String id) {
        this.checkInit();
        String registryID = this.convertID(id);
        if (!this.hasRegistry(id)) {
            return null;
        }
        GUIRegistry registry = this.registries.get(registryID);
        if (registry == null) {
            registry = this.createActiveCopy(registryID, true);
        }
        return registry;
    }

    private GUIRegistry createActiveCopy(String registryID, boolean applyCustomization) {
        GUIRegistry registry = this.getRegistryDefaults(registryID);
        if (registry == null) {
            registry = this.createCustomRegistry(registryID);
            this.customizations.remove(registryID);
        }
        registry = (GUIRegistry)registry.clone();
        Configuration config = this.getCustomization(registryID);
        if (config != null && applyCustomization) {
            config.configure(registry);
            this.customizations.remove(registryID);
        }
        this.registries.put(registryID, registry);
        return registry;
    }

    public GUIRegistry copyRegistry(String id) {
        return this.copyRegistry(id, this.generateID());
    }

    private String generateID() {
        int i = 0;
        String id;
        while (this.hasRegistry(id = CUSTOM_ID_PREFIX + i)) {
            ++i;
        }
        return id;
    }

    private String generateName(String name) {
        Set<String> names = this.collectNames();
        int i = 2;
        String result;
        while (names.contains(result = name + " (" + i + ")")) {
            ++i;
        }
        return result;
    }

    private Set<String> collectNames() {
        String[] ids = this.getRegistryIDs();
        HashSet<String> result = new HashSet<String>(ids.length);
        for (String id : ids) {
            result.add(this.getRegistryName(id));
        }
        return result;
    }

    private GUIRegistry copyRegistry(String id, String newID) {
        GUIRegistry result = (GUIRegistry)this.getRegistry(id).clone();
        result.setID(newID);
        result.setParentID(id);
        this.registries.put(newID, result);
        return result;
    }

    @Override
    public GUIRegistry getRegistryDefaults(String id) {
        this.checkInit();
        GUIRegistry result = this.registryDefaults.get(id);
        if (result == null && this.configurations.containsKey(id)) {
            result = this.createRegistryFromConfiguraiton(id);
            this.registryDefaults.put(id, result);
        }
        return result;
    }

    @Override
    public String[] getRegistryIDs() {
        this.checkInit();
        LinkedHashSet<String> ids = new LinkedHashSet<String>(this.configurations.keySet());
        ids.addAll(this.registryDefaults.keySet());
        ids.addAll(this.registries.keySet());
        ids.addAll(this.customizations.keySet());
        return ids.toArray(new String[ids.size()]);
    }

    @Override
    public void removeRegistry(String id) {
        this.checkInit();
        this.registryDefaults.remove(id);
        this.configurations.remove(id);
        this.customizations.remove(id);
        this.registries.remove(id);
        if (this.convertID(id).equals(this.getActive())) {
            this.setActive(null);
        }
    }

    @Override
    public String getActive() {
        this.checkInit();
        return this.active;
    }

    @Override
    public GUIRegistry getActiveRegistry() {
        this.checkInit();
        if (this.getActive() == null) {
            return null;
        }
        return this.getRegistry(this.convertID(this.getActive()));
    }

    @Override
    public void setActive(String id) {
        if (id == this.getActive() || id != null && id.equals(this.getActive())) {
            return;
        }
        String oldValue = this.getActive();
        this.active = id;
        this.firePropertyChange("active", oldValue, this.getActive());
        this.firePropertyChange("activeRegistry", null, null);
    }

    @Override
    public void resetRegistry(String id) {
        this.checkInit();
        String registryID = this.convertID(id);
        if (this.getRegistryDefaults(registryID) == null || !this.registries.containsKey(registryID)) {
            return;
        }
        this.createActiveCopy(registryID, false);
        if (registryID.equals(this.getActive())) {
            this.firePropertyChange("activeRegistry", null, null);
        }
    }

    @Override
    public Object clone() {
        DefaultModuleConfiguration result = (DefaultModuleConfiguration)super.clone();
        result.actionSet = new ActionSet();
        result.actionSet.add(this.actionSet);
        if (result.registries != null) {
            result.registries = new LinkedHashMap<String, GUIRegistry>(this.registries);
        }
        if (this.registryDefaults != null) {
            result.registryDefaults = new LinkedHashMap<String, GUIRegistry>(this.registries);
        }
        if (this.customizations != null) {
            result.customizations = new HashMap<String, Configuration>(this.customizations);
        }
        result.configurations = new LinkedHashMap<String, Configuration>(this.configurations);
        return result;
    }

    public boolean hasRegistry(String id) {
        this.checkInit();
        return this.registryDefaults.containsKey(id) || this.registries.containsKey(id) || this.configurations.containsKey(id) || this.customizations.containsKey(id);
    }

    private boolean isRegistryInitialized(String id) {
        return this.registries.containsKey(id);
    }

    @Override
    public String getRegistryName(String id) {
        this.checkInit();
        if (!this.hasRegistry(id)) {
            return null;
        }
        if (this.registries.containsKey(id)) {
            return this.getRegistry(id).getDisplayName();
        }
        if (this.registryDefaults.containsKey(id)) {
            return this.getRegistryDefaults(id).getDisplayName();
        }
        if (this.customizations.containsKey(id) && this.getCustomization(id).getDisplayName() != null) {
            return this.getCustomization(id).getDisplayName();
        }
        if (this.getConfiguration(id, false) != null) {
            return this.getConfiguration(id, false).getDisplayName();
        }
        return null;
    }

    @Override
    public void addRegistry(GUIRegistry registry, boolean isDefault) throws IllegalArgumentException {
        this.checkInit();
        if (this.hasRegistry(registry.getID())) {
            throw new IllegalArgumentException("Registry with id " + registry.getID() + " is already exists");
        }
        if (isDefault) {
            this.addRegistryDefaults(registry);
        } else {
            this.registries.put(this.convertID(registry.getID()), registry);
        }
    }

    public void setPath(String path) {
        this.path = path;
    }
}

