/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.action;

import chemaxon.marvin.uif.action.ActionProperties;
import chemaxon.marvin.uif.action.support.DefaultActionProperties;
import chemaxon.marvin.uif.util.SerialUtils;
import chemaxon.marvin.uif.util.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionDescriptor
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private String categoryID;
    private String className;
    private String id;
    private String subID;
    private List<ActionDescriptor> childs;
    private Map<String, DefaultActionProperties> propertyMap = new HashMap<String, DefaultActionProperties>(3);

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public String getID() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSubID() {
        return this.subID;
    }

    public void setSubID(String subID) {
        this.subID = subID;
    }

    public boolean isEnumerated() {
        return this.childs != null && this.childs.size() > 0;
    }

    public String getCategoryID() {
        return this.categoryID;
    }

    public void setCategoryID(String categoryID) {
        this.categoryID = categoryID;
    }

    public void addChild(ActionDescriptor child) {
        if (this.childs == null) {
            this.childs = new ArrayList<ActionDescriptor>();
        }
        child.setSubID(child.getID());
        if (this.getID().contains("{0}")) {
            child.setId(MessageFormat.format(this.getID(), child.getID()));
        } else {
            child.setId(this.getID() + "." + child.getID());
        }
        this.childs.add(child);
    }

    public ActionDescriptor[] getChilds() {
        return this.childs != null ? this.childs.toArray(new ActionDescriptor[this.childs.size()]) : new ActionDescriptor[]{};
    }

    public ActionProperties getProperties(String context) {
        return this.propertyMap.get(context);
    }

    public Map<String, DefaultActionProperties> getProperties() {
        return Collections.unmodifiableMap(this.propertyMap);
    }

    public void addProperties(String context, DefaultActionProperties properties) {
        this.propertyMap.put(context, properties);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = SerialUtils.readString(in);
        this.subID = SerialUtils.readString(in);
        this.categoryID = SerialUtils.readString(in);
        this.className = SerialUtils.readString(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = SerialUtils.readString(in);
            DefaultActionProperties properties = new DefaultActionProperties();
            properties.readExternal(in);
            this.propertyMap.put(key, properties);
        }
        int childCount = in.read();
        if (childCount > 0) {
            this.childs = new ArrayList<ActionDescriptor>();
            for (int i = 0; i < childCount; ++i) {
                ActionDescriptor child = new ActionDescriptor();
                child.readExternal(in);
                this.childs.add(child);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerialUtils.writeString(out, this.id);
        SerialUtils.writeString(out, this.subID);
        SerialUtils.writeString(out, this.categoryID);
        SerialUtils.writeString(out, this.className);
        out.writeInt(this.propertyMap.size());
        for (String key : this.propertyMap.keySet()) {
            SerialUtils.writeString(out, key);
            this.propertyMap.get(key).writeExternal(out);
        }
        out.write(this.getChilds().length);
        for (ActionDescriptor child : this.getChilds()) {
            child.writeExternal(out);
        }
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ActionDescriptor)) {
            return false;
        }
        ActionDescriptor other = (ActionDescriptor)obj;
        return Utils.equals(this.id, other.id) && Utils.equals(this.subID, other.subID) && Utils.equals(this.categoryID, other.categoryID) && Utils.equals(this.className, other.className) && Utils.equals(this.propertyMap, other.propertyMap) && Utils.equals(this.childs, other.childs);
    }
}

