/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.action;

import chemaxon.marvin.uif.builder.impl.action.ActionSet;
import chemaxon.marvin.uif.builder.impl.config.Configuration;
import chemaxon.marvin.uif.util.PublicCloneable;
import chemaxon.marvin.uif.util.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;

public class Module
implements PublicCloneable<Module>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private ActionSet actionSet;
    private LinkedHashMap<String, Configuration> configurations;

    public Module() {
        this(null, null);
    }

    public Module(ActionSet actionSet, Configuration configuration) {
        this.actionSet = actionSet;
        this.configurations = new LinkedHashMap(3);
        if (configuration != null) {
            this.addConfiguration(configuration);
        }
    }

    public ActionSet getActionSet() {
        return this.actionSet;
    }

    public void setActionSet(ActionSet actionSet) {
        this.actionSet = actionSet;
    }

    public void addConfiguration(Configuration configuration) {
        this.configurations.put(configuration.getID(), configuration);
    }

    public String[] getConfigurationIDs() {
        return this.configurations.keySet().toArray(new String[this.configurations.keySet().size()]);
    }

    public Configuration getConfiguration(String id) {
        return this.configurations.get(id);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.actionSet = (ActionSet)in.readObject();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            Configuration config = new Configuration();
            config.readExternal(in);
            this.addConfiguration(config);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.actionSet);
        out.writeInt(this.configurations.size());
        for (Configuration config : this.configurations.values()) {
            config.writeExternal(out);
        }
    }

    public int hashCode() {
        return Utils.hash(this.actionSet, this.configurations);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Module)) {
            return false;
        }
        Module other = (Module)obj;
        return Utils.equals(this.actionSet, other.actionSet) && Utils.equals(this.configurations, other.configurations);
    }

    @Override
    public Module clone() {
        Module module;
        try {
            module = (Module)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        module.configurations = Utils.clone(this.configurations);
        return module;
    }
}

