/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.config;

import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;

class MenuPathHelper {
    public static final String ROOT_PATH = "";
    public static final String MENUBAR_PATH = "menubar";
    public static final String POPUP_PATH = "popup";
    public static final String TOOLBAR_PATH = "toolbar";

    private MenuPathHelper() {
    }

    public static boolean isMenubar(String path) {
        return MENUBAR_PATH.equals(path);
    }

    public static boolean isToolBar(String path) {
        return MenuPathHelper.isTopLevelGroup(TOOLBAR_PATH, path);
    }

    public static boolean isPopup(String path) {
        return MenuPathHelper.isTopLevelGroup(POPUP_PATH, path);
    }

    private static boolean isTopLevelGroup(String groupID, String path) {
        String id = MenuPathHelper.getID(path);
        String remainder = MenuPathHelper.getChildPath(path);
        return groupID.equals(id) && remainder != null && MenuPathHelper.getChildPath(remainder) == null;
    }

    public static ItemGroup findGroup(GUIRegistry registry, String path) {
        Item result = MenuPathHelper.findItem(registry, path);
        if (result instanceof ItemGroup) {
            return (ItemGroup)result;
        }
        return null;
    }

    public static Item findItem(GUIRegistry registry, String path) {
        String id = MenuPathHelper.getID(path);
        String remainder = MenuPathHelper.getChildPath(path);
        if (id.equals(MENUBAR_PATH)) {
            return MenuPathHelper.find(registry.getMenuBar(), remainder);
        }
        String subID = MenuPathHelper.getID(remainder);
        if (id.equals(POPUP_PATH)) {
            return MenuPathHelper.find(registry.getPopup(subID), MenuPathHelper.getChildPath(remainder));
        }
        if (id.equals(TOOLBAR_PATH)) {
            return MenuPathHelper.find(registry.getToolBar(subID), MenuPathHelper.getChildPath(remainder));
        }
        return null;
    }

    private static Item find(ItemGroup group, String path) {
        if (group == null) {
            return null;
        }
        if (path == null || path.length() == 0) {
            return group;
        }
        String id = MenuPathHelper.getID(path);
        String remainder = MenuPathHelper.getChildPath(path);
        Item item = group.getItem(id);
        if (remainder == null) {
            return item;
        }
        if (item instanceof ItemGroup) {
            return MenuPathHelper.find((ItemGroup)item, remainder);
        }
        return null;
    }

    private static String getID(String path) {
        if (path == null) {
            return null;
        }
        int idx = path.indexOf(47);
        if (idx != -1) {
            return path.substring(0, idx);
        }
        return path;
    }

    private static String getChildPath(String path) {
        if (path == null) {
            return null;
        }
        int idx = path.indexOf(47);
        if (idx != -1) {
            return path.substring(idx + 1);
        }
        return null;
    }
}

