/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.config;

import chemaxon.marvin.uif.builder.impl.config.ConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.MenuPathHelper;
import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.Styled;
import chemaxon.marvin.uif.model.ToolBarGroup;
import chemaxon.marvin.uif.util.SerialUtils;
import chemaxon.marvin.uif.util.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ModifyConfigurationEntry
implements ConfigurationEntry,
Externalizable {
    private static final long serialVersionUID = 0L;
    private Boolean visible;
    private Integer style;
    private String path;
    private String name;
    private String icon;
    private String anchor;
    private Integer row;
    private Integer index;

    public ModifyConfigurationEntry(String path, String name, String icon, Boolean visible, Integer style, String anchor, Integer row, Integer index) {
        this.visible = visible;
        this.style = style;
        this.path = path;
        this.name = name;
        this.icon = icon;
        this.anchor = anchor;
        this.row = row;
        this.index = index;
    }

    public ModifyConfigurationEntry() {
    }

    public String getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Integer getStyle() {
        return this.style;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public Integer getRow() {
        return this.row;
    }

    public Integer getIndex() {
        return this.index;
    }

    @Override
    public void apply(GUIRegistry registry) {
        Item item = MenuPathHelper.findItem(registry, this.path);
        if (item == null) {
            return;
        }
        DisplayProperties properties = item.getDisplayProperties();
        if (properties != null) {
            this.apply(properties);
        }
        if (this.visible != null) {
            item.setVisible(this.visible);
        }
        if (this.style != null && item instanceof Styled) {
            ((Styled)((Object)item)).setButtonStyle(this.style);
        }
        if (item instanceof ToolBarGroup) {
            ToolBarGroup dockable = (ToolBarGroup)item;
            if (this.anchor != null) {
                dockable.setAnchor(this.anchor);
            }
            if (this.row != null) {
                dockable.setRow(this.row);
            }
            if (this.index != null) {
                dockable.setIndex(this.index);
            }
        }
    }

    private void apply(DisplayProperties properties) {
        if (this.getName() != null) {
            properties.setDisplayName(this.getName());
        }
        if (this.getIcon() != null) {
            properties.setIconPath(this.getIcon());
        }
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModifyConfigurationEntry)) {
            return false;
        }
        ModifyConfigurationEntry other = (ModifyConfigurationEntry)obj;
        return Utils.equals(this.path, other.path) && Utils.equals(this.style, other.style) && Utils.equals(this.visible, other.visible) && Utils.equals(this.name, other.name) && Utils.equals(this.icon, other.icon) && Utils.equals(this.anchor, other.anchor) && Utils.equals(this.row, other.row) && Utils.equals(this.index, other.index);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.visible = SerialUtils.readBoolean(in);
        this.style = SerialUtils.readInteger(in);
        this.path = SerialUtils.readString(in);
        this.name = SerialUtils.readString(in);
        this.icon = SerialUtils.readString(in);
        this.anchor = SerialUtils.readString(in);
        this.row = SerialUtils.readInteger(in);
        this.index = SerialUtils.readInteger(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerialUtils.writeBoolean(out, this.visible);
        SerialUtils.writeInteger(out, this.style);
        SerialUtils.writeString(out, this.path);
        SerialUtils.writeString(out, this.name);
        SerialUtils.writeString(out, this.icon);
        SerialUtils.writeString(out, this.anchor);
        SerialUtils.writeInteger(out, this.row);
        SerialUtils.writeInteger(out, this.index);
    }
}

