/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.config;

import chemaxon.marvin.uif.builder.impl.config.ConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.MenuPathHelper;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.util.SerialUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OrderConfigurationEntry
implements ConfigurationEntry,
Externalizable {
    private static final long serialVersionUID = 0L;
    private String path;
    private String order;

    public OrderConfigurationEntry() {
    }

    public OrderConfigurationEntry(String path, String order) {
        this.path = path;
        this.order = order;
    }

    @Override
    public void apply(GUIRegistry registry) {
        ItemGroup group = MenuPathHelper.findGroup(registry, this.path);
        if (group == null) {
            return;
        }
        String[] items = this.order.split("/");
        int current = 0;
        for (int i = 0; i < items.length; ++i) {
            int idx = group.indexOf(items[i]);
            if (idx == -1) continue;
            if (idx != current) {
                group.move(idx, current);
            }
            ++current;
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getItemOrder() {
        return this.order;
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OrderConfigurationEntry)) {
            return false;
        }
        OrderConfigurationEntry other = (OrderConfigurationEntry)obj;
        return (this.path == other.path || this.path != null && this.path.equals(other.path)) && (this.order == other.order || this.order != null && this.order.equals(other.order));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.path = SerialUtils.readString(in);
        this.order = SerialUtils.readString(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerialUtils.writeString(out, this.path);
        SerialUtils.writeString(out, this.order);
    }
}

