/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.config;

import chemaxon.marvin.uif.builder.impl.config.ConfigurationEntry;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.util.SerialUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PopupConfigurationEntry
implements ConfigurationEntry,
Externalizable {
    private static final long serialVersionUID = 0L;
    private ItemGroup popup;
    private String basedOn;

    public PopupConfigurationEntry() {
    }

    public PopupConfigurationEntry(ItemGroup popup) {
        this(popup, null);
    }

    public PopupConfigurationEntry(ItemGroup popup, String basedOn) {
        this.popup = popup;
        this.basedOn = basedOn;
    }

    public ItemGroup getPopup() {
        return this.popup;
    }

    public void setPopup(ItemGroup popup) {
        this.popup = popup;
    }

    @Override
    public void apply(GUIRegistry registry) {
        ItemGroup entry = (ItemGroup)this.popup.clone();
        if (this.basedOn != null) {
            ItemGroup parent = registry.getPopup(this.basedOn);
            if (parent != null) {
                for (int i = parent.getItemCount() - 1; i >= 0; --i) {
                    Item item = parent.getItem(i);
                    if (entry.indexOf(item.getID()) != -1) continue;
                    entry.add((Item)item.clone(), 0);
                }
            } else {
                System.err.println("Missing parent for popup " + entry.getID());
            }
        }
        registry.addPopup(entry);
    }

    public int hashCode() {
        return this.popup != null ? this.popup.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PopupConfigurationEntry)) {
            return false;
        }
        PopupConfigurationEntry other = (PopupConfigurationEntry)obj;
        return (this.popup == other.popup || this.popup != null && this.popup.equals(other.popup)) && (this.basedOn == other.basedOn || this.basedOn != null && this.basedOn.equals(other.basedOn));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.basedOn = SerialUtils.readString(in);
        this.popup = (ItemGroup)SerialUtils.readObject(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerialUtils.writeString(out, this.basedOn);
        SerialUtils.writeObject(out, this.popup);
    }
}

