/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.config;

import chemaxon.marvin.uif.builder.impl.config.AddConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.Configuration;
import chemaxon.marvin.uif.builder.impl.config.ConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.MenuBarEntry;
import chemaxon.marvin.uif.builder.impl.config.ModifyConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.OrderConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.PopupConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.RemoveConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.ToolBarEntry;
import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.Styled;
import chemaxon.marvin.uif.model.ToolBarGroup;
import chemaxon.marvin.uif.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class RegistryComparator {
    private GUIRegistry defaultRegistry;
    private GUIRegistry registry;

    public RegistryComparator(GUIRegistry defaultRegistry, GUIRegistry registry) {
        this.defaultRegistry = defaultRegistry;
        this.registry = registry;
    }

    public Configuration compare() {
        Configuration result = new Configuration(this.registry.getID());
        if (this.registry.getID() != this.defaultRegistry.getID()) {
            result.setParent(this.defaultRegistry.getID());
        }
        if (!Utils.equals(this.registry.getDisplayName(), this.defaultRegistry.getDisplayName())) {
            result.setDisplayName(this.registry.getDisplayName());
        }
        if (this.registry.getUseLargeIcons() != this.defaultRegistry.getUseLargeIcons()) {
            result.setLargeIcons(this.registry.getUseLargeIcons());
        }
        this.compareMenuBars(result);
        this.compareToolBars(result);
        this.comparePopups(result);
        return result;
    }

    private void compareMenuBars(Configuration result) {
        this.compare("", this.defaultRegistry.getMenuBar(), this.registry.getMenuBar(), result);
    }

    private void compareToolBars(Configuration result) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        ids.addAll(Arrays.asList(this.defaultRegistry.getToolBarIDs()));
        ids.addAll(Arrays.asList(this.registry.getToolBarIDs()));
        for (String id : ids) {
            this.compare("toolbar", this.defaultRegistry.getToolBar(id), this.registry.getToolBar(id), result);
        }
    }

    private void comparePopups(Configuration result) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        ids.addAll(Arrays.asList(this.defaultRegistry.getPopupIDs()));
        ids.addAll(Arrays.asList(this.registry.getPopupIDs()));
        for (String id : ids) {
            this.compare("popup", this.defaultRegistry.getPopup(id), this.registry.getPopup(id), result);
        }
    }

    private void compare(String root, Item original, Item current, Configuration config) {
        if (original == null && current == null) {
            return;
        }
        if (original == null && current != null) {
            RegistryComparator.createAddEntry(config, root, current);
            return;
        }
        if (original != null && current == null) {
            config.addEntry(new RemoveConfigurationEntry(RegistryComparator.getPath(root, original.getID())));
            return;
        }
        if (original.getClass() != current.getClass()) {
            config.addEntry(new RemoveConfigurationEntry(RegistryComparator.getPath(root, original.getID())));
            RegistryComparator.createAddEntry(config, root, current);
            return;
        }
        this.compareProperties(root, original, current, config);
        if (original instanceof ItemGroup && current instanceof ItemGroup) {
            this.compareGroups(root, (ItemGroup)original, (ItemGroup)current, config);
        }
    }

    private void compareGroups(String root, ItemGroup original, ItemGroup current, Configuration config) {
        String path = RegistryComparator.getPath(root, current.getID());
        List<String> originalIDs = RegistryComparator.collectIDs(original);
        List<String> currentIDs = RegistryComparator.collectIDs(current);
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        ids.addAll(originalIDs);
        ids.addAll(currentIDs);
        Configuration workUnit = new Configuration(config.getID());
        for (String id : ids) {
            this.compare(path, original.getItem(id), current.getItem(id), workUnit);
        }
        this.compareOrder(path, originalIDs, currentIDs, workUnit);
        config.add(workUnit);
    }

    private void compareOrder(String path, List<String> originalIDs, List<String> currentIDs, Configuration config) {
        if (currentIDs.size() < 2) {
            return;
        }
        List<String> originalOrder = RegistryComparator.retainAll(originalIDs, currentIDs);
        if (((Object)originalOrder).equals(currentIDs)) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < currentIDs.size(); ++i) {
            if (i != 0) {
                buffer.append("/");
            }
            buffer.append(currentIDs.get(i));
        }
        config.addEntry(new OrderConfigurationEntry(path, buffer.toString()));
    }

    private void compareProperties(String path, Item original, Item current, Configuration config) {
        DisplayProperties defaultProperties = original.getDisplayProperties();
        DisplayProperties properties = current.getDisplayProperties();
        Boolean visible = null;
        String name = null;
        Integer style = null;
        String iconPath = null;
        String anchor = null;
        Integer row = null;
        Integer index = null;
        if (defaultProperties != null && properties != null) {
            if (!Utils.equals(properties.getDisplayName(), defaultProperties.getDisplayName())) {
                name = properties.getDisplayName();
            }
            if (!Utils.equals(properties.getIconPath(), defaultProperties.getIconPath())) {
                iconPath = properties.getIconPath();
            }
        }
        if (original.isVisible() != current.isVisible()) {
            visible = new Boolean(current.isVisible());
        }
        if (original instanceof Styled && current instanceof Styled) {
            Styled gr1 = (Styled)((Object)original);
            Styled gr2 = (Styled)((Object)current);
            if (gr1.getButtonStyle() != gr2.getButtonStyle()) {
                style = new Integer(gr2.getButtonStyle());
            }
        }
        if (original instanceof ToolBarGroup && current instanceof ToolBarGroup) {
            ToolBarGroup d1 = (ToolBarGroup)original;
            ToolBarGroup d2 = (ToolBarGroup)current;
            if (!Utils.equals(d1.getAnchor(), d2.getAnchor())) {
                anchor = d2.getAnchor();
            }
            if (d1.getIndex() != d2.getIndex()) {
                index = new Integer(d2.getIndex());
            }
            if (d1.getRow() != d2.getRow()) {
                row = new Integer(d2.getRow());
            }
        }
        if (name != null || iconPath != null || visible != null || style != null || anchor != null || row != null || index != null) {
            config.addEntry(new ModifyConfigurationEntry(RegistryComparator.getPath(path, current.getID()), name, iconPath, visible, style, anchor, row, index));
        }
    }

    private static String getPath(String root, String child) {
        return root.length() == 0 ? child : root + "/" + child;
    }

    private static List<String> collectIDs(ItemGroup group) {
        ArrayList<String> result = new ArrayList<String>(group.getItemCount());
        for (int i = 0; i < group.getItemCount(); ++i) {
            result.add(group.getItem(i).getID());
        }
        return result;
    }

    private static List<String> retainAll(List<String> first, List<String> second) {
        ArrayList<String> result = new ArrayList<String>(first);
        result.retainAll(second);
        return result;
    }

    private static void createAddEntry(Configuration config, String path, Item item) {
        ConfigurationEntry entry = RegistryComparator.createAddEntry(path, item);
        if (!(entry instanceof AddConfigurationEntry)) {
            config.addEntry(entry);
            return;
        }
        AddConfigurationEntry addEntry = RegistryComparator.findAddEntry(config, path);
        if (addEntry != null) {
            addEntry.addItem(item);
        } else {
            config.addEntry(entry);
        }
    }

    private static AddConfigurationEntry findAddEntry(Configuration config, String path) {
        List<ConfigurationEntry> items = config.getEntries();
        for (ConfigurationEntry c : items) {
            if (!(c instanceof AddConfigurationEntry) || !((AddConfigurationEntry)c).getPath().equals(path)) continue;
            return (AddConfigurationEntry)c;
        }
        return null;
    }

    private static ConfigurationEntry createAddEntry(String path, Item item) {
        if ("toolbar".equals(path)) {
            return new ToolBarEntry((ToolBarGroup)item);
        }
        if ("".equals(path)) {
            return new MenuBarEntry((ItemGroup)item);
        }
        if ("popup".equals(path)) {
            return new PopupConfigurationEntry((ItemGroup)item);
        }
        return new AddConfigurationEntry(path, Collections.singletonList(item));
    }
}

