/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.parser;

import chemaxon.marvin.uif.action.ActionProperties;
import chemaxon.marvin.uif.action.Category;
import chemaxon.marvin.uif.action.manager.LazyActionGroup;
import chemaxon.marvin.uif.action.support.DefaultActionProperties;
import chemaxon.marvin.uif.action.support.LabelInfo;
import chemaxon.marvin.uif.builder.impl.action.ActionDescriptor;
import chemaxon.marvin.uif.builder.impl.action.ActionFactoryDescriptor;
import chemaxon.marvin.uif.builder.impl.action.ActionGroupDescriptor;
import chemaxon.marvin.uif.builder.impl.action.ActionSet;
import chemaxon.marvin.uif.builder.impl.action.Module;
import chemaxon.marvin.uif.builder.impl.action.SchemeInfo;
import chemaxon.marvin.uif.builder.impl.action.ShortcutInfo;
import chemaxon.marvin.uif.builder.impl.action.ShortcutsInfo;
import chemaxon.marvin.uif.builder.impl.config.AddConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.Configuration;
import chemaxon.marvin.uif.builder.impl.config.ConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.CustomizationInfo;
import chemaxon.marvin.uif.builder.impl.config.MenuBarEntry;
import chemaxon.marvin.uif.builder.impl.config.ModifyConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.OrderConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.PopupConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.RemoveConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.ToolBarEntry;
import chemaxon.marvin.uif.builder.parser.BundleInfo;
import chemaxon.marvin.uif.builder.parser.SAXParserManager;
import chemaxon.marvin.uif.model.DefaultItem;
import chemaxon.marvin.uif.model.DefaultItemGroup;
import chemaxon.marvin.uif.model.DefaultToolbarGroup;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.Separator;
import chemaxon.marvin.uif.model.ToolBarGroup;
import chemaxon.marvin.uif.util.MappedResourceBundle;
import chemaxon.marvin.uif.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ObjectParser
extends DefaultHandler {
    private Stack<Object> stack;
    private Stack<BundleInfo> bundleStack;
    private Object root;
    private ResourceBundle bundle;

    public ObjectParser() {
        this(null);
    }

    public ObjectParser(ResourceBundle bundle) {
        this.bundle = bundle;
        this.stack = new Stack();
        this.bundleStack = new Stack();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    public Object getResult() {
        return this.root;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("action".equals(localName)) {
            this.push(this.createAction(attributes));
        } else if ("action-group".equals(localName)) {
            this.push(this.createActionGroup(attributes));
        } else if ("action-set".equals(localName)) {
            this.push(new ActionSet());
        } else if ("action-ui".equals(localName)) {
            this.push(this.createConfiguration(attributes));
        } else if ("actions".equals(localName)) {
            this.push(this.createActions(attributes));
        } else if ("add".equals(localName)) {
            this.push(new AddConfigurationEntry(attributes.getValue("path"), attributes.getValue("anchor")));
        } else if ("bundle".equals(localName)) {
            this.push(ObjectParser.createBundle(attributes));
        } else if ("category".equals(localName)) {
            this.push(this.createCategory(attributes));
        } else if ("customization".equals(localName)) {
            this.push(new CustomizationInfo(attributes.getValue("active")));
        } else if ("context".equals(localName)) {
            this.push(this.createContext(attributes));
        } else if ("entry".equals(localName)) {
            this.push(this.createEntry(attributes));
        } else if ("factory".equals(localName)) {
            this.push(this.createFactory(attributes));
        } else if ("item".equals(localName)) {
            this.push(this.createItem(attributes));
        } else if ("keyboard-shortcut".equals(localName)) {
            this.push(this.createKeyboardShortcut(attributes));
        } else if ("modify".equals(localName)) {
            this.push(this.createModifiyEntry(attributes));
        } else if ("module".equals(localName)) {
            this.push(new Module());
        } else if ("menu".equals(localName)) {
            this.push(this.createMenu(attributes));
        } else if ("menubar".equals(localName)) {
            this.push(new DefaultItemGroup("menubar"));
        } else if ("order".equals(localName)) {
            this.push(new OrderConfigurationEntry(attributes.getValue("path"), attributes.getValue("itemorder")));
        } else if ("popup".equals(localName)) {
            this.push(this.createPopup(attributes));
        } else if ("remove".equals(localName)) {
            this.push(new RemoveConfigurationEntry(ObjectParser.getMandatoryAttribute(attributes, "path")));
        } else if ("scheme".equals(localName)) {
            this.push(this.createScheme(attributes));
        } else if ("separator".equals(localName)) {
            this.push(this.createSeparator(attributes));
        } else if ("shortcuts".equals(localName)) {
            this.push(this.createShortcuts(attributes));
        } else if ("toolbar".equals(localName)) {
            this.push(this.createToolBar(attributes));
        } else if ("value".equals(localName)) {
            this.push(this.createAction(attributes));
        } else {
            throw new SAXException("Unknown tag: " + localName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        Object tmp = this.pop();
        if ("action".equals(localName)) {
            ((ActionsInfo)this.stack.peek()).addAction((ActionDescriptor)tmp);
        } else if ("action-ui".equals(localName)) {
            if (!this.stack.isEmpty()) {
                ((Module)this.stack.peek()).addConfiguration((Configuration)tmp);
            }
        } else if ("actions".equals(localName)) {
            ((ActionSet)this.stack.peek()).add(((ActionsInfo)tmp).actions);
        } else if ("action-group".equals(localName)) {
            ((ActionsInfo)this.stack.peek()).addAction((ActionGroupDescriptor)tmp);
        } else if ("action-set".equals(localName)) {
            if (!this.stack.isEmpty()) {
                ((Module)this.stack.peek()).setActionSet((ActionSet)tmp);
            }
        } else if ("add".equals(localName)) {
            ((Configuration)this.stack.peek()).addEntry((ConfigurationEntry)tmp);
        } else if ("bundle".equals(localName)) {
            this.setBundle((BundleInfo)tmp);
        } else if ("category".equals(localName)) {
            ((ActionSet)this.stack.peek()).addCategory((Category)tmp);
        } else if ("context".equals(localName)) {
            DefaultActionProperties context = (DefaultActionProperties)tmp;
            ((ActionDescriptor)this.stack.peek()).addProperties(context.getContextID(), context);
        } else if (!"customization".equals(localName)) {
            if ("entry".equals(localName)) {
                this.handleEntry(tmp);
            } else if ("factory".equals(localName)) {
                ((ActionsInfo)this.stack.peek()).addFactory((ActionFactoryDescriptor)tmp);
            } else if ("item".equals(localName)) {
                this.handleItem((Item)tmp);
            } else if ("keyboard-shortcut".equals(localName)) {
                this.handleShortcut((ShortcutInfo)tmp);
            } else if ("menu".equals(localName)) {
                this.handleItem((Item)tmp);
            } else if ("menubar".equals(localName)) {
                ((Configuration)this.stack.peek()).addEntry(new MenuBarEntry((ItemGroup)tmp));
            } else if ("modify".equals(localName)) {
                ((Configuration)this.stack.peek()).addEntry((ConfigurationEntry)tmp);
            } else if (!"module".equals(localName)) {
                if ("order".equals(localName)) {
                    ((Configuration)this.stack.peek()).addEntry((ConfigurationEntry)tmp);
                } else if ("popup".equals(localName)) {
                    ((Configuration)this.stack.peek()).addEntry((ConfigurationEntry)tmp);
                } else if ("remove".equals(localName)) {
                    ((Configuration)this.stack.peek()).addEntry((ConfigurationEntry)tmp);
                } else if ("scheme".equals(localName)) {
                    this.handleSchema(tmp);
                } else if ("separator".equals(localName)) {
                    this.handleSeparator(tmp);
                } else if (!"shortcuts".equals(localName)) {
                    if ("toolbar".equals(localName)) {
                        ((Configuration)this.stack.peek()).addEntry(new ToolBarEntry((ToolBarGroup)tmp));
                    } else if ("value".equals(localName)) {
                        ((ActionDescriptor)this.stack.peek()).addChild((ActionDescriptor)tmp);
                    } else {
                        throw new SAXException("Unknown tag: " + localName);
                    }
                }
            }
        }
        if (this.stack.isEmpty()) {
            this.root = tmp;
        }
    }

    private void handleEntry(Object o) {
        GroupEntryInfo info = (GroupEntryInfo)o;
        ActionGroupDescriptor group = (ActionGroupDescriptor)this.stack.peek();
        group.addEntry(info.getRefID());
        if (info.isDefaultEntry()) {
            group.setDefaultID(info.getRefID());
        }
    }

    private void handleItem(Item item) {
        if (this.stack.peek() instanceof ItemGroup) {
            ((ItemGroup)this.stack.peek()).add(item);
        } else if (this.stack.peek() instanceof PopupConfigurationEntry) {
            ((PopupConfigurationEntry)this.stack.peek()).getPopup().add(item);
        } else {
            ((AddConfigurationEntry)this.stack.peek()).addItem(item);
        }
    }

    private void handleShortcut(ShortcutInfo info) {
        if (this.stack.peek() instanceof ShortcutsInfo) {
            ((ShortcutsInfo)this.stack.peek()).addShortcut(info);
        } else {
            ((ActionSet)this.stack.peek()).addShortcut(info);
        }
    }

    private void handleSchema(Object o) {
        if (o instanceof SchemeInfo) {
            this.handleShortcutSchema((SchemeInfo)o);
        } else {
            ((CustomizationInfo)this.stack.peek()).addConfiguration((Configuration)o);
        }
    }

    private void handleShortcutSchema(SchemeInfo info) {
        if (this.stack.peek() instanceof ShortcutsInfo) {
            ((ShortcutsInfo)this.stack.peek()).addScheme(info);
        } else {
            ((ActionSet)this.stack.peek()).addShortcutSchema(info);
        }
    }

    private void handleSeparator(Object o) {
        if (o instanceof GroupEntryInfo) {
            this.handleEntry(o);
        } else {
            this.handleItem((Item)o);
        }
    }

    private void push(Object o) {
        if (!this.bundleStack.isEmpty()) {
            this.bundleStack.push(this.bundleStack.peek());
        } else {
            this.bundleStack.push(new BundleInfo(this.bundle));
        }
        this.stack.push(o);
    }

    private Object pop() {
        this.bundleStack.pop();
        Object o = this.stack.pop();
        return o;
    }

    private Object createAction(Attributes attributes) throws SAXException {
        ActionDescriptor result = new ActionDescriptor();
        this.configureDescriptor(attributes, result);
        return result;
    }

    private Object createActionGroup(Attributes attributes) throws SAXException {
        ActionGroupDescriptor result = new ActionGroupDescriptor();
        this.configureDescriptor(attributes, result);
        if (result.getClassName() == null) {
            result.setClassName(LazyActionGroup.class.getName());
        }
        return result;
    }

    private Object createActions(Attributes attributes) {
        if ("global".equals(attributes.getValue("scope"))) {
            System.err.println("Global actions deprecated!");
        }
        return new ActionsInfo(attributes.getValue("category"));
    }

    private static BundleInfo createBundle(Attributes attributes) throws SAXException {
        ResourceBundle result;
        String base = ObjectParser.getMandatoryAttribute(attributes, "base");
        boolean explicitAttributes = "true".equals(attributes.getValue("explicit"));
        try {
            result = new MappedResourceBundle(ResourceBundle.getBundle(base));
        }
        catch (MissingResourceException e) {
            try {
                result = ObjectParser.handleMissingResource(base, e);
            }
            catch (MissingResourceException mre) {
                throw new SAXException(e);
            }
        }
        return new BundleInfo(result, explicitAttributes);
    }

    private Object createCategory(Attributes attributes) throws SAXException {
        String id = ObjectParser.getMandatoryAttribute(attributes, "id");
        return new Category(id, this.getLocalizedAttribute(attributes, "name", "category." + id, null));
    }

    private Object createConfiguration(Attributes attributes) {
        String id = attributes.getValue("id");
        Configuration result = new Configuration(id);
        result.setDisplayName(this.getLocalizedAttribute(attributes, "name", "action-ui." + id, null));
        result.setParent(attributes.getValue("parent"));
        result.setIncludePath(attributes.getValue("include"));
        result.setLargeIcons(!"false".equals(attributes.getValue("largeIcons")));
        return result;
    }

    private ActionProperties createContext(Attributes attributes) throws SAXException {
        String contextID = ObjectParser.getMandatoryAttribute(attributes, "id");
        String prefix = "action." + ((ActionDescriptor)this.stack.peek()).getID();
        DefaultActionProperties result = this.createProperties(attributes, prefix, contextID);
        result.setContextID(contextID);
        return result;
    }

    private Object createEntry(Attributes attributes) {
        return new GroupEntryInfo(attributes.getValue("idRef"), "true".equals(attributes.getValue("default")));
    }

    private Object createFactory(Attributes attributes) throws SAXException {
        ActionFactoryDescriptor result = new ActionFactoryDescriptor();
        result.setFactoryClassName(ObjectParser.getMandatoryAttribute(attributes, "class"));
        result.setCategoryID(attributes.getValue("category"));
        return result;
    }

    private Object createItem(Attributes attributes) throws SAXException {
        DefaultItem result = new DefaultItem(ObjectParser.getMandatoryAttribute(attributes, "id"));
        this.readItemProperties(result, attributes, "item." + result.getID());
        return result;
    }

    private Object createKeyboardShortcut(Attributes attributes) throws SAXException {
        String key = ObjectParser.getMandatoryAttribute(attributes, "key");
        String schemeID = ObjectParser.getMandatoryAttribute(attributes, "scheme");
        String commandID = ObjectParser.getMandatoryAttribute(attributes, "commandID");
        if (commandID.length() == 0) {
            commandID = null;
        }
        return new ShortcutInfo(key, commandID, schemeID);
    }

    private Object createMenu(Attributes attributes) throws SAXException {
        DefaultItemGroup result = new DefaultItemGroup(ObjectParser.getMandatoryAttribute(attributes, "id"));
        this.readItemProperties(result, attributes, "menu." + result.getID());
        return result;
    }

    private Object createModifiyEntry(Attributes attributes) throws SAXException {
        Boolean visible = attributes.getValue("visible") != null ? Boolean.valueOf("true".equals(attributes.getValue("visible"))) : null;
        Integer style = attributes.getValue("style") != null ? Integer.valueOf(ObjectParser.getStyleInt(attributes.getValue("style"))) : null;
        Integer row = attributes.getValue("row") != null ? Integer.valueOf(attributes.getValue("row")) : null;
        Integer index = attributes.getValue("index") != null ? Integer.valueOf(attributes.getValue("index")) : null;
        return new ModifyConfigurationEntry(ObjectParser.getMandatoryAttribute(attributes, "path"), attributes.getValue("name"), attributes.getValue("icon"), visible, style, attributes.getValue("anchor"), row, index);
    }

    private Object createPopup(Attributes attributes) throws SAXException {
        DefaultItemGroup group = new DefaultItemGroup(ObjectParser.getMandatoryAttribute(attributes, "id"));
        this.readItemProperties(group, attributes, "popup." + group.getID());
        String parent = attributes.getValue("parent");
        return new PopupConfigurationEntry(group, parent);
    }

    private Object createScheme(Attributes attributes) throws SAXException {
        if (this.stack.peek() instanceof CustomizationInfo) {
            return this.createConfiguration(attributes);
        }
        return this.createShortcutScheme(attributes);
    }

    private Object createShortcutScheme(Attributes attributes) throws SAXException {
        String id = ObjectParser.getMandatoryAttribute(attributes, "id");
        String name = this.getLocalizedAttribute(attributes, "name", "scheme." + id, null);
        String parent = attributes.getValue("parent");
        boolean deleted = "true".equals(attributes.getValue("deleted"));
        return new SchemeInfo(id, parent, name, deleted);
    }

    private Object createSeparator(Attributes attributes) {
        if (this.stack.peek() instanceof ActionGroupDescriptor) {
            return new GroupEntryInfo();
        }
        return new Separator(attributes.getValue("id"));
    }

    private Object createShortcuts(Attributes attributes) {
        ShortcutsInfo result = new ShortcutsInfo();
        result.setActive(attributes.getValue("active"));
        return result;
    }

    private void configureDescriptor(Attributes attributes, ActionDescriptor result) throws SAXException {
        result.setId(ObjectParser.getMandatoryAttribute(attributes, "id"));
        result.setCategoryID(attributes.getValue("category"));
        result.setClassName(attributes.getValue("class"));
        this.loadProperties(result, attributes, "action." + result.getID());
    }

    private void loadProperties(ActionDescriptor result, Attributes attributes, String prefix) {
        if (this.getUseExplicitProperties()) {
            result.addProperties(null, this.createProperties(attributes, prefix, null));
        } else {
            this.gatherDefaultContexts(result, attributes, prefix);
        }
    }

    private void gatherDefaultContexts(ActionDescriptor action, Attributes attributes, String prefix) {
        String[] contexts = new String[]{null, "menu", "popup", "toolpopup", "toolbar"};
        for (int i = 0; i < contexts.length; ++i) {
            DefaultActionProperties properties = this.createProperties(attributes, prefix, contexts[i]);
            if (properties.isEmpty()) continue;
            action.addProperties(contexts[i], properties);
        }
    }

    private DefaultActionProperties createProperties(Attributes attributes, String prefix, String suffix) {
        DefaultActionProperties result = new DefaultActionProperties();
        LabelInfo info = LabelInfo.parse(this.getLocalizedAttribute(attributes, "name", prefix, suffix));
        info.configure(result);
        result.setSmallIconResource(this.getLocalizedAttribute(attributes, "icon", prefix, suffix));
        result.setLargeIconResource(this.getLocalizedAttribute(attributes, "largeicon", prefix, suffix));
        result.setShortDescription(this.getLocalizedAttribute(attributes, "tooltip", prefix, suffix));
        result.setLongDescription(this.getLocalizedAttribute(attributes, "helptext", prefix, suffix));
        result.setNamePattern(this.getLocalizedAttribute(attributes, "namepattern", prefix, suffix));
        result.setHelpID(this.getLocalizedAttribute(attributes, "helpID", prefix, suffix));
        return result;
    }

    private Object createToolBar(Attributes attributes) throws SAXException {
        DefaultToolbarGroup result = new DefaultToolbarGroup(ObjectParser.getMandatoryAttribute(attributes, "id"));
        this.readItemProperties(result, attributes, "toolbar." + result.getID());
        String style = attributes.getValue("style");
        if (style != null) {
            if (ObjectParser.getStyleInt(style) == -1) {
                throw new SAXException("Unknown toolbar style " + style + "!");
            }
            result.setButtonStyle(ObjectParser.getStyleInt(style));
        } else {
            result.setButtonStyle(0);
        }
        result.setAnchor(attributes.getValue("anchor"));
        if (attributes.getValue("row") != null) {
            result.setRow(Integer.parseInt(attributes.getValue("row")));
        }
        if (attributes.getValue("index") != null) {
            result.setIndex(Integer.parseInt(attributes.getValue("index")));
        }
        return result;
    }

    private void readItemProperties(Item item, Attributes attributes, String prefix) {
        if (attributes.getValue("visible") != null) {
            item.setVisible("true".equals(attributes.getValue("visible")));
        }
        this.readDisplayProperties(item, attributes, prefix);
    }

    private void readDisplayProperties(Item item, Attributes attributes, String prefix) {
        if (item.getDisplayProperties() == null) {
            return;
        }
        item.getDisplayProperties().setDisplayName(this.getLocalizedAttribute(attributes, "name", prefix, null));
        item.getDisplayProperties().setHelpID(attributes.getValue("helpID"));
        item.getDisplayProperties().setIconPath(this.getLocalizedAttribute(attributes, "icon", prefix, null));
    }

    private void setBundle(BundleInfo bundle) {
        if (this.bundleStack.isEmpty()) {
            throw new IllegalStateException();
        }
        this.bundleStack.pop();
        this.bundleStack.push(bundle);
    }

    private boolean getUseExplicitProperties() {
        BundleInfo info = this.bundleStack.peek();
        return info != null ? info.explicitProperties : false;
    }

    private ResourceBundle getBundle() {
        if (this.bundleStack.isEmpty()) {
            return null;
        }
        BundleInfo info = this.bundleStack.peek();
        return info != null ? info.bundle : null;
    }

    private static String getMandatoryAttribute(Attributes attributes, String id) throws SAXException {
        String result = attributes.getValue(id);
        if (result == null) {
            throw new SAXException("Missing mandatory attribute " + id);
        }
        return result;
    }

    protected String getLocalizedAttribute(Attributes attributes, String propertyName, String prefix, String suffix) {
        String property = attributes.getValue(propertyName);
        if (this.getBundle() == null) {
            return property;
        }
        if (this.getUseExplicitProperties()) {
            if (ObjectParser.isLocalizedID(property)) {
                return Utils.getString(this.getBundle(), ObjectParser.getLocalizedID(property), null);
            }
        } else if (property == null) {
            return Utils.getString(this.getBundle(), prefix, propertyName, suffix, null);
        }
        return property;
    }

    private static String getLocalizedID(String property) {
        return property.substring(1);
    }

    private static boolean isLocalizedID(String property) {
        return property != null && property.charAt(0) == '%';
    }

    private static int getStyleInt(String style) {
        if ("icon".equals(style)) {
            return 0;
        }
        if ("text".equals(style)) {
            return 1;
        }
        if ("icontext".equals(style)) {
            return 2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(InputStream is, ResourceBundle bundle) throws SAXException, IOException {
        Object value;
        SAXParser parser = SAXParserManager.getInstance().createParser();
        try {
            ObjectParser handler = new ObjectParser(bundle);
            parser.parse(is, (DefaultHandler)handler);
            value = handler.getResult();
        }
        finally {
            Utils.close(is);
            SAXParserManager.getInstance().releaseParser(parser);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle handleMissingResource(String baseName, MissingResourceException mre) throws MissingResourceException {
        PropertyResourceBundle propertyResourceBundle;
        String codeBase;
        String resource = ObjectParser.toResourceName(baseName, "properties");
        try {
            codeBase = System.getProperty("chemaxon.marvin.util.codeBase");
        }
        catch (SecurityException e) {
            throw mre;
        }
        if (codeBase == null) {
            throw mre;
        }
        URL cb = new URL(codeBase);
        URL url = new URL(cb, resource.charAt(0) != '/' ? resource : resource.substring(1));
        URLConnection connection = url.openConnection();
        if (connection == null) {
            throw mre;
        }
        connection.setUseCaches(true);
        InputStream is = connection.getInputStream();
        try {
            propertyResourceBundle = new PropertyResourceBundle(connection.getInputStream());
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (MalformedURLException e) {
                throw mre;
            }
            catch (IOException e) {
                throw mre;
            }
        }
        is.close();
        return propertyResourceBundle;
    }

    private static final String toResourceName(String bundleName, String suffix) {
        StringBuilder sb = new StringBuilder(bundleName.length() + 1 + suffix.length());
        sb.append(bundleName.replace('.', '/')).append('.').append(suffix);
        return sb.toString();
    }

    private static class GroupEntryInfo {
        private String refID;
        private boolean defaultEntry;

        public GroupEntryInfo() {
        }

        public GroupEntryInfo(String refID, boolean defaultEntry) {
            this.refID = refID;
            this.defaultEntry = defaultEntry;
        }

        public String getRefID() {
            return this.refID;
        }

        public boolean isDefaultEntry() {
            return this.defaultEntry;
        }
    }

    private static class ActionsInfo {
        private String categoryID;
        private ActionSet actions;

        public ActionsInfo(String categoryID) {
            this.categoryID = categoryID;
            this.actions = new ActionSet();
        }

        public void addAction(ActionDescriptor descriptor) {
            descriptor.setCategoryID(this.categoryID);
            this.actions.addAction(descriptor);
        }

        public void addFactory(ActionFactoryDescriptor descriptor) {
            descriptor.setCategoryID(this.categoryID);
            this.actions.addFactory(descriptor);
        }
    }
}

