/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.parser;

import chemaxon.marvin.uif.builder.impl.action.SchemeInfo;
import chemaxon.marvin.uif.builder.impl.action.ShortcutInfo;
import chemaxon.marvin.uif.builder.impl.action.ShortcutsInfo;
import chemaxon.marvin.uif.builder.impl.config.AddConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.Configuration;
import chemaxon.marvin.uif.builder.impl.config.ConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.CustomizationInfo;
import chemaxon.marvin.uif.builder.impl.config.MenuBarEntry;
import chemaxon.marvin.uif.builder.impl.config.ModifyConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.OrderConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.PopupConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.RemoveConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.ToolBarEntry;
import chemaxon.marvin.uif.builder.parser.ObjectInputSource;
import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.Separator;
import chemaxon.marvin.uif.model.ToolBarGroup;
import java.io.BufferedOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class ObjectReader
implements XMLReader {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final int INDENT_NUMBER = 2;
    private static final String nsu = "";
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private Stack<String> tags;
    private AttributesImpl atts = new AttributesImpl();

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.tags = new Stack();
        if (!(input instanceof ObjectInputSource)) {
            throw new SAXException("ObjectReader can only work with source of ObjectInputSource!");
        }
        if (this.contentHandler == null) {
            return;
        }
        ObjectInputSource source = (ObjectInputSource)input;
        Object o = source.getObject();
        this.contentHandler.startDocument();
        if (o instanceof ShortcutsInfo) {
            this.writeShortcuts((ShortcutsInfo)o);
        } else if (o instanceof CustomizationInfo) {
            this.writeCustomization((CustomizationInfo)o);
        } else {
            this.writeConfiguration((Configuration)o);
        }
        this.contentHandler.endDocument();
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    private void writeEmptyElement(String name) throws SAXException {
        this.startElement(name);
        this.endElement();
    }

    private void startElement(String name) throws SAXException {
        this.tags.push(name);
        this.contentHandler.startElement(nsu, name, name, this.atts);
        this.atts.clear();
    }

    private void endElement() throws SAXException {
        String name = this.tags.pop();
        this.contentHandler.endElement(nsu, name, name);
    }

    private void addAttribute(String name, Object value) {
        if (value == null) {
            return;
        }
        this.atts.addAttribute(nsu, name, name, "CDATA", value.toString());
    }

    private void writeShortcuts(ShortcutsInfo info) throws SAXException {
        this.addAttribute("active", info.getActive());
        this.startElement("shortcuts");
        for (SchemeInfo schemeInfo : info.getSchemes()) {
            this.writeScheme(schemeInfo);
        }
        for (Externalizable externalizable : info.getShortcuts()) {
            this.writeShortcut((ShortcutInfo)externalizable);
        }
        this.endElement();
    }

    private void writeCustomization(CustomizationInfo info) throws SAXException {
        this.addAttribute("active", info.getActive());
        this.startElement("customization");
        for (Configuration config : info.getConfigurations()) {
            this.writeConfiguration(config);
        }
        this.endElement();
    }

    private void writeConfiguration(Configuration configuration) throws SAXException {
        if (configuration.getEntries().size() == 0 && configuration.getDisplayName() == null && configuration.getParent() == null) {
            return;
        }
        this.addAttribute("id", configuration.getID());
        this.addAttribute("name", configuration.getDisplayName());
        this.addAttribute("parent", configuration.getParent());
        this.addAttribute("largeIcons", configuration.isLargeIcons());
        this.startElement("scheme");
        for (ConfigurationEntry entry : configuration.getEntries()) {
            if (entry instanceof AddConfigurationEntry) {
                this.writeAddEntry((AddConfigurationEntry)entry);
                continue;
            }
            if (entry instanceof OrderConfigurationEntry) {
                this.writeOrderEntry((OrderConfigurationEntry)entry);
                continue;
            }
            if (entry instanceof ModifyConfigurationEntry) {
                this.writeModifyEntry((ModifyConfigurationEntry)entry);
                continue;
            }
            if (entry instanceof RemoveConfigurationEntry) {
                this.writeRemoveEntry((RemoveConfigurationEntry)entry);
                continue;
            }
            if (entry instanceof MenuBarEntry) {
                this.writeMenuBar(((MenuBarEntry)entry).getMenuBar());
                continue;
            }
            if (entry instanceof ToolBarEntry) {
                this.writeToolBar(((ToolBarEntry)entry).getToolBar());
                continue;
            }
            if (!(entry instanceof PopupConfigurationEntry)) continue;
            this.writePopupEntry(((PopupConfigurationEntry)entry).getPopup());
        }
        this.endElement();
    }

    private void writeToolBar(ToolBarGroup toolbar) throws SAXException {
        this.saveItemProperties(toolbar);
        if (toolbar.getButtonStyle() != 0) {
            this.addAttribute("style", ObjectReader.getStyleString(toolbar.getButtonStyle()));
        }
        this.addAttribute("anchor", toolbar.getAnchor());
        if (toolbar.getRow() != -1) {
            this.addAttribute("row", toolbar.getRow());
        }
        if (toolbar.getIndex() != -1) {
            this.addAttribute("index", toolbar.getIndex());
        }
        this.startElement("toolbar");
        this.writeItems(toolbar);
        this.endElement();
    }

    private void writeMenuBar(ItemGroup group) throws SAXException {
        this.startElement("menubar");
        this.writeItems(group);
        this.endElement();
    }

    private void writeRemoveEntry(RemoveConfigurationEntry entry) throws SAXException {
        this.addAttribute("path", entry.getPath());
        this.writeEmptyElement("remove");
    }

    private void writeOrderEntry(OrderConfigurationEntry entry) throws SAXException {
        this.addAttribute("path", entry.getPath());
        this.addAttribute("itemorder", entry.getItemOrder());
        this.writeEmptyElement("order");
    }

    private void writeAddEntry(AddConfigurationEntry entry) throws SAXException {
        this.addAttribute("path", entry.getPath());
        this.addAttribute("anchor", entry.getAnchor());
        this.startElement("add");
        for (Item item : entry.getItems()) {
            this.writeItemsImpl(item);
        }
        this.endElement();
    }

    private void writeItems(ItemGroup group) throws SAXException {
        for (int i = 0; i < group.getItemCount(); ++i) {
            this.writeItemsImpl(group.getItem(i));
        }
    }

    private void writeItemsImpl(Item item) throws SAXException {
        if (item instanceof ItemGroup) {
            this.writeItemGroup((ItemGroup)item);
        } else if (item instanceof Separator) {
            this.writeSeparator((Separator)item);
        } else {
            this.writeItem(item);
        }
    }

    private void writeSeparator(Separator item) throws SAXException {
        this.saveItemProperties(item);
        this.writeEmptyElement("separator");
    }

    private void writeItemGroup(ItemGroup group) throws SAXException {
        this.saveItemProperties(group);
        this.startElement("menu");
        this.writeItems(group);
        this.endElement();
    }

    private void writeItem(Item item) throws SAXException {
        this.saveItemProperties(item);
        this.writeEmptyElement("item");
    }

    private void writeModifyEntry(ModifyConfigurationEntry entry) throws SAXException {
        this.addAttribute("path", entry.getPath());
        this.addAttribute("icon", entry.getIcon());
        this.addAttribute("name", entry.getName());
        this.addAttribute("visible", entry.getVisible());
        this.addAttribute("style", ObjectReader.getStyleString(entry.getStyle()));
        this.addAttribute("anchor", entry.getAnchor());
        this.addAttribute("row", entry.getRow());
        this.addAttribute("index", entry.getIndex());
        this.writeEmptyElement("modify");
    }

    private void writePopupEntry(ItemGroup popup) throws SAXException {
        this.saveItemProperties(popup);
        this.startElement("popup");
        this.writeItems(popup);
        this.endElement();
    }

    private void writeShortcut(ShortcutInfo shortcut) throws SAXException {
        this.addAttribute("key", shortcut.getKeyStroke());
        this.addAttribute("commandID", shortcut.getCommandID() != null ? shortcut.getCommandID() : nsu);
        this.addAttribute("scheme", shortcut.getSchemeID());
        this.writeEmptyElement("keyboard-shortcut");
    }

    private void writeScheme(SchemeInfo scheme) throws SAXException {
        this.addAttribute("id", scheme.getId());
        this.addAttribute("parent", scheme.getParentID());
        this.addAttribute("name", scheme.getDisplayName());
        if (scheme.isDeleted()) {
            this.addAttribute("deleted", "true");
        }
        this.writeEmptyElement("scheme");
    }

    private void saveItemProperties(Item item) {
        DisplayProperties displayProperties;
        this.addAttribute("id", item.getID());
        if (!item.isVisible()) {
            this.addAttribute("visible", "false");
        }
        if ((displayProperties = item.getDisplayProperties()) != null) {
            this.addAttribute("name", displayProperties.getDisplayName());
            this.addAttribute("icon", displayProperties.getIcon());
        }
    }

    public static String getStyleString(Integer style) {
        if (style == null) {
            return null;
        }
        int value = style;
        if (value == 0) {
            return "icon";
        }
        if (value == 1) {
            return "text";
        }
        if (value == 2) {
            return "icontext";
        }
        return null;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    private static void write(Source source, Result result) throws TransformerException {
        Transformer transformer = ObjectReader.createTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", DEFAULT_ENCODING);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", Integer.toString(2));
        transformer.transform(source, result);
    }

    private static Transformer createTransformer() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("indent-number", new Integer(2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return factory.newTransformer();
    }

    private static void write(XMLReader reader, InputSource is, OutputStream os) throws TransformerException {
        ObjectReader.write(new SAXSource(reader, is), new StreamResult(os));
    }

    public static void write(ShortcutsInfo info, OutputStream os) throws TransformerException {
        ObjectReader.write(new ObjectReader(), new ObjectInputSource(info), new BufferedOutputStream(os));
    }

    public static void write(CustomizationInfo info, OutputStream os) throws TransformerException {
        ObjectReader.write(new ObjectReader(), new ObjectInputSource(info), new BufferedOutputStream(os));
    }
}

