/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.component;

import chemaxon.marvin.uif.component.ButtonFactory;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.marvin.uif.util.swing.DropDownToggleButton;
import chemaxon.marvin.uif.util.swing.ExtendedToolBar;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.plaf.UIResource;

public final class DefaultButtonFactory
implements ButtonFactory {
    private static final ButtonFactory INSTANCE = new DefaultButtonFactory();
    private static final PropertyChangeListener LISTENER = new UIListener();

    public static ButtonFactory getInstance() {
        return INSTANCE;
    }

    private DefaultButtonFactory() {
    }

    @Override
    public JButton createButton() {
        JButton result = new JButton();
        this.configure(result);
        return result;
    }

    @Override
    public JToggleButton createToggleButton() {
        JToggleButton result = new JToggleButton();
        this.configure(result);
        return result;
    }

    @Override
    public JToolBar createToolBar() {
        ExtendedToolBar result = new ExtendedToolBar();
        this.configure((AbstractButton)result.getMoreComponent());
        result.setMargin(new Insets(0, 0, 0, 0));
        result.setRollover(true);
        return result;
    }

    @Override
    public JToggleButton createSplitToggleButton(JPopupMenu popupMenu) {
        DropDownToggleButton result = new DropDownToggleButton(null, popupMenu);
        this.configure(result);
        return result;
    }

    static void updateInsets(AbstractButton button) {
        if (!Utils.isLafAqua()) {
            button.setMargin(new Insets(0, 0, 0, 0));
        } else if (!(button.getMargin() instanceof UIResource)) {
            button.setMargin(null);
        }
    }

    private void configure(AbstractButton button) {
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.setAlignmentX(0.0f);
        button.putClientProperty("JButton.buttonType", "toolbar");
        button.setAlignmentY(0.5f);
        button.setFocusable(false);
        DefaultButtonFactory.updateInsets(button);
        button.addPropertyChangeListener("UI", LISTENER);
        button.setRolloverEnabled(true);
    }

    private static class UIListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DefaultButtonFactory.updateInsets((AbstractButton)evt.getSource());
        }
    }
}

